/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.util.SysUtil;
import com.els.modules.project.dto.ProjectBaseInfoDTO;
import com.els.modules.project.dto.ProjectReceivablesDTO;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.entity.ProjectReceivables;
import com.els.modules.project.mapper.ProjectBaseInfoMapper;
import com.els.modules.project.service.ProjectBaseInfoApiService;
import com.els.modules.project.service.ProjectReceivablesService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectBaseInfoApiServiceImpl
implements ProjectBaseInfoApiService {
    @Resource
    private ProjectBaseInfoMapper projectBaseInfoMapper;
    @Resource
    private ProjectReceivablesService projectReceivablesService;

    @Transactional(rollbackFor={RuntimeException.class})
    public void updateCollectionInfo(String elsAccount, String contractId, String collectionPlanId, String collectionDate, BigDecimal collectionAmount) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        wrapper.eq((Object)"parent_contract_baseinfo_id", (Object)contractId);
        List projectBaseInfos = this.projectBaseInfoMapper.selectList((Wrapper)wrapper);
        if (!projectBaseInfos.isEmpty()) {
            for (ProjectBaseInfo entity : projectBaseInfos) {
                List<ProjectReceivables> projectReceivables = this.projectReceivablesService.selectByMainId(entity.getId());
                ProjectReceivables projectReceivables1 = null;
                for (ProjectReceivables item : projectReceivables) {
                    if (!collectionPlanId.equals(item.getFbk1())) continue;
                    projectReceivables1 = item;
                    break;
                }
                if (projectReceivables1 == null) continue;
                projectReceivables.remove((Object)projectReceivables1);
                projectReceivables1.setFbk2(collectionDate);
                projectReceivables1.setActualReceivablesAmount(collectionAmount);
                BigDecimal collectionTotal = BigDecimal.ZERO;
                for (ProjectReceivables item : projectReceivables) {
                    if (item.getActualReceivablesAmount() == null) continue;
                    collectionTotal = collectionTotal.add(item.getActualReceivablesAmount());
                }
                collectionTotal = collectionTotal.add(collectionAmount);
                projectReceivables1.setAccumulativeReceivablesAmount(collectionTotal);
                entity.setFbk1(collectionTotal.toString());
                this.projectReceivablesService.updateById((Object)projectReceivables1);
                this.projectBaseInfoMapper.updateById((Object)entity);
            }
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void updateInvoicingInfo(String elsAccount, String contractId, String collectionPlanId, String invoicingDate, BigDecimal invoicingAmount) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        wrapper.eq((Object)"parent_contract_baseinfo_id", (Object)contractId);
        List projectBaseInfos = this.projectBaseInfoMapper.selectList((Wrapper)wrapper);
        if (!projectBaseInfos.isEmpty()) {
            for (ProjectBaseInfo entity : projectBaseInfos) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"project_id", (Object)entity.getId());
                queryWrapper.eq((Object)"fbk1", (Object)collectionPlanId);
                List list = this.projectReceivablesService.list((Wrapper)queryWrapper);
                if (list.isEmpty()) continue;
                for (ProjectReceivables item : list) {
                    item.setDrawBillAmount(invoicingAmount);
                    item.setFbk3(invoicingDate);
                }
                this.projectReceivablesService.updateBatchById(list);
            }
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void updateProjectInfo(ProjectBaseInfoDTO projectBaseInfoDTO, List<ProjectReceivablesDTO> projectReceivablesDTOS) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)projectBaseInfoDTO.getElsAccount());
        wrapper.eq((Object)"parent_contract_baseinfo_id", (Object)projectBaseInfoDTO.getParentContractBaseinfoId());
        List projectBaseInfos = this.projectBaseInfoMapper.selectList((Wrapper)wrapper);
        if (!projectBaseInfos.isEmpty()) {
            ArrayList<ProjectReceivables> projectReceivablesList = new ArrayList<ProjectReceivables>();
            for (ProjectBaseInfo entity : projectBaseInfos) {
                ProjectBaseInfo updateBase = (ProjectBaseInfo)((Object)SysUtil.copyProperties((Object)projectBaseInfoDTO, ProjectBaseInfo.class));
                updateBase.setId(entity.getId());
                this.projectBaseInfoMapper.updateById((Object)updateBase);
                if (projectReceivablesDTOS == null || projectReceivablesDTOS.size() <= 0) continue;
                for (ProjectReceivablesDTO item : projectReceivablesDTOS) {
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"project_id", (Object)entity.getId());
                    queryWrapper.eq((Object)"fbk1", (Object)item.getFbk1());
                    List list = this.projectReceivablesService.list((Wrapper)queryWrapper);
                    if (!list.isEmpty()) {
                        for (ProjectReceivables entry : list) {
                            ProjectReceivables receivables = (ProjectReceivables)((Object)SysUtil.copyProperties((Object)item, ProjectReceivables.class));
                            receivables.setId(entry.getId());
                            receivables.setFbk3(entry.getFbk3());
                            receivables.setDrawBillAmount(entry.getDrawBillAmount());
                            receivables.setFbk2(entry.getFbk2());
                            receivables.setActualReceivablesAmount(entry.getActualReceivablesAmount());
                            projectReceivablesList.add(receivables);
                        }
                        continue;
                    }
                    ProjectReceivables receivables = (ProjectReceivables)((Object)SysUtil.copyProperties((Object)item, ProjectReceivables.class));
                    receivables.setId(IdWorker.getIdStr());
                    receivables.setProjectId(entity.getId());
                    projectReceivablesList.add(receivables);
                }
            }
            if (projectReceivablesList.size() > 0) {
                this.projectReceivablesService.saveOrUpdateBatch(projectReceivablesList);
            }
        }
    }
}

