/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.contract.dto.SalesContractPlanDto;
import com.els.modules.contract.service.PurchaseContractHeadApiService;
import com.els.modules.contract.service.SalesContractApiService;
import com.els.modules.contract.service.SalesContractPlanApiService;
import com.els.modules.expense.entity.CostExpense;
import com.els.modules.expense.service.CostExpenseService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.payment.api.service.PaymentRpcService;
import com.els.modules.project.dto.ProjectEnclosureDTO;
import com.els.modules.project.dto.ProjectReceivablesDTO;
import com.els.modules.project.entity.BpSystemDeployApply;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.entity.ProjectCost;
import com.els.modules.project.entity.ProjectEnclosure;
import com.els.modules.project.entity.ProjectReceivables;
import com.els.modules.project.mapper.ProjectBaseInfoMapper;
import com.els.modules.project.service.ProjectBaseInfoService;
import com.els.modules.project.service.ProjectCostService;
import com.els.modules.project.service.ProjectEnclosureService;
import com.els.modules.project.service.ProjectReceivablesService;
import com.els.modules.workhours.entity.EmployeeWorkHours;
import com.els.modules.workhours.enumerate.WorkCategoryEnum;
import com.els.modules.workhours.enumerate.WorkHoursStatusEnum;
import com.els.modules.workhours.service.EmployeeWorkHoursService;
import com.els.rpc.service.CoreInvokeOtherRpcService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ProjectBaseInfoServiceImpl
extends BaseServiceImpl<ProjectBaseInfoMapper, ProjectBaseInfo>
implements ProjectBaseInfoService {
    @Resource
    private ProjectCostService projectCostService;
    @Resource
    private ProjectReceivablesService projectReceivablesService;
    @Resource
    private ProjectEnclosureService projectEnclosureService;
    @Resource
    private SalesContractApiService salesContractApiService;
    @Resource
    private SalesContractPlanApiService salesContractPlanApiService;
    @Autowired
    private BaseRpcService baseRpcService;
    @Autowired
    private CostExpenseService costExpenseService;
    @Autowired
    private PaymentRpcService paymentRpcService;
    @Autowired
    private PurchaseOrganizationInfoRpcService purchaseOrganizationInfoRpcService;
    @Autowired
    private PurchaseContractHeadApiService purchaseContractHeadApiService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(ProjectBaseInfo projectBaseInfo, List<ProjectCost> projectCostList, List<ProjectReceivables> projectReceivablesList, List<ProjectEnclosure> projectEnclosureList) {
        projectBaseInfo.setApprovalStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        PurchaseOrganizationInfoDTO dept = this.purchaseOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "dept", projectBaseInfo.getAffiliatedDepartmentId());
        if (dept != null) {
            projectBaseInfo.setAffiliatedDepartmentName(dept.getOrgName());
        }
        ((ProjectBaseInfoMapper)this.baseMapper).insert((Object)projectBaseInfo);
        super.setHeadDefaultValue((BaseEntity)projectBaseInfo);
        this.insertData(projectBaseInfo, projectCostList, projectReceivablesList, projectEnclosureList);
        if (StrUtil.isNotBlank((CharSequence)projectBaseInfo.getParentContractBaseinfoId())) {
            this.salesContractApiService.projectApproval(projectBaseInfo.getParentContractBaseinfoId(), projectBaseInfo.getAffiliatedDepartmentName(), projectBaseInfo.getAffiliatedDepartmentId());
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(ProjectBaseInfo projectBaseInfo, List<ProjectCost> projectCostList, List<ProjectReceivables> projectReceivablesList, List<ProjectEnclosure> projectEnclosureList) {
        int count;
        PurchaseOrganizationInfoDTO dept = this.purchaseOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "dept", projectBaseInfo.getAffiliatedDepartmentId());
        if (dept != null) {
            projectBaseInfo.setAffiliatedDepartmentName(dept.getOrgName());
        }
        Assert.isTrue(((count = ((ProjectBaseInfoMapper)this.baseMapper).updateById((Object)projectBaseInfo)) != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.projectCostService.deleteByMainId(projectBaseInfo.getId());
        this.projectReceivablesService.deleteByMainId(projectBaseInfo.getId());
        this.projectEnclosureService.deleteByMainId(projectBaseInfo.getId());
        this.insertData(projectBaseInfo, projectCostList, projectReceivablesList, projectEnclosureList);
    }

    private void insertData(ProjectBaseInfo projectBaseInfo, List<ProjectCost> projectCostList, List<ProjectReceivables> projectReceivablesList, List<ProjectEnclosure> projectEnclosureList) {
        if (!CollectionUtils.isEmpty(projectCostList)) {
            for (ProjectCost projectCost : projectCostList) {
                projectCost.setProjectId(projectBaseInfo.getId());
                SysUtil.setSysParam((BaseEntity)projectCost, (BaseEntity)projectBaseInfo);
            }
            this.projectCostService.saveBatch(projectCostList, 2000);
        }
        if (!CollectionUtils.isEmpty(projectReceivablesList)) {
            for (ProjectReceivables projectReceivables : projectReceivablesList) {
                projectReceivables.setProjectId(projectBaseInfo.getId());
                SysUtil.setSysParam((BaseEntity)projectReceivables, (BaseEntity)projectBaseInfo);
            }
            this.projectReceivablesService.saveBatch(projectReceivablesList, 2000);
        }
        if (!CollectionUtils.isEmpty(projectEnclosureList)) {
            for (ProjectEnclosure projectEnclosure : projectEnclosureList) {
                projectEnclosure.setProjectId(projectBaseInfo.getId());
                SysUtil.setSysParam((BaseEntity)projectEnclosure, (BaseEntity)projectBaseInfo);
            }
            this.projectEnclosureService.saveBatch(projectEnclosureList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        String contractId = ((ProjectBaseInfo)((Object)this.getById((Serializable)((Object)id)))).getParentContractBaseinfoId();
        if (StrUtil.isNotBlank((CharSequence)contractId)) {
            this.salesContractApiService.cancelProjectApproval(contractId);
        }
        this.projectCostService.deleteByMainId(id);
        this.projectReceivablesService.deleteByMainId(id);
        this.projectEnclosureService.deleteByMainId(id);
        ((ProjectBaseInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.projectCostService.deleteByMainId(serializable.toString());
            this.projectReceivablesService.deleteByMainId(serializable.toString());
            this.projectEnclosureService.deleteByMainId(serializable.toString());
            ((ProjectBaseInfoMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public JSONArray findProjectByType(String elsAccount, String projectType) {
        ArrayList<String> projectTypeList = new ArrayList<String>();
        ArrayList<String> projectStatusList = new ArrayList<String>();
        projectStatusList.add("operation");
        projectStatusList.add("conclusion");
        projectStatusList.add("subscribe");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"els_account", (Object)elsAccount)).eq((Object)"is_enable", (Object)CommonConstant.STATUS_YES)).ne((Object)"project_status", (Object)"notStarted")).ne((Object)"project_status", (Object)"");
        if (WorkCategoryEnum.PROJECT.getCode().equals(projectType)) {
            queryWrapper.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)wrapper.ne((Object)"project_status", (Object)"operation")).eq((Object)"project_type", (Object)"outer_project");
            });
        } else if (WorkCategoryEnum.OTHER.getCode().equals(projectType)) {
            projectTypeList.add("outer_project");
            queryWrapper.eq((Object)"project_status", (Object)"underway");
        } else if (WorkCategoryEnum.PRODUCT.getCode().equals(projectType)) {
            projectTypeList.add("product_develop");
            queryWrapper.eq((Object)"project_status", (Object)"underway");
        } else if (WorkCategoryEnum.DEVOPS.getCode().equals(projectType)) {
            projectTypeList.add("outer_project");
            queryWrapper.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"project_status", (Object)"operation")).or()).eq((Object)"project_type", (Object)"operation_project");
            });
        }
        List projectList = null;
        projectList = WorkCategoryEnum.DEVOPS.getCode().equals(projectType) || WorkCategoryEnum.PROJECT.getCode().equals(projectType) ? this.list((Wrapper)queryWrapper) : this.list((Wrapper)queryWrapper.in((Object)"project_type", projectTypeList));
        JSONArray result = new JSONArray();
        for (ProjectBaseInfo info : projectList) {
            JSONObject obj = new JSONObject();
            obj.put("id", (Object)info.getId());
            obj.put("name", (Object)info.getProjectName());
            result.add((Object)obj);
        }
        return result;
    }

    @Override
    public void refreshData(ProjectBaseInfo baseInfo) {
        BigDecimal bigDecimal1;
        Object salesContractById;
        Map salesContractByIdSet;
        String elsAccount = baseInfo.getElsAccount();
        BigDecimal maxWorkHours = BigDecimal.valueOf(this.getMaxWorkHours(elsAccount).intValue());
        String id = baseInfo.getId();
        ProjectBaseInfo updateInfo = new ProjectBaseInfo();
        updateInfo.setId(id);
        List hoursList = ((EmployeeWorkHoursService)SpringContextUtils.getBean(EmployeeWorkHoursService.class)).list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"check_status", (Object)WorkHoursStatusEnum.AUTH_COMPLETE.getValue())).eq((Object)"target_key", (Object)id)).eq((Object)"work_category", (Object)WorkCategoryEnum.PROJECT.getCode()));
        BigDecimal actualPersonDayCost = BigDecimal.ZERO;
        BigDecimal actualPersonDay = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)hoursList)) {
            for (EmployeeWorkHours hours : hoursList) {
                BigDecimal confirmHours = hours.getConfirmHours();
                BigDecimal costValue = hours.getCostValue() == null ? BigDecimal.ZERO : BigDecimal.valueOf(hours.getCostValue().intValue());
                BigDecimal cost = confirmHours.divide(maxWorkHours, 4, 4).multiply(costValue).setScale(2, 4);
                actualPersonDayCost = actualPersonDayCost.add(cost);
                actualPersonDay = actualPersonDay.add(confirmHours.divide(maxWorkHours, 4, 4));
            }
        }
        updateInfo.setActualPersonDay(actualPersonDay);
        updateInfo.setActualPersonDayCost(actualPersonDayCost);
        BigDecimal maintenancePersonDayCost = BigDecimal.ZERO;
        List devOpsoursList = ((EmployeeWorkHoursService)SpringContextUtils.getBean(EmployeeWorkHoursService.class)).list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"check_status", (Object)WorkHoursStatusEnum.AUTH_COMPLETE.getValue())).eq((Object)"target_key", (Object)id)).eq((Object)"work_category", (Object)WorkCategoryEnum.DEVOPS.getCode()));
        if (!CollectionUtils.isEmpty((Collection)devOpsoursList)) {
            for (EmployeeWorkHours hours : devOpsoursList) {
                BigDecimal confirmHours = hours.getConfirmHours();
                BigDecimal costValue = hours.getCostValue() == null ? BigDecimal.ZERO : BigDecimal.valueOf(hours.getCostValue().intValue());
                BigDecimal cost = confirmHours.divide(maxWorkHours, 4, 4).multiply(costValue).setScale(2, 4);
                maintenancePersonDayCost = maintenancePersonDayCost.add(cost);
            }
        }
        updateInfo.setMaintenancePersonDayCost(maintenancePersonDayCost);
        BigDecimal actualTravelCost = BigDecimal.ZERO;
        List costExpenseList = this.costExpenseService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"check_status", (Object)WorkHoursStatusEnum.AUTH_COMPLETE.getValue())).eq((Object)"project_id", (Object)id));
        for (CostExpense costExpense : costExpenseList) {
            if (costExpense.getAmount() == null) continue;
            actualTravelCost = actualTravelCost.add(costExpense.getAmount());
        }
        updateInfo.setActualTravelCost(actualTravelCost);
        BigDecimal externalProcurementCost = this.paymentRpcService.getExternalProcurementCost(elsAccount, id);
        updateInfo.setExternalProcurementCost(externalProcurementCost);
        BigDecimal totalCost = actualPersonDayCost.add(actualTravelCost).add(externalProcurementCost);
        updateInfo.setTotalCost(totalCost);
        BigDecimal bigDecimal = this.purchaseContractHeadApiService.selectPCTotalTaxAmountById(baseInfo.getId());
        if (bigDecimal != null) {
            BigDecimal bigDecimal2 = bigDecimal.setScale(2, 4);
            updateInfo.setFbk6(bigDecimal2.toString());
        }
        if ((salesContractByIdSet = (Map)(salesContractById = this.salesContractApiService.getById(baseInfo.getParentContractBaseinfoId()))) != null) {
            Object firstYearContractAmount = salesContractByIdSet.get("firstYearContractAmount");
            if (firstYearContractAmount != null) {
                updateInfo.setFbk7(firstYearContractAmount.toString());
            }
            if (salesContractByIdSet.get("softwareFee") != null) {
                Object softwareFee = salesContractByIdSet.get("softwareFee");
                updateInfo.setSoftwareFee((BigDecimal)softwareFee);
            }
        }
        if ((bigDecimal1 = this.purchaseContractHeadApiService.selectPCHTenancyRentTotal(baseInfo.getId())) != null) {
            BigDecimal bigDecimal3 = bigDecimal1.setScale(2, 4);
            updateInfo.setFbk8(bigDecimal3.toString());
        }
        this.updateById((Object)updateInfo);
    }

    private Integer getMaxWorkHours(String elsAccount) {
        Integer maxWorkHours = 8;
        ElsCompanySetDTO companySetDTO = this.baseRpcService.getElsCompanySetByElsAccountAndItemCode(elsAccount, "maxWorkHours");
        if (companySetDTO != null && StrUtil.isNotBlank((CharSequence)companySetDTO.getDefaultValue())) {
            try {
                maxWorkHours = Integer.valueOf(companySetDTO.getDefaultValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return maxWorkHours;
    }

    @Override
    public int updateCollectionInfo() {
        List projectBaseInfos = this.list();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<ProjectReceivables> projectReceivablesList = new ArrayList<ProjectReceivables>();
        for (ProjectBaseInfo projectBaseInfo : projectBaseInfos) {
            List<ProjectReceivables> projectReceivables = this.projectReceivablesService.selectByMainId(projectBaseInfo.getId());
            List collect = projectReceivables.stream().filter(s -> StringUtils.isBlank((String)s.getFbk1())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                List plansByHeadId = this.salesContractPlanApiService.getPlansByHeadId(projectBaseInfo.getParentContractBaseinfoId());
                if (!CollectionUtil.isNotEmpty((Collection)plansByHeadId)) continue;
                this.projectReceivablesService.deleteByMainId(projectBaseInfo.getId());
                BigDecimal sumAll = BigDecimal.ZERO;
                for (SalesContractPlanDto salesContractPlanDto : plansByHeadId) {
                    ProjectReceivables projectReceivables1 = new ProjectReceivables();
                    ProjectReceivablesDTO receivables = new ProjectReceivablesDTO();
                    receivables.setPayRate(new BigDecimal(salesContractPlanDto.getContractPercentage().replace("%", "")));
                    receivables.setStatus(salesContractPlanDto.getStatus());
                    receivables.setTax(new BigDecimal(salesContractPlanDto.getTaxRate()));
                    receivables.setContractPayTimeHistory(salesContractPlanDto.getStage());
                    receivables.setPayTimeHistory(salesContractPlanDto.getPaymentDesc());
                    receivables.setPlanReceivablesTime(salesContractPlanDto.getPlanCollectionDate());
                    if (salesContractPlanDto.getCollectionAmount() != null) {
                        receivables.setActualReceivablesAmount(salesContractPlanDto.getCollectionAmount());
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)salesContractPlanDto.getCollectionDate())) {
                        receivables.setActualReceivablesTime(salesContractPlanDto.getCollectionDate());
                    }
                    receivables.setRemark(salesContractPlanDto.getRemarks());
                    receivables.setSortIndex(salesContractPlanDto.getSort());
                    receivables.setPlanReceivablesAmount(salesContractPlanDto.getTaxIncludedAmount());
                    if (salesContractPlanDto.getInvoicingAmount() != null) {
                        receivables.setDrawBillAmount(salesContractPlanDto.getInvoicingAmount());
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)salesContractPlanDto.getInvoicingDate())) {
                        receivables.setDrawBillTime(salesContractPlanDto.getInvoicingDate());
                    }
                    receivables.setFbk1(salesContractPlanDto.getId());
                    receivables.setFbk4(salesContractPlanDto.getByStages());
                    receivables.setFbk3(salesContractPlanDto.getInvoicingDate());
                    receivables.setProjectId(projectBaseInfo.getId());
                    if (salesContractPlanDto.getCollectionAmount() != null) {
                        receivables.setAccumulativeReceivablesAmount(sumAll.add(salesContractPlanDto.getCollectionAmount()));
                    }
                    BeanUtils.copyProperties((Object)receivables, (Object)((Object)projectReceivables1));
                    projectReceivablesList.add(projectReceivables1);
                }
                this.projectReceivablesService.saveBatch(projectReceivablesList, 4000);
                continue;
            }
            List<ProjectReceivables> receivablesList = this.projectReceivablesService.selectByMainId(projectBaseInfo.getId());
            for (ProjectReceivables receivables : receivablesList) {
                SalesContractPlanDto plansById = this.salesContractPlanApiService.getPlansById(receivables.getFbk1());
                if (receivables.getActualReceivablesAmount() != null || plansById.getCollectionAmount() == null) continue;
                receivables.setAccumulativeReceivablesAmount(plansById.getCollectionAmount());
            }
        }
        return 0;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public List<ProjectEnclosure> updateProjectEnclosure() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)"1517606");
        queryWrapper.ge((Object)"create_time", (Object)"2018-11-01");
        List projectBaseInfos = this.list((Wrapper)queryWrapper);
        ArrayList<ProjectEnclosure> projectEnclosures = new ArrayList<ProjectEnclosure>();
        for (ProjectBaseInfo projectBaseInfo : projectBaseInfos) {
            JSONArray array;
            ProjectEnclosure projectEnclosure;
            ProjectEnclosureDTO projectEnclosureDTO;
            JSONArray objects = this.salesContractApiService.updateProjectEnclosures(projectBaseInfo.getParentContractBaseinfoId());
            JSONArray objects1 = this.salesContractApiService.updateProjectEnclosures1(projectBaseInfo.getParentContractBaseinfoId());
            List attachmentDTOS = JSONObject.parseArray((String)objects.toJSONString(), PurchaseAttachmentDTO.class);
            List elsSealFileItems = JSONObject.parseArray((String)objects1.toJSONString(), PurchaseAttachmentDTO.class);
            if (!CollectionUtils.isEmpty((Collection)attachmentDTOS) || !CollectionUtils.isEmpty((Collection)elsSealFileItems)) {
                this.projectEnclosureService.removeByMainId(projectBaseInfo.getId());
            }
            if (!attachmentDTOS.isEmpty()) {
                for (PurchaseAttachmentDTO entity : attachmentDTOS) {
                    projectEnclosureDTO = new ProjectEnclosureDTO();
                    projectEnclosure = new ProjectEnclosure();
                    projectEnclosureDTO.setEnclosureName(entity.getFileName());
                    array = new JSONArray();
                    array.add(JSONObject.toJSON((Object)entity));
                    projectEnclosureDTO.setAttachment((Object)array.toJSONString());
                    projectEnclosureDTO.setFileId(entity.getId());
                    projectEnclosureDTO.setProjectId(projectBaseInfo.getId());
                    BeanUtils.copyProperties((Object)projectEnclosureDTO, (Object)((Object)projectEnclosure));
                    projectEnclosures.add(projectEnclosure);
                }
            }
            if (elsSealFileItems.isEmpty()) continue;
            for (PurchaseAttachmentDTO entity : elsSealFileItems) {
                projectEnclosureDTO = new ProjectEnclosureDTO();
                projectEnclosure = new ProjectEnclosure();
                projectEnclosureDTO.setEnclosureName(entity.getFileName());
                projectEnclosureDTO.setProjectId(projectBaseInfo.getId());
                array = new JSONArray();
                array.add(JSONObject.toJSON((Object)entity));
                projectEnclosureDTO.setAttachment((Object)array.toJSONString());
                projectEnclosureDTO.setFileId(entity.getId());
                BeanUtils.copyProperties((Object)projectEnclosureDTO, (Object)((Object)projectEnclosure));
                projectEnclosures.add(projectEnclosure);
            }
        }
        this.projectEnclosureService.saveBatch(projectEnclosures, 4000);
        return projectEnclosures;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void transport(ProjectBaseInfo projectBaseInfo, List<ProjectEnclosure> projectEnclosureList) {
        ProjectBaseInfo baseInfo = (ProjectBaseInfo)((Object)((ProjectBaseInfoMapper)this.baseMapper).selectById((Serializable)((Object)projectBaseInfo.getId())));
        if (baseInfo == null) {
            throw new ELSBootException("\u9879\u76ee\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (projectBaseInfo.getOnlineDate() != null) {
            baseInfo.setOnlineDate(projectBaseInfo.getOnlineDate());
        }
        if (projectBaseInfo.getAcceptanceDate() != null) {
            baseInfo.setAcceptanceDate(projectBaseInfo.getAcceptanceDate());
        }
        if (projectBaseInfo.getTransitDimensionDate() != null) {
            baseInfo.setTransitDimensionDate(projectBaseInfo.getTransitDimensionDate());
        }
        if (StringUtils.isNotEmpty((String)projectBaseInfo.getMaintenanceConsultantId())) {
            baseInfo.setMaintenanceConsultantId(projectBaseInfo.getMaintenanceConsultantId());
        }
        if (StringUtils.isNotEmpty((String)projectBaseInfo.getMaintenanceConsultantName())) {
            baseInfo.setMaintenanceConsultantName(projectBaseInfo.getMaintenanceConsultantName());
        }
        if (StringUtils.isNotEmpty((String)projectBaseInfo.getMaintenanceDevId())) {
            baseInfo.setMaintenanceDevId(projectBaseInfo.getMaintenanceDevId());
        }
        if (StringUtils.isNotEmpty((String)projectBaseInfo.getMaintenanceDevName())) {
            baseInfo.setMaintenanceDevName(projectBaseInfo.getMaintenanceDevName());
        }
        if (StringUtils.isNotEmpty((String)projectBaseInfo.getMaintenanceTeamId())) {
            baseInfo.setMaintenanceTeamId(projectBaseInfo.getMaintenanceTeamId());
        }
        if (StringUtils.isNotEmpty((String)projectBaseInfo.getMaintenanceTeamName())) {
            baseInfo.setMaintenanceTeamName(projectBaseInfo.getMaintenanceTeamName());
        }
        baseInfo.setProjectStatus("operation");
        int count = ((ProjectBaseInfoMapper)this.baseMapper).updateById((Object)baseInfo);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        if (CollectionUtil.isNotEmpty(projectEnclosureList)) {
            for (ProjectEnclosure entity : projectEnclosureList) {
                entity.setProjectId(projectBaseInfo.getId());
                SysUtil.setSysParam((BaseEntity)baseInfo, (BaseEntity)projectBaseInfo);
            }
            this.projectEnclosureService.saveBatch(projectEnclosureList, 2000);
        }
        this.invokePanshiUpdateProject(baseInfo);
    }

    @Override
    public List<BpSystemDeployApply> init() {
        return ((ProjectBaseInfoMapper)this.baseMapper).init();
    }

    private void invokePanshiUpdateProject(ProjectBaseInfo baseInfo) {
        try {
            ElsSubAccountDTO accountDTO;
            CoreInvokeOtherRpcService rpcService = (CoreInvokeOtherRpcService)SpringContextUtils.getBean(CoreInvokeOtherRpcService.class);
            JSONObject body = new JSONObject();
            body.put("projectName", (Object)baseInfo.getProjectName());
            if (StringUtils.isNotEmpty((String)baseInfo.getMaintenanceConsultantId())) {
                body.put("projectPrincipal", (Object)baseInfo.getMaintenanceConsultantId());
            }
            if (baseInfo.getOnlineDate() != null) {
                body.put("onlineDate", (Object)DateUtil.formatDate((Date)baseInfo.getOnlineDate()));
            }
            if (baseInfo.getAcceptanceDate() != null) {
                body.put("checkDate", (Object)DateUtil.formatDate((Date)baseInfo.getAcceptanceDate()));
            }
            if (baseInfo.getTransitDimensionDate() != null) {
                body.put("toOperationDate", (Object)DateUtil.formatDate((Date)baseInfo.getTransitDimensionDate()));
            }
            if (StringUtils.isNotEmpty((String)baseInfo.getCustomerSuccessManagerId()) && (accountDTO = this.invokeAccountRpcService.getAccountById(baseInfo.getCustomerSuccessManagerId())) != null) {
                body.put("csm", (Object)accountDTO.getSubAccount());
            }
            if (baseInfo.getMaintenanceTeamName() != null) {
                body.put("maintenanceTeamName", (Object)baseInfo.getMaintenanceTeamName());
            }
            if (baseInfo.getMaintenanceDevId() != null) {
                body.put("maintenanceDevId", (Object)baseInfo.getMaintenanceDevId());
            }
            body.put("signatory", (Object)baseInfo.getContractBody());
            body.put("businessManager", (Object)baseInfo.getCustomerManagerName());
            body.put("clientName", (Object)baseInfo.getParentCustomerName());
            rpcService.callPanshi("updateProject", body);
        }
        catch (Exception e) {
            this.log.error("invokePanshiUpdateProject_failed:", (Throwable)e);
        }
    }
}

