/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.entity.ProjectInfoChange;
import com.els.modules.project.mapper.ProjectInfoChangeMapper;
import com.els.modules.project.service.ProjectBaseInfoService;
import com.els.modules.project.service.ProjectInfoChangeService;
import com.els.modules.project.vo.ProjectBaseInfoVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectInfoChangeServiceImpl
extends BaseServiceImpl<ProjectInfoChangeMapper, ProjectInfoChange>
implements ProjectInfoChangeService {
    @Autowired
    private ProjectBaseInfoService projectBaseInfoService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void save(ProjectBaseInfoVO infoVO) {
        String projectId = infoVO.getProjectId();
        List changeList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).ne((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue()));
        ProjectInfoChange infoChange = null;
        ProjectBaseInfo oldProjectBaseInfo = null;
        ProjectBaseInfo newProjectBaseInfo = new ProjectBaseInfo();
        BeanUtils.copyProperties((Object)((Object)infoVO), (Object)((Object)newProjectBaseInfo));
        String saveType = "0";
        if (!changeList.isEmpty()) {
            saveType = "1";
            infoChange = (ProjectInfoChange)((Object)changeList.get(0));
            oldProjectBaseInfo = (ProjectBaseInfo)((Object)JSONObject.parseObject((String)infoChange.getBeforeData(), ProjectBaseInfo.class));
        } else {
            infoChange = new ProjectInfoChange();
            infoChange.setId(IdWorker.getIdStr());
            infoChange.setChangeNumber(this.invokeBaseRpcService.getNextCode("bpProjectChangeNumber", (Object)infoChange));
            oldProjectBaseInfo = (ProjectBaseInfo)((Object)this.projectBaseInfoService.getById((Serializable)((Object)infoVO.getId())));
            JSONObject oldObj = SysUtil.objectToJSON((Object)((Object)oldProjectBaseInfo));
            oldObj.put("projectId", (Object)oldProjectBaseInfo.getId());
            oldObj.put("id", (Object)infoChange.getId());
            infoChange.setBeforeData(oldObj.toJSONString());
            infoChange.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            infoChange.setProjectId(projectId);
            infoChange.setProjectName(oldProjectBaseInfo.getProjectName());
            infoChange.setProjectNumber(oldProjectBaseInfo.getProjectNumber());
            infoChange.setTemplateAccount(oldProjectBaseInfo.getTemplateAccount());
            infoChange.setTemplateName(oldProjectBaseInfo.getTemplateNumber());
            infoChange.setTemplateNumber(oldProjectBaseInfo.getTemplateNumber());
            infoChange.setTemplateVersion(oldProjectBaseInfo.getTemplateVersion() + "");
        }
        JSONObject newObj = SysUtil.objectToJSON((Object)((Object)newProjectBaseInfo));
        newObj.put("id", (Object)infoChange.getId());
        newObj.put("projectId", (Object)projectId);
        infoChange.setAfterData(newObj.toJSONString());
        infoChange.setFieldData(this.getChangeFiledJsonData(oldProjectBaseInfo, newProjectBaseInfo));
        if ("0".equals(saveType)) {
            this.save((Object)infoChange);
        } else {
            this.updateById((Object)infoChange);
        }
        infoVO.setId(infoChange.getId());
    }

    private String getChangeFiledJsonData(ProjectBaseInfo oldProjectBaseInfo, ProjectBaseInfo newProjectBaseInfo) {
        JSONObject oldObj = SysUtil.objectToJSON((Object)((Object)oldProjectBaseInfo));
        JSONObject newObj = SysUtil.objectToJSON((Object)((Object)newProjectBaseInfo));
        JSONArray result = new JSONArray();
        List<Field> fieldList = Arrays.asList(((Object)((Object)oldProjectBaseInfo)).getClass().getDeclaredFields());
        for (Field field : fieldList) {
            JSONObject changeObj;
            Object newFieldValue;
            Object oldFieldValue;
            String fieldName = field.getName();
            if (Number.class.isAssignableFrom(field.getType())) {
                oldFieldValue = oldObj.getBigDecimal(fieldName);
                if (!this.getBigDecimalChangeFlag((BigDecimal)oldFieldValue, (BigDecimal)(newFieldValue = newObj.getBigDecimal(fieldName)))) continue;
                changeObj = new JSONObject();
                changeObj.put("fieldName", (Object)fieldName);
                changeObj.put("oldFieldValue", oldFieldValue);
                changeObj.put("newFieldValue", newFieldValue);
                result.add((Object)changeObj);
                continue;
            }
            oldFieldValue = oldObj.getString(fieldName);
            if (!this.getStringChangeFlag((String)oldFieldValue, (String)(newFieldValue = newObj.getString(fieldName)))) continue;
            changeObj = new JSONObject();
            changeObj.put("fieldName", (Object)fieldName);
            changeObj.put("oldFieldValue", oldFieldValue);
            changeObj.put("newFieldValue", newFieldValue);
            result.add((Object)changeObj);
        }
        if (result.isEmpty()) {
            throw new ELSBootException("\u5f53\u524d\u672a\u505a\u4efb\u4f55\u53d8\u66f4\uff0c\u4e0d\u80fd\u4fdd\u5b58\uff01");
        }
        return result.toJSONString();
    }

    private boolean getBigDecimalChangeFlag(BigDecimal oldFieldValue, BigDecimal newFieldValue) {
        if (oldFieldValue == null && newFieldValue == null) {
            return false;
        }
        if (oldFieldValue != null && newFieldValue == null) {
            return true;
        }
        if (oldFieldValue == null && newFieldValue != null) {
            return true;
        }
        return oldFieldValue.compareTo(newFieldValue) != 0;
    }

    private boolean getStringChangeFlag(String oldFieldValue, String newFieldValue) {
        if (StrUtil.isBlank((CharSequence)oldFieldValue) && StrUtil.isBlank((CharSequence)newFieldValue)) {
            return false;
        }
        if (StrUtil.isNotBlank((CharSequence)oldFieldValue) && StrUtil.isBlank((CharSequence)newFieldValue)) {
            return true;
        }
        if (StrUtil.isBlank((CharSequence)oldFieldValue) && StrUtil.isNotBlank((CharSequence)newFieldValue)) {
            return true;
        }
        return !oldFieldValue.equals(newFieldValue);
    }

    @Override
    public void delete(String id) {
        ((ProjectInfoChangeMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public JSONObject queryById(String id) {
        ProjectInfoChange infoChange = (ProjectInfoChange)((Object)this.getById((Serializable)((Object)id)));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        Result result = null;
        ProjectBaseInfo oldProjectBaseInfo = (ProjectBaseInfo)((Object)JSONObject.parseObject((String)infoChange.getBeforeData(), ProjectBaseInfo.class));
        ProjectBaseInfo newProjectBaseInfo = (ProjectBaseInfo)((Object)JSONObject.parseObject((String)infoChange.getAfterData(), ProjectBaseInfo.class));
        result = Result.ok((Object)((Object)oldProjectBaseInfo));
        dictAspect.parseDictText((Object)result);
        JSONObject oldObj = (JSONObject)result.getResult();
        result = Result.ok((Object)((Object)newProjectBaseInfo));
        dictAspect.parseDictText((Object)result);
        JSONObject newObj = (JSONObject)result.getResult();
        JSONArray filedArray = JSONObject.parseArray((String)infoChange.getFieldData());
        for (Object obj : filedArray) {
            JSONObject filedObj = (JSONObject)obj;
            oldObj.put(filedObj.getString("fieldName") + "_new", (Object)filedObj.getString("newFieldValue"));
            if (!oldObj.containsKey((Object)(filedObj.getString("fieldName") + "_dictText"))) continue;
            oldObj.put(filedObj.getString("fieldName") + "_new_dictText", (Object)newObj.getString(filedObj.getString("fieldName") + "_dictText"));
        }
        oldObj.put("flowId", (Object)infoChange.getFlowId());
        return oldObj;
    }

    @Override
    public JSONObject queryEditById(String id) {
        ProjectInfoChange infoChange = (ProjectInfoChange)((Object)this.getById((Serializable)((Object)id)));
        if (infoChange == null) {
            ProjectBaseInfo baseInfo = (ProjectBaseInfo)((Object)this.projectBaseInfoService.getById((Serializable)((Object)id)));
            if (baseInfo == null) {
                throw new ELSBootException("id \u4e0d\u5b58\u5728\uff01");
            }
            List changeList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)id)).ne((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue()));
            if (changeList.isEmpty()) {
                JSONObject resultObj = SysUtil.objectToJSON((Object)((Object)baseInfo));
                resultObj.put("projectId", (Object)baseInfo.getId());
                return resultObj;
            }
            return JSONObject.parseObject((String)((ProjectInfoChange)((Object)changeList.get(0))).getAfterData());
        }
        return JSONObject.parseObject((String)infoChange.getAfterData());
    }
}

