/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.entity.ProjectMainPlan;
import com.els.modules.project.entity.ProjectMainPlanChange;
import com.els.modules.project.enumerate.MainPlanDictEnum;
import com.els.modules.project.mapper.ProjectMainPlanChangeMapper;
import com.els.modules.project.service.ProjectBaseInfoService;
import com.els.modules.project.service.ProjectMainPlanChangeService;
import com.els.modules.project.service.ProjectMainPlanService;
import com.els.modules.project.vo.FieldRecordVo;
import com.els.modules.project.vo.ProjectBaseInfoVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectMainPlanChangeServiceImpl
extends BaseServiceImpl<ProjectMainPlanChangeMapper, ProjectMainPlanChange>
implements ProjectMainPlanChangeService {
    @Autowired
    private ProjectMainPlanService projectMainPlanService;
    @Autowired
    private ProjectBaseInfoService projectBaseInfoService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void delete(String id) {
        ((ProjectMainPlanChangeMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void save(ProjectBaseInfoVO infoVO) {
        String projectId = infoVO.getProjectId();
        List changeList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).ne((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue()));
        ProjectMainPlanChange infoChange = null;
        ProjectBaseInfoVO oldProjectBaseInfo = new ProjectBaseInfoVO();
        ProjectBaseInfo baseInfo = (ProjectBaseInfo)((Object)this.projectBaseInfoService.getById((Serializable)((Object)projectId)));
        BeanUtils.copyProperties((Object)((Object)baseInfo), (Object)((Object)oldProjectBaseInfo));
        ProjectBaseInfoVO newProjectBaseInfo = new ProjectBaseInfoVO();
        BeanUtils.copyProperties((Object)((Object)oldProjectBaseInfo), (Object)((Object)newProjectBaseInfo));
        List<ProjectMainPlan> oldProjectMainPlanList = this.projectMainPlanService.selectByMainId(projectId);
        if (oldProjectMainPlanList.isEmpty()) {
            throw new ELSBootException("\u8be5\u9879\u76ee\u5c1a\u672a\u521b\u5efa\u4e3b\u8ba1\u5212\uff0c\u4e0d\u80fd\u521b\u5efa\u4e3b\u8ba1\u5212\u53d8\u66f4\u5355\uff01");
        }
        oldProjectBaseInfo.setProjectMainPlanList(oldProjectMainPlanList);
        newProjectBaseInfo.setProjectMainPlanList(infoVO.getProjectMainPlanList());
        String saveType = "0";
        if (!changeList.isEmpty()) {
            saveType = "1";
            infoChange = (ProjectMainPlanChange)((Object)changeList.get(0));
        } else {
            infoChange = new ProjectMainPlanChange();
            infoChange.setId(IdWorker.getIdStr());
            JSONObject oldObj = SysUtil.objectToJSON((Object)((Object)oldProjectBaseInfo));
            oldObj.put("projectId", (Object)projectId);
            oldObj.put("id", (Object)infoChange.getId());
            infoChange.setBeforeData(oldObj.toJSONString());
            infoChange.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            infoChange.setProjectId(projectId);
            infoChange.setProjectName(infoVO.getProjectName());
            infoChange.setProjectNumber(infoVO.getProjectNumber());
        }
        JSONObject newObj = SysUtil.objectToJSON((Object)((Object)newProjectBaseInfo));
        newObj.put("projectId", (Object)projectId);
        newObj.put("id", (Object)infoChange.getId());
        infoChange.setAfterData(newObj.toJSONString());
        infoChange.setFieldData(this.getChangeFiledJsonData(oldProjectBaseInfo, newProjectBaseInfo));
        if ("0".equals(saveType)) {
            this.save((Object)infoChange);
        } else {
            this.updateById((Object)infoChange);
        }
        infoVO.setId(infoChange.getId());
    }

    private String getChangeFiledJsonData(ProjectBaseInfoVO oldInfo, ProjectBaseInfoVO newInfo) {
        JSONObject newObj;
        String fieldName;
        List<Field> fieldList;
        JSONArray result = new JSONArray();
        List<ProjectMainPlan> newMainPlanList = newInfo.getProjectMainPlanList();
        HashMap<String, ProjectMainPlan> newMainPlanMap = new HashMap<String, ProjectMainPlan>();
        ArrayList<ProjectMainPlan> addMainPlanList = new ArrayList<ProjectMainPlan>();
        for (ProjectMainPlan entity : newMainPlanList) {
            if (StringUtils.isBlank((CharSequence)entity.getId())) {
                addMainPlanList.add(entity);
                continue;
            }
            newMainPlanMap.put(entity.getId(), entity);
        }
        List<ProjectMainPlan> oldMainPlanList = oldInfo.getProjectMainPlanList();
        Map oldMainPlanMap = oldMainPlanList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        for (ProjectMainPlan entity : oldMainPlanList) {
            JSONObject oldObj;
            if (newMainPlanMap.get(entity.getId()) == null) {
                oldObj = SysUtil.objectToJSON((Object)((Object)entity));
                fieldList = Arrays.asList(ProjectMainPlan.class.getDeclaredFields());
                for (Field field : fieldList) {
                    fieldName = field.getName();
                    this.changFiled(field, oldObj, null, fieldName, result, "projectMainPlanList", "3", entity.getId());
                }
                continue;
            }
            oldObj = SysUtil.objectToJSON((Object)((Object)entity));
            JSONObject newObj2 = SysUtil.objectToJSON(newMainPlanMap.get(entity.getId()));
            Iterator<Field> fieldList2 = Arrays.asList(ProjectMainPlan.class.getDeclaredFields());
            Iterator<Field> iterator = fieldList2.iterator();
            while (iterator.hasNext()) {
                Field field3 = iterator.next();
                String fieldName2 = field3.getName();
                this.changFiled(field3, oldObj, newObj2, fieldName2, result, "projectMainPlanList", "1", entity.getId());
            }
        }
        for (ProjectMainPlan entity : addMainPlanList) {
            entity.setId(IdWorker.getIdStr());
            newObj = SysUtil.objectToJSON((Object)((Object)entity));
            fieldList = Arrays.asList(ProjectMainPlan.class.getDeclaredFields());
            for (Field field : fieldList) {
                fieldName = field.getName();
                this.changFiled(field, null, newObj, fieldName, result, "projectMainPlanList", "2", entity.getId());
            }
        }
        for (ProjectMainPlan entity : newMainPlanList) {
            if (!StringUtils.isNotBlank((CharSequence)entity.getId()) || oldMainPlanMap.get(entity.getId()) != null) continue;
            newObj = SysUtil.objectToJSON((Object)((Object)entity));
            fieldList = Arrays.asList(ProjectMainPlan.class.getDeclaredFields());
            for (Field field : fieldList) {
                fieldName = field.getName();
                this.changFiled(field, null, newObj, fieldName, result, "projectMainPlanList", "2", entity.getId());
            }
            JSONObject changeObj = new JSONObject();
            changeObj.put("fieldName", (Object)"id");
            changeObj.put("oldFieldValue", (Object)"");
            changeObj.put("newFieldValue", (Object)entity.getId());
            changeObj.put("group", (Object)"projectMainPlanList");
            changeObj.put("updateType", (Object)"2");
            changeObj.put("itemId", (Object)entity.getId());
            result.add((Object)changeObj);
        }
        if (result.isEmpty()) {
            throw new ELSBootException("\u5f53\u524d\u672a\u505a\u4efb\u4f55\u53d8\u66f4\uff0c\u4e0d\u80fd\u4fdd\u5b58\uff01");
        }
        return result.toJSONString();
    }

    private void changFiled(Field field, JSONObject oldObj, JSONObject newObj, String fieldName, JSONArray result, String groupCode, String operate, String itemId) {
        JSONObject changeObj = new JSONObject();
        changeObj.put("fieldName", (Object)fieldName);
        if (Number.class.isAssignableFrom(field.getType())) {
            if (oldObj == null) {
                changeObj.put("oldFieldValue", (Object)"");
                BigDecimal newFieldValue = newObj.getBigDecimal(fieldName);
                changeObj.put("newFieldValue", (Object)newFieldValue);
            } else if (newObj == null) {
                changeObj.put("newFieldValue", (Object)"");
                BigDecimal oldFieldValue = oldObj.getBigDecimal(fieldName);
                changeObj.put("oldFieldValue", (Object)oldFieldValue);
            } else {
                BigDecimal newFieldValue;
                BigDecimal oldFieldValue = oldObj.getBigDecimal(fieldName);
                if (this.getBigDecimalChangeFlag(oldFieldValue, newFieldValue = newObj.getBigDecimal(fieldName))) {
                    changeObj.put("oldFieldValue", (Object)oldFieldValue);
                    changeObj.put("newFieldValue", (Object)newFieldValue);
                }
            }
        } else if (oldObj == null) {
            changeObj.put("oldFieldValue", (Object)"");
            String newFieldValue = newObj.getString(fieldName);
            changeObj.put("newFieldValue", (Object)newFieldValue);
        } else if (newObj == null) {
            changeObj.put("newFieldValue", (Object)"");
            String oldFieldValue = oldObj.getString(fieldName);
            changeObj.put("oldFieldValue", (Object)oldFieldValue);
        } else {
            String newFieldValue;
            String oldFieldValue = oldObj.getString(fieldName);
            if (this.getStringChangeFlag(oldFieldValue, newFieldValue = newObj.getString(fieldName))) {
                changeObj.put("oldFieldValue", (Object)oldFieldValue);
                changeObj.put("newFieldValue", (Object)newFieldValue);
            }
        }
        changeObj.put("group", (Object)groupCode);
        changeObj.put("updateType", (Object)operate);
        changeObj.put("itemId", (Object)itemId);
        if (!(StringUtils.isBlank((CharSequence)changeObj.getString("oldFieldValue")) && StringUtils.isBlank((CharSequence)changeObj.getString("newFieldValue")) || "currentChangeId".equals(changeObj.getString("fieldName")))) {
            result.add((Object)changeObj);
        }
    }

    private boolean getBigDecimalChangeFlag(BigDecimal oldFieldValue, BigDecimal newFieldValue) {
        if (oldFieldValue == null && newFieldValue == null) {
            return false;
        }
        if (oldFieldValue != null && newFieldValue == null) {
            return true;
        }
        if (oldFieldValue == null && newFieldValue != null) {
            return true;
        }
        return oldFieldValue.compareTo(newFieldValue) != 0;
    }

    private boolean getStringChangeFlag(String oldFieldValue, String newFieldValue) {
        if (StrUtil.isBlank((CharSequence)oldFieldValue) && StrUtil.isBlank((CharSequence)newFieldValue)) {
            return false;
        }
        if (StrUtil.isNotBlank((CharSequence)oldFieldValue) && StrUtil.isBlank((CharSequence)newFieldValue)) {
            return true;
        }
        if (StrUtil.isBlank((CharSequence)oldFieldValue) && StrUtil.isNotBlank((CharSequence)newFieldValue)) {
            return true;
        }
        return !oldFieldValue.equals(newFieldValue);
    }

    @Override
    public JSONObject queryById(String id) {
        ProjectMainPlanChange infoChange = (ProjectMainPlanChange)((Object)this.getById((Serializable)((Object)id)));
        String beforeData = infoChange.getBeforeData();
        ProjectBaseInfoVO dataVO = (ProjectBaseInfoVO)((Object)JSONObject.parseObject((String)beforeData, ProjectBaseInfoVO.class));
        List<ProjectMainPlan> projectMainPlanList = dataVO.getProjectMainPlanList();
        String fieldData = infoChange.getFieldData();
        List recordVoList = JSONObject.parseArray((String)fieldData, FieldRecordVo.class);
        JSONObject jsonObject = JSONObject.parseObject((String)beforeData);
        Result result = new Result();
        result = Result.ok((Object)((Object)dataVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        JSONObject parseVo = (JSONObject)result.getResult();
        jsonObject.putAll((Map)parseVo);
        jsonObject.put("id", (Object)infoChange.getId());
        jsonObject.put("flowId", (Object)infoChange.getFlowId());
        jsonObject.put("workFlowType", (Object)infoChange.getWorkFlowType());
        jsonObject.put("auditStatus", (Object)infoChange.getAuditStatus());
        jsonObject.put("projectMainPlanList_hasStar", (Object)true);
        jsonObject.put("projectMainPlanList", (Object)this.getMainPlanJsonArray(projectMainPlanList, recordVoList));
        return jsonObject;
    }

    @Override
    public JSONObject queryEditById(String id) {
        ProjectMainPlanChange infoChange = (ProjectMainPlanChange)((Object)this.getById((Serializable)((Object)id)));
        if (infoChange == null) {
            ProjectBaseInfo baseInfo = (ProjectBaseInfo)((Object)this.projectBaseInfoService.getById((Serializable)((Object)id)));
            if (baseInfo == null) {
                throw new ELSBootException("id \u4e0d\u5b58\u5728\uff01");
            }
            List changeList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)id)).ne((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue()));
            if (changeList.isEmpty()) {
                ProjectBaseInfoVO infoVO = new ProjectBaseInfoVO();
                BeanUtils.copyProperties((Object)((Object)baseInfo), (Object)((Object)infoVO));
                List<ProjectMainPlan> projectMainPlanList = this.projectMainPlanService.selectByMainId(id);
                infoVO.setProjectMainPlanList(projectMainPlanList);
                JSONObject resultObj = SysUtil.objectToJSON((Object)((Object)infoVO));
                resultObj.put("projectId", (Object)baseInfo.getId());
                return resultObj;
            }
            return JSONObject.parseObject((String)((ProjectMainPlanChange)((Object)changeList.get(0))).getAfterData());
        }
        return JSONObject.parseObject((String)infoChange.getAfterData());
    }

    private JSONArray getMainPlanJsonArray(List<ProjectMainPlan> projectMainPlanList, List<FieldRecordVo> contactsRecordList) {
        List dictDTOS;
        JSONArray jsonArray = new JSONArray();
        List updList = contactsRecordList.parallelStream().filter(o -> "1".equals(o.getUpdateType())).collect(Collectors.toList());
        List addList = contactsRecordList.parallelStream().filter(o -> "2".equals(o.getUpdateType())).collect(Collectors.toList());
        List delList = contactsRecordList.parallelStream().filter(o -> "3".equals(o.getUpdateType())).collect(Collectors.toList());
        String newDictText = "";
        for (ProjectMainPlan info : projectMainPlanList.parallelStream().filter(o -> o.getId() != null).collect(Collectors.toList())) {
            List recordVos = updList.parallelStream().filter(o -> o.getItemId().equals(info.getId())).collect(Collectors.toList());
            JSONObject object = JSONObject.parseObject((String)String.valueOf(JSONObject.toJSONString((Object)((Object)info))));
            if (!recordVos.isEmpty() && recordVos.size() > 0) {
                object.put("updateType", (Object)1);
                object.put("updateType_dictText", (Object)"\u4fee\u6539");
            }
            JSONObject objectNew = new JSONObject();
            String value = "";
            for (Map.Entry entry : object.entrySet()) {
                value = entry.getValue();
                objectNew.put((String)entry.getKey(), (Object)value);
                if (StringUtils.isNotBlank((CharSequence)MainPlanDictEnum.getByField((String)entry.getKey()))) {
                    dictDTOS = this.invokeBaseRpcService.queryDictItemsByCode(MainPlanDictEnum.getByField((String)entry.getKey()), TenantContext.getTenant());
                    value = dictDTOS.parallelStream().filter(o -> o.getValue().equals(entry.getValue())).map(DictDTO::getText).collect(Collectors.joining());
                    objectNew.put((String)entry.getKey() + "_dictText", (Object)(value != null ? value : ""));
                    objectNew.put((String)entry.getKey() + "_dictText_new", (Object)true);
                    continue;
                }
                object.put((String)entry.getKey(), (Object)(value != null ? value : ""));
            }
            object = objectNew;
            Iterator<Object> iterator = recordVos.iterator();
            while (iterator.hasNext()) {
                FieldRecordVo vo = (FieldRecordVo)iterator.next();
                newDictText = vo.getNewFieldValue();
                if (StringUtils.isNotBlank((CharSequence)MainPlanDictEnum.getByField(vo.getFieldName()))) {
                    dictDTOS = this.invokeBaseRpcService.queryDictItemsByCode(MainPlanDictEnum.getByField(vo.getFieldName()), TenantContext.getTenant());
                    newDictText = dictDTOS.parallelStream().filter(o -> o.getValue().equals(vo.getNewFieldValue())).map(DictDTO::getText).collect(Collectors.joining());
                    String oldDictText = dictDTOS.parallelStream().filter(o -> o.getValue().equals(vo.getOldFieldValue())).map(DictDTO::getText).collect(Collectors.joining());
                    object.put(vo.getFieldName() + "_dictText", (Object)((String)(StringUtils.isNotBlank((CharSequence)object.getString(vo.getFieldName())) ? oldDictText : "") + " \u2794 " + newDictText));
                    object.put(vo.getFieldName() + "_dictText_new", (Object)true);
                    object.put(vo.getFieldName(), (Object)((String)(StringUtils.isNotBlank((CharSequence)object.getString(vo.getFieldName())) ? oldDictText : "") + " \u2794 " + newDictText));
                } else {
                    object.put(vo.getFieldName(), (Object)((StringUtils.isNotBlank((CharSequence)object.getString(vo.getFieldName())) ? object.get((Object)vo.getFieldName()) : "") + " \u2794 " + newDictText));
                }
                object.put(vo.getFieldName() + "_new", (Object)true);
            }
            jsonArray.add((Object)object);
        }
        Map<String, List<FieldRecordVo>> addItemList = addList.stream().collect(Collectors.groupingBy(FieldRecordVo::getItemId));
        Set<String> addKeys = addItemList.keySet();
        for (String key : addKeys) {
            List<FieldRecordVo> list = addItemList.get(key);
            Object object = new JSONObject();
            object.put("updateType", (Object)2);
            object.put("updateType_dictText", (Object)"\u65b0\u589e");
            for (FieldRecordVo vo : list) {
                object.put(vo.getFieldName(), (Object)vo.getNewFieldValue());
            }
            JSONObject objectNew = new JSONObject();
            String value = "";
            for (Map.Entry entry : object.entrySet()) {
                value = entry.getValue();
                objectNew.put((String)entry.getKey(), (Object)value);
                if (StringUtils.isNotBlank((CharSequence)MainPlanDictEnum.getByField((String)entry.getKey()))) {
                    dictDTOS = this.invokeBaseRpcService.queryDictItemsByCode(MainPlanDictEnum.getByField((String)entry.getKey()), TenantContext.getTenant());
                    value = dictDTOS.parallelStream().filter(o -> o.getValue().equals(entry.getValue())).map(DictDTO::getText).collect(Collectors.joining());
                    objectNew.put((String)entry.getKey() + "_dictText", (Object)(value != null ? value : ""));
                    continue;
                }
                object.put((String)entry.getKey(), (Object)(value != null ? value : ""));
            }
            object = objectNew;
            jsonArray.add(object);
        }
        Map<String, List<FieldRecordVo>> delItemList = delList.stream().collect(Collectors.groupingBy(FieldRecordVo::getItemId));
        Set<String> delKeys = delItemList.keySet();
        JSONArray deleteList = new JSONArray();
        for (String key : delKeys) {
            List<FieldRecordVo> list = delItemList.get(key);
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                JSONObject itJson = (JSONObject)iterator.next();
                if (!list.get(0).getItemId().equals(itJson.get((Object)"id"))) continue;
                deleteList.add((Object)itJson);
                iterator.remove();
            }
        }
        JSONArray delectArray = new JSONArray();
        for (int i = 0; i < deleteList.size(); ++i) {
            JSONObject jsonObject = deleteList.getJSONObject(i);
            jsonObject.put("updateType", (Object)3);
            jsonObject.put("updateType_dictText", (Object)"\u5220\u9664");
            JSONObject deletObject = new JSONObject();
            String value = "";
            for (Map.Entry entry : jsonObject.entrySet()) {
                value = entry.getValue();
                deletObject.put((String)entry.getKey(), (Object)value);
                if (StringUtils.isNotBlank((CharSequence)MainPlanDictEnum.getByField((String)entry.getKey()))) {
                    dictDTOS = this.invokeBaseRpcService.queryDictItemsByCode(MainPlanDictEnum.getByField((String)entry.getKey()), TenantContext.getTenant());
                    value = dictDTOS.parallelStream().filter(o -> o.getValue().equals(entry.getValue())).map(DictDTO::getText).collect(Collectors.joining());
                    deletObject.put((String)entry.getKey() + "_dictText", (Object)(value != null ? value : ""));
                    continue;
                }
                jsonObject.put((String)entry.getKey(), (Object)(value != null ? value : ""));
            }
            delectArray.add((Object)deletObject);
        }
        jsonArray.addAll((Collection)delectArray);
        return jsonArray;
    }
}

