/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.entity.ProjectMainPlan;
import com.els.modules.project.entity.ProjectReceivables;
import com.els.modules.project.mapper.ProjectMainPlanMapper;
import com.els.modules.project.service.ProjectBaseInfoService;
import com.els.modules.project.service.ProjectMainPlanService;
import com.els.modules.project.service.ProjectReceivablesService;
import com.els.modules.project.vo.ProjectBaseInfoVO;
import com.els.modules.project.vo.ProjectMainPlanVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectMainPlanServiceImpl
extends BaseServiceImpl<ProjectMainPlanMapper, ProjectMainPlan>
implements ProjectMainPlanService {
    @Autowired
    private ProjectBaseInfoService projectBaseInfoService;

    @Override
    public List<ProjectMainPlan> selectByMainId(String mainId) {
        return ((ProjectMainPlanMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((ProjectMainPlanMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public ProjectBaseInfoVO queryByMainId(String mainId) {
        ProjectBaseInfo baseInfo = (ProjectBaseInfo)((Object)((ProjectBaseInfoService)SpringContextUtils.getBean(ProjectBaseInfoService.class)).getById((Serializable)((Object)mainId)));
        if (baseInfo == null) {
            throw new ELSBootException("\u9879\u76ee Id \u4e0d\u5b58\u5728\uff01");
        }
        List<ProjectMainPlan> projectMainPlanList = this.selectByMainId(mainId);
        if (projectMainPlanList.isEmpty()) {
            List<ProjectReceivables> projectReceivablesList = ((ProjectReceivablesService)SpringContextUtils.getBean(ProjectReceivablesService.class)).selectByMainId(mainId);
            List dictList = ((InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class)).queryDictItemsByCode("stage", TenantContext.getTenant());
            HashMap<String, DictDTO> dictMap = new HashMap<String, DictDTO>();
            for (DictDTO dto : dictList) {
                dictMap.put(dto.getValue(), dto);
            }
            Map<String, List<ProjectReceivables>> receivablesMap = projectReceivablesList.stream().filter(o -> StrUtil.isNotBlank((CharSequence)o.getContractPayTimeHistory())).collect(Collectors.groupingBy(ProjectReceivables::getContractPayTimeHistory));
            for (int i = 0; i < 50; ++i) {
                DictDTO dictDTO = (DictDTO)dictMap.get(i + "");
                if (dictDTO == null) continue;
                List<ProjectReceivables> projectReceivables = receivablesMap.get(i + "");
                if (projectReceivables == null) {
                    projectReceivables = receivablesMap.get(dictDTO.getText());
                }
                if (projectReceivables != null && projectReceivables.size() > 0) {
                    HashMap receivablesMap2 = new HashMap();
                    for (ProjectReceivables receivables : projectReceivables) {
                        String projectCycle = receivables.getFbk4();
                        if (StrUtil.isBlank((CharSequence)projectCycle)) {
                            projectCycle = "flag";
                        }
                        if (receivablesMap2.containsKey(projectCycle)) {
                            ((List)receivablesMap2.get(projectCycle)).add(receivables);
                            continue;
                        }
                        ArrayList<ProjectReceivables> list = new ArrayList<ProjectReceivables>();
                        list.add(receivables);
                        receivablesMap2.put(projectCycle, list);
                    }
                    for (String projectCycle : receivablesMap2.keySet()) {
                        List list = (List)receivablesMap2.get(projectCycle);
                        ProjectMainPlan mainPlan = new ProjectMainPlan();
                        mainPlan.setElsAccount(TenantContext.getTenant());
                        mainPlan.setProjectId(mainId);
                        mainPlan.setProjectName(baseInfo.getProjectName());
                        mainPlan.setProjectStage(dictDTO.getValue());
                        mainPlan.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                        if (!"flag".equals(projectCycle)) {
                            mainPlan.setProjectCycle(projectCycle);
                        }
                        mainPlan.setRelationReceive("1");
                        BigDecimal total = BigDecimal.ZERO;
                        for (ProjectReceivables receivables : list) {
                            if (receivables.getPlanReceivablesAmount() == null) continue;
                            total = total.add(receivables.getPlanReceivablesAmount());
                        }
                        mainPlan.setReceiveAmount(total);
                        projectMainPlanList.add(mainPlan);
                    }
                    continue;
                }
                ProjectMainPlan mainPlan = new ProjectMainPlan();
                mainPlan.setElsAccount(TenantContext.getTenant());
                mainPlan.setProjectId(mainId);
                mainPlan.setProjectName(baseInfo.getProjectName());
                mainPlan.setProjectStage(dictDTO.getValue());
                mainPlan.setRelationReceive("0");
                projectMainPlanList.add(mainPlan);
            }
        }
        ProjectBaseInfoVO baseInfoVO = new ProjectBaseInfoVO();
        BeanUtils.copyProperties((Object)((Object)baseInfo), (Object)((Object)baseInfoVO));
        baseInfoVO.setProjectMainPlanList(projectMainPlanList);
        return baseInfoVO;
    }

    @Override
    @Transactional
    public void save(ProjectBaseInfoVO infoVO) {
        this.opt(infoVO, "0");
    }

    @Override
    @Transactional
    public void submit(ProjectBaseInfoVO infoVO) {
        this.opt(infoVO, "1");
    }

    private void opt(ProjectBaseInfoVO infoVO, String status) {
        ProjectBaseInfo baseInfo = new ProjectBaseInfo();
        baseInfo.setId(infoVO.getId());
        baseInfo.setMainPlanStatus(status);
        ((ProjectBaseInfoService)SpringContextUtils.getBean(ProjectBaseInfoService.class)).updateById((Object)baseInfo);
        List<ProjectMainPlan> projectMainPlanList = infoVO.getProjectMainPlanList();
        this.deleteByMainId(infoVO.getId());
        if (projectMainPlanList != null && projectMainPlanList.size() > 0) {
            ProjectBaseInfo projectBaseInfo = (ProjectBaseInfo)((Object)((ProjectBaseInfoService)SpringContextUtils.getBean(ProjectBaseInfoService.class)).getById((Serializable)((Object)infoVO.getId())));
            for (ProjectMainPlan mainPlan : projectMainPlanList) {
                mainPlan.setMainPlanStatus(status);
                mainPlan.setProjectId(infoVO.getId());
                mainPlan.setProjectName(projectBaseInfo.getProjectName());
                mainPlan.setProjectManagerId(projectBaseInfo.getProjectManagerId());
                mainPlan.setProjectManagerName(projectBaseInfo.getProjectManagerName());
            }
            this.saveBatch(projectMainPlanList);
        }
    }

    @Override
    public void start(ProjectMainPlan mainPlan) {
        mainPlan.setMainPlanStatus("2");
        this.updateById((Object)mainPlan);
    }

    @Override
    public void finish(ProjectMainPlan mainPlan) {
        mainPlan.setMainPlanStatus("3");
        this.updateById((Object)mainPlan);
    }

    @Override
    public ProjectMainPlanVO findCurrentPlanByMainId(String mainId) {
        ProjectMainPlanVO mainPlanVO = new ProjectMainPlanVO();
        ProjectMainPlan mainPlan = null;
        ArrayList<DictDTO> dictResultList = new ArrayList<DictDTO>();
        List<ProjectMainPlan> projectMainPlanList = ((ProjectMainPlanMapper)this.baseMapper).selectByMainId(mainId);
        for (ProjectMainPlan plan : projectMainPlanList) {
            if (plan.getActualStartDate() == null || plan.getActualFinishDate() != null) continue;
            mainPlan = plan;
            break;
        }
        if (mainPlan == null && projectMainPlanList.size() > 0) {
            mainPlan = projectMainPlanList.get(0);
        }
        List dictList = ((InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class)).queryDictItemsByCode("stage", TenantContext.getTenant());
        HashMap<String, DictDTO> dictMap = new HashMap<String, DictDTO>();
        for (DictDTO dto : dictList) {
            dictMap.put(dto.getValue(), dto);
        }
        for (ProjectMainPlan plan : projectMainPlanList) {
            DictDTO dto = (DictDTO)dictMap.get(plan.getProjectStage());
            if (dto == null) continue;
            dictResultList.add(dto);
        }
        mainPlanVO.setProjectMainPlan(mainPlan);
        mainPlanVO.setProjectStageList(dictResultList);
        return mainPlanVO;
    }

    @Override
    public void syncProjectManange() {
        QueryWrapper queryWrapper = new QueryWrapper();
        List list = this.projectBaseInfoService.list((Wrapper)queryWrapper);
        for (ProjectBaseInfo projectBaseInfo : list) {
            LambdaUpdateWrapper lambdaUpdateWrapper = new UpdateWrapper().lambda();
            lambdaUpdateWrapper.eq(ProjectMainPlan::getProjectId, (Object)projectBaseInfo.getId());
            lambdaUpdateWrapper.set(ProjectMainPlan::getProjectManagerName, (Object)projectBaseInfo.getProjectManagerName());
            lambdaUpdateWrapper.set(ProjectMainPlan::getProjectManagerId, (Object)projectBaseInfo.getProjectManagerId());
            lambdaUpdateWrapper.set(ProjectMainPlan::getProjectName, (Object)projectBaseInfo.getProjectName());
            this.update((Wrapper)lambdaUpdateWrapper);
        }
    }
}

