/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.dict.api.service.DictItemRpcService;
import com.els.modules.project.entity.BpProjectWeekReportConfig;
import com.els.modules.project.entity.ProjectWeekReport;
import com.els.modules.project.enumerate.WeekReportStatusEnum;
import com.els.modules.project.mapper.ProjectWeekReportMapper;
import com.els.modules.project.service.BpProjectWeekReportConfigService;
import com.els.modules.project.service.ProjectWeekReportService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class ProjectWeekReportServiceImpl
extends BaseServiceImpl<ProjectWeekReportMapper, ProjectWeekReport>
implements ProjectWeekReportService {
    @Autowired
    private BpProjectWeekReportConfigService bpProjectWeekReportConfigService;

    @Override
    public void add(ProjectWeekReport projectWeekReport) {
        projectWeekReport.setWeeklyStatus(WeekReportStatusEnum.NEW.getValue());
        this.checkLimit(projectWeekReport);
        ((ProjectWeekReportMapper)this.baseMapper).insert((Object)projectWeekReport);
    }

    private void checkLimit(ProjectWeekReport projectWeekReport) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BpProjectWeekReportConfig::getEnabled, (Object)"1");
        List configList = this.bpProjectWeekReportConfigService.list((Wrapper)lambdaQueryWrapper);
        String projectStage = projectWeekReport.getProjectStage();
        if (StringUtils.isEmpty((Object)projectStage)) {
            throw new ELSBootException("\u9879\u76ee\u9636\u6bb5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        BigDecimal projectProgress = projectWeekReport.getProjectProgress();
        if (projectProgress == null) {
            throw new ELSBootException("\u9879\u76ee\u8fdb\u5ea6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        for (BpProjectWeekReportConfig config : configList) {
            BigDecimal limitValue;
            String progress = config.getProgress();
            if (!progress.equals(projectStage) || projectProgress.compareTo(limitValue = config.getLimitValue()) <= 0) continue;
            DictItemRpcService dictItemRpcService = (DictItemRpcService)SpringContextUtils.getBean(DictItemRpcService.class);
            String dictItemValue = dictItemRpcService.getDictItemValue("stage", progress);
            throw new ELSBootException("\u9879\u76ee\u5f53\u524d\u5904\u4e8e" + dictItemValue + "\u9636\u6bb5\uff0c\u9879\u76ee\u8fdb\u5ea6\u4e0d\u5f97\u9ad8\u4e8e" + limitValue + "%!");
        }
    }

    @Override
    public void edit(ProjectWeekReport projectWeekReport) {
        this.checkLimit(projectWeekReport);
        int count = ((ProjectWeekReportMapper)this.baseMapper).updateById((Object)projectWeekReport);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((ProjectWeekReportMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void publish(ProjectWeekReport projectWeekReport) {
        projectWeekReport.setWeeklyStatus(WeekReportStatusEnum.PUBLISHED.getValue());
        projectWeekReport.setPublishTime(new Date());
        ((ProjectWeekReportMapper)this.baseMapper).updateById((Object)projectWeekReport);
    }

    @Override
    public void reject(ProjectWeekReport projectWeekReport) {
        projectWeekReport.setWeeklyStatus(WeekReportStatusEnum.REJECTED.getValue());
        ((ProjectWeekReportMapper)this.baseMapper).updateById((Object)projectWeekReport);
    }
}

