/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.workHoursCheck.job;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.common.api.service.JobRpcService;
import com.els.common.email.ElsEmailBuilder;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.LoginUserContext;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.employ.api.dto.ElsEmployeInfoDTO;
import com.els.modules.employ.api.service.EmployeeInfoRpcService;
import com.els.modules.workHoursCheck.entity.BpWorksHoursCheck;
import com.els.modules.workHoursCheck.service.BpWorksHoursCheckService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkHoursCheckOfSendEmail
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(WorkHoursCheckOfSendEmail.class);
    @Autowired
    private BpWorksHoursCheckService service;
    @Autowired
    private EmployeeInfoRpcService employeeInfoRpcService;
    @Autowired
    private InvokeBaseRpcService baseRpcService;
    @Resource
    private AccountRpcService accountRpcService;
    @Resource(name="srmPoolExecutor")
    public ThreadPoolExecutor srmPoolExecutor;

    public void execute(String parameter) {
        List collect;
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String elsAccount = paramObj.getString("elsAccount");
        TenantContext.setTenant((String)elsAccount);
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM");
        String lastMonth = dft.format(cal.getTime());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
        queryWrapper.lambda().eq(BpWorksHoursCheck::getMouthCheck, (Object)lastMonth);
        List bpWorksHoursChecks = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)bpWorksHoursChecks) && !(collect = bpWorksHoursChecks.stream().filter(s -> new BigDecimal(StringUtils.isNotBlank((CharSequence)s.getFbk2()) ? s.getFbk2() : "0").compareTo(new BigDecimal(StringUtils.isNotBlank((CharSequence)s.getNeedWordHours()) ? s.getNeedWordHours() : "0")) < 0).collect(Collectors.toList())).isEmpty()) {
            List collect1 = collect.stream().map(BpWorksHoursCheck::getEmployId).distinct().collect(Collectors.toList());
            List elsEmployeInfoDTOS = this.employeeInfoRpcService.listEmployeInfoByIds(collect1);
            List collect2 = elsEmployeInfoDTOS.stream().map(ElsEmployeInfoDTO::getSubAccountId).collect(Collectors.toList());
            String join = String.join((CharSequence)",", collect2);
            List accountListByUserIds = this.accountRpcService.getAccountListByUserIds(join);
            List collect3 = accountListByUserIds.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getSuperiorLeader())).map(i -> i.getSuperiorLeader().split("_")[0]).collect(Collectors.toList());
            List accountList = this.accountRpcService.getAccountList(TenantContext.getTenant(), collect3);
            LoginUser loginUser = SysUtil.getLoginUser();
            if (loginUser == null) {
                ElsSubAccountDTO account = this.accountRpcService.getAccount(TenantContext.getTenant(), "1001");
                loginUser = (LoginUser)JSONObject.parseObject((String)JSON.toJSONString((Object)account), LoginUser.class);
            }
            JSONObject object = new JSONObject();
            String[] split = lastMonth.split("-");
            object.put("year", (Object)split[0]);
            object.put("month", (Object)split[1]);
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgKey", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)TenantContext.getTenant());
            msgObj.put("businessType", (Object)"workhours");
            msgObj.put("operateType", (Object)"remind");
            msgObj.put("businessObj", (Object)object);
            msgObj.put("sendObj", (Object)loginUser);
            JSONArray array = new JSONArray();
            JSONObject receiveObj = new JSONObject();
            receiveObj.put("toElsAccount", (Object)TenantContext.getTenant());
            receiveObj.put("urlParam", (Object)"");
            receiveObj.put("toSubAccountList", (Object)JSONObject.parseArray((String)JSON.toJSONString((Object)accountListByUserIds)));
            array.add((Object)receiveObj);
            msgObj.put("receiveList", (Object)array);
            MqUtil.sendBusMsg((String)msgObj.toJSONString());
            List srmWorkHoursMsgSuperiorLeader = this.baseRpcService.queryDictItemsByCode("srmWorkHoursMsgSuperiorLeader", TenantContext.getTenant());
            List<Object> leader = new ArrayList();
            if (!srmWorkHoursMsgSuperiorLeader.isEmpty()) {
                leader = srmWorkHoursMsgSuperiorLeader.stream().map(DictDTO::getValue).distinct().collect(Collectors.toList());
            }
            LoginUser finalLoginUser = loginUser;
            ArrayList finalLeader = leader;
            this.srmPoolExecutor.execute(() -> {
                try {
                    LoginUserContext.setUser((LoginUser)finalLoginUser);
                    TenantContext.setTenant((String)elsAccount);
                    this.sendEmailSuperLeader(finalLeader, accountList, accountListByUserIds, lastMonth, finalLoginUser);
                }
                finally {
                    TenantContext.clear();
                    LoginUserContext.clear();
                }
            });
        }
    }

    public void sendEmailSuperLeader(List<String> leader, List<ElsSubAccountDTO> accountList, List<ElsSubAccountDTO> accountListByUserIds, String lastMonth, LoginUser finalLoginUser) {
        for (ElsSubAccountDTO elsSubAccountDTO : accountList) {
            if (leader.contains(elsSubAccountDTO.getRealname())) continue;
            JSONObject jsonObject = new JSONObject();
            List collect4 = accountListByUserIds.stream().filter(item -> item.getSuperiorLeader().contains(elsSubAccountDTO.getSubAccount())).map(ElsSubAccountDTO::getRealname).collect(Collectors.toList());
            jsonObject.put("time", (Object)lastMonth);
            String[] split = lastMonth.split("-");
            jsonObject.put("year", (Object)split[0]);
            jsonObject.put("month", (Object)split[1]);
            String join1 = String.join((CharSequence)"\uff0c", collect4);
            jsonObject.put("userName", (Object)join1);
            JSONObject msgObjSuperiorLeader = new JSONObject();
            msgObjSuperiorLeader.put("msgKey", (Object)IdWorker.getIdStr());
            msgObjSuperiorLeader.put("busAccount", (Object)TenantContext.getTenant());
            msgObjSuperiorLeader.put("businessType", (Object)"workhours");
            msgObjSuperiorLeader.put("operateType", (Object)"remindSuperiorLeader");
            msgObjSuperiorLeader.put("businessObj", (Object)jsonObject);
            msgObjSuperiorLeader.put("sendObj", (Object)finalLoginUser);
            JSONArray arraymsgObjSuperiorLeader = new JSONArray();
            JSONObject receiveObjmsgObjSuperiorLeader = new JSONObject();
            receiveObjmsgObjSuperiorLeader.put("toElsAccount", (Object)TenantContext.getTenant());
            receiveObjmsgObjSuperiorLeader.put("urlParam", (Object)"");
            receiveObjmsgObjSuperiorLeader.put("toSubAccountList", (Object)JSONObject.parseArray((String)JSON.toJSONString(Arrays.asList(elsSubAccountDTO))));
            arraymsgObjSuperiorLeader.add((Object)receiveObjmsgObjSuperiorLeader);
            msgObjSuperiorLeader.put("receiveList", (Object)arraymsgObjSuperiorLeader);
            MqUtil.sendBusMsg((String)msgObjSuperiorLeader.toJSONString());
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void sendEmail(Map<String, String> employNames, String emailModeName, String lastMonth) {
        ElsEmailConfigDTO config = this.baseRpcService.getEmailConfig("1517606");
        String[] split = lastMonth.split("-");
        for (Map.Entry<String, String> stringStringEntry : employNames.entrySet()) {
            String subject = "\u5de5\u65f6\u586b\u62a5\u90ae\u4ef6\u63d0\u9192";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("userName", stringStringEntry.getKey());
            params.put("year", split[0]);
            params.put("month", split[1]);
            GroupTemplate groupTemplate = new GroupTemplate();
            Template template = groupTemplate.getTemplate(emailModeName);
            template.binding(params);
            String render = template.render();
            ElsEmailBuilder.sendEmailWithEp((ElsEmailConfigDTO)config, (String)stringStringEntry.getValue(), (String)subject, (String)render, null, (boolean)false);
        }
    }
}

