/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.workHoursCheck.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.els.api.dto.BaseDTO;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.service.AccountExtendRpcService;
import com.els.modules.calendar.api.dto.CalendarDTO;
import com.els.modules.calendar.api.service.CalendarRpcService;
import com.els.modules.employ.api.dto.ElsEmployeInfoDTO;
import com.els.modules.employ.api.service.EmployeeInfoRpcService;
import com.els.modules.manleave.api.dto.PurchaseManLeaveDTO;
import com.els.modules.manleave.api.service.ManLeaveRpcService;
import com.els.modules.workHoursCheck.entity.BpWorksHoursCheck;
import com.els.modules.workHoursCheck.mapper.BpWorksHoursCheckMapper;
import com.els.modules.workHoursCheck.service.BpWorksHoursCheckService;
import com.els.modules.workHoursCheck.utils.DateCheckUtils;
import com.els.modules.workhours.entity.EmployeeWorkHours;
import com.els.modules.workhours.enumerate.WorkCategoryEnum;
import com.els.modules.workhours.enumerate.WorkHoursStatusEnum;
import com.els.modules.workhours.service.EmployeeWorkHoursService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BpWorksHoursCheckServiceImpl
extends BaseServiceImpl<BpWorksHoursCheckMapper, BpWorksHoursCheck>
implements BpWorksHoursCheckService {
    @Resource
    private EmployeeInfoRpcService employeeInfoRpcService;
    @Resource
    private AccountExtendRpcService accountExtendRpcService;
    @Autowired
    private EmployeeWorkHoursService employeeWorkHoursService;
    @Resource
    private CalendarRpcService calendarRpcService;
    @Resource
    private ManLeaveRpcService manLeaveRpcService;

    @Override
    public void add(BpWorksHoursCheck bpWorksHoursCheck) {
        ((BpWorksHoursCheckMapper)this.baseMapper).insert((Object)bpWorksHoursCheck);
    }

    @Override
    public void edit(BpWorksHoursCheck bpWorksHoursCheck) {
        int count = ((BpWorksHoursCheckMapper)this.baseMapper).updateById((Object)bpWorksHoursCheck);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((BpWorksHoursCheckMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((BpWorksHoursCheckMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @Transactional
    public void generatMouthMsg(String mouth) {
        SimpleDateFormat formatM = new SimpleDateFormat("yyyy-MM");
        if (mouth != null && formatM.format(new Date()).equals(mouth)) {
            this.refreshEmployMsg(mouth);
            this.refreshEmployAskLeaveMsg(mouth);
        } else if (mouth != null) {
            this.generatMouthCheck(mouth);
            this.refreshEmployAskLeaveMsg(mouth);
        }
    }

    private void refreshEmployAskLeaveMsg(String mouth) {
        String mouthNow = DateUtils.getDate((String)"yyyy-MM");
        SimpleDateFormat formatD = new SimpleDateFormat("yyyy-MM-dd");
        if (mouth != null) {
            mouthNow = mouth;
        }
        Date firstday = new Date();
        Date lastday = new Date();
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat formatM = new SimpleDateFormat("yyyy-MM");
        try {
            firstday = formatD.parse(DateCheckUtils.getFirstDay(mouthNow));
            lastday = formatD.parse(DateCheckUtils.getLastDay(mouthNow));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List purchaseManLeaveDTOS = this.manLeaveRpcService.listByMouth(mouthNow);
        List<CalendarDTO> woekDate = this.getWoekDate(mouth);
        if (!CollectionUtils.isEmpty((Collection)purchaseManLeaveDTOS)) {
            BigDecimal total;
            List workDateList = woekDate.stream().map(item -> formatD.format(item.getDayOff())).collect(Collectors.toList());
            HashMap<String, BigDecimal> askLeaveDays = new HashMap<String, BigDecimal>();
            Map<String, List> collect1 = purchaseManLeaveDTOS.stream().collect(Collectors.toMap(PurchaseManLeaveDTO::getUserId, p -> {
                ArrayList<PurchaseManLeaveDTO> getNameList = new ArrayList<PurchaseManLeaveDTO>();
                getNameList.add((PurchaseManLeaveDTO)p);
                return getNameList;
            }, (value1, value2) -> {
                value1.addAll(value2);
                return value1;
            }));
            for (Map.Entry<String, List> entry : collect1.entrySet()) {
                String mapKey = entry.getKey();
                total = BigDecimal.ZERO;
                List value = entry.getValue();
                for (PurchaseManLeaveDTO purchaseManLeaveDTO : value) {
                    List collect;
                    double dateWorkHour;
                    int days;
                    List<String> strings;
                    if (purchaseManLeaveDTO.getLeaveStartDate().after(firstday) && purchaseManLeaveDTO.getLeaveEndDate().before(lastday)) {
                        total = total.add(purchaseManLeaveDTO.getLeaveDays());
                        continue;
                    }
                    if (purchaseManLeaveDTO.getLeaveStartDate().before(firstday) && purchaseManLeaveDTO.getLeaveEndDate().after(lastday)) {
                        total = total.add(BigDecimal.valueOf(workDateList.size()));
                        continue;
                    }
                    if (purchaseManLeaveDTO.getLeaveStartDate().after(firstday) && purchaseManLeaveDTO.getLeaveEndDate().after(lastday)) {
                        List collect2;
                        strings = DateCheckUtils.listFristToDay(purchaseManLeaveDTO.getLeaveEndDate());
                        days = 0;
                        if (!CollectionUtils.isEmpty(strings) && !CollectionUtils.isEmpty(collect2 = strings.stream().filter(item -> woekDate.contains(item)).collect(Collectors.toList()))) {
                            days = collect2.size();
                        }
                        dateWorkHour = this.getDateWorkHour(purchaseManLeaveDTO.getLeaveEndDate(), "end");
                        total = total.add(BigDecimal.valueOf(dateWorkHour + (double)days));
                        continue;
                    }
                    if (!purchaseManLeaveDTO.getLeaveStartDate().after(firstday) || !purchaseManLeaveDTO.getLeaveEndDate().after(lastday)) continue;
                    strings = DateCheckUtils.listLastoDay(purchaseManLeaveDTO.getLeaveStartDate());
                    days = 0;
                    if (!CollectionUtils.isEmpty(strings) && !CollectionUtils.isEmpty(collect = strings.stream().filter(item -> woekDate.contains(item)).collect(Collectors.toList()))) {
                        days = collect.size();
                    }
                    dateWorkHour = this.getDateWorkHour(purchaseManLeaveDTO.getLeaveStartDate(), "start");
                    total = total.add(BigDecimal.valueOf(dateWorkHour + (double)days));
                }
                askLeaveDays.put(mapKey, total);
            }
            if (!CollectionUtils.isEmpty(askLeaveDays)) {
                List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BpWorksHoursCheck::getEmployId, (Collection)askLeaveDays.keySet().stream().collect(Collectors.toList()))).eq(BpWorksHoursCheck::getMouthCheck, (Object)mouth)).list();
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    for (BpWorksHoursCheck bpWorksHoursCheck : list) {
                        total = BigDecimal.ZERO;
                        if (StringUtils.isNotBlank((CharSequence)bpWorksHoursCheck.getFbk3())) {
                            total = new BigDecimal(bpWorksHoursCheck.getFbk3());
                        }
                        if (askLeaveDays.containsKey(bpWorksHoursCheck.getEmployId())) {
                            BigDecimal bigDecimal = (BigDecimal)askLeaveDays.get(bpWorksHoursCheck.getEmployId());
                            double v = bigDecimal.multiply(new BigDecimal(8)).doubleValue();
                            bpWorksHoursCheck.setAskLeaveHours(String.valueOf(v));
                            total = total.add(new BigDecimal(v));
                        } else {
                            bpWorksHoursCheck.setAskLeaveHours("0");
                        }
                        bpWorksHoursCheck.setFbk2(total.toString());
                    }
                }
                this.updateBatchById(list);
            }
        }
    }

    private double getDateWorkHour(Date date, String type) {
        Calendar calendar = Calendar.getInstance();
        if ("start".equals(type)) {
            calendar.setTime(date);
            calendar.set(11, 8);
            calendar.set(12, 30);
            calendar.set(13, 0);
            if (date.before(calendar.getTime())) {
                return 1.0;
            }
            long datePoor = DateCheckUtils.getDatePoor(date, calendar.getTime());
            if (datePoor >= 4L) {
                return 0.5;
            }
            return 1.0;
        }
        calendar.setTime(date);
        calendar.set(11, 18);
        calendar.set(12, 0);
        calendar.set(13, 0);
        if (date.after(calendar.getTime())) {
            return 1.0;
        }
        long datePoor = DateCheckUtils.getDatePoor(calendar.getTime(), date);
        if (datePoor <= 4L) {
            return 0.5;
        }
        return 1.0;
    }

    @Override
    public void generatMouthCheck(String mouth) {
        QueryWrapper bpWorksHoursCheckQueryWrapper = new QueryWrapper();
        bpWorksHoursCheckQueryWrapper.lambda().eq(BpWorksHoursCheck::getMouthCheck, (Object)mouth);
        List list = this.list((Wrapper)bpWorksHoursCheckQueryWrapper);
        List elsEmployeInfoDTOS = this.employeeInfoRpcService.listEmployeInfoOfWorkHoursCheck(mouth);
        List collect1 = elsEmployeInfoDTOS.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getSubAccountId())).map(ElsEmployeInfoDTO::getSubAccountId).distinct().collect(Collectors.toList());
        List elsSubAccountDTOS = this.accountExtendRpcService.listByIds(collect1);
        Map collect2 = elsSubAccountDTOS.stream().collect(Collectors.toMap(BaseDTO::getId, Function.identity(), (k1, k2) -> k2));
        Map collect = elsEmployeInfoDTOS.stream().collect(Collectors.toMap(ElsEmployeInfoDTO::getId, Function.identity(), (k1, k2) -> k2));
        List workHours = ((QueryChainWrapper)this.employeeWorkHoursService.query().eq((Object)"DATE_FORMAT(work_date,'%Y-%m')", (Object)mouth)).list();
        Map<String, List<EmployeeWorkHours>> worksOfEmploy = workHours.stream().collect(Collectors.toMap(EmployeeWorkHours::getStaffId, p -> {
            ArrayList<EmployeeWorkHours> getNameList = new ArrayList<EmployeeWorkHours>();
            getNameList.add((EmployeeWorkHours)((Object)p));
            return getNameList;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        List<CalendarDTO> woekDate = this.getWoekDate(mouth);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (BpWorksHoursCheck bpWorksHoursCheck : list) {
                bpWorksHoursCheck.setMouthCheck(mouth);
                if (!collect.containsKey(bpWorksHoursCheck.getEmployId())) continue;
                ElsEmployeInfoDTO elsEmployeInfoDTO = (ElsEmployeInfoDTO)collect.get(bpWorksHoursCheck.getEmployId());
                this.calculateWorkDate(elsEmployeInfoDTO, bpWorksHoursCheck, woekDate);
                this.calculateWorkHours(bpWorksHoursCheck, elsEmployeInfoDTO, worksOfEmploy);
            }
        }
        List collect3 = list.stream().map(BpWorksHoursCheck::getEmployId).distinct().collect(Collectors.toList());
        List collect4 = elsEmployeInfoDTOS.stream().filter(item -> !collect3.contains(item.getId())).collect(Collectors.toList());
        ArrayList<BpWorksHoursCheck> newEmploye = new ArrayList<BpWorksHoursCheck>();
        if (!CollectionUtils.isEmpty(collect4)) {
            for (ElsEmployeInfoDTO elsEmployeInfoDTO : collect4) {
                BpWorksHoursCheck bpWorksHoursCheck = new BpWorksHoursCheck();
                bpWorksHoursCheck.setElsAccount(elsEmployeInfoDTO.getElsAccount());
                bpWorksHoursCheck.setEmployId(elsEmployeInfoDTO.getId());
                bpWorksHoursCheck.setEmployName(elsEmployeInfoDTO.getLoginName());
                bpWorksHoursCheck.setDepartment(elsEmployeInfoDTO.getDepartment());
                bpWorksHoursCheck.setMouthCheck(mouth);
                this.calculateWorkDate(elsEmployeInfoDTO, bpWorksHoursCheck, woekDate);
                this.calculateWorkHours(bpWorksHoursCheck, elsEmployeInfoDTO, worksOfEmploy);
                if (collect2.containsKey(elsEmployeInfoDTO.getSubAccountId())) {
                    bpWorksHoursCheck.setSuperiorLeader(((ElsSubAccountDTO)collect2.get(elsEmployeInfoDTO.getSubAccountId())).getSuperiorLeader());
                }
                newEmploye.add(bpWorksHoursCheck);
            }
        }
        if (!CollectionUtils.isEmpty(newEmploye)) {
            this.saveBatch(newEmploye);
        }
        this.updateBatchById(list);
    }

    private void refreshEmployMsg(String mouth) {
        QueryWrapper bpWorksHoursCheckQueryWrapper = new QueryWrapper();
        bpWorksHoursCheckQueryWrapper.lambda().eq(BpWorksHoursCheck::getMouthCheck, (Object)DateUtils.getDate((String)"yyyy-MM"));
        List list = this.list((Wrapper)bpWorksHoursCheckQueryWrapper);
        List elsEmployeInfoDTOS = this.employeeInfoRpcService.listEmployeInfoOfWorkHoursCheck(mouth);
        List collect1 = elsEmployeInfoDTOS.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getSubAccountId())).map(ElsEmployeInfoDTO::getSubAccountId).distinct().collect(Collectors.toList());
        List elsSubAccountDTOS = this.accountExtendRpcService.listByIds(collect1);
        Map collect2 = elsSubAccountDTOS.stream().collect(Collectors.toMap(BaseDTO::getId, Function.identity(), (k1, k2) -> k2));
        Map collect = elsEmployeInfoDTOS.stream().collect(Collectors.toMap(ElsEmployeInfoDTO::getId, Function.identity(), (k1, k2) -> k2));
        List workHours = ((QueryChainWrapper)this.employeeWorkHoursService.query().eq((Object)"DATE_FORMAT(work_date,'%Y-%m')", (Object)DateUtils.getDate((String)"yyyy-MM"))).list();
        Map<String, List<EmployeeWorkHours>> worksOfEmploy = workHours.stream().collect(Collectors.toMap(EmployeeWorkHours::getStaffId, p -> {
            ArrayList<EmployeeWorkHours> getNameList = new ArrayList<EmployeeWorkHours>();
            getNameList.add((EmployeeWorkHours)((Object)p));
            return getNameList;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        List<CalendarDTO> woekDate = this.getWoekDate(null);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (BpWorksHoursCheck bpWorksHoursCheck : list) {
                SimpleDateFormat formatM = new SimpleDateFormat("yyyy-MM");
                bpWorksHoursCheck.setMouthCheck(formatM.format(new Date()));
                if (!collect.containsKey(bpWorksHoursCheck.getEmployId())) continue;
                ElsEmployeInfoDTO elsEmployeInfoDTO = (ElsEmployeInfoDTO)collect.get(bpWorksHoursCheck.getEmployId());
                this.calculateWorkDate(elsEmployeInfoDTO, bpWorksHoursCheck, woekDate);
                this.calculateWorkHours(bpWorksHoursCheck, elsEmployeInfoDTO, worksOfEmploy);
            }
        }
        List collect3 = list.stream().map(BpWorksHoursCheck::getEmployId).distinct().collect(Collectors.toList());
        List collect4 = elsEmployeInfoDTOS.stream().filter(item -> !collect3.contains(item.getId())).collect(Collectors.toList());
        ArrayList<BpWorksHoursCheck> newEmploye = new ArrayList<BpWorksHoursCheck>();
        if (!CollectionUtils.isEmpty(collect4)) {
            for (ElsEmployeInfoDTO elsEmployeInfoDTO : collect4) {
                BpWorksHoursCheck bpWorksHoursCheck = new BpWorksHoursCheck();
                bpWorksHoursCheck.setElsAccount(elsEmployeInfoDTO.getElsAccount());
                bpWorksHoursCheck.setEmployId(elsEmployeInfoDTO.getId());
                bpWorksHoursCheck.setEmployName(elsEmployeInfoDTO.getLoginName());
                bpWorksHoursCheck.setDepartment(elsEmployeInfoDTO.getDepartment());
                SimpleDateFormat formatM = new SimpleDateFormat("yyyy-MM");
                bpWorksHoursCheck.setMouthCheck(formatM.format(new Date()));
                this.calculateWorkDate(elsEmployeInfoDTO, bpWorksHoursCheck, woekDate);
                this.calculateWorkHours(bpWorksHoursCheck, elsEmployeInfoDTO, worksOfEmploy);
                if (collect2.containsKey(elsEmployeInfoDTO.getSubAccountId())) {
                    bpWorksHoursCheck.setSuperiorLeader(((ElsSubAccountDTO)collect2.get(elsEmployeInfoDTO.getSubAccountId())).getSuperiorLeader());
                }
                newEmploye.add(bpWorksHoursCheck);
            }
        }
        if (!CollectionUtils.isEmpty(newEmploye)) {
            this.saveBatch(newEmploye);
        }
        this.updateBatchById(list);
    }

    private void calculateWorkHours(BpWorksHoursCheck bpWorksHoursCheck, ElsEmployeInfoDTO elsEmployeInfoDTO, Map<String, List<EmployeeWorkHours>> worksOfEmploy) {
        List<Object> employeeWorkHours = new ArrayList();
        if (worksOfEmploy.containsKey(bpWorksHoursCheck.getEmployId())) {
            employeeWorkHours = worksOfEmploy.get(bpWorksHoursCheck.getEmployId());
        } else if (worksOfEmploy.containsKey(elsEmployeInfoDTO.getSubAccountId()) && CollectionUtils.isEmpty(employeeWorkHours)) {
            employeeWorkHours = worksOfEmploy.get(elsEmployeInfoDTO.getSubAccountId());
        }
        if (!CollectionUtils.isEmpty(employeeWorkHours)) {
            List collect = employeeWorkHours.stream().filter(item -> WorkHoursStatusEnum.AUTH_COMPLETE.getValue().equals(item.getCheckStatus()) || WorkHoursStatusEnum.WAIT_AUTH.getValue().equals(item.getCheckStatus())).collect(Collectors.toList());
            BigDecimal totalWorkHours = BigDecimal.ZERO;
            BigDecimal projectHours = collect.stream().filter(i -> WorkCategoryEnum.PROJECT.getCode().equals(i.getWorkCategory())).map(EmployeeWorkHours::getWorkHours).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalWorkHours = totalWorkHours.add(projectHours);
            bpWorksHoursCheck.setProjectWordHours(projectHours.toString());
            BigDecimal productHours = collect.stream().filter(i -> WorkCategoryEnum.PRODUCT.getCode().equals(i.getWorkCategory())).map(EmployeeWorkHours::getWorkHours).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalWorkHours = totalWorkHours.add(productHours);
            bpWorksHoursCheck.setProductWordHours(productHours.toString());
            BigDecimal deptHours = collect.stream().filter(i -> WorkCategoryEnum.DEPARTMENT.getCode().equals(i.getWorkCategory())).map(EmployeeWorkHours::getWorkHours).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalWorkHours = totalWorkHours.add(deptHours);
            bpWorksHoursCheck.setDeptWordHours(deptHours.toString());
            BigDecimal presaleHours = collect.stream().filter(i -> WorkCategoryEnum.PRESALE.getCode().equals(i.getWorkCategory())).map(EmployeeWorkHours::getWorkHours).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalWorkHours = totalWorkHours.add(presaleHours);
            bpWorksHoursCheck.setSaleWordHours(presaleHours.toString());
            BigDecimal devopsHours = collect.stream().filter(i -> WorkCategoryEnum.DEVOPS.getCode().equals(i.getWorkCategory())).map(EmployeeWorkHours::getWorkHours).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalWorkHours = totalWorkHours.add(devopsHours);
            bpWorksHoursCheck.setTsoWordHours(devopsHours.toString());
            BigDecimal comfirmHours = employeeWorkHours.stream().filter(i -> WorkHoursStatusEnum.AUTH_COMPLETE.equals(i.getCheckStatus())).map(EmployeeWorkHours::getWorkHours).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            bpWorksHoursCheck.setAuditComfirmHours(comfirmHours.toString());
            SimpleDateFormat formatM = new SimpleDateFormat("yyyy-MM-dd");
            List collect1 = employeeWorkHours.stream().map(item -> formatM.format(item.getWorkDate())).distinct().collect(Collectors.toList());
            bpWorksHoursCheck.setFbk1(Integer.toString(collect1.size()));
            bpWorksHoursCheck.setFbk2(totalWorkHours.toString());
            bpWorksHoursCheck.setFbk3(totalWorkHours.toString());
        }
    }

    private void calculateWorkDate(ElsEmployeInfoDTO elsEmployeInfoDTO, BpWorksHoursCheck bpWorksHoursCheck, List<CalendarDTO> woekDate) {
        Date termDate;
        SimpleDateFormat formatM = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat formatD = new SimpleDateFormat("yyyy-MM-dd");
        if (elsEmployeInfoDTO.getHireDate() != null && formatM.format(new Date()).equals(formatM.format(elsEmployeInfoDTO.getHireDate()))) {
            bpWorksHoursCheck.setHire("1");
        } else {
            bpWorksHoursCheck.setHire("0");
        }
        bpWorksHoursCheck.setHireDate(elsEmployeInfoDTO.getHireDate());
        if (elsEmployeInfoDTO.getTermDate() != null && formatM.format(new Date()).equals(formatM.format(elsEmployeInfoDTO.getTermDate()))) {
            bpWorksHoursCheck.setTerm("1");
            bpWorksHoursCheck.setTermDate(elsEmployeInfoDTO.getTermDate());
        } else {
            bpWorksHoursCheck.setTerm("0");
        }
        List<Object> workDateList = new ArrayList();
        if ("1".equals(bpWorksHoursCheck.getHire()) && "0".equals(bpWorksHoursCheck.getTerm())) {
            Date hireDate = bpWorksHoursCheck.getHireDate();
            workDateList = woekDate.stream().filter(item -> item.getDayOff().after(hireDate) && item.getDayOff().before(new Date())).map(item -> formatD.format(item.getDayOff())).collect(Collectors.toList());
        }
        if ("1".equals(bpWorksHoursCheck.getTerm()) && "0".equals(bpWorksHoursCheck.getHire())) {
            termDate = bpWorksHoursCheck.getTermDate();
            workDateList = woekDate.stream().filter(item -> item.getDayOff().before(termDate)).map(item -> formatD.format(item.getDayOff())).collect(Collectors.toList());
        }
        if ("0".equals(bpWorksHoursCheck.getTerm()) && "0".equals(bpWorksHoursCheck.getHire())) {
            termDate = new Date();
            workDateList = woekDate.stream().filter(item -> item.getDayOff().before(termDate)).map(item -> formatD.format(item.getDayOff())).collect(Collectors.toList());
        }
        if ("1".equals(bpWorksHoursCheck.getTerm()) && "1".equals(bpWorksHoursCheck.getHire())) {
            termDate = bpWorksHoursCheck.getTermDate();
            Date hireDate = bpWorksHoursCheck.getHireDate();
            workDateList = woekDate.stream().filter(item -> item.getDayOff().before(termDate) && item.getDayOff().after(hireDate)).map(item -> formatD.format(item.getDayOff())).collect(Collectors.toList());
        }
        bpWorksHoursCheck.setNeedWordHours(String.valueOf(workDateList.size() * 8));
        bpWorksHoursCheck.setWordDate(workDateList.stream().collect(Collectors.joining(",")));
    }

    private List<CalendarDTO> getWoekDate(String mouth) {
        try {
            ArrayList<CalendarDTO> calendarDTOS = new ArrayList<CalendarDTO>();
            Date date = new Date();
            SimpleDateFormat formatD = new SimpleDateFormat("yyyy-MM-dd");
            if (mouth == null) {
                SimpleDateFormat formatM = new SimpleDateFormat("yyyy-MM");
                mouth = formatM.format(new Date());
            } else {
                date = formatD.parse(DateCheckUtils.getLastDay(mouth));
            }
            Date firstday = formatD.parse(DateCheckUtils.getFirstDay(mouth));
            Date lastday = formatD.parse(DateCheckUtils.getLastDay(mouth));
            List<String> strings = DateCheckUtils.getAllDays(date);
            List dayOffList = this.calendarRpcService.findDayOffList(TenantContext.getTenant(), firstday, lastday);
            List collect = dayOffList.stream().map(item -> formatD.format(item.getDayOff())).collect(Collectors.toList());
            for (String string : strings) {
                if (collect.contains(string)) continue;
                CalendarDTO calendarDTO = new CalendarDTO();
                calendarDTO.setDayOff(DateUtils.parseDate((String)string, (String)"yyyy-MM-dd"));
                calendarDTOS.add(calendarDTO);
            }
            return calendarDTOS;
        }
        catch (Exception e) {
            this.log.error("\u83b7\u53d6\u5de5\u4f5c\u65e5\u5931\u8d25" + e.getMessage());
            throw new ELSBootException((Throwable)e);
        }
    }
}

