/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.workHoursCheck.utils;

import com.els.common.util.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.junit.Test;

public class DateCheckUtils {
    private static String DAY_PATTERN = "yyyy-MM-dd";
    private static String MOUTH_PATTERN = "yyyy-MM";
    private static SimpleDateFormat formatM = new SimpleDateFormat("yyyy-MM");

    public static String getFirstDay(String mouth) {
        try {
            Date date = formatM.parse(mouth);
            Calendar instance = Calendar.getInstance();
            instance.setTime(date);
            instance.add(2, 0);
            instance.set(5, 1);
            Date firstday = instance.getTime();
            return DateUtils.formatDate((Date)firstday, (String)DAY_PATTERN);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getLastDay(String mouth) {
        try {
            Date date = formatM.parse(mouth);
            Calendar instance = Calendar.getInstance();
            instance.setTime(date);
            instance.add(2, 1);
            instance.set(5, 0);
            Date lastDay = instance.getTime();
            return DateUtils.formatDate((Date)lastDay, (String)DAY_PATTERN);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<String> listFristToDay(Date time) {
        ArrayList<String> strings = new ArrayList<String>();
        try {
            Calendar currentDay = Calendar.getInstance();
            String firstDay = DateCheckUtils.getFirstDay(formatM.format(time));
            currentDay.setTime(DateUtils.parseDate((String)firstDay, (String)DAY_PATTERN));
            while (time.after(currentDay.getTime())) {
                strings.add(DateUtils.formatDate((Date)currentDay.getTime(), (String)DAY_PATTERN));
                currentDay.add(5, 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strings;
    }

    public static List<String> getAllDays(Date time) {
        ArrayList<String> strings = new ArrayList<String>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(time);
            calendar.add(2, 0);
            calendar.set(5, 1);
            int max = calendar.getActualMaximum(5);
            for (int i = 0; i < max; ++i) {
                calendar.set(5, i + 1);
                String day = sdf.format(calendar.getTime());
                strings.add(day);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strings;
    }

    public static List<String> listLastoDay(Date time) {
        ArrayList<String> strings = new ArrayList<String>();
        try {
            Calendar currentDay = Calendar.getInstance();
            String firstDay = DateCheckUtils.getLastDay(formatM.format(time));
            currentDay.setTime(DateUtils.parseDate((String)firstDay, (String)DAY_PATTERN));
            while (time.before(currentDay.getTime())) {
                strings.add(DateUtils.formatDate((Date)currentDay.getTime(), (String)DAY_PATTERN));
                currentDay.add(5, -1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strings;
    }

    public static long getDatePoor(Date endDate, Date nowDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long hour = diff / nh;
        return hour;
    }

    @Test
    public void test() throws ParseException {
        Date date = new SimpleDateFormat(DAY_PATTERN).parse("2023-09-11");
        List<String> strings = DateCheckUtils.listFristToDay(date);
        List<String> strings1 = DateCheckUtils.listLastoDay(date);
    }
}

