/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.workhours.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.service.AccountExtendRpcService;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.mainData.api.service.OrgRpcService;
import com.els.modules.project.service.ProjectBaseInfoService;
import com.els.modules.workhours.entity.EmployeeWorkHours;
import com.els.modules.workhours.enumerate.WorkHoursStatusEnum;
import com.els.modules.workhours.excel.WorkHoursExportServiceImpl;
import com.els.modules.workhours.service.EmployeeWorkHoursService;
import com.els.modules.workhours.vo.EmployeeWorkHoursVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u5458\u5de5\u5de5\u65f6"})
@RestController
@RequestMapping(value={"/workhours/employeeWorkHours"})
public class EmployeeWorkHoursController
extends BaseController<EmployeeWorkHours, EmployeeWorkHoursService> {
    @Autowired
    private EmployeeWorkHoursService employeeWorkHoursService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private OrgRpcService orgRpcService;
    @Autowired
    private ProjectBaseInfoService projectBaseInfoService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/itemList"})
    @RequiresPermissions(value={"project#projectBaseInfo:queryById"})
    public Result<?> queryItemPageList(EmployeeWorkHours employeeWorkHours, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)employeeWorkHours), (Map)req.getParameterMap());
        queryWrapper.clear();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"target_key", (Object)employeeWorkHours.getTargetKey())).orderByDesc((Object)"work_date");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.employeeWorkHoursService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:list"})
    @PermissionDataView(businessType="workhours")
    public Result<?> queryPageList(EmployeeWorkHours employeeWorkHours, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)employeeWorkHours), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        this.buildQueryWrapper((QueryWrapper<EmployeeWorkHours>)queryWrapper, employeeWorkHours);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.employeeWorkHoursService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:list"})
    @PermissionDataView(businessType="workhours")
    public Result<?> queryTabsCounts(EmployeeWorkHours employeeWorkHours, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)employeeWorkHours), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"check_status", "count(0) as participateQuantity"}).lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        this.buildQueryWrapper((QueryWrapper<EmployeeWorkHours>)queryWrapper, employeeWorkHours);
        queryWrapper.groupBy((Object)"check_status");
        List list = ((EmployeeWorkHoursService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(EmployeeWorkHours::getCheckStatus, EmployeeWorkHours::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "checkStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("checkStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "checkStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    private void buildQueryWrapper(QueryWrapper<EmployeeWorkHours> queryWrapper, EmployeeWorkHours workHours) {
        LoginUser loginUser = SysUtil.getLoginUser();
        Set roleSet = ((AccountRpcService)SpringContextUtils.getBean(AccountRpcService.class)).getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
        if ("1".equals(AdminFlagUtil.getAdminFlag()) || "auditor".equals(AdminFlagUtil.getAdminFlag()) || roleSet.contains("WorkHoursAuditor")) {
            return;
        }
        List accountIdList = ((AccountExtendRpcService)SpringContextUtils.getBean(AccountExtendRpcService.class)).getAccountIdListByLeader(this.getTenantId(), SysUtil.getLoginUser().getSubAccount());
        String currentUserId = SysUtil.getLoginUser().getId();
        if (workHours.getQueryType().equals("1")) {
            queryWrapper.in((Object)"create_by_id", (Collection)accountIdList);
        } else {
            queryWrapper.and(q -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)q.eq((Object)"target_charge_id", (Object)currentUserId);
            });
        }
        if (!loginUser.getId().equals("1666989921665564674")) {
            queryWrapper.and(q -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)q.eq((Object)"target_charge_id", (Object)currentUserId)).ne((Object)"check_status", (Object)WorkHoursStatusEnum.NEW.getValue())).or()).in((Object)"create_by_id", (Collection)accountIdList);
            });
        } else {
            queryWrapper.and(q -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)q.eq((Object)"target_charge_id", (Object)currentUserId)).ne((Object)"check_status", (Object)WorkHoursStatusEnum.NEW.getValue())).or()).in((Object)"create_by_id", new Object[]{"1666989921665564674"});
            });
        }
    }

    @AutoLog(value="\u5458\u5de5\u5de5\u65f6-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:add"})
    @FormCommit
    public Result<?> add(@RequestBody EmployeeWorkHoursVO hoursVO) {
        this.employeeWorkHoursService.add(hoursVO);
        return Result.ok((Object)hoursVO);
    }

    @AutoLog(value="\u5458\u5de5\u5de5\u65f6-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:edit"})
    public Result<?> edit(@RequestBody EmployeeWorkHours employeeWorkHours) {
        this.employeeWorkHoursService.edit(employeeWorkHours);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5458\u5de5\u5de5\u65f6-\u53d1\u9001")
    @ApiOperation(value="\u53d1\u9001", notes="\u53d1\u9001")
    @PostMapping(value={"/send"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:send"})
    public Result<?> send(@RequestBody EmployeeWorkHoursVO hoursVO) {
        this.employeeWorkHoursService.send(hoursVO);
        return Result.ok((Object)hoursVO);
    }

    @AutoLog(value="\u5458\u5de5\u5de5\u65f6-\u5de5\u65f6\u63d0\u9192")
    @ApiOperation(value="\u53d1\u9001", notes="\u53d1\u9001")
    @GetMapping(value={"/sendWorkRemind"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:send"})
    public Result<?> sendWorkRemind() {
        this.employeeWorkHoursService.sendMsgOfWorkHours();
        return Result.ok((Object)3);
    }

    @AutoLog(value="\u5458\u5de5\u5de5\u65f6-\u5de5\u65f6\u5ba1\u6279\u63d0\u9192")
    @ApiOperation(value="\u5de5\u65f6\u5ba1\u6279\u63d0\u9192", notes="\u5de5\u65f6\u5ba1\u6279\u63d0\u9192")
    @GetMapping(value={"/workAuditRemind"})
    public Result<?> workAuditRemind() {
        this.employeeWorkHoursService.workAuditRemind();
        return Result.ok((Object)3);
    }

    @AutoLog(value="\u5458\u5de5\u5de5\u65f6-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.employeeWorkHoursService.delete(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        EmployeeWorkHours employeeWorkHours = (EmployeeWorkHours)((Object)this.employeeWorkHoursService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)employeeWorkHours));
    }

    @ApiOperation(value="\u901a\u8fc7\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u7ec4\u7ec7\u4eba\u5458", notes="\u901a\u8fc7\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u7ec4\u7ec7\u4eba\u5458")
    @GetMapping(value={"/queryPersonByCode"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:add"})
    public Result<?> queryPersonByCode(@RequestParam(name="orgCategory") String orgCategory, @RequestParam(name="orgCode") String orgCode) {
        return Result.ok((Object)this.orgRpcService.findOrgPerson(this.getTenantId(), orgCategory, orgCode));
    }

    @ApiOperation(value="\u901a\u8fc7\u9879\u76ee\u7c7b\u578b\u67e5\u8be2\u9879\u76ee\u4fe1\u606f", notes="\u901a\u8fc7\u9879\u76ee\u7c7b\u578b\u67e5\u8be2\u9879\u76ee\u4fe1\u606f")
    @GetMapping(value={"/queryProjectByType"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:add"})
    public Result<?> queryProjectByType(@RequestParam(name="projectType") String projectType) {
        return Result.ok((Object)this.projectBaseInfoService.findProjectByType(this.getTenantId(), projectType));
    }

    @ApiOperation(value="\u6309\u7167\u65e5\u671f\u8303\u56f4\u67e5\u8be2\u5458\u5de5\u5de5\u65f6", notes="\u6309\u7167\u65e5\u671f\u8303\u56f4\u67e5\u8be2\u5458\u5de5\u5de5\u65f6")
    @PostMapping(value={"/findWorkHours"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:add"})
    public Result<?> findWorkHours(@RequestBody EmployeeWorkHoursVO hoursVO) {
        List workHoursList = this.employeeWorkHoursService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"staff_id", (Object)SysUtil.getLoginUser().getId())).between((Object)"work_date", (Object)hoursVO.getStartDate(), (Object)hoursVO.getEndDate()));
        return Result.ok((Object)workHoursList);
    }

    @ApiOperation(value="\u6309\u7167\u65e5\u671f\u8303\u56f4\u67e5\u8be2\u5de5\u4f5c\u65e5", notes="\u6309\u7167\u65e5\u671f\u8303\u56f4\u67e5\u8be2\u5de5\u4f5c\u65e5")
    @PostMapping(value={"/findWorkDate"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:add"})
    public Result<?> findWorkDate(@RequestBody EmployeeWorkHoursVO hoursVO) {
        return Result.ok(this.employeeWorkHoursService.findWorkDateList(this.getTenantId(), hoursVO.getStartDate(), hoursVO.getEndDate()));
    }

    @AutoLog(value="\u5458\u5de5\u5de5\u65f6-\u5ba1\u6279")
    @ApiOperation(value="\u5ba1\u6279", notes="\u5ba1\u6279")
    @PostMapping(value={"/auditOpt"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:auditOpt"})
    public Result<?> auditOpt(@RequestBody EmployeeWorkHoursVO hoursVO) {
        this.employeeWorkHoursService.auditOpt(hoursVO);
        return Result.ok((Object)hoursVO);
    }

    @AutoLog(value="\u5458\u5de5\u5de5\u65f6-\u9a73\u56de\u5df2\u901a\u8fc7")
    @ApiOperation(value="\u9a73\u56de\u5df2\u901a\u8fc7", notes="\u9a73\u56de\u5df2\u901a\u8fc7")
    @PostMapping(value={"/rejectAuditPass"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:rejectAuditPass"})
    public Result<?> rejectAuditPass(@RequestBody EmployeeWorkHoursVO hoursVO) {
        this.employeeWorkHoursService.rejectAuditPass(hoursVO);
        return Result.ok((Object)hoursVO);
    }

    @AutoLog(value="\u5458\u5de5\u5de5\u65f6-\u6307\u6d3e\u5ba1\u6279\u4eba")
    @ApiOperation(value="\u6307\u6d3e\u5ba1\u6279\u4eba", notes="\u6307\u6d3e\u5ba1\u6279\u4eba")
    @PostMapping(value={"/assignPerson"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:assignPerson"})
    public Result<?> assignPerson(@RequestBody EmployeeWorkHoursVO hoursVO) {
        this.employeeWorkHoursService.assignPerson(hoursVO);
        return Result.ok((Object)hoursVO);
    }

    @ApiOperation(value="\u5bfc\u51fa", notes="\u5bfc\u51fa")
    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"workhours#employeeWorkHours:exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, WorkHoursExportServiceImpl.class);
    }
}

