/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.workhours.excel;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.excel.service.BaseExportService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.service.AccountExtendRpcService;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.workhours.entity.EmployeeWorkHours;
import com.els.modules.workhours.enumerate.WorkHoursStatusEnum;
import com.els.modules.workhours.service.EmployeeWorkHoursService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="workHoursExportServiceImpl")
public class WorkHoursExportServiceImpl
extends BaseExportService<EmployeeWorkHours, EmployeeWorkHours, EmployeeWorkHours>
implements ExportDataLoaderService {
    @Autowired
    private EmployeeWorkHoursService employeeWorkHoursService;

    public List<EmployeeWorkHours> queryExportData(QueryWrapper<EmployeeWorkHours> queryWrapper, EmployeeWorkHours param, Map<String, String[]> paramMap) {
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        List pageList = this.employeeWorkHoursService.list((Wrapper)queryWrapper);
        return pageList;
    }

    public long queryExportDataCount(QueryWrapper<EmployeeWorkHours> queryWrapper, EmployeeWorkHours map, Map<String, String[]> paramMap) {
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        return this.employeeWorkHoursService.count((Wrapper)queryWrapper);
    }

    private void buildQueryWrapper(QueryWrapper<EmployeeWorkHours> queryWrapper, EmployeeWorkHours workHours) {
        LoginUser loginUser = SysUtil.getLoginUser();
        Set roleSet = ((AccountRpcService)SpringContextUtils.getBean(AccountRpcService.class)).getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
        if ("1".equals(AdminFlagUtil.getAdminFlag()) || "auditor".equals(AdminFlagUtil.getAdminFlag()) || roleSet.contains("employeeWorkHoursExport")) {
            return;
        }
        List accountIdList = ((AccountExtendRpcService)SpringContextUtils.getBean(AccountExtendRpcService.class)).getAccountIdListByLeader(TenantContext.getTenant(), SysUtil.getLoginUser().getSubAccount());
        String currentUserId = SysUtil.getLoginUser().getId();
        queryWrapper.and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)q.eq((Object)"target_charge_id", (Object)currentUserId)).ne((Object)"check_status", (Object)WorkHoursStatusEnum.NEW.getValue())).or()).in((Object)"create_by_id", (Collection)accountIdList);
        });
    }

    public String getBusinessType() {
        return "employeeWorkHoursList";
    }

    public String getBeanName() {
        return "workHoursExportExcelDataBatchQueryLoader";
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> entityMap, Map<String, String[]> requestParamMap) {
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = this.builderWrapper(entityMap, requestParamMap);
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List records = ((Page)this.employeeWorkHoursService.page((IPage)page, (Wrapper)queryWrapper)).getRecords();
        return JSON.toJSONString((Object)records);
    }
}

