/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.workhours.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.api.dto.BaseDTO;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.common.email.ElsEmailBuilder;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.calendar.api.dto.CalendarDTO;
import com.els.modules.calendar.api.service.CalendarRpcService;
import com.els.modules.employ.api.dto.ElsEmployeInfoDTO;
import com.els.modules.employ.api.service.EmployeeCostRpcService;
import com.els.modules.employ.api.service.EmployeeInfoRpcService;
import com.els.modules.manleave.api.service.ManLeaveRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.service.ProjectBaseInfoService;
import com.els.modules.workhours.entity.EmployeeWorkHours;
import com.els.modules.workhours.enumerate.WorkCategoryEnum;
import com.els.modules.workhours.enumerate.WorkHoursStatusEnum;
import com.els.modules.workhours.mapper.EmployeeWorkHoursMapper;
import com.els.modules.workhours.service.EmployeeWorkHoursService;
import com.els.modules.workhours.vo.EmployeeWorkHoursVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Template;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class EmployeeWorkHoursServiceImpl
extends BaseServiceImpl<EmployeeWorkHoursMapper, EmployeeWorkHours>
implements EmployeeWorkHoursService {
    private static final Logger log = LogManager.getLogger(EmployeeWorkHoursServiceImpl.class);
    @Autowired
    private CalendarRpcService calendarRpcService;
    @Autowired
    private EmployeeCostRpcService employeeCostRpcService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private AccountRpcService accountRpcService;
    @Autowired
    private ProjectBaseInfoService projectBaseInfoService;
    @Autowired
    private PurchaseOrganizationInfoRpcService purchaseOrganizationInfoRpcService;
    @Autowired
    private BaseRpcService baseRpcService;
    @Autowired
    private EmployeeInfoRpcService employeeInfoRpcService;
    @Resource
    private RedisUtil redisUtil;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    private static final String LOCK_KEY = "sys:workhours:add";

    @Override
    @Transactional
    public void add(EmployeeWorkHoursVO hoursVO) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, SysUtil.getLoginUser().getId(), 300000L)) {
            throw new ELSBootException("\u8bf7\u6c42\u5df2\u7ecf\u63d0\u4ea4\uff0c\u7cfb\u7edf\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u63d0\u4ea4");
        }
        try {
            this.checkParam(hoursVO);
            List<EmployeeWorkHours> hoursList = hoursVO.getWorkHoursList();
            String hoursStatus = WorkHoursStatusEnum.NEW.getValue();
            if ("1".equals(hoursVO.getSendOrNot())) {
                hoursStatus = WorkHoursStatusEnum.WAIT_AUTH.getValue();
            }
            ArrayList<EmployeeWorkHours> insertList = new ArrayList<EmployeeWorkHours>();
            ArrayList<String> needDeleteIdList = new ArrayList<String>();
            ArrayList<String> notDeleteIdList = new ArrayList<String>();
            Integer costValue = this.employeeCostRpcService.getCostValueByUserId(SysUtil.getLoginUser().getId());
            if (costValue == null) {
                throw new ELSBootException("\u60a8\u8fd8\u6ca1\u6709\u914d\u7f6e\u6807\u51c6\u6210\u672c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u6807\u51c6\u6210\u672c");
            }
            ElsSubAccountDTO accountDTO = this.invokeAccountRpcService.getAccountById(SysUtil.getLoginUser().getId());
            ElsEmployeInfoDTO elsEmployeInfoDTO = this.employeeInfoRpcService.getEmployeeInfoBySubAccountId(accountDTO.getId());
            if (elsEmployeInfoDTO == null) {
                throw new ELSBootException("\u672a\u627e\u5230\u5458\u5de5\u4fe1\u606f\uff01");
            }
            HashMap<String, ProjectBaseInfo> projectMap = new HashMap<String, ProjectBaseInfo>();
            List workHoursList = this.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"staff_id", (Object)SysUtil.getLoginUser().getId())).between((Object)"work_date", (Object)hoursVO.getStartDate(), (Object)hoursVO.getEndDate()));
            List dbIdList = workHoursList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LoginUser loginUser = SysUtil.getLoginUser();
            for (EmployeeWorkHours hours : hoursList) {
                if (WorkHoursStatusEnum.WAIT_AUTH.getValue().equals(hours.getCheckStatus()) || WorkHoursStatusEnum.AUTH_COMPLETE.getValue().equals(hours.getCheckStatus())) {
                    notDeleteIdList.add(hours.getId());
                    continue;
                }
                if (StrUtil.isNotBlank((CharSequence)hours.getId())) {
                    needDeleteIdList.add(hours.getId());
                }
                hours.setDepartmentName(elsEmployeInfoDTO.getDepartment());
                hours.setCostDepartment(elsEmployeInfoDTO.getCostCenter());
                hours.setCostValue(costValue);
                hours.setId(IdWorker.getIdStr());
                hours.setReplaceWrite("0");
                hours.setCheckStatus(hoursStatus);
                hours.setStaffId(accountDTO.getId());
                hours.setStaffName(accountDTO.getRealname());
                hours.setStaffCode(accountDTO.getWorkNo());
                hours.setExtraWorkFlag("0");
                hours.setCheckRemark("");
                this.workHourAndManLeave(hours);
                this.buildHours(hours, projectMap, accountDTO);
                insertList.add(hours);
            }
            for (String id : dbIdList) {
                if (notDeleteIdList.contains(id)) continue;
                EmployeeWorkHours byId = (EmployeeWorkHours)((Object)this.getById((Serializable)((Object)id)));
                for (int i = 0; i < insertList.size(); ++i) {
                    if (((EmployeeWorkHours)((Object)insertList.get(i))).getWorkDate().compareTo(byId.getWorkDate()) != 0 || !byId.getCheckStatus().equals("2") && !byId.getCheckStatus().equals("3")) continue;
                    insertList.remove(i);
                }
                if (byId.getCheckStatus().equals("2") || byId.getCheckStatus().equals("3")) continue;
                needDeleteIdList.add(id);
            }
            if (!needDeleteIdList.isEmpty()) {
                ((EmployeeWorkHoursMapper)this.baseMapper).deleteBatchIds(needDeleteIdList);
            }
            if (!insertList.isEmpty()) {
                this.saveBatch(insertList);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, SysUtil.getLoginUser().getId());
        }
    }

    private void buildHours(EmployeeWorkHours hours, Map<String, ProjectBaseInfo> projectMap, ElsSubAccountDTO accountDTO) {
        if (WorkCategoryEnum.PROJECT.getCode().equals(hours.getWorkCategory()) || WorkCategoryEnum.OTHER.getCode().equals(String.valueOf(hours.getWorkCategory())) || WorkCategoryEnum.PRODUCT.getCode().equals(hours.getWorkCategory()) || WorkCategoryEnum.DEVOPS.getCode().equals(hours.getWorkCategory())) {
            ProjectBaseInfo baseInfo = null;
            if (projectMap.containsKey(hours.getTargetKey())) {
                baseInfo = projectMap.get(hours.getTargetKey());
            } else {
                baseInfo = (ProjectBaseInfo)((Object)this.projectBaseInfoService.getById((Serializable)((Object)hours.getTargetKey())));
                if (baseInfo == null) {
                    throw new ELSBootException("\u64cd\u4f5c\u5931\u8d25\uff0c\u90e8\u5206\u9879\u76ee\u5df2\u7ecf\u5173\u95ed\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
                }
                if (!baseInfo.getEnable().equals("1")) {
                    throw new ELSBootException(String.format("[%s]\u9879\u76ee\u4e0d\u53ef\u7528,\u6682\u65f6\u4e0d\u53ef\u586b\u62a5\u5de5\u65f6,\u8bf7\u68c0\u67e5", baseInfo.getProjectName()));
                }
                if (StrUtil.isNotEmpty((CharSequence)baseInfo.getProjectStatus()) && baseInfo.getProjectStatus().equals("notStarted")) {
                    throw new ELSBootException(String.format("[%s]\u9879\u76ee\u4e3a\u5f85\u542f\u52a8,\u6682\u65f6\u4e0d\u53ef\u586b\u62a5\u5de5\u65f6,\u8bf7\u68c0\u67e5", baseInfo.getProjectName()));
                }
                projectMap.put(hours.getTargetKey(), baseInfo);
            }
            if (baseInfo.getProjectManagerId().equals(hours.getStaffId()) && baseInfo.getProjectManagerName().equals(hours.getStaffName())) {
                hours.setTargetChargeId(baseInfo.getProjectChiefInspectorId());
                hours.setTargetChargeName(baseInfo.getProjectChiefInspectorName());
            } else {
                hours.setTargetChargeId(baseInfo.getProjectManagerId());
                hours.setTargetChargeName(baseInfo.getProjectManagerName());
            }
        } else if (WorkCategoryEnum.DEPARTMENT.getCode().equals(hours.getWorkCategory()) || WorkCategoryEnum.LEAVE.getCode().equals(hours.getWorkCategory()) || WorkCategoryEnum.BREAKOFF.getCode().equals(hours.getWorkCategory())) {
            String orgCode = hours.getDepartmentName();
            if (StrUtil.isEmpty((CharSequence)orgCode)) {
                throw new ELSBootException("\u60a8\u8fd8\u6ca1\u6709\u5206\u914d\u90e8\u95e8\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u90e8\u95e8");
            }
            PurchaseOrganizationInfoDTO orgInfo = this.getOrgInfo(orgCode, null, hours.getStaffId());
            if (orgInfo == null) {
                throw new ELSBootException("\u7cfb\u7edf\u7ed9\u60a8\u5206\u914d\u7684\u90e8\u95e8\u4e0d\u5b58\u5728");
            }
            hours.setTargetKey(orgInfo.getId());
            hours.setTargetName(orgInfo.getOrgName());
            hours.setTargetChargeId(orgInfo.getFbk1());
            hours.setTargetChargeName(orgInfo.getFbk2());
        } else if (WorkCategoryEnum.PRESALE.getCode().equals(hours.getWorkCategory())) {
            hours.setTargetChargeId(hours.getTargetKey());
            hours.setTargetChargeName(hours.getTargetName());
        }
    }

    private PurchaseOrganizationInfoDTO getOrgInfo(String orgCode, String orgId, String staffId) {
        PurchaseOrganizationInfoDTO orgInfo = null;
        orgInfo = orgId != null ? this.purchaseOrganizationInfoRpcService.selectById(orgId) : this.purchaseOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "dept", orgCode);
        if (orgInfo == null) {
            throw new ELSBootException("\u7cfb\u7edf\u7ed9\u60a8\u5206\u914d\u7684\u90e8\u95e8\u4e0d\u5b58\u5728");
        }
        if (staffId.equals(orgInfo.getFbk1()) && StrUtil.isNotBlank((CharSequence)orgInfo.getSuperExecutiveId())) {
            return this.getOrgInfo(orgCode, orgInfo.getSuperExecutiveId(), staffId);
        }
        return orgInfo;
    }

    private String getHoursLimitFalg() {
        String hoursLimitFalg = "0";
        ElsCompanySetDTO companySetDTO = this.baseRpcService.getElsCompanySetByElsAccountAndItemCode(TenantContext.getTenant(), "hoursLimitFalg");
        if (companySetDTO != null && StrUtil.isNotBlank((CharSequence)companySetDTO.getDefaultValue())) {
            hoursLimitFalg = companySetDTO.getDefaultValue();
        }
        return hoursLimitFalg;
    }

    private Integer getMaxWorkHours() {
        Integer maxWorkHours = 8;
        ElsCompanySetDTO companySetDTO = this.baseRpcService.getElsCompanySetByElsAccountAndItemCode(TenantContext.getTenant(), "maxWorkHours");
        if (companySetDTO != null && StrUtil.isNotBlank((CharSequence)companySetDTO.getDefaultValue())) {
            try {
                maxWorkHours = Integer.valueOf(companySetDTO.getDefaultValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return maxWorkHours;
    }

    private void checkParam(EmployeeWorkHoursVO hoursVO) {
        List<EmployeeWorkHours> hoursList = hoursVO.getWorkHoursList();
        String hoursLimitFalg = this.getHoursLimitFalg();
        Integer maxWorkHours = this.getMaxWorkHours();
        List<String> workDateList = this.findWorkDateList(TenantContext.getTenant(), hoursVO.getStartDate(), hoursVO.getEndDate());
        String nowDate = EmployeeWorkHoursServiceImpl.getNetworkTime();
        LoginUser loginUser = SysUtil.getLoginUser();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ProjectBaseInfoService projectBaseInfoService = (ProjectBaseInfoService)SpringContextUtils.getBean(ProjectBaseInfoService.class);
        ArrayList<String> projectStatusList = new ArrayList<String>();
        projectStatusList.add("stop");
        projectStatusList.add("customerOperation");
        projectStatusList.add("stopOperation");
        projectStatusList.add("notStarted");
        queryWrapper.in(ProjectBaseInfo::getProjectStatus, projectStatusList);
        List projectInfos = projectBaseInfoService.list((Wrapper)queryWrapper);
        for (EmployeeWorkHours hours : hoursList) {
            if (WorkHoursStatusEnum.WAIT_AUTH.getValue().equals(hours.getCheckStatus()) || WorkHoursStatusEnum.AUTH_COMPLETE.getValue().equals(hours.getCheckStatus())) continue;
            String projectId = hours.getTargetKey();
            String targetName = hours.getTargetName();
            if (!CollectionUtils.isEmpty((Collection)projectInfos)) {
                List projectIds = projectInfos.stream().map(BaseEntity::getId).collect(Collectors.toList());
                if (!StringUtils.isEmpty((Object)projectId) && projectIds.contains(projectId)) {
                    throw new ELSBootException("'" + targetName + "'\u9879\u76ee\u72b6\u6001\u5904\u4e8e'\u4e2d\u6b62 \u6216 \u5ba2\u6237\u81ea\u8fd0\u7ef4 \u6216 \u505c\u6b62\u8fd0\u7ef4 \u6216 \u5f85\u542f\u52a8' \u4e2d, \u4e0d\u80fd\u586b\u62a5\u5de5\u65f6 \uff01");
                }
            }
            if (hours.getWorkDate() == null) {
                throw new ELSBootException("\u5de5\u65f6\u586b\u62a5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (hours.getWorkDate().after(new Date())) {
                throw new ELSBootException("\u5de5\u65f6\u4e0d\u80fd\u586b\u5199\u5f53\u524d\u65f6\u95f4\u4e4b\u540e\u7684\u65e5\u671f\uff01");
            }
            String workDateStr = DateUtil.formatDate((Date)hours.getWorkDate());
            if (!workDateList.contains(workDateStr)) {
                throw new ELSBootException("\u65e5\u671f\uff1a" + workDateStr + "\u4e0d\u662f\u5de5\u4f5c\u65e5\uff0c\u4e0d\u80fd\u586b\u62a5\u5de5\u65f6\uff01");
            }
            if ("0".equals(hoursLimitFalg)) {
                String oldDate = DateUtil.format((Date)hours.getWorkDate(), (String)"yyyy-MM-dd");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(hours.getWorkDate());
                int i = calendar.get(2);
                calendar.setTime(new Date());
                int nowMouth = calendar.get(2);
                calendar.set(5, 4);
                if (i != nowMouth) {
                    if (calendar.getTime().before(new Date())) {
                        throw new ELSBootException((String)oldDate + "\u4e0d\u53ef\u586b\u62a5\u4e0a\u6708\u4ee5\u524d\u5f97\u5de5\u65f6");
                    }
                    if (!this.checkWeek(hours.getWorkDate())) {
                        throw new ELSBootException((String)oldDate + "\u5df2\u8fc7\u586b\u62a5\u65f6\u9650\uff0c\u4e0d\u80fd\u586b\u62a5\u5de5\u65f6\uff01");
                    }
                }
                if (i == nowMouth && !this.checkWeek(hours.getWorkDate())) {
                    throw new ELSBootException((String)oldDate + "\u5df2\u8fc7\u586b\u62a5\u65f6\u9650\uff0c\u4e0d\u80fd\u586b\u62a5\u5de5\u65f6\uff01");
                }
            }
            if (hours.getWorkHours() == null || hours.getWorkHours().compareTo(BigDecimal.ZERO) < 0) {
                throw new ELSBootException("\u65e5\u671f\uff1a" + workDateStr + "\u586b\u62a5\u5de5\u65f6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank((CharSequence)hours.getWorkContents())) {
                throw new ELSBootException("\u65e5\u671f\uff1a" + workDateStr + "\u5de5\u65f6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StrUtil.isBlank((CharSequence)hours.getWorkCategory())) continue;
            throw new ELSBootException("\u65e5\u671f\uff1a" + workDateStr + "\u5de5\u65f6\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Map<Date, List<EmployeeWorkHours>> hoursMap = hoursList.stream().collect(Collectors.groupingBy(EmployeeWorkHours::getWorkDate));
        for (Date workDate : hoursMap.keySet()) {
            List<EmployeeWorkHours> list = hoursMap.get(workDate);
            BigDecimal totalHours = BigDecimal.ZERO;
            for (EmployeeWorkHours hours : list) {
                totalHours = totalHours.add(hours.getWorkHours());
            }
            if (totalHours.compareTo(new BigDecimal(maxWorkHours)) <= 0) continue;
            String workDateStr = DateUtil.formatDate((Date)workDate);
            throw new ELSBootException("\u65e5\u671f\uff1a" + workDateStr + "\u586b\u62a5\u5de5\u65f6\u8d85\u51fa\u7cfb\u7edf\u6700\u5927\u914d\u7f6e\u503c\uff01\u6700\u5927\u503c\u4e3a\uff1a" + maxWorkHours);
        }
    }

    private boolean checkMouth(Date workDate) {
        return false;
    }

    private boolean checkWeek(Date workDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        int dayOfWeek = calendar.get(7);
        if (dayOfWeek == 1) {
            dayOfWeek = 7;
        }
        if (dayOfWeek - 1 > 3) {
            calendar.setFirstDayOfWeek(1);
            Date today = new Date();
            calendar.setTime(today);
            if (dayOfWeek == 7 || dayOfWeek == 1) {
                calendar.add(5, -1 * (dayOfWeek + 2));
            } else {
                calendar.set(7, 2);
            }
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            ArrayList<String> weekDatesList = new ArrayList<String>();
            while (calendar.getTime().before(new Date())) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String startDateStr = sdf.format(calendar.getTime());
                weekDatesList.add(startDateStr);
                calendar.add(5, 1);
            }
            if (weekDatesList.contains(dateFormat.format(workDate))) {
                return true;
            }
        } else {
            calendar.add(5, -(dayOfWeek + 5));
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            ArrayList<String> datesList = new ArrayList<String>();
            while (calendar.getTime().before(new Date())) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String startDateStr = sdf.format(calendar.getTime());
                datesList.add(startDateStr);
                calendar.add(5, 1);
            }
            if (datesList.contains(dateFormat.format(workDate))) {
                return true;
            }
        }
        return false;
    }

    public static String getNetworkTime() {
        String webUrl = "http://www.baidu.com";
        try {
            URL url = new URL(webUrl);
            URLConnection conn = url.openConnection();
            conn.connect();
            long dateL = conn.getDate();
            Date date = new Date(dateL);
            SimpleDateFormat dateFormat = new SimpleDateFormat("YYYY-MM-dd");
            return dateFormat.format(date);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public void edit(EmployeeWorkHours hours) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, SysUtil.getLoginUser().getId(), 300000L)) {
            throw new ELSBootException("\u8bf7\u6c42\u5df2\u7ecf\u63d0\u4ea4\uff0c\u7cfb\u7edf\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u63d0\u4ea4");
        }
        try {
            EmployeeWorkHours dbHours = (EmployeeWorkHours)((Object)this.getById((Serializable)((Object)hours.getId())));
            if (WorkHoursStatusEnum.WAIT_AUTH.getValue().equals(dbHours.getCheckStatus()) || WorkHoursStatusEnum.AUTH_COMPLETE.getValue().equals(dbHours.getCheckStatus())) {
                throw new ELSBootException("\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u4fee\u6539\uff01");
            }
            EmployeeWorkHoursVO hoursVO = new EmployeeWorkHoursVO();
            List hoursList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"staff_id", (Object)hours.getStaffId())).eq((Object)"work_date", (Object)hours.getWorkDate()));
            ArrayList<EmployeeWorkHours> checkList = new ArrayList<EmployeeWorkHours>();
            checkList.add(hours);
            for (EmployeeWorkHours workHours : hoursList) {
                if (workHours.getId().equals(hours.getId())) continue;
                checkList.add(workHours);
            }
            hoursVO.setWorkHoursList(checkList);
            hoursVO.setEndDate(hours.getWorkDate());
            hoursVO.setStartDate(hours.getWorkDate());
            this.checkParam(hoursVO);
            ElsSubAccountDTO accountDTO = this.invokeAccountRpcService.getAccountById(SysUtil.getLoginUser().getId());
            HashMap<String, ProjectBaseInfo> projectMap = new HashMap<String, ProjectBaseInfo>();
            this.buildHours(hours, projectMap, accountDTO);
            int count = ((EmployeeWorkHoursMapper)this.baseMapper).updateById((Object)hours);
            Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, SysUtil.getLoginUser().getId());
        }
    }

    @Override
    public void delete(String id) {
        ((EmployeeWorkHoursMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public List<String> findWorkDateList(String elsAccount, Date startDate, Date endDate) {
        if (startDate == null) {
            throw new ELSBootException("startDate \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (endDate == null) {
            throw new ELSBootException("endDate \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (startDate.compareTo(endDate) > 0) {
            throw new ELSBootException("endDate \u5fc5\u987b\u5927\u4e8e startDate\uff01");
        }
        List dtoList = this.calendarRpcService.findDayOffList(elsAccount, startDate, endDate);
        ArrayList<String> dayOffList = new ArrayList<String>();
        for (CalendarDTO dto : dtoList) {
            dayOffList.add(DateUtil.formatDate((Date)dto.getDayOff()));
        }
        ArrayList<String> resultList = new ArrayList<String>();
        Date currentDate = new Date();
        do {
            String startDateStr;
            if (dayOffList.contains(startDateStr = DateUtil.formatDate((Date)startDate))) continue;
            resultList.add(startDateStr);
        } while ((startDate = DateUtil.offsetDay((Date)startDate, (int)1)).compareTo(endDate) <= 0 && startDate.compareTo(currentDate) <= 0);
        return resultList;
    }

    @Override
    @Transactional
    public void send(EmployeeWorkHoursVO hoursVO) {
        List<EmployeeWorkHours> hoursList = hoursVO.getWorkHoursList();
        String hoursLimitFalg = this.getHoursLimitFalg();
        String nowDate = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        for (EmployeeWorkHours hours : hoursList) {
            if (WorkHoursStatusEnum.WAIT_AUTH.getValue().equals(hours.getCheckStatus()) || WorkHoursStatusEnum.AUTH_COMPLETE.getValue().equals(hours.getCheckStatus())) {
                throw new ELSBootException("\u53ea\u6709\u672a\u53d1\u9001\u8ddf\u5df2\u9a73\u56de\u7684\u5355\u636e\u53ef\u4ee5\u53d1\u9001\uff01");
            }
            if ("0".equals(hoursLimitFalg)) {
                String oldDate = DateUtil.format((Date)hours.getWorkDate(), (String)"yyyy-MM-dd");
                String[] nowSplit = nowDate.split("-");
                String[] oldSplit = oldDate.split("-");
                if (Integer.valueOf(nowSplit[1]) > Integer.valueOf(oldSplit[1])) {
                    if (Integer.valueOf(nowSplit[2]) > 4) {
                        throw new ELSBootException(oldDate + "\u5df2\u8fc7\u586b\u62a5\u65f6\u9650\uff0c\u4e0d\u53ef\u53d1\u9001\u5de5\u65f6\uff01");
                    }
                    if (Integer.valueOf(oldSplit[1]) + 1 != Integer.valueOf(nowSplit[1])) {
                        if (Integer.valueOf(nowSplit[1]) == 1 && Integer.valueOf(oldSplit[1]) + 1 == 13) continue;
                        throw new ELSBootException(oldDate + "\u4e0d\u53ef\u586b\u62a5\u4e0a\u6708\u4ee5\u524d\u5f97\u5de5\u65f6");
                    }
                }
            }
            hours.setCheckStatus(WorkHoursStatusEnum.WAIT_AUTH.getValue());
        }
        this.updateBatchById(hoursList);
    }

    @Override
    public void auditOpt(EmployeeWorkHoursVO hoursVO) {
        List<EmployeeWorkHours> hoursList = hoursVO.getWorkHoursList();
        String auditOpt = hoursVO.getAuditOpt();
        String checkStatus = WorkHoursStatusEnum.AUTH_COMPLETE.getValue();
        if ("0".equals(auditOpt)) {
            checkStatus = WorkHoursStatusEnum.REJECTED.getValue();
        }
        String crrentUserId = SysUtil.getLoginUser().getId();
        for (EmployeeWorkHours hours : hoursList) {
            hours.setCheckStatus(checkStatus);
            hours.setCheckRemark(hoursVO.getRemark());
            if ("1".equals(auditOpt)) {
                hours.setConfirmHours(hours.getWorkHours());
            }
            if (crrentUserId.equals(hours.getTargetChargeId())) continue;
            throw new ELSBootException("\u53ea\u6709\u5f53\u524d\u5de5\u65f6\u8d1f\u8d23\u4eba\u624d\u80fd\u5ba1\u6279\uff01");
        }
        if (!hoursList.isEmpty()) {
            this.updateBatchById(hoursList);
        }
    }

    @Override
    public void rejectAuditPass(EmployeeWorkHoursVO hoursVO) {
        List<EmployeeWorkHours> hoursList = hoursVO.getWorkHoursList();
        for (EmployeeWorkHours hours : hoursList) {
            if (!hours.getCheckStatus().equals(WorkHoursStatusEnum.AUTH_COMPLETE.getValue())) {
                throw new ELSBootException("\u8bf7\u9009\u62e9\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\u8fdb\u884c\u9a73\u56de\uff01");
            }
            hours.setCheckStatus(WorkHoursStatusEnum.REJECTED.getValue());
        }
        if (!hoursList.isEmpty()) {
            this.updateBatchById(hoursList);
        }
    }

    @Override
    public void assignPerson(EmployeeWorkHoursVO hoursVO) {
        List<EmployeeWorkHours> hoursList = hoursVO.getWorkHoursList();
        for (EmployeeWorkHours hours : hoursList) {
            hours.setTargetChargeId(hoursVO.getTargetChargeId());
            hours.setTargetChargeName(hoursVO.getTargetChargeName());
        }
        if (!hoursList.isEmpty()) {
            this.updateBatchById(hoursList);
        }
    }

    @Override
    public void sendMsgOfWorkHours() {
        SimpleDateFormat formatD = new SimpleDateFormat("yyyy-MM-dd");
        TenantContext.setTenant((String)SysUtil.getPurchaseAccount());
        Calendar calendar = Calendar.getInstance();
        int dayOfWeek = calendar.get(7);
        if (dayOfWeek == 1) {
            calendar.add(5, -6);
        } else {
            calendar.add(5, -(dayOfWeek + 1));
        }
        Date startDate = calendar.getTime();
        calendar.add(5, 7);
        Date endDate = calendar.getTime();
        List dayOffList = this.calendarRpcService.findDayOffList(TenantContext.getTenant(), startDate, endDate);
        List collect = dayOffList.stream().map(item -> formatD.format(item.getDayOff())).collect(Collectors.toList());
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(EmployeeWorkHours::getWorkDate, collect)).list();
        Map<String, List<EmployeeWorkHours>> collect1 = list.stream().collect(Collectors.groupingBy(EmployeeWorkHours::getStaffId));
        Iterator<String> iterator = collect1.keySet().iterator();
        HashMap<String, JSONObject> jsonMap = new HashMap<String, JSONObject>();
        while (iterator.hasNext()) {
            String next = iterator.next();
            List<EmployeeWorkHours> employeeWorkHours = collect1.get(next);
            BigDecimal reduce = employeeWorkHours.stream().filter(p -> p.getWorkHours() != null).map(EmployeeWorkHours::getWorkHours).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (reduce.compareTo(new BigDecimal(collect.size() * 8)) >= 0) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("userId", (Object)employeeWorkHours.get(0).getStaffId());
            jsonObject.put("userName", (Object)employeeWorkHours.get(0).getStaffName());
            Map<Date, List<EmployeeWorkHours>> collect2 = employeeWorkHours.stream().collect(Collectors.groupingBy(EmployeeWorkHours::getWorkDate));
            jsonObject.put("workDate", (Object)employeeWorkHours.get(0).getStaffName());
            jsonMap.put(next, jsonObject);
        }
        if (!jsonMap.isEmpty()) {
            ArrayList strings = new ArrayList(jsonMap.keySet());
            List elsEmployeInfoDTOS = this.employeeInfoRpcService.listEmployeInfoByIds(strings);
            elsEmployeInfoDTOS.forEach(item -> {
                String id = item.getId();
                if (jsonMap.containsKey(id)) {
                    JSONObject jsonObject = (JSONObject)jsonMap.get(id);
                    jsonObject.put("email", (Object)item.getEmail());
                }
            });
            List collect2 = elsEmployeInfoDTOS.stream().map(ElsEmployeInfoDTO::getSubAccountId).collect(Collectors.toList());
            String join = String.join((CharSequence)",", collect2);
            List accountListByUserIds = this.accountRpcService.getAccountListByUserIds(join);
            LoginUser loginUser = SysUtil.getLoginUser();
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgKey", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)TenantContext.getTenant());
            msgObj.put("businessType", (Object)"workhours");
            msgObj.put("operateType", (Object)"remind");
            msgObj.put("businessObj", (Object)new JSONObject());
            msgObj.put("sendObj", (Object)loginUser);
            JSONArray array = new JSONArray();
            JSONObject receiveObj = new JSONObject();
            receiveObj.put("toElsAccount", (Object)TenantContext.getTenant());
            receiveObj.put("urlParam", (Object)"");
            receiveObj.put("toSubAccountList", (Object)JSONObject.parseArray((String)JSON.toJSONString((Object)accountListByUserIds)));
            array.add((Object)receiveObj);
            msgObj.put("receiveList", (Object)array);
            MqUtil.sendBusMsg((String)msgObj.toJSONString());
        }
    }

    @Override
    public List<String> findWorkDateList4ManLeave(String elsAccount, Date startDate, Date endDate) {
        if (startDate == null) {
            throw new ELSBootException("startDate \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (endDate == null) {
            throw new ELSBootException("endDate \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (startDate.compareTo(endDate) > 0) {
            throw new ELSBootException("endDate \u5fc5\u987b\u5927\u4e8e startDate\uff01");
        }
        List dtoList = this.calendarRpcService.findDayOffList(elsAccount, startDate, endDate);
        ArrayList<String> dayOffList = new ArrayList<String>();
        for (CalendarDTO dto : dtoList) {
            dayOffList.add(DateUtil.formatDate((Date)dto.getDayOff()));
        }
        ArrayList<String> resultList = new ArrayList<String>();
        do {
            String startDateStr;
            if (dayOffList.contains(startDateStr = DateUtil.formatDate((Date)startDate))) continue;
            resultList.add(startDateStr);
        } while ((startDate = DateUtil.offsetDay((Date)startDate, (int)1)).compareTo(endDate) <= 0);
        return resultList;
    }

    @Override
    public List<String> findWorkDateList5ManLeave(String elsAccount, Date startDay, Date endDay) {
        if (startDay == null) {
            throw new ELSBootException("startDate \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (endDay == null) {
            throw new ELSBootException("endDate \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (startDay.compareTo(endDay) > 0) {
            throw new ELSBootException("endDate \u5fc5\u987b\u5927\u4e8e startDate\uff01");
        }
        List dtoList = this.calendarRpcService.findDayOffList(elsAccount, startDay, endDay);
        ArrayList<String> dayOffList = new ArrayList<String>();
        for (CalendarDTO dto : dtoList) {
            dayOffList.add(DateUtil.formatDate((Date)dto.getDayOff()));
        }
        ArrayList<String> resultList = new ArrayList<String>();
        do {
            String startDateStr;
            if (dayOffList.contains(startDateStr = DateUtil.formatDate((Date)startDay))) continue;
            resultList.add(startDateStr);
        } while ((startDay = DateUtil.offsetDay((Date)startDay, (int)1)).compareTo(endDay) <= 0);
        return resultList;
    }

    @Override
    public void workAuditRemind() {
        LambdaQueryWrapper lambdaQuery = new LambdaQueryWrapper();
        DateTime dateTime = DateUtil.lastMonth();
        DateTime beginOfMonth = DateUtil.beginOfMonth((Date)dateTime);
        DateTime endOfMonth = DateUtil.endOfMonth((Date)dateTime);
        log.info("workAuditRemind beginOfMonth: {}, endOfMonth: {}", (Object)beginOfMonth, (Object)endOfMonth);
        lambdaQuery.ge(EmployeeWorkHours::getWorkDate, (Object)beginOfMonth);
        lambdaQuery.le(EmployeeWorkHours::getWorkDate, (Object)endOfMonth);
        lambdaQuery.eq(BaseEntity::getElsAccount, (Object)"1517606");
        lambdaQuery.eq(EmployeeWorkHours::getCheckStatus, (Object)WorkHoursStatusEnum.WAIT_AUTH.getValue());
        List list = this.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        Set targetChargeId = list.stream().map(EmployeeWorkHours::getTargetChargeId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(targetChargeId)) {
            return;
        }
        String userIds = String.join((CharSequence)",", targetChargeId);
        log.info("workAuditRemind userIds: {}", (Object)userIds);
        List accountList = this.accountRpcService.getAccountListByUserIds(userIds);
        if (CollectionUtils.isEmpty((Collection)accountList)) {
            return;
        }
        Map<String, ElsSubAccountDTO> accountMap = accountList.stream().collect(Collectors.toMap(BaseDTO::getId, account -> account));
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)dateTime);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        log.info("workAuditRemind year: {},  month: {} ", (Object)year, (Object)month);
        Map<String, List<EmployeeWorkHours>> targetChargeIdMap = list.stream().collect(Collectors.groupingBy(EmployeeWorkHours::getTargetChargeId));
        for (Map.Entry<String, List<EmployeeWorkHours>> entry : targetChargeIdMap.entrySet()) {
            List<EmployeeWorkHours> hoursList;
            String userId = entry.getKey();
            ElsSubAccountDTO elsSubAccountDTO = accountMap.get(userId);
            if (elsSubAccountDTO == null || CollectionUtils.isEmpty(hoursList = entry.getValue())) continue;
            Set staffName = hoursList.stream().map(EmployeeWorkHours::getStaffName).collect(Collectors.toSet());
            String staffNames = String.join((CharSequence)"\u3001", staffName);
            log.info("workAuditRemind send to : {} , staffNames: {}", (Object)elsSubAccountDTO.getEmail(), (Object)staffNames);
            ElsEmailConfigDTO config = this.invokeBaseRpcService.getEmailConfig("1517606");
            String subject = "\u5de5\u65f6\u5ba1\u6279\u63d0\u9192";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("year", year);
            params.put("month", month);
            params.put("userName", staffNames);
            GroupTemplate groupTemplate = new GroupTemplate();
            Template template = groupTemplate.getTemplate("WorkHoursAuditOfSendEmailToLeader.html");
            template.binding(params);
            String render = template.render();
            ElsEmailBuilder.sendEmailWithEp((ElsEmailConfigDTO)config, (String)elsSubAccountDTO.getEmail(), (String)subject, (String)render, null, (boolean)false);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.error("sleep error : {} ", (Object)e.getMessage());
            }
        }
    }

    public void workHourAndManLeave(EmployeeWorkHours hours) {
        ManLeaveRpcService manLeaveRpcService = (ManLeaveRpcService)SpringContextUtils.getBean(ManLeaveRpcService.class);
        manLeaveRpcService.selectManLeaveByWorkDate(hours.getWorkDate(), hours.getStaffName(), hours.getStaffId(), hours.getWorkHours());
    }
}

