/*
 * Decompiled with CFR 0.152.
 */
package com.els.huayang.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateXUtils {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static Date parse(String dateString) {
        LocalDateTime localDate = LocalDateTime.parse(dateString, DATE_TIME_FORMATTER);
        ZoneId zoneId = ZoneId.systemDefault();
        Instant instant = localDate.atZone(zoneId).toInstant();
        Date date = Date.from(instant);
        return date;
    }

    public static String format(Date target) {
        Instant instant = target.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        return localDateTime.format(DATE_TIME_FORMATTER);
    }

    public static Date parse(String dateString, DateTimeFormatter dateTimeFormatter) {
        LocalDateTime localDate = LocalDateTime.parse(dateString, dateTimeFormatter);
        ZoneId zoneId = ZoneId.systemDefault();
        Instant instant = localDate.atZone(zoneId).toInstant();
        Date date = Date.from(instant);
        return date;
    }

    public static String format(Date target, DateTimeFormatter dateTimeFormatter) {
        Instant instant = target.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        return localDateTime.format(dateTimeFormatter);
    }
}

