/*
 * Decompiled with CFR 0.152.
 */
package com.els.huayang.utils;

import com.alibaba.fastjson.JSONObject;
import com.els.base.core.exception.CommonException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    protected static Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    private static HttpClient sslClient() {
        try {
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String str) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String str) {
                }
            };
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{trustManager}, null);
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard-strict").setExpectContinueEnabled(Boolean.TRUE.booleanValue()).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)socketFactory).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            CloseableHttpClient closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
            return closeableHttpClient;
        }
        catch (KeyManagementException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String doPost(String url, JSONObject headers, String dataMap) {
        try {
            HttpResponse httpResponse = HttpUtils.doPostAsHttpResponse(url, headers, dataMap);
            if (httpResponse != null) {
                Integer code = httpResponse.getStatusLine().getStatusCode();
                if (code == 200) {
                    return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                }
                String msg = String.format("\u8bf7\u6c42\u5f02\u5e38\uff0c\u54cd\u5e94\u7f16\u7801->%s", code);
                logger.error(msg);
                throw new CommonException(msg);
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doGet(String url, JSONObject headers) {
        try {
            HttpResponse httpResponse = HttpUtils.doGetAsHttpResponse(url, headers);
            if (httpResponse != null) {
                Integer code = httpResponse.getStatusLine().getStatusCode();
                if (code == 200) {
                    return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                }
                String msg = String.format("\u8bf7\u6c42\u5f02\u5e38\uff0c\u54cd\u5e94\u7f16\u7801->%s", code);
                logger.error(msg);
                throw new CommonException(msg);
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HttpResponse doPostAsHttpResponse(String url, JSONObject headers, String dataMap) {
        logger.info("");
        logger.info("\u53d1\u9001http post\u8bf7\u6c42\u5f00\u59cb \n url->{} \n head->{} \n body->{}", new Object[]{url, headers, dataMap});
        HttpClient httpClient = HttpUtils.sslClient();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(HttpUtils.setTimeOutConfig(httpPost.getConfig()));
        if (headers != null) {
            for (String header : headers.keySet()) {
                httpPost.setHeader(header, headers.getString(header));
            }
        }
        StringEntity stringEntity = new StringEntity(dataMap, Charset.defaultCharset());
        stringEntity.setContentType(ContentType.APPLICATION_JSON.toString());
        httpPost.setEntity((HttpEntity)stringEntity);
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            logger.info("\u53d1\u9001http post\u8bf7\u6c42\u7ed3\u675f");
            logger.info("");
            return httpResponse;
        }
        catch (IOException e) {
            logger.error("Post\u8bf7\u6c42\u9519\u8bef {}", (Object)e.getMessage());
            return null;
        }
    }

    public static HttpResponse doGetAsHttpResponse(String url, JSONObject headers) {
        logger.info("");
        logger.info("\u53d1\u9001http get\u8bf7\u6c42\u5f00\u59cb \n url->{} \n head->{}", (Object)url, (Object)headers);
        HttpClient httpClient = HttpUtils.sslClient();
        HttpGet httpGet = new HttpGet(url);
        httpGet.setConfig(HttpUtils.setTimeOutConfig(httpGet.getConfig()));
        if (headers != null) {
            for (String header : headers.keySet()) {
                httpGet.setHeader(header, headers.getString(header));
            }
        }
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            logger.info("\u53d1\u9001http get\u8bf7\u6c42\u7ed3\u675f");
            logger.info("");
            return httpResponse;
        }
        catch (IOException e) {
            logger.error("Get\u8bf7\u6c42\u9519\u8bef {}", (Object)e.getMessage());
            return null;
        }
    }

    private static RequestConfig setTimeOutConfig(RequestConfig requestConfig) {
        if (requestConfig == null) {
            requestConfig = RequestConfig.DEFAULT;
        }
        return RequestConfig.copy((RequestConfig)requestConfig).setConnectionRequestTimeout(30000).setConnectTimeout(30000).setSocketTimeout(10000).build();
    }

    public static String buildUrl(String url, Map<String, String> queryMap) {
        StringBuffer sbUrl = new StringBuffer();
        if (!StringUtils.isBlank((CharSequence)url)) {
            sbUrl.append(url);
        }
        if (null != queryMap) {
            StringBuffer sbQuery = new StringBuffer();
            for (Map.Entry<String, String> query : queryMap.entrySet()) {
                if (0 < sbQuery.length()) {
                    sbQuery.append("&");
                }
                if (StringUtils.isBlank((CharSequence)query.getKey()) && !StringUtils.isBlank((CharSequence)query.getValue())) {
                    sbQuery.append(query.getValue());
                }
                if (StringUtils.isBlank((CharSequence)query.getKey())) continue;
                sbQuery.append(query.getKey());
                if (StringUtils.isBlank((CharSequence)query.getValue())) continue;
                sbQuery.append("=");
                try {
                    sbQuery.append(URLEncoder.encode(query.getValue(), "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            if (0 < sbQuery.length()) {
                sbUrl.append("?").append(sbQuery);
            }
        }
        return sbUrl.toString();
    }
}

