/*
 * Decompiled with CFR 0.152.
 */
package com.els.huayang.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.utils.excel.ExcelUtils;
import com.els.huayang.handler.ExcelModelConverterHandle;
import com.els.huayang.pojo.ExportExcel;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelDynamicExportUtils<T> {
    protected static Logger logger = LoggerFactory.getLogger(ExcelDynamicExportUtils.class);

    public void exportExcel(ExportExcel exportExcel, HttpServletResponse httpResponse, ExcelModelConverterHandle converterHandle, List<T> data, String tittle) {
        converterHandle.Handle();
        try {
            httpResponse.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode(tittle + ".xls", "UTF-8") + "\";");
            httpResponse.setHeader("Content-Disposition", header.toString());
            httpResponse.setCharacterEncoding("UTF-8");
            httpResponse.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = httpResponse.getOutputStream();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, exportExcel.getTitleAndModelKeys(), data, (String)tittle, null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faexcel\u5931\u8d25", (Throwable)e);
            throw new CommonException("\u5bfc\u51faexcel\u5931\u8d25");
        }
    }
}

