/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.contract.manage.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.contract.manage.emum.ContractStatus;
import com.els.base.contract.manage.entity.ContractManage;
import com.els.base.contract.manage.entity.ContractManageExample;
import com.els.base.contract.manage.service.ContractManageService;
import com.els.base.contract.template.entity.ContractTemplate;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="T_CONTRACT_MANAGE")
@Controller
@RequestMapping(value={"contractManage"})
public class ContractManageController {
    @Resource
    protected ContractManageService contractManageService;

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u6a21\u677f\u521b\u5efa")
    @RequestMapping(value={"service/createByTemplate"})
    @ResponseBody
    public ResponseResult<String> createByTemplate(@RequestBody ContractManage contractManage, @RequestBody ContractTemplate contractTemplate) {
        if (contractTemplate.getAuditStatus() != 3) {
            throw new CommonException("\u5fc5\u987b\u5ba1\u6838\u901a\u8fc7\u7684\u6a21\u677f\u624d\u80fd\u521b\u5efa");
        }
        contractManage.setIsEnable(1);
        contractManage.setCreateUserTime(new Date());
        User loginUser = SpringSecurityUtils.getLoginUser();
        String username = loginUser.getUsername();
        contractManage.setCreateUserName(username);
        contractManage.setIssend(0);
        contractManage.setContractStatus(ContractStatus.CREATE.getCode());
        contractManage.setTemplateNo(contractTemplate.getTemplateNo());
        contractManage.setTemplateType(contractTemplate.getTemplateType());
        contractManage.setTemplateVersion(contractTemplate.getVersion());
        this.contractManageService.addObj(contractManage);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaT_CONTRACT_MANAGE")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody ContractManage contractManage) {
        Assert.isNotBlank((String)contractManage.getTemplateNo(), (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)contractManage.getTemplateType(), (String)"\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)contractManage.getVersion(), (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a");
        contractManage.setIsEnable(1);
        contractManage.setCreateUserTime(new Date());
        User loginUser = SpringSecurityUtils.getLoginUser();
        String username = loginUser.getUsername();
        contractManage.setCreateUserName(username);
        contractManage.setIssend(0);
        contractManage.setContractStatus(ContractStatus.CREATE.getCode());
        this.contractManageService.addObj(contractManage);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91T_CONTRACT_MANAGE")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody ContractManage contractManage) {
        Assert.isNotBlank((String)contractManage.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        User loginUser = SpringSecurityUtils.getLoginUser();
        String username = loginUser.getUsername();
        contractManage.setUpdateUserName(username);
        contractManage.setUpdateUserTime(new Date());
        this.contractManageService.modifyObj(contractManage);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u903b\u8f91\u5220\u9664\u5408\u540c\u5355\u636e")
    @RequestMapping(value={"service/deleteByEnable"})
    @ResponseBody
    public ResponseResult<String> deleteByEnable(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55");
        this.contractManageService.modifyById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u903b\u8f91\u5220\u9664\u5408\u540c\u5355\u636e")
    @RequestMapping(value={"service/deleteByEnables"})
    @ResponseBody
    public ResponseResult<String> deleteByEnables(@RequestBody(required=true) List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String id : ids) {
            this.contractManageService.modifyById(id);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664T_CONTRACT_MANAGE")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.contractManageService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ContractManageExample example = new ContractManageExample();
        example.createCriteria().andIdIn((List)ids);
        List contractManages = this.contractManageService.queryAllObjByExample((IExample)example);
        contractManages.forEach(contractManage -> {
            if (contractManage.getContractStatus().compareTo(1) != 0) {
                throw new CommonException("\u53ea\u6709\u65b0\u5efa\u7684\u5355\u636e\u624d\u53ef\u4ee5\u5220\u9664");
            }
        });
        for (String id : ids) {
            this.contractManageService.deleteObjById(id);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2T_CONTRACT_MANAGE")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 ContractManage", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<ContractManage>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ContractManageExample example = new ContractManageExample();
        example.setPageView((PageView<ContractManage>)new PageView(pageNo, pageSize));
        ContractManageExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.contractManageService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u4e3b\u952eid\u67e5\u8be2\u8be6\u60c5\u5355\u4e2a")
    @RequestMapping(value={"service/queryById"})
    @ResponseBody
    public ResponseResult<ContractManage> queryTemplateById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u67e5\u8be2id\u4e0d\u80fd\u4e3a\u7a7a");
        ContractManage contractManage = (ContractManage)this.contractManageService.queryObjById(id);
        return ResponseResult.success((Object)contractManage);
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a\u4f20\u9644\u4ef6")
    @RequestMapping(value={"service/attachment"})
    @ResponseBody
    public ResponseResult<String> attachment(@RequestBody ContractManage contractManage) {
        if (StringUtils.isBlank((String)contractManage.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.contractManageService.addAttachment(contractManage);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5408\u540c\u4f5c\u5e9f")
    @RequestMapping(value={"service/discarded"})
    @ResponseBody
    public ResponseResult<String> Discarded(@RequestBody ContractManage contractManage) {
        if (StringUtils.isBlank((String)contractManage.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        ContractManageExample example = new ContractManageExample();
        example.createCriteria().andIdEqualTo(contractManage.getId());
        List contractManages = this.contractManageService.queryAllObjByExample((IExample)example);
        contractManages.forEach(contract -> {
            if (contract.getContractStatus() == 1 && contract.getContractStatus() == 9) {
                throw new CommonException("\u65b0\u5efa\u7684\u5355\u636e\u548c\u5df2\u7ecf\u4f5c\u5e9f\u7684\u5355\u636e\u4e0d\u80fd\u4f5c\u5e9f");
            }
        });
        contractManage.setContractStatus(ContractStatus.INVALID.getCode());
        contractManage.setIssend(1);
        this.contractManageService.modifyObj(contractManage);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u7ed9\u4f9b\u5e94\u5546\uff0c\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4")
    @RequestMapping(value={"service/supconfirm"})
    @ResponseBody
    public ResponseResult<String> ToSupConfirm(@RequestBody ContractManage contractManage) {
        if (StringUtils.isBlank((String)contractManage.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (contractManage.getContractStatus() != 1) {
            throw new CommonException("\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u624d\u53ef\u4ee5");
        }
        contractManage.setContractStatus(ContractStatus.TO_SUP_CONFIRME.getCode());
        contractManage.setIssend(1);
        this.contractManageService.modifyObj(contractManage);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u9001\u5ba1\u5408\u540c\u5355\u636e")
    @RequestMapping(value={"service/approve"})
    @ResponseBody
    public ResponseResult<String> approve(@RequestBody List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            throw new CommonException("\u9001\u5ba1\u5931\u8d25,ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.contractManageService.approve(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7b7e\u7f72\u5408\u540c")
    @RequestMapping(value={"service/sign"})
    @ResponseBody
    public ResponseResult<String> Sign(@RequestBody ContractManage contractManage) {
        if (StringUtils.isBlank((String)contractManage.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (contractManage.getContractStatus() != 6) {
            throw new CommonException("\u53ea\u6709\u5ba1\u6279\u901a\u8fc7\u624d\u80fd\u7b7e\u7f72\u5408\u540c");
        }
        contractManage.setContractStatus(ContractStatus.SIGN.getCode());
        this.contractManageService.modifyObj(contractManage);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5f52\u6863")
    @RequestMapping(value={"service/file"})
    @ResponseBody
    public ResponseResult<String> File(@RequestBody ContractManage contractManage) {
        if (StringUtils.isBlank((String)contractManage.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        contractManage.setContractStatus(ContractStatus.FILE.getCode());
        this.contractManageService.modifyObj(contractManage);
        return ResponseResult.success();
    }
}

