/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.contract.template.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.contract.manage.emum.ContractStatus;
import com.els.base.contract.template.emum.AuditStatus;
import com.els.base.contract.template.entity.ContractTemplate;
import com.els.base.contract.template.entity.ContractTemplateExample;
import com.els.base.contract.template.service.ContractTemplateService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5408\u540c\u6a21\u677f")
@Controller
@RequestMapping(value={"contractTemplate"})
public class ContractTemplateController {
    @Resource
    protected ContractTemplateService contractTemplateService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5408\u540c\u6a21\u677f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody ContractTemplate contractTemplate) {
        Assert.isNotBlank((String)contractTemplate.getTemplateNo(), (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)contractTemplate.getTemplateType(), (String)"\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)contractTemplate.getVersion(), (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a");
        contractTemplate.setIsEnable(1);
        contractTemplate.setCreateTime(new Date());
        contractTemplate.setAuditStatus(AuditStatus.UNAUDITED.getCode());
        this.contractTemplateService.addObj(contractTemplate);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5408\u540c\u6a21\u677f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody ContractTemplate contractTemplate) {
        Assert.isNotBlank((String)contractTemplate.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        User loginUser = SpringSecurityUtils.getLoginUser();
        String username = loginUser.getUsername();
        contractTemplate.setUpdateUserName(username);
        contractTemplate.setUpdateUserTime(new Date());
        this.contractTemplateService.modifyObj(contractTemplate);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u903b\u8f91\u5220\u9664\u5408\u540c\u6a21\u677f")
    @RequestMapping(value={"service/deleteByEnable"})
    @ResponseBody
    public ResponseResult<String> deleteByEnable(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55");
        this.contractTemplateService.modifyById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u903b\u8f91\u5220\u9664\u5408\u540c\u6a21\u677f")
    @RequestMapping(value={"service/deleteByEnables"})
    @ResponseBody
    public ResponseResult<String> deleteByEnables(@RequestBody(required=true) List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String id : ids) {
            this.contractTemplateService.modifyById(id);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5408\u540c\u6a21\u677f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.contractTemplateService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String id : ids) {
            this.contractTemplateService.deleteObjById(id);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5408\u540c\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 ContractTemplate", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<ContractTemplate>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ContractTemplateExample example = new ContractTemplateExample();
        example.setPageView((PageView<ContractTemplate>)new PageView(pageNo, pageSize));
        ContractTemplateExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.contractTemplateService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5ba1\u6838\u901a\u8fc7\u7684\u5408\u540c\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 ContractTemplate", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPass"})
    @ResponseBody
    public ResponseResult<PageView<ContractTemplate>> findByP(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ContractTemplateExample example = new ContractTemplateExample();
        example.setPageView((PageView<ContractTemplate>)new PageView(pageNo, pageSize));
        ContractTemplateExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andAuditStatusEqualTo(3);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" UPDATE_USER_TIME DESC");
        PageView pageData = this.contractTemplateService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u4e3b\u952eid\u67e5\u8be2\u8be6\u60c5\u5355\u4e2a")
    @RequestMapping(value={"service/queryById"})
    @ResponseBody
    public ResponseResult<ContractTemplate> queryTemplateById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u67e5\u8be2id\u4e0d\u80fd\u4e3a\u7a7a");
        ContractTemplate contractTemplate = (ContractTemplate)this.contractTemplateService.queryObjById(id);
        return ResponseResult.success((Object)contractTemplate);
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a\u4f20\u9644\u4ef6")
    @RequestMapping(value={"service/attachment"})
    @ResponseBody
    public ResponseResult<String> attachment(@RequestBody ContractTemplate contractTemplate) {
        if (StringUtils.isBlank((String)contractTemplate.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.contractTemplateService.addAttachment(contractTemplate);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u9001\u5ba1\u6a21\u677f")
    @RequestMapping(value={"service/approve"})
    @ResponseBody
    public ResponseResult<String> approve(@RequestBody List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            throw new CommonException("\u9001\u5ba1\u5931\u8d25,ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.contractTemplateService.approve(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5408\u540c\u4f5c\u5e9f")
    @RequestMapping(value={"service/discarded"})
    @ResponseBody
    public ResponseResult<String> Discarded(@RequestBody ContractTemplate contractTemplate) {
        if (StringUtils.isBlank((String)contractTemplate.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        ContractTemplateExample example = new ContractTemplateExample();
        example.createCriteria().andIdEqualTo(contractTemplate.getId());
        List contractTemplates = this.contractTemplateService.queryAllObjByExample((IExample)example);
        contractTemplates.forEach(templates -> {
            if (templates.getAuditStatus() == 1 && templates.getAuditStatus() == 9) {
                throw new CommonException("\u672a\u5ba1\u6838\u7684\u5408\u540c\u6a21\u677f\u4e0d\u80fd\u4f5c\u5e9f\uff01");
            }
        });
        contractTemplate.setAuditStatus(ContractStatus.INVALID.getCode());
        this.contractTemplateService.modifyObj(contractTemplate);
        return ResponseResult.success();
    }
}

