/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.material.dao.MaterialPropKeyGroupMapper;
import com.els.base.material.entity.MaterialPropKey;
import com.els.base.material.entity.MaterialPropKeyExample;
import com.els.base.material.entity.MaterialPropKeyGroup;
import com.els.base.material.entity.MaterialPropKeyGroupExample;
import com.els.base.material.service.MaterialPropKeyGroupService;
import com.els.base.material.service.MaterialPropKeyService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialPropKeyGroupService")
public class MaterialPropKeyGroupServiceImpl
implements MaterialPropKeyGroupService {
    @Resource
    protected MaterialPropKeyGroupMapper materialPropKeyGroupMapper;
    @Resource
    protected MaterialPropKeyService materialPropKeyService;

    @CacheEvict(value={"materialPropKeyGroup"}, allEntries=true)
    @Transactional
    public void addObj(MaterialPropKeyGroup t) {
        if (StringUtils.isBlank((String)t.getGroupCode())) {
            throw new CommonException("\u7269\u6599\u5c5e\u6027\u7ec4\u7f16\u7801\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58", "isNull", new Object[]{"\u7269\u6599\u5c5e\u6027\u7ec4\u7f16\u7801"});
        }
        if (StringUtils.isBlank((String)t.getGroupName())) {
            throw new CommonException("\u7269\u6599\u5c5e\u6027\u7ec4\u540d\u79f0\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58", "isNull", new Object[]{"\u7269\u6599\u5c5e\u6027\u7ec4\u540d\u79f0"});
        }
        if (t.getGroupCode().length() > 255) {
            throw new CommonException("\u7269\u6599\u5c5e\u6027\u7ec4\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u7269\u6599\u5c5e\u6027\u7ec4\u7f16\u7801", 255});
        }
        if (t.getGroupName().length() > 255) {
            throw new CommonException("\u7269\u6599\u5c5e\u6027\u7ec4\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u7269\u6599\u5c5e\u6027\u7ec4\u540d\u79f0", 255});
        }
        MaterialPropKeyGroupExample materialPropKeyGroupExample = new MaterialPropKeyGroupExample();
        MaterialPropKeyGroupExample.Criteria criteria = materialPropKeyGroupExample.createCriteria();
        criteria.andGroupCodeEqualTo(t.getGroupCode());
        criteria.andProjectIdEqualTo(t.getProjectId());
        criteria.andCompanyIdEqualTo(t.getCompanyId());
        int materialPropKeyGroupCount = this.materialPropKeyGroupMapper.countByExample(materialPropKeyGroupExample);
        if (materialPropKeyGroupCount > 0) {
            throw new CommonException("\u7269\u6599\u5c5e\u6027\u7ec4GroupCode\u503c '" + t.getGroupCode() + " '\u91cd\u590d\uff0c\u65e0\u6cd5\u4fdd\u5b58", "base_is_exists", new Object[]{"\u7269\u6599\u5c5e\u6027\u7ec4GroupCode\u503c"});
        }
        this.materialPropKeyGroupMapper.insertSelective(t);
        List<MaterialPropKey> materialPropKeyList = t.getMaterialPropKeyList();
        if (CollectionUtils.isNotEmpty(materialPropKeyList)) {
            for (MaterialPropKey materialPropKey : materialPropKeyList) {
                if (StringUtils.isBlank((String)materialPropKey.getPropCode())) {
                    throw new CommonException("\u7269\u6599\u5c5e\u6027key\u7684PropCode\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58", "base_canot_be_null", new Object[]{"\u7269\u6599\u5c5e\u6027key\u7684PropCode\u503c"});
                }
                MaterialPropKeyExample materialPropKeyExample = new MaterialPropKeyExample();
                MaterialPropKeyExample.Criteria materialPropKeyExampleCriteria = materialPropKeyExample.createCriteria();
                materialPropKeyExampleCriteria.andProjectIdEqualTo(t.getProjectId());
                materialPropKeyExampleCriteria.andCompanyIdEqualTo(t.getCompanyId());
                materialPropKeyExampleCriteria.andPropCodeEqualTo(materialPropKey.getPropCode());
                List oldMaterialPropKeyList = this.materialPropKeyService.queryAllObjByExample((IExample)materialPropKeyExample);
                if (CollectionUtils.isNotEmpty((Collection)oldMaterialPropKeyList)) {
                    throw new CommonException("\u7269\u6599\u5c5e\u6027key\u7684PropCode\u503c '" + materialPropKey.getPropCode() + "' \u91cd\u590d\uff0c\u65e0\u6cd5\u4fdd\u5b58", "base_is_exists", new Object[]{"\u7269\u6599\u5c5e\u6027key\u7684PropCode\u503c"});
                }
                materialPropKey.setPropKeyGroupId(t.getId());
                materialPropKey.setProjectId(t.getProjectId());
                materialPropKey.setCompanyId(t.getCompanyId());
                materialPropKey.setMaterialCategoryId(t.getMaterialCategoryId());
                this.materialPropKeyService.addObj(materialPropKey);
            }
        }
    }

    @CacheEvict(value={"materialPropKeyGroup"}, allEntries=true)
    public void deleteObjById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.materialPropKeyGroupMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialPropKeyGroup"}, allEntries=true)
    @Transactional
    public void modifyObj(MaterialPropKeyGroup t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        if (StringUtils.isBlank((String)t.getGroupCode())) {
            throw new CommonException("\u7269\u6599\u5c5e\u6027\u7ec4\u7f16\u7801\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58", "isNull", new Object[]{"\u7269\u6599\u5c5e\u6027\u7ec4\u7f16\u7801"});
        }
        if (StringUtils.isBlank((String)t.getGroupName())) {
            throw new CommonException("\u7269\u6599\u5c5e\u6027\u7ec4\u540d\u79f0\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58", "isNull", new Object[]{"\u7269\u6599\u5c5e\u6027\u7ec4\u540d\u79f0"});
        }
        if (t.getGroupCode().length() > 255) {
            throw new CommonException("\u7269\u6599\u5c5e\u6027\u7ec4\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u7269\u6599\u5c5e\u6027\u7ec4\u7f16\u7801", 255});
        }
        if (t.getGroupName().length() > 255) {
            throw new CommonException("\u7269\u6599\u5c5e\u6027\u7ec4\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u7269\u6599\u5c5e\u6027\u7ec4\u540d\u79f0", 255});
        }
        MaterialPropKeyGroup materialPropKeyGroup = this.materialPropKeyGroupMapper.selectByPrimaryKey(t.getId());
        if (materialPropKeyGroup == null) {
            throw new CommonException("\u8be5\u5206\u7ec4:" + t.getId() + "\u4e0d\u5b58\u5728\uff0c\u4fee\u6539\u5931\u8d25", "do_not_exists", new Object[]{"\u8be5\u5206\u7ec4"});
        }
        if (materialPropKeyGroup.getGroupCode().equals(t.getGroupCode())) {
            materialPropKeyGroup.setGroupName(t.getGroupName());
            this.materialPropKeyGroupMapper.updateByPrimaryKey(materialPropKeyGroup);
        } else {
            MaterialPropKeyGroupExample materialPropKeyGroupExample = new MaterialPropKeyGroupExample();
            MaterialPropKeyGroupExample.Criteria criteria = materialPropKeyGroupExample.createCriteria();
            criteria.andGroupCodeEqualTo(t.getGroupCode());
            criteria.andProjectIdEqualTo(t.getProjectId());
            criteria.andCompanyIdEqualTo(t.getCompanyId());
            int materialPropKeyGroupCount = this.materialPropKeyGroupMapper.countByExample(materialPropKeyGroupExample);
            if (materialPropKeyGroupCount > 0) {
                throw new CommonException("\u7269\u6599\u5c5e\u6027\u7ec4" + t.getGroupCode() + "\u503c\u91cd\u590d\uff0c\u65e0\u6cd5\u4fdd\u5b58", "base_is_exists");
            }
            t.setProjectId(t.getProjectId());
            t.setCompanyId(t.getCompanyId());
            this.materialPropKeyGroupMapper.updateByPrimaryKey(t);
        }
        MaterialPropKeyExample materialPropKeyExample = new MaterialPropKeyExample();
        MaterialPropKeyExample.Criteria materialPropKeyExampleCriteria = materialPropKeyExample.createCriteria();
        materialPropKeyExampleCriteria.andProjectIdEqualTo(t.getProjectId());
        materialPropKeyExampleCriteria.andCompanyIdEqualTo(t.getCompanyId());
        materialPropKeyExampleCriteria.andPropKeyGroupIdEqualTo(t.getId());
        materialPropKeyExampleCriteria.andMaterialCategoryIdEqualTo(t.getMaterialCategoryId());
        this.materialPropKeyService.deleteByExample(materialPropKeyExample);
        List<MaterialPropKey> newMaterialPropKeyList = t.getMaterialPropKeyList();
        if (CollectionUtils.isNotEmpty(newMaterialPropKeyList)) {
            for (MaterialPropKey materialPropKey : newMaterialPropKeyList) {
                materialPropKey.setProjectId(t.getProjectId());
                materialPropKey.setCompanyId(t.getCompanyId());
                materialPropKey.setMaterialCategoryId(t.getMaterialCategoryId());
                materialPropKey.setPropKeyGroupId(t.getId());
                this.materialPropKeyService.addObj(materialPropKey);
            }
        }
    }

    @Cacheable(value={"materialPropKeyGroup"}, keyGenerator="redisKeyGenerator")
    public MaterialPropKeyGroup queryObjById(String id) {
        return this.materialPropKeyGroupMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialPropKeyGroup"}, keyGenerator="redisKeyGenerator")
    public List<MaterialPropKeyGroup> queryAllObjByExample(MaterialPropKeyGroupExample example) {
        return this.materialPropKeyGroupMapper.selectByExample(example);
    }

    @Cacheable(value={"materialPropKeyGroup"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialPropKeyGroup> queryObjByPage(MaterialPropKeyGroupExample example) {
        PageView<MaterialPropKeyGroup> pageView = example.getPageView();
        pageView.setQueryResult(this.materialPropKeyGroupMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"materialPropKeyGroup"}, allEntries=true)
    public void deleteByExample(MaterialPropKeyGroupExample example) {
        Assert.isNotNull((Object)((Object)example), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialPropKeyGroupMapper.deleteByExample(example);
    }

    @CacheEvict(value={"materialPropKeyGroup"}, allEntries=true)
    @Transactional
    public void addAll(List<MaterialPropKeyGroup> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.materialPropKeyGroupMapper.insertSelective((MaterialPropKeyGroup)record));
    }
}

