/*
 * Decompiled with CFR 0.152.
 */
package com.els.sinolifesdk.service.impl;

import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.service.WorkFlowService;
import com.els.sinolifesdk.service.SinoLifeApiService;
import com.els.sinolifesdk.service.SinoLifeEsbService;
import com.sinolife.sf.platform.runtime.PlatformContext;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SinoLifeApiServiceImpl
implements SinoLifeApiService {
    @Value(value="${sinolife.esb.api.enable:false}")
    private boolean esbApiEnabled;
    @Resource
    private WorkFlowService workFlowService;
    private static Logger logger = LoggerFactory.getLogger(SinoLifeApiServiceImpl.class);

    @Override
    public Map<String, Object> CreateExpensesApply(Map<String, Object> paramMap) {
        logger.info("SinoLifeApiService.CreateExpensesApply ==> {}", paramMap);
        Map<String, Object> result = null;
        if (!this.esbApiEnabled) {
            String applyId = (String)paramMap.get("seq");
            String applyNo = (String)paramMap.get("applyNo");
            ProcessStartVO vo = ProcessStartVO.newInstance((String)"purchase_requisition", (String)applyNo, (String)applyId, (String)("/stockRequireManage/stockRequireJoint?id=" + applyId));
            vo.setListenerClass((Class)paramMap.get("listenerClass"));
            this.workFlowService.startProcess(vo);
            result = this.getGenericResult(true);
            result.put("expensesApplyNo", DateFormatUtils.format((Date)new Date(), (String)"'TSRS'yyyyMMddHHmmss"));
            result.put("applyBepVoucherNo", DateFormatUtils.format((Date)new Date(), (String)"'TSRN'yyyyMMddHHmmss"));
            result.put("applyType", "TSRT");
            if ("Y".equals(paramMap.get("isLendInExpenses"))) {
                result.put("lendApplyNo", DateFormatUtils.format((Date)new Date(), (String)"'TSLS'yyyyMMddHHmmss"));
                result.put("lendBepVoucherNo", DateFormatUtils.format((Date)new Date(), (String)"'TSLN'yyyyMMddHHmmss"));
                result.put("lendType", "TSLT");
            }
            return result;
        }
        result = this.getSinoLifeEsbService().CreateExpensesApply(paramMap);
        logger.info("SinoLifeApiService.CreateExpensesApply <== {}", result);
        return result;
    }

    @Override
    public Map<String, Object> CreateLendApply(Map<String, Object> paramMap) {
        Map<Object, Object> returnMap = new HashMap<String, String>();
        if (this.esbApiEnabled) {
            try {
                logger.info(".....\u8f93\u5165......." + paramMap.toString());
                returnMap = PlatformContext.getEsbContext().getEsbService(SinoLifeEsbService.class).CreateLendApply(paramMap);
                logger.info(".....\u8f93\u51fa...resultMap=" + returnMap);
                return returnMap;
            }
            catch (Exception e) {
                logger.error("\u8bf7\u6c42\u5931\u8d25" + e.getCause());
                returnMap.put("flag", "N");
                returnMap.put("message", e.getCause());
                return returnMap;
            }
        }
        returnMap.put("expensesApplyNo", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        returnMap.put("applyBepVoucherNo", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        returnMap.put("applyType", "\u7533\u8bf7\u5355\u7c7b\u578b" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        returnMap.put("lendApplyNo", "lendApplyNo=" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        returnMap.put("lendBepVoucherNo", "\u501f\u6b3e\u5355\u7f16\u53f7lendBepVoucherNo=" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        returnMap.put("lendType", "\u501f\u6b3e\u5355\u7c7b\u578b");
        returnMap.put("flag", "Y");
        returnMap.put("message", "\u6210\u529f");
        return returnMap;
    }

    @Override
    public Map<String, Object> CreatereimburseApply(Map<String, Object> paramMap) {
        if (this.esbApiEnabled) {
            return null;
        }
        return null;
    }

    @Override
    public Map<String, Object> payeeApprove(Map<String, Object> paramMap) {
        logger.info("SinoLifeApiService.payeeApprove ==> {}", paramMap);
        Map<String, Object> result = null;
        if (this.esbApiEnabled) {
            result = this.getSinoLifeEsbService().payeeApprove(paramMap);
        } else {
            String companyCode = (String)paramMap.get("companyCode");
            String companyId = (String)paramMap.get("companyId");
            ProcessStartVO process = ProcessStartVO.newInstance((String)"supplier_data", (String)companyCode, (String)companyId, (String)("/supManagement/supplierCompany?companyCode=" + companyCode));
            process.setListenerClass((Class)paramMap.get("listenerClass"));
            this.workFlowService.startProcess(process);
            result = this.getGenericResult(true);
            result.put("applyNo", DateFormatUtils.format((Date)new Date(), (String)"'TSAS'yyyyMMddHHmmss"));
            result.put("bepVoucherNo", DateFormatUtils.format((Date)new Date(), (String)"'TSAN'yyyyMMddHHmmss"));
            result.put("billType", "TSBT");
        }
        logger.info("SinoLifeApiService.payeeApprove <== {}", result);
        return result;
    }

    @Override
    public boolean bepBudgetCheck(List<Map<String, Object>> list) {
        return this.esbApiEnabled ? this.getSinoLifeEsbService().bepBudgetCheck(list) : true;
    }

    @Override
    public Map<String, String> createFlow(String tid, String templateVersion, String createUser, String title, String content, Map<String, String> attachements, Map<String, String> otherParam) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (this.esbApiEnabled) {
            try {
                returnMap = PlatformContext.getEsbContext().getEsbService(SinoLifeEsbService.class).createFlow(tid, templateVersion, createUser, title, content, attachements, otherParam);
                logger.info(".....\u62db\u6807\u5b9a\u6807\u7ed3\u679c\u53d1\u9001OA\u5ba1\u6279\u8c03\u7528\u63a5\u53e3\u540e\u8f93\u51fa...resultMap=" + returnMap);
                return returnMap;
            }
            catch (Exception e) {
                logger.error("\u62db\u6807\u5b9a\u6807\u5ba1\u6279\u53d1\u9001OA\u8bf7\u6c42\u5931\u8d25" + e.getCause());
                return returnMap;
            }
        }
        returnMap.put("flag", "Y");
        returnMap.put("message", "\u6210\u529f");
        returnMap.put("flowId", "11111111111111111");
        return returnMap;
    }

    @Override
    public Map<String, Object> getLendWriteOffInfoList(Map<String, Object> paramMap) {
        if (this.esbApiEnabled) {
            return null;
        }
        return null;
    }

    @Override
    public Map<String, Object> transactionInitiation(Map<String, Object> paramMap) {
        if (this.esbApiEnabled) {
            return null;
        }
        return null;
    }

    @Override
    public Map<String, Object> expensesApplyClose(Map<String, Object> paramMap) {
        logger.info("SinoLifeApiService.expensesApplyClose ==> {}", paramMap);
        Map<String, Object> result = null;
        result = this.esbApiEnabled ? this.getSinoLifeEsbService().expensesApplyClose(paramMap) : this.getGenericResult(true);
        logger.info("SinoLifeApiService.expensesApplyClose <== {}", result);
        return result;
    }

    @Override
    public Map<String, Object> payeeInfoEdit(Map<String, Object> paramMap) {
        logger.info("SinoLifeApiService.payeeInfoEdit ==> {}", paramMap);
        Map<String, Object> result = null;
        result = this.esbApiEnabled ? this.getSinoLifeEsbService().payeeInfoEdit(paramMap) : this.getGenericResult(true);
        logger.info("SinoLifeApiService.payeeInfoEdit <== {}", result);
        return result;
    }

    @Override
    public Map<String, Object> GetInvoiceByUmId(Map<String, Object> paramMap) {
        if (this.esbApiEnabled) {
            return null;
        }
        return null;
    }

    @Override
    public String toPartnerEsbHandle(Map<String, Object> paramMap) {
        if (this.esbApiEnabled) {
            return null;
        }
        return null;
    }

    @Override
    public Map<String, Object> executeForPcp(String mode, Map<String, Object> paramMap) {
        Map<Object, Object> returnMap = new HashMap();
        if (this.esbApiEnabled) {
            try {
                logger.info("payeeApprove.....\u8f93\u5165......." + paramMap.toString());
                returnMap = PlatformContext.getEsbContext().getEsbService(SinoLifeEsbService.class).executeForPcp("getEconomicIssuesSet", paramMap);
                logger.info("payeeApprove.....\u8f93\u51fa...resultMap=" + returnMap);
                return paramMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> createTwoDimensionCommon(Map<String, String> param) {
        if (this.esbApiEnabled) {
            return null;
        }
        return null;
    }

    @Override
    public Map<String, String> postWeiXinMessageToUser(Map<String, String> templateValue, String url, String wxUserId, String templateCode) {
        if (this.esbApiEnabled) {
            return null;
        }
        return null;
    }

    private <T> T getEsbService(Class<T> serviceClass) {
        return PlatformContext.getEsbContext().getEsbService(serviceClass);
    }

    private SinoLifeEsbService getSinoLifeEsbService() {
        return this.getEsbService(SinoLifeEsbService.class);
    }

    private Map<String, Object> getGenericResult(boolean success) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("flag", success ? "Y" : "N");
        result.put("message", success ? "\u64cd\u4f5c\u6210\u529f" : "\u64cd\u4f5c\u5931\u8d25");
        return result;
    }
}

