/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.rpc.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONArray;
import com.els.common.context.TokenContext;
import com.els.common.util.SpringContextUtils;
import com.els.modules.account.rpc.service.ImAccountInvokeSupplierRpcService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ImImAccountInvokeSupplierBeanServiceImpl
implements ImAccountInvokeSupplierRpcService {
    private static final Logger log = LoggerFactory.getLogger(ImImAccountInvokeSupplierBeanServiceImpl.class);
    @Autowired
    private RestTemplate imRestTemplate;
    @Value(value="${els.config.service.address}")
    private String serverName;
    private String getToElsAccountPath = "/tioRecordData/getToElsAccount";
    private String getElsAccountPath = "/tioRecordData/getElsAccount";

    public HttpEntity<String> buildHeadEntity(HttpHeaders headers) {
        String token;
        if (null == headers) {
            headers = new HttpHeaders();
        }
        if (null == (token = TokenContext.getToken())) {
            token = SpringContextUtils.getHttpServletRequest().getHeader("X-Access-Token");
        }
        headers.add("X-Access-Token", token);
        return new HttpEntity((MultiValueMap)headers);
    }

    public List<String> getSupplierElsAccount(String name) {
        if (CharSequenceUtil.isEmpty((CharSequence)this.serverName) || CharSequenceUtil.isEmpty((CharSequence)this.getElsAccountPath)) {
            log.error("::: \u672a\u914d\u7f6eIm\u8bf7\u6c42SRM\u83b7\u53d6SupplierElsAccount\u6570\u636e\u7684\u63a5\u53e3\u5730\u5740 =>{}", (Object)"ImImAccountInvokeSupplierBeanServiceImpl#getSupplierElsAccount");
            return Lists.newArrayList();
        }
        HttpHeaders headers = new HttpHeaders();
        ArrayList<MediaType> mediaTypeList = new ArrayList<MediaType>();
        mediaTypeList.add(MediaType.APPLICATION_JSON_UTF8);
        headers.setAccept(mediaTypeList);
        HttpEntity<String> entity = this.buildHeadEntity(headers);
        try {
            ResponseEntity resultResponseEntity = this.imRestTemplate.postForEntity(this.serverName + this.getElsAccountPath + "?name=" + name, entity, String.class, new Object[0]);
            String body = (String)resultResponseEntity.getBody();
            return JSONArray.parseArray((String)body, String.class);
        }
        catch (Exception e) {
            log.error("Http \u8bf7\u6c42SRM\u83b7\u53d6SupplierElsAccount\u6570\u636e\u7684\u5f02\u5e38==>{}", (Object)e.getMessage());
            return Lists.newArrayList();
        }
    }

    public List<String> getSupplierToElsAccount(String name) {
        if (CharSequenceUtil.isEmpty((CharSequence)this.serverName) || CharSequenceUtil.isEmpty((CharSequence)this.getToElsAccountPath)) {
            log.error("::: \u672a\u914d\u7f6eIm\u8bf7\u6c42SRM\u83b7\u53d6SupplierToElsAccount\u6570\u636e\u7684\u63a5\u53e3\u5730\u5740 =>{}", (Object)"ImImAccountInvokeSupplierBeanServiceImpl#getSupplierElsAccount");
            return Lists.newArrayList();
        }
        HttpHeaders headers = new HttpHeaders();
        ArrayList<MediaType> mediaTypeList = new ArrayList<MediaType>();
        mediaTypeList.add(MediaType.APPLICATION_JSON_UTF8);
        headers.setAccept(mediaTypeList);
        HttpEntity<String> entity = this.buildHeadEntity(headers);
        try {
            ResponseEntity resultResponseEntity = this.imRestTemplate.postForEntity(this.serverName + this.getToElsAccountPath + "?name=" + name, entity, String.class, new Object[0]);
            String body = (String)resultResponseEntity.getBody();
            return JSONArray.parseArray((String)body, String.class);
        }
        catch (Exception e) {
            log.error("Http \u8bf7\u6c42SRM\u83b7\u53d6SupplierToElsAccount\u6570\u636e\u7684\u5f02\u5e38==>{}", (Object)e.getMessage());
            return Lists.newArrayList();
        }
    }
}

