/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.xc;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.api.dto.BaseDTO;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.ConvertUtils;
import com.els.common.util.PasswordUtil;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.third.base.enums.ThirdTypeEnum;
import com.els.modules.third.base.util.ThirdUtil;
import com.els.modules.third.jdyxc.service.XcSysBusinessManager;
import com.els.modules.third.jdyxc.util.XcApiUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetElsSubAccountFromXcDbImpl
extends XcSysBusinessManager
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetElsSubAccountFromXcDbImpl.class);
    private static final String MEMBER_LIST = "/jdy/v2/bd/emp";
    private static final String MEMBER_DETAIL = "/jdy/v2/bd/emp_detail";
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private PurchaseOrganizationInfoRpcService purchaseOrganizationInfoService;

    public JSONObject before(JSONObject obj, Object custom) {
        return this.getSendJSON(obj, custom, MEMBER_LIST);
    }

    public JSONObject after(JSONObject obj, JSONObject paramObj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        String elsAccount = customObj.getString("bus_account");
        log.info("GetElsSubAccountFromXcDbImpl -> result \u3010{}\u3011", (Object)JSON.toJSONString((Object)obj));
        List resultData = JSON.parseArray((String)JSONArray.toJSONString((Object)this.handlerHeadResultListInfoV2(obj), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), Map.class);
        if (CollUtil.isEmpty((Collection)resultData)) {
            obj.put("message", (Object)"\u6682\u65e0\u4eba\u5458\u6570\u636e\u9700\u8981\u540c\u6b65");
            return obj;
        }
        Map returnMap = resultData.stream().collect(Collectors.toMap(o -> o.get("id").toString(), Function.identity()));
        Set<String> sourceIds = returnMap.keySet();
        JSONArray jsonArray = new JSONArray();
        for (String sourceId : sourceIds) {
            JSONObject jsonObject = XcApiUtil.findInterfaceById((String)elsAccount, (String)"getAccountDetail", (String)sourceId, (String)MEMBER_DETAIL);
            jsonObject.putAll((Map)returnMap.get(sourceId));
            jsonArray.add((Object)jsonObject);
        }
        List datas = JSON.parseArray((String)jsonArray.toJSONString(), Map.class);
        datas = ThirdUtil.getFieldMapping((List)datas, (String)elsAccount, (String)"getAccount", null);
        List subAccountList = this.elsSubAccountService.list((Wrapper)new LambdaQueryWrapper().eq(ElsSubAccount::getElsAccount, (Object)elsAccount));
        List dbList = subAccountList.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getSourceId())).collect(Collectors.toList());
        Map<String, String> dbMap = dbList.stream().collect(Collectors.toMap(ElsSubAccount::getSourceId, BaseEntity::getId));
        List purchaseOrganizationInfoDTOS = this.purchaseOrganizationInfoService.listByCateCode(elsAccount, "dept");
        Map<String, String> orgMap = purchaseOrganizationInfoDTOS.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getSourceId())).collect(Collectors.toMap(PurchaseOrganizationInfoDTO::getSourceId, BaseDTO::getId));
        ArrayList<ElsSubAccount> insertList = new ArrayList<ElsSubAccount>();
        ArrayList<ElsSubAccount> updateList = new ArrayList<ElsSubAccount>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (Map data : datas) {
            String orgId;
            ElsSubAccount subAccount = (ElsSubAccount)JSON.parseObject((String)JSON.toJSONString((Object)data), ElsSubAccount.class);
            if (StringUtils.isNotBlank((CharSequence)subAccount.getOrgCode()) && StringUtils.isNotBlank((CharSequence)(orgId = orgMap.get(subAccount.getOrgCode())))) {
                subAccount.setOrgCode(orgId);
            }
            if (subAccount.getSex() == 0) {
                subAccount.setSex(Integer.valueOf(2));
            }
            if (subAccount.getStatus() == 0) {
                subAccount.setStatus(Integer.valueOf(2));
            }
            try {
                if (subAccount.getBirthday() != null) {
                    subAccount.setBirthday(sdf.parse(sdf.format(subAccount.getBirthday())));
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (dbMap.containsKey(subAccount.getSourceId())) {
                subAccount.setId(dbMap.get(subAccount.getSourceId()));
                subAccount.setSubAccount(null);
                updateList.add(subAccount);
                continue;
            }
            subAccount.setElsAccount(elsAccount);
            subAccount.setSourceType("erp");
            subAccount.setSourceSystem(ThirdTypeEnum.THIRD_JD_XC.getValue());
            subAccount.setDeleted(Integer.valueOf(0));
            String salt = ConvertUtils.randomGen((int)8);
            String passwordEncode = PasswordUtil.encrypt((String)(elsAccount + "_" + subAccount.getSubAccount()), (String)"123456", (String)salt);
            subAccount.setPassword(passwordEncode);
            subAccount.setSalt(salt);
            insertList.add(subAccount);
        }
        if (!CollUtil.isEmpty(insertList)) {
            this.elsSubAccountService.saveBatch(insertList, 200);
        }
        if (!CollUtil.isEmpty(updateList)) {
            this.elsSubAccountService.updateBatchById(updateList, 200);
        }
        this.getPageInfo(obj, custom);
        return obj;
    }
}

