/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.qip.service.impl;

import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.qip.dto.QipOrderDTO;
import com.els.modules.qip.entity.QipOrderHead;
import com.els.modules.qip.entity.QipOrderItem;
import com.els.modules.qip.mapper.QipOrderHeadMapper;
import com.els.modules.qip.mapper.QipOrderItemMapper;
import com.els.modules.qip.service.CallQipService;
import com.els.modules.qip.service.QipOrderHeadService;
import com.els.modules.qip.vo.QipOrderHeadVO;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QipOrderHeadServiceImpl
extends BaseServiceImpl<QipOrderHeadMapper, QipOrderHead>
implements QipOrderHeadService {
    @Autowired
    private QipOrderHeadMapper qipOrderHeadMapper;
    @Autowired
    private QipOrderItemMapper qipOrderItemMapper;
    @Resource
    private CallQipService callQipService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(QipOrderHeadVO qipOrderHeadPage) {
        QipOrderDTO dto = new QipOrderDTO();
        BeanUtils.copyProperties((Object)((Object)qipOrderHeadPage), (Object)dto);
        Result<?> response = this.callQipService.createOrder(dto);
        if (!response.isSuccess()) {
            throw new ELSBootException("\u4e0b\u5355\u5931\u8d25\uff1a" + response.getMessage());
        }
        QipOrderDTO orderDTO = (QipOrderDTO)response.getResult();
        QipOrderHead head = new QipOrderHead();
        BeanUtils.copyProperties((Object)orderDTO, (Object)((Object)head));
        this.qipOrderHeadMapper.insert((Object)head);
        this.insertData(head, qipOrderHeadPage.getQipOrderItemList());
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(QipOrderHead qipOrderHead, List<QipOrderItem> qipOrderItemList) {
        this.qipOrderHeadMapper.updateById((Object)qipOrderHead);
        this.qipOrderItemMapper.deleteByMainId(qipOrderHead.getId());
        this.insertData(qipOrderHead, qipOrderItemList);
    }

    private void insertData(QipOrderHead qipOrderHead, List<QipOrderItem> qipOrderItemList) {
        for (QipOrderItem entity : qipOrderItemList) {
            entity.setHeadId(qipOrderHead.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)qipOrderHead);
        }
        if (!qipOrderItemList.isEmpty()) {
            this.qipOrderItemMapper.insertBatchSomeColumn(qipOrderItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.qipOrderItemMapper.deleteByMainId(id);
        this.qipOrderHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.qipOrderItemMapper.deleteByMainId(serializable.toString());
            this.qipOrderHeadMapper.deleteById(serializable);
        }
    }
}

