/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MobilePatternUtil {
    private static final String CHINA_MOBILE_PATTERN = "(?:^(?:\\+86)?1(?:34[0-8]|3[5-9]|4[78]|5[0-27-9]|7[28]|8[2-478]|9[578])\\d{8}$)|(?:^(?:\\+86)?1440\\d{7}$)|(?:^(?:\\+86)?170[356]\\d{7}$)";
    private static final String CHINA_UNICOM_PATTERN = "(?:^(?:\\+86)?1(?:3[0-2]|4[056]|5[56]|66|7[156]|8[56]|96)\\d{8}$)|(?:^(?:\\+86)?170[47-9]\\d{7}$)";
    private static final String CHINA_TELECOM_PATTERN = "(?:^(?:\\+86)?1(?:33|49|53|7[37]|8[019]|9[0139])\\d{8}$)|(?:^(?:\\+86)?1349\\d{7}$)|(?:^(?:\\+86)?1410\\d{7}$)|(?:^(?:\\+86)?170[0-2]\\d{7}$)";
    private static final String CHINA_PATTERN = "(?:^(?:\\+86)?1(?:3[0-9]|4[01456879]|5[0-35-9]|6[2567]|7[0-8]|8[0-9]|9[0-35-9])\\d{8}$)";

    public static boolean checkChinaMobile(String mobile) {
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            Pattern regexp = Pattern.compile(CHINA_MOBILE_PATTERN);
            return regexp.matcher(mobile).matches();
        }
        return false;
    }

    public static boolean checkChinaUnicom(String mobile) {
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            Pattern regexp = Pattern.compile(CHINA_UNICOM_PATTERN);
            return regexp.matcher(mobile).matches();
        }
        return false;
    }

    public static boolean checkChinaTelecom(String mobile) {
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            Pattern regexp = Pattern.compile(CHINA_TELECOM_PATTERN);
            return regexp.matcher(mobile).matches();
        }
        return false;
    }

    public static boolean checkChineseMobile(String mobile) {
        Pattern regexp = Pattern.compile(CHINA_PATTERN);
        return regexp.matcher(mobile).matches();
    }
}

