/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.contractlock.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.contractlock.dto.AdminDto;
import com.els.modules.electronsign.contractlock.dto.SealDto;
import com.els.modules.electronsign.contractlock.entity.SaleCLCompanyInfo;
import com.els.modules.electronsign.contractlock.entity.SaleClPersonalInfo;
import com.els.modules.electronsign.contractlock.enumerate.CLAuthResultEnum;
import com.els.modules.electronsign.contractlock.enumerate.CLCertificationStatusEnum;
import com.els.modules.electronsign.contractlock.enumerate.CLContactTypeEnum;
import com.els.modules.electronsign.contractlock.mapper.SaleCLCompanyInfoMapper;
import com.els.modules.electronsign.contractlock.service.SaleCLCompanyInfoService;
import com.els.modules.electronsign.contractlock.service.SaleClPersonalInfoService;
import com.els.modules.electronsign.contractlock.util.ClResultAnalysisUtil;
import com.els.modules.electronsign.contractlock.vo.ClCallback;
import com.els.modules.electronsign.contractlock.vo.ClCompanyCertificationVO;
import com.els.modules.electronsign.contractlock.vo.ClCompanyStaffVO;
import com.els.modules.electronsign.contractlock.vo.ClQueryCertificationVO;
import com.els.modules.electronsign.contractlock.vo.ClRoleVO;
import com.els.modules.electronsign.contractlock.vo.ClSealAuthVO;
import com.els.modules.electronsign.util.ESignUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleCLCompanyInfoServiceImpl
extends BaseServiceImpl<SaleCLCompanyInfoMapper, SaleCLCompanyInfo>
implements SaleCLCompanyInfoService {
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleClPersonalInfoService personalInfoService;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void add(SaleCLCompanyInfo saleCLCompanyInfo) {
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(SaleCLCompanyInfo::getCompanyName, (Object)saleCLCompanyInfo.getCompanyName())) == 0L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_rRCIOMKWxqVBcI_9ebb70f", (String)"\u8be5\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        saleCLCompanyInfo.setCreateAccount(TenantContext.getTenant());
        ((SaleCLCompanyInfoMapper)this.baseMapper).insert((Object)saleCLCompanyInfo);
        this.processNewCompany(saleCLCompanyInfo);
    }

    public void processNewCompany(SaleCLCompanyInfo info) {
        ClQueryCertificationVO clQueryCertificationVO = new ClQueryCertificationVO();
        clQueryCertificationVO.setBase(new ClQueryCertificationVO.Param(info.getCompanyName()));
        Result<?> response = this.getIPassResponse(clQueryCertificationVO, "query-info-company");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            String status = jsonObject.getString("status");
            JSONArray adminInfosArray = jsonObject.getJSONArray("adminInfos");
            if (CollUtil.isNotEmpty((Collection)adminInfosArray)) {
                boolean checkFlg = false;
                List adminDtos = adminInfosArray.toJavaList(AdminDto.class);
                for (AdminDto admin : adminDtos) {
                    String newSurname;
                    String surname;
                    if ((!StrUtil.isNotBlank((CharSequence)admin.getName()) || !StrUtil.isNotBlank((CharSequence)admin.getMobile())) && !StrUtil.isNotBlank((CharSequence)admin.getEmail()) || !StrUtil.equals((CharSequence)(surname = admin.getName().substring(0, 1)), (CharSequence)(newSurname = info.getApplyUserName().substring(0, 1)))) continue;
                    if (StrUtil.isNotBlank((CharSequence)admin.getMobile()) && StrUtil.equals((CharSequence)info.getApplyContactType(), (CharSequence)CLContactTypeEnum.MOBILE.getValue()) && ESignUtil.matchingMobilePhones(admin.getMobile(), info.getApplyContact())) {
                        checkFlg = true;
                    }
                    if (!StrUtil.isNotBlank((CharSequence)admin.getEmail()) || !StrUtil.equals((CharSequence)info.getApplyContactType(), (CharSequence)CLContactTypeEnum.EMAIL.getValue()) || !ESignUtil.matchingEmail(admin.getEmail(), info.getApplyContact())) continue;
                    checkFlg = true;
                }
                if (!checkFlg) {
                    StringBuffer msg = new StringBuffer();
                    msg.append(I18nUtil.translate((String)"i18n_field_rAEIKAZdLieRSMjUVLxKRvjABs[_3889698f", (String)"\u8be5\u4f01\u4e1a\u5df2\u5728\u5951\u7ea6\u9501\u8ba4\u8bc1\u901a\u8fc7\uff0c\u586b\u5199\u7684\u7533\u8bf7\u4eba\u4e0d\u5728\u7ba1\u7406\u5458\u5217\u8868\u4e2d\uff1a["));
                    adminDtos.forEach(adminDto -> {
                        msg.append("\u59d3\u540d\uff1a" + adminDto.getName());
                        if (StrUtil.isNotBlank((CharSequence)adminDto.getMobile())) {
                            msg.append("\uff1b\u624b\u673a\uff1a" + adminDto.getMobile());
                        }
                        if (StrUtil.isNotBlank((CharSequence)adminDto.getEmail())) {
                            msg.append("\uff1b\u90ae\u7bb1\uff1a" + adminDto.getEmail());
                        }
                        msg.append("\uff1b");
                    });
                    msg.append("]");
                    throw new ELSBootException(msg.toString());
                }
            }
            if (StrUtil.isNotBlank((CharSequence)status) && "AUTH_SUCCESS".equals(status)) {
                info.setCertificationStatus(CLCertificationStatusEnum.PASSED.getValue());
                info.setCompanyId(jsonObject.getString("id"));
                this.insertAdmin(info);
                info.setCertificationStartTime(new Date());
                this.updateInfo(info);
            }
        }
    }

    @Override
    public void edit(SaleCLCompanyInfo saleCLCompanyInfo) {
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleCLCompanyInfo::getCompanyName, (Object)saleCLCompanyInfo.getCompanyName())).ne(BaseEntity::getId, (Object)saleCLCompanyInfo.getId())) == 0L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_rRCIOMKWxqVBcI_9ebb70f", (String)"\u8be5\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        int count = ((SaleCLCompanyInfoMapper)this.baseMapper).updateById((Object)saleCLCompanyInfo);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.getCertificationInfo(saleCLCompanyInfo.getId());
    }

    @Override
    public void delete(String id) {
        ((SaleCLCompanyInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleCLCompanyInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    public void saveInfo(SaleCLCompanyInfo req) {
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        if (StrUtil.isBlank((CharSequence)req.getElsAccount())) {
            req.setElsAccount(TenantContext.getTenant());
        }
        req.setCreateTime(new Date());
        req.setCreateBy(currentUser);
        ((SaleCLCompanyInfoMapper)this.baseMapper).insert((Object)req);
    }

    public void updateInfo(SaleCLCompanyInfo req) {
        req.setUpdateTime(new Date());
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        req.setUpdateBy(currentUser);
        ((SaleCLCompanyInfoMapper)this.baseMapper).updateById((Object)req);
    }

    public void handleDb(SaleCLCompanyInfo req) {
        if (StringUtils.isBlank((CharSequence)req.getId())) {
            req.setCreateAccount(TenantContext.getTenant());
            this.saveInfo(req);
        } else {
            this.updateInfo(req);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public SaleCLCompanyInfo submitCertification(SaleCLCompanyInfo req) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)req.getId()), (String)I18nUtil.translate((String)"i18n_field_VWsM_40db030c", (String)"\u8bf7\u5148\u4fdd\u5b58"));
        Result<?> response = null;
        if (StringUtils.isBlank((CharSequence)req.getCompanyId())) {
            ClCompanyCertificationVO certificationInfo = (ClCompanyCertificationVO)SysUtil.copyProperties((Object)((Object)req), ClCompanyCertificationVO.class);
            certificationInfo.setApplicantInfo(new ClCompanyCertificationVO.ApplicantInfo(req.getApplyUserName(), req.getApplyContact(), req.getApplyContactType()));
            certificationInfo.setCallbackUrl(this.address + "/els/contractLock/saleCLCompanyInfo/noToken/callback/authCompany");
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)certificationInfo)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-auth-company"));
            response = ClResultAnalysisUtil.analysisResult(object);
            if (response.isSuccess()) {
                JSONObject jsonObject = (JSONObject)response.getResult();
                req.setCertificationPageUrl(jsonObject.getString("pageUrl"));
                req.setRequestId(jsonObject.getString("requestId"));
                req.setCertificationStatus(CLCertificationStatusEnum.UNDER_CERTIFICATION.getValue());
                this.handleDb(req);
            } else {
                Assert.isTrue((boolean)false, (String)response.getMessage());
            }
        }
        return req;
    }

    private void insertAdmin(SaleCLCompanyInfo company) {
        TenantContext.setTenant((String)company.getElsAccount());
        List list = this.personalInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleClPersonalInfo::getCompanyId, (Object)company.getCompanyId())).eq(SaleClPersonalInfo::getApplyContact, (Object)company.getApplyContact())).eq(SaleClPersonalInfo::getApplyUserName, (Object)company.getApplyUserName())).eq(BaseEntity::getDeleted, (Object)"0"));
        if (CollUtil.isNotEmpty((Collection)list)) {
            list.forEach(x -> {
                x.setRoleStr("ADMIN");
                x.setRealName("1");
                this.personalInfoService.updateById(x);
            });
        } else {
            SaleClPersonalInfo saleClPersonalInfo = new SaleClPersonalInfo();
            saleClPersonalInfo.setRoleStr("ADMIN");
            BeanUtil.copyProperties((Object)((Object)company), (Object)((Object)saleClPersonalInfo), (String[])new String[0]);
            saleClPersonalInfo.setCreateTime(new Date());
            saleClPersonalInfo.setId(null);
            saleClPersonalInfo.setAuthPageUrl(null);
            saleClPersonalInfo.setRealName("1");
            this.personalInfoService.save((Object)saleClPersonalInfo);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void getCertificationInfo(String id) {
        SaleCLCompanyInfo info = (SaleCLCompanyInfo)((Object)this.getById((Serializable)((Object)id)));
        ClQueryCertificationVO clQueryCertificationVO = new ClQueryCertificationVO();
        clQueryCertificationVO.setBody(new ClQueryCertificationVO.Param(info.getCompanyName()));
        Result<?> response = this.getIPassResponse(clQueryCertificationVO, "query-auth-company");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            Integer status = jsonObject.getInteger("status");
            if (ObjectUtil.isNotEmpty((Object)status)) {
                info.setCertificationStatus(status);
                if (status.equals(CLCertificationStatusEnum.PASSED.getValue())) {
                    clQueryCertificationVO = new ClQueryCertificationVO();
                    clQueryCertificationVO.setBase(new ClQueryCertificationVO.Param(info.getCompanyName()));
                    response = this.getIPassResponse(clQueryCertificationVO, "query-info-company");
                    jsonObject = (JSONObject)response.getResult();
                    info.setCompanyId(jsonObject.getString("id"));
                    this.insertAdmin(info);
                }
                info.setCertificationStartTime(new Date());
                this.updateById((Object)info);
            }
        } else {
            Assert.isTrue((boolean)false, (String)response.getMessage());
        }
    }

    @Override
    public SaleCLCompanyInfo getAuthPage(String id) {
        SaleCLCompanyInfo info = (SaleCLCompanyInfo)((Object)this.getById((Serializable)((Object)id)));
        ClQueryCertificationVO clQueryCertificationVO = new ClQueryCertificationVO();
        clQueryCertificationVO.setBody(new ClQueryCertificationVO.Param(info.getCompanyId(), new ClCompanyCertificationVO.ApplicantInfo(info.getApplyUserName(), info.getApplyContact(), info.getApplyContactType())));
        Result<?> response = this.getIPassResponse(clQueryCertificationVO, "get-auth-page");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            info.setAuthPageUrl(jsonObject.getString("pageUrl"));
            this.updateInfo(info);
            return info;
        }
        Assert.isTrue((boolean)false, (String)response.getMessage());
        return null;
    }

    @Override
    public void addStaff(SaleClPersonalInfo saleCLCompanyInfo) {
        ClCompanyStaffVO staffReq = new ClCompanyStaffVO();
        staffReq.setCompanyId(saleCLCompanyInfo.getCompanyId());
        ClCompanyStaffVO.Body body = new ClCompanyStaffVO.Body();
        body.setUser(new ClCompanyCertificationVO.ApplicantInfo(saleCLCompanyInfo.getApplyUserName(), saleCLCompanyInfo.getApplyContact(), saleCLCompanyInfo.getApplyContactType()));
        staffReq.setBody(body);
        Result<?> result = this.getIPassResponse(staffReq, "add-staff-company-personal");
        if (result.isSuccess()) {
            JSONObject jsonObject = (JSONObject)result.getResult();
            saleCLCompanyInfo.setAccountId(jsonObject.getString("id"));
            saleCLCompanyInfo.setRealName(jsonObject.getBoolean("realName") != false ? "1" : "0");
            if (StrUtil.isNotBlank((CharSequence)saleCLCompanyInfo.getId())) {
                this.personalInfoService.edit(saleCLCompanyInfo);
            } else {
                SaleCLCompanyInfo companyInfo = this.getByCompanyId(saleCLCompanyInfo.getCompanyId());
                saleCLCompanyInfo.setCreateTime(new Date());
                saleCLCompanyInfo.setElsAccount(companyInfo.getElsAccount());
                saleCLCompanyInfo.setCompanyId(companyInfo.getCompanyId());
                saleCLCompanyInfo.setCompanyName(companyInfo.getCompanyName());
                this.personalInfoService.add(saleCLCompanyInfo);
            }
        } else {
            Assert.isTrue((boolean)false, (String)result.getMessage());
        }
    }

    @Override
    public SaleCLCompanyInfo getByCompanyId(String id) {
        return (SaleCLCompanyInfo)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(SaleCLCompanyInfo::getCompanyId, (Object)id)));
    }

    @Override
    public void removeStaff(SaleClPersonalInfo saleClPersonalInfo) {
        ClCompanyStaffVO staffReq = new ClCompanyStaffVO();
        staffReq.setCompanyId(saleClPersonalInfo.getCompanyId());
        ClCompanyStaffVO.Body body = new ClCompanyStaffVO.Body();
        body.setContact(saleClPersonalInfo.getApplyContact());
        body.setContactType(saleClPersonalInfo.getApplyContactType());
        staffReq.setBody(body);
        Result<?> result = this.getIPassResponse(staffReq, "remove-staff-company-personal");
        if (result.isSuccess()) {
            this.personalInfoService.delete(saleClPersonalInfo.getId());
        } else {
            Assert.isTrue((boolean)false, (String)result.getMessage());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void handleCallBackAuth(String contents) {
        ClCallback.CompanyAuth companyAuth = (ClCallback.CompanyAuth)JSON.parseObject((String)contents, ClCallback.CompanyAuth.class);
        SaleCLCompanyInfo dbInfo = this.selectByRequestId(companyAuth.getRequestId());
        if (ObjectUtil.isNotNull((Object)((Object)dbInfo))) {
            dbInfo.setCertificationStatus(CLAuthResultEnum.getSrmStatusByValue(companyAuth.getStatus()));
            dbInfo.setCompanyId(companyAuth.getCompanyId());
            dbInfo.setUpdateTime(new Date());
            this.updateById((Object)dbInfo);
            if (CLAuthResultEnum.PASSED.getValue().equals(companyAuth.getStatus())) {
                this.insertAdmin(dbInfo);
            }
        }
    }

    @Override
    public void generateDefaultSeal(SealDto sealRq) {
        SaleCLCompanyInfo companyInfo = (SaleCLCompanyInfo)((Object)this.getById((Serializable)((Object)sealRq.getId())));
        List personalInfos = this.personalInfoService.listByIds(sealRq.getUserIds());
        if (StrUtil.isNotBlank((CharSequence)companyInfo.getDefaultSealId())) {
            List oldPns = this.personalInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleClPersonalInfo::getAddDefaultSeal, (Object)"1")).eq(SaleClPersonalInfo::getCompanyId, (Object)companyInfo.getCompanyId()));
            List oldIds = oldPns.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
            List nowIds = personalInfos.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
            List removes = oldPns.stream().filter(x -> !nowIds.contains(x.getId())).collect(Collectors.toList());
            List adds = personalInfos.stream().filter(x -> !oldIds.contains(x.getId())).collect(Collectors.toList());
            ClSealAuthVO clSealAuthVO = new ClSealAuthVO();
            clSealAuthVO.setCompanyId(companyInfo.getCompanyId());
            clSealAuthVO.getBody().setSealId(companyInfo.getDefaultSealId());
            clSealAuthVO.getBody().setSealImageInfo(null);
            clSealAuthVO.getBody().setName(null);
            if (CollUtil.isNotEmpty(removes)) {
                List<ClSealAuthVO.User> us = removes.stream().map(x -> {
                    ClSealAuthVO.User u = new ClSealAuthVO.User();
                    u.setContact(x.getApplyContact());
                    u.setContactType(x.getApplyContactType());
                    return u;
                }).collect(Collectors.toList());
                clSealAuthVO.getBody().setOperate("REMOVE");
                clSealAuthVO.getBody().setSealUsers(us);
                Result<?> result = this.getIPassResponse(clSealAuthVO, "modify-auto-seal");
                Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
                this.personalInfoService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(SaleClPersonalInfo::getAddDefaultSeal, (Object)"0")).in(BaseEntity::getId, (Collection)removes.stream().map(x -> x.getId()).collect(Collectors.toList())));
            }
            if (CollUtil.isNotEmpty(adds)) {
                List<ClSealAuthVO.User> as = adds.stream().map(x -> {
                    ClSealAuthVO.User u = new ClSealAuthVO.User();
                    u.setContact(x.getApplyContact());
                    u.setContactType(x.getApplyContactType());
                    return u;
                }).collect(Collectors.toList());
                clSealAuthVO.getBody().setOperate("ADD");
                clSealAuthVO.getBody().setSealUsers(as);
                Result<?> addResult = this.getIPassResponse(clSealAuthVO, "modify-auto-seal");
                Assert.isTrue((boolean)addResult.isSuccess(), (String)addResult.getMessage());
                this.personalInfoService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(SaleClPersonalInfo::getAddDefaultSeal, (Object)"1")).in(BaseEntity::getId, (Collection)adds.stream().map(x -> x.getId()).collect(Collectors.toList())));
            }
        } else {
            ClSealAuthVO clSealAuthVO = new ClSealAuthVO();
            clSealAuthVO.setCompanyId(companyInfo.getCompanyId());
            List<ClSealAuthVO.User> us = personalInfos.stream().map(x -> {
                ClSealAuthVO.User u = new ClSealAuthVO.User();
                u.setContact(x.getApplyContact());
                u.setContactType(x.getApplyContactType());
                return u;
            }).collect(Collectors.toList());
            clSealAuthVO.getBody().setUsers(us);
            Result<?> result = this.getIPassResponse(clSealAuthVO, "create-auto-seal");
            Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
            JSONObject jsonObject = (JSONObject)result.getResult();
            String sealId = jsonObject.getString("id");
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)sealId), (String)I18nUtil.translate((String)"i18n_field_yVIHLvMid_26f57497", (String)"\u63a5\u53e3\u5f02\u5e38\uff0c\u672a\u8fd4\u56deid"));
            companyInfo.setDefaultSealId(sealId);
            personalInfos.forEach(p -> p.setAddDefaultSeal("1"));
            this.updateById((Object)companyInfo);
            this.personalInfoService.updateBatchById(personalInfos);
        }
    }

    @Override
    public SealDto defaultSeal(String id) {
        SaleCLCompanyInfo companyInfo = (SaleCLCompanyInfo)((Object)this.getById((Serializable)((Object)id)));
        SealDto seal = new SealDto();
        List psns = this.personalInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleClPersonalInfo::getAddDefaultSeal, (Object)"1")).eq(SaleClPersonalInfo::getCompanyId, (Object)companyInfo.getCompanyId()));
        if (CollUtil.isNotEmpty((Collection)psns)) {
            seal.setUserIds(psns.stream().map(x -> x.getId()).collect(Collectors.toList()));
        }
        seal.setSalePsns(this.personalInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleClPersonalInfo::getCompanyId, (Object)companyInfo.getCompanyId())).eq(SaleClPersonalInfo::getRealName, (Object)"1")));
        seal.setId(id);
        return seal;
    }

    @Override
    public void roleAdmin(String id, String operate) {
        ClRoleVO clRoleVO = new ClRoleVO();
        SaleClPersonalInfo personalInfo = (SaleClPersonalInfo)((Object)this.personalInfoService.getById((Serializable)((Object)id)));
        clRoleVO.setCompanyId(personalInfo.getCompanyId());
        clRoleVO.getBody().setRole("SEAL_ADMIN");
        clRoleVO.getBody().setOperate(operate);
        clRoleVO.getBody().setUsers(Arrays.asList(new ClRoleVO.User(personalInfo.getApplyContact(), personalInfo.getApplyContactType())));
        Result<?> addResult = this.getIPassResponse(clRoleVO, "admin-psn-role");
        Assert.isTrue((boolean)addResult.isSuccess(), (String)addResult.getMessage());
        personalInfo.setRoleStr(operate.equals("ADD") ? "SEAL_ADMIN" : null);
        this.personalInfoService.updateById((Object)personalInfo);
    }

    private SaleCLCompanyInfo selectByRequestId(String requestId) {
        return ((SaleCLCompanyInfoMapper)this.baseMapper).selectByRequestId(requestId);
    }

    private Result<?> getIPassResponse(Object req, String iPassCode) {
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)req)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(iPassCode));
        return ClResultAnalysisUtil.analysisResult(object);
    }
}

