/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.jdyxc.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.api.dto.BaseCreateAccountDto;
import com.els.common.util.RedisUtil;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.third.base.enums.ThirdTypeEnum;
import com.els.modules.third.base.vo.ThirdPartyInstanceAndXcVo;
import com.els.modules.third.jdyxc.dto.JdyMarketParamDto;
import com.els.modules.third.jdyxc.dto.RespParamDto;
import com.els.modules.third.jdyxc.dto.ThirdAuthUserDto;
import com.els.modules.third.jdyxc.dto.ThirdAuthUserListDto;
import com.els.modules.third.jdyxc.service.MarketBusinessService;
import com.els.modules.third.jdyxc.service.impl.BizBusinessManager;
import com.els.modules.third.util.CreateAccountUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="envAppAuthUserChangeType")
public class AuthUserBizBusinessServiceImpl
extends BizBusinessManager
implements MarketBusinessService {
    private static final Logger log = LoggerFactory.getLogger(AuthUserBizBusinessServiceImpl.class);
    @Autowired
    private RedisUtil redisUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public RespParamDto handlerBusiness(JSONObject json) {
        List userList;
        ThirdAuthUserDto userDto;
        String userUuId;
        block7: {
            log.info("AuthUserBizBusinessServiceImpl-->RespParam\u3010show\u3011input param\uff1a{}", (Object)json.toJSONString());
            JdyMarketParamDto marketParams = (JdyMarketParamDto)JSON.parseObject((String)json.toJSONString(), JdyMarketParamDto.class);
            userUuId = "";
            userDto = (ThirdAuthUserDto)JSONObject.parseObject((String)marketParams.getData(), ThirdAuthUserDto.class);
            userList = userDto.getUserList();
            if (!StringUtils.isEmpty((CharSequence)userDto.getThirdPartyInstanceId())) break block7;
            log.error("AuthUserBizBusinessServiceImpl-->RespParam\u3010show\u3011\u7b2c\u4e09\u65b9id\u4e3a\u7a7a\u3002\u64cd\u4f5c\u5931\u8d25");
            RespParamDto respParamDto = RespParamDto.bulidFailure((String)"envAppAuthUserChangeType");
            this.redisUtil.del(new String[]{userUuId});
            return respParamDto;
        }
        try {
            ThirdPartyInstanceAndXcVo instanceAndXcVo = this.getThirdPartyInstanceAndXcVo(userDto.getThirdPartyInstanceId());
            for (ThirdAuthUserListDto listDto : userList) {
                userUuId = instanceAndXcVo.getOrderId() + "-" + listDto.getUid();
                if (!this.checkForUserId(userUuId).booleanValue()) {
                    log.info("AuthUserBizBusinessServiceImpl-->RespParam\u3010show\u3011userUuId\uff1a{} \u5df2\u6dfb\u52a0\u3002\u65e0\u9700\u64cd\u4f5c", (Object)userUuId);
                    continue;
                }
                if (null != this.redisUtil.get(userUuId)) continue;
                this.redisUtil.set(userUuId, (Object)userUuId);
                ElsEnterpriseInfo elsEnterpriseInfo = this.getElsEnterpriseInfo(instanceAndXcVo.getOrderId());
                BaseCreateAccountDto accountDto = new BaseCreateAccountDto();
                accountDto.setCompanyName(elsEnterpriseInfo.getName());
                accountDto.setUserUuid(userUuId);
                accountDto.setPhoneNumber(listDto.getPhone());
                accountDto.setSubName(listDto.getUserName());
                accountDto.setThirdType(ThirdTypeEnum.THIRD_JD_XC.getValue());
                accountDto.setSourceType(EXTERNAL_SYSTEM);
                CreateAccountUtil.createAccount(instanceAndXcVo.getElsAccount(), listDto.getLoginName(), accountDto);
            }
        }
        catch (Exception e) {
            RespParamDto respParamDto;
            try {
                log.error(e.getMessage());
                respParamDto = RespParamDto.bulidFailure((String)"1", (String)e.getMessage());
            }
            catch (Throwable throwable) {
                this.redisUtil.del(new String[]{userUuId});
                throw throwable;
            }
            this.redisUtil.del(new String[]{userUuId});
            return respParamDto;
        }
        this.redisUtil.del(new String[]{userUuId});
        return RespParamDto.bulidSuccess((String)"synOrderPaySuccessType");
    }
}

