/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.esign.entity.ElsEnterpriseCertificationInfo;
import com.els.modules.esign.entity.ElsSubaccountCertificationInfo;
import com.els.modules.esign.enums.CertificationStatusEnum;
import com.els.modules.esign.mapper.ElsEnterpriseCertificationInfoMapper;
import com.els.modules.esign.service.ElsEnterpriseCertificationInfoService;
import com.els.modules.esign.service.ElsSubaccountCertificationInfoService;
import com.els.modules.esign.util.EsignResultAnalysisUtil;
import com.els.modules.esign.vo.EnterpriseAuthCallBakVO;
import com.els.modules.esign.vo.EsignAuthCallbackVO;
import com.els.modules.esign.vo.EsignAuthResponseVO;
import com.els.modules.esign.vo.EsignCreateOrgAccountVO;
import com.els.modules.esign.vo.EsignOrgAdminResponseVO;
import com.els.modules.esign.vo.EsignOrgAuthEO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.system.rpc.service.SystemInvokeOrganizationInfoRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsEnterpriseCertificationInfoServiceImpl
extends BaseServiceImpl<ElsEnterpriseCertificationInfoMapper, ElsEnterpriseCertificationInfo>
implements ElsEnterpriseCertificationInfoService {
    private static final Logger log = LoggerFactory.getLogger(ElsEnterpriseCertificationInfoServiceImpl.class);
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SystemInvokeOrganizationInfoRpcService systemInvokeOrganizationInfoRpcService;
    @Autowired
    private ElsSubaccountCertificationInfoService elsSubaccountCertificationInfoService;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveElsEnterpriseCertificationInfo(ElsEnterpriseCertificationInfo elsEnterpriseCertificationInfo) {
        PurchaseOrganizationInfoDTO organizationInfo;
        elsEnterpriseCertificationInfo.setBusAccount(TenantContext.getTenant());
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsEnterpriseCertificationInfo.getElsAccount())).eq(ElsEnterpriseCertificationInfo::getCertificationStatus, (Object)"2")).count();
        if (count != null && count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u8d26\u53f7\u5df2\u521b\u5efa\u4f01\u4e1a\u8ba4\u8bc1\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        }
        elsEnterpriseCertificationInfo.setCertificationStatus("0");
        ElsEnterpriseInfo enterpriseInfo = this.elsEnterpriseInfoMapper.getByElsAccount(elsEnterpriseCertificationInfo.getElsAccount());
        if (enterpriseInfo != null) {
            elsEnterpriseCertificationInfo.setEnterpriseId(enterpriseInfo.getId());
            elsEnterpriseCertificationInfo.setEnterpriseName(enterpriseInfo.getName());
        }
        if ("1".equals(elsEnterpriseCertificationInfo.getLoadingCompany()) && (organizationInfo = this.systemInvokeOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", elsEnterpriseCertificationInfo.getCompanyCode())) != null) {
            elsEnterpriseCertificationInfo.setCompanyName(organizationInfo.getOrgName());
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"company_name", (Object)elsEnterpriseCertificationInfo.getCompanyName());
        wrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        if (StringUtils.isNotBlank((CharSequence)elsEnterpriseCertificationInfo.getCreatedAccount())) {
            wrapper.eq((Object)"created_account", (Object)elsEnterpriseCertificationInfo.getCreatedAccount());
        } else {
            wrapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"created_account")).or()).eq((Object)"created_account", (Object)""));
        }
        if (!this.list((Wrapper)wrapper).isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rRCIOMKWxqVBcI_9ebb70f", (String)"\u8be5\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        }
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).insert((Object)elsEnterpriseCertificationInfo);
        if ("1".equals(elsEnterpriseCertificationInfo.getFbk6())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsEnterpriseCertificationInfo::getFbk6, (Object)"0")).ne(BaseEntity::getId, (Object)elsEnterpriseCertificationInfo.getId())).update();
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void updateElsEnterpriseCertificationInfo(ElsEnterpriseCertificationInfo elsEnterpriseCertificationInfo) {
        PurchaseOrganizationInfoDTO organizationInfo;
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(BaseEntity::getId, (Object)elsEnterpriseCertificationInfo.getId())).eq(BaseEntity::getElsAccount, (Object)elsEnterpriseCertificationInfo.getElsAccount())).eq(ElsEnterpriseCertificationInfo::getCertificationStatus, (Object)"2")).count();
        if (count != null && count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u8d26\u53f7\u5df2\u521b\u5efa\u4f01\u4e1a\u8ba4\u8bc1\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        }
        if ("1".equals(elsEnterpriseCertificationInfo.getLoadingCompany()) && (organizationInfo = this.systemInvokeOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", elsEnterpriseCertificationInfo.getCompanyCode())) != null) {
            elsEnterpriseCertificationInfo.setCompanyName(organizationInfo.getOrgName());
        }
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).updateById((Object)elsEnterpriseCertificationInfo);
        if ("1".equals(elsEnterpriseCertificationInfo.getFbk6())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsEnterpriseCertificationInfo::getFbk6, (Object)"0")).ne(BaseEntity::getId, (Object)elsEnterpriseCertificationInfo.getId())).update();
        }
    }

    @Override
    public void delElsEnterpriseCertificationInfo(String id) {
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsEnterpriseCertificationInfo(List<String> idList) {
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Result<?> submitCertification(ElsEnterpriseCertificationInfo certificationInfo) {
        if (StringUtils.isBlank((CharSequence)certificationInfo.getId())) {
            this.saveElsEnterpriseCertificationInfo(certificationInfo);
        } else {
            this.updateElsEnterpriseCertificationInfo(certificationInfo);
        }
        Result<?> response = null;
        if (StringUtils.isBlank((CharSequence)certificationInfo.getOrgId())) {
            EsignCreateOrgAccountVO accountVO = (EsignCreateOrgAccountVO)SysUtil.copyProperties((Object)((Object)certificationInfo), EsignCreateOrgAccountVO.class);
            accountVO.setThirdPartyUserId(certificationInfo.getThirdPartyUserId());
            accountVO.setName(certificationInfo.getCompanyName());
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)accountVO)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("create-org-account"));
            response = EsignResultAnalysisUtil.analysisResult(object);
            if (response.isSuccess()) {
                JSONObject jsonObject = (JSONObject)response.getResult();
                certificationInfo.setOrgId(jsonObject.getString("orgId"));
                certificationInfo.setFbk9("1");
                this.updateById((Object)certificationInfo);
            } else {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_LiDJKmW_44a47b5", (String)"\u8ba4\u8bc1\u63d0\u4ea4\u5931\u8d25:") + response.getMessage()));
            }
        }
        this.esignOrgAuth(certificationInfo);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_LiDJLR_296e9080", (String)"\u8ba4\u8bc1\u63d0\u4ea4\u6210\u529f"));
    }

    private void esignOrgAuth(ElsEnterpriseCertificationInfo certificationInfo) {
        ElsSubaccountCertificationInfo psnCertification = (ElsSubaccountCertificationInfo)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.elsSubaccountCertificationInfoService.lambdaQuery().eq(ElsSubaccountCertificationInfo::getAccountId, (Object)certificationInfo.getAccountId())).eq(BaseEntity::getElsAccount, (Object)certificationInfo.getElsAccount())).one());
        String notifyUrl = this.address.endsWith("/") ? this.address + "/els/esign/elsEnterpriseCertificationInfo/v3/callback/orgAuth" : this.address + "//els/esign/elsEnterpriseCertificationInfo/v3/callback/orgAuth";
        EsignOrgAuthEO authenticationEO = new EsignOrgAuthEO(certificationInfo, psnCertification, notifyUrl);
        JSONObject requestJSON = new JSONObject();
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)authenticationEO)));
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-v3-org-auth-address"));
        Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
        if (!response.isSuccess()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LiDJKmW_44a47b5", (String)"\u8ba4\u8bc1\u63d0\u4ea4\u5931\u8d25:") + response.getMessage());
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        EsignAuthResponseVO esignAuthResponseVO = (EsignAuthResponseVO)JSON.parseObject((String)jsonObject.toJSONString(), EsignAuthResponseVO.class);
        certificationInfo.setLongLink(esignAuthResponseVO.getAuthUrl());
        certificationInfo.setShortLink(esignAuthResponseVO.getAuthShortUrl());
        certificationInfo.setCertificationFlowId(esignAuthResponseVO.getAuthFlowId());
        certificationInfo.setCertificationStartTime(new Date());
        this.updateById((Object)certificationInfo);
    }

    @Override
    public Result<?> getCertificationInfo(String id) {
        ElsEnterpriseCertificationInfo certificationInfo = (ElsEnterpriseCertificationInfo)((Object)this.getById((Serializable)((Object)id)));
        if (certificationInfo != null) {
            JSONObject param = new JSONObject();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("flowId", certificationInfo.getCertificationFlowId());
            param.put("base", map);
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(param, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-auth-info"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_tkKm_2f078e83", (String)"\u64cd\u4f5c\u5931\u8d25") + "\uff1a" + response.getMessage()));
            }
            JSONObject data = (JSONObject)response.getResult();
            String status = data.getString("status");
            if (!"SUCCESS".equals(status)) {
                if ("INIT".equals(status)) {
                    return Result.error((String)I18nUtil.translate((String)"i18n_alert_rVHWIhAWLiWtsLLiMWVKdVELCtLiKyHcLiW_763da9fc", (String)"\u8be5\u4fe1\u606f\u201c\u5df2\u53d1\u8d77\u201d\u8ba4\u8bc1\uff0c\u4f46\u8fd8\u672a\u8ba4\u8bc1\u5b8c\uff0c\u8bf7\u5728\u8be6\u60c5\u9875\u9762\u70b9\u51fb\u8ba4\u8bc1\u94fe\u63a5\u8fdb\u884c\u8ba4\u8bc1\uff01"));
                }
                if ("ING".equals(status)) {
                    return Result.error((String)I18nUtil.translate((String)"i18n_alert_rVHjLizELWHcsWWVLyVEoLiMLW_b5d7fad0", (String)"\u8be5\u4fe1\u606f\u7684\u8ba4\u8bc1\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u8bf7\u60a8\u8010\u5fc3\u7b49\u5f85\u8ba4\u8bc1\u5b8c\u6210\uff01"));
                }
                return Result.error((String)I18nUtil.translate((String)"i18n__rVHLizELWIKmWWVLVVLiW_8dcfc898", (String)"\u8be5\u4fe1\u606f\u8ba4\u8bc1\u72b6\u6001\u4e3a\u201c\u5df2\u5931\u8d25\u201d\uff0c\u8bf7\u60a8\u91cd\u65b0\u8ba4\u8bc1\uff01"));
            }
            certificationInfo.setCertificationStatus("1");
            ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).updateById((Object)certificationInfo);
            return Result.ok((String)I18nUtil.translate((String)"i18n_title_operationSuccess", (String)"\u64cd\u4f5c\u6210\u529f\uff01"));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_VNjWWjSWmhxuIdjWFW_5a452366", (String)"\u4f20\u5165\u7684id\u6709\u8bef\uff0c\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff01"));
    }

    @Override
    public void enterpriseCallBack(JSONObject object) {
        EnterpriseAuthCallBakVO authCallBakVO = (EnterpriseAuthCallBakVO)JSON.parseObject((String)object.toJSONString(), EnterpriseAuthCallBakVO.class);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"certification_flow_id", (Object)authCallBakVO.getFlowId());
        List certificationInfos = this.list((Wrapper)wrapper);
        if (!certificationInfos.isEmpty() && authCallBakVO.isSuccess()) {
            ElsEnterpriseCertificationInfo certificationInfo = (ElsEnterpriseCertificationInfo)((Object)certificationInfos.get(0));
            certificationInfo.setCertificationStatus("1");
            certificationInfo.setVerifyCode(authCallBakVO.getVerifycode());
            this.updateById((Object)certificationInfo);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public Result<?> modifyAuthInfo(ElsEnterpriseCertificationInfo certificationInfo) {
        ElsEnterpriseCertificationInfo dbCertification = (ElsEnterpriseCertificationInfo)((Object)this.getById((Serializable)((Object)certificationInfo.getId())));
        String optType = "modify";
        if (!dbCertification.getIdNumber().equals(certificationInfo.getIdNumber())) {
            optType = "new";
        }
        this.updateElsEnterpriseCertificationInfo(certificationInfo);
        if ("new".equals(optType)) {
            EsignCreateOrgAccountVO accountVO = (EsignCreateOrgAccountVO)SysUtil.copyProperties((Object)((Object)certificationInfo), EsignCreateOrgAccountVO.class);
            accountVO.setThirdPartyUserId(dbCertification.getThirdPartyUserId());
            accountVO.setName(certificationInfo.getCompanyName());
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)accountVO)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("create-org-account"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
            if (!response.isSuccess()) throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_crKmW_95bef49b", (String)"\u4fee\u6539\u5931\u8d25:") + response.getMessage());
            JSONObject jsonObject = (JSONObject)response.getResult();
            certificationInfo.setOrgId(jsonObject.getString("orgId"));
            int createTimes = Integer.valueOf((String)ObjectUtil.defaultIfBlank((CharSequence)dbCertification.getFbk9(), (CharSequence)"0")) + 1;
            certificationInfo.setFbk9(String.valueOf(createTimes));
            this.updateById((Object)certificationInfo);
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_crLR_25ddaeda", (String)"\u4fee\u6539\u6210\u529f"));
        } else {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("orgId", (Object)certificationInfo.getOrgId());
            requestJSON.put("base", (Object)bascis);
            EsignCreateOrgAccountVO accountVO = (EsignCreateOrgAccountVO)SysUtil.copyProperties((Object)((Object)certificationInfo), EsignCreateOrgAccountVO.class);
            accountVO.setThirdPartyUserId(certificationInfo.getThirdPartyUserId());
            accountVO.setCreator(certificationInfo.getAccountId());
            accountVO.setName(certificationInfo.getCompanyName());
            requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)accountVO)));
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("modify-org-account"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
            if (!response.isSuccess()) throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_crKmW_95bef49b", (String)"\u4fee\u6539\u5931\u8d25:") + response.getMessage());
            this.updateById((Object)certificationInfo);
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_crLR_25ddaeda", (String)"\u4fee\u6539\u6210\u529f"));
    }

    @Override
    public JSONObject orgAuthCallback4V3(JSONObject object) {
        log.info("e\u7b7e\u5b9d-V3\u673a\u6784\u8ba4\u8bc1&\u6388\u6743\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)object);
        EsignAuthCallbackVO authCallBakVO = (EsignAuthCallbackVO)JSON.parseObject((String)object.toJSONString(), EsignAuthCallbackVO.class);
        if ("AUTH_PASS".equals(authCallBakVO.getAction())) {
            this.authCallbackProccessor(authCallBakVO);
        } else if ("AUTHORIZE_FINISH".equals(authCallBakVO.getAction())) {
            this.authorizedCallbackProccessor(authCallBakVO);
        } else {
            log.error("e\u7b7e\u5b9d\u6210\u529f\u56de\u8c03(V3\u7248\u672c) \u6d41\u7a0b[{}]-\u8ba4\u8bc1\u4e3b\u4f53[{}]-\u901a\u77e5\u7c7b\u578b[{}]\u6ca1\u6709\u76f8\u5e94\u7684\u901a\u77e5\u7c7b\u578b\u5904\u7406\uff01", new Object[]{authCallBakVO.getAuthFlowId(), authCallBakVO.getAuthType(), authCallBakVO.getAction()});
        }
        JSONObject resp = new JSONObject();
        resp.put("code", (Object)"200");
        resp.put("msg", (Object)"success");
        return resp;
    }

    private void authorizedCallbackProccessor(EsignAuthCallbackVO authCallBakVO) {
        List certificationInfos = ((LambdaQueryChainWrapper)this.lambdaQuery().select(new SFunction[]{BaseEntity::getId}).eq(ElsEnterpriseCertificationInfo::getCertificationFlowId, (Object)authCallBakVO.getAuthFlowId())).list();
        if (CollectionUtil.isNotEmpty((Collection)certificationInfos)) {
            ElsEnterpriseCertificationInfo certificationInfo = new ElsEnterpriseCertificationInfo();
            certificationInfo.setId(((ElsEnterpriseCertificationInfo)((Object)certificationInfos.get(0))).getId());
            certificationInfo.setFbk3("1");
            List<EsignAuthCallbackVO.AuthorizedInfo> authorizedInfos = authCallBakVO.getAuthorizedInfo();
            if (CollectionUtil.isNotEmpty(authorizedInfos)) {
                certificationInfo.setFbk4(String.valueOf(authorizedInfos.get(0).getEffectiveTime()));
                certificationInfo.setFbk5(String.valueOf(authorizedInfos.get(0).getExpireTime()));
            }
            certificationInfo.setCertificationStatus("1");
            certificationInfo.setFbk1(authCallBakVO.getOrgId());
            certificationInfo.setFbk2(authCallBakVO.getPsnId());
            this.updateById((Object)certificationInfo);
        }
    }

    private void authCallbackProccessor(EsignAuthCallbackVO authCallBakVO) {
        List certificationInfos = ((LambdaQueryChainWrapper)this.lambdaQuery().select(new SFunction[]{BaseEntity::getId}).eq(ElsEnterpriseCertificationInfo::getCertificationFlowId, (Object)authCallBakVO.getAuthFlowId())).list();
        if (CollectionUtil.isNotEmpty((Collection)certificationInfos)) {
            ElsEnterpriseCertificationInfo certificationInfo = new ElsEnterpriseCertificationInfo();
            certificationInfo.setId(((ElsEnterpriseCertificationInfo)((Object)certificationInfos.get(0))).getId());
            certificationInfo.setCertificationStatus("1");
            EsignAuthCallbackVO.Organization organization = authCallBakVO.getOrganization();
            if (organization != null && organization.getTransactor() != null) {
                certificationInfo.setFbk1(organization.getOrgId());
                certificationInfo.setFbk2(organization.getTransactor().getPsnId());
            }
            this.updateById((Object)certificationInfo);
        }
    }

    @Override
    public EsignOrgAdminResponseVO listOrgAdministrators(ElsEnterpriseCertificationInfo certificationInfo) {
        JSONObject requestJSON = new JSONObject();
        JSONObject bascis = new JSONObject();
        bascis.put("orgId", (Object)certificationInfo.getFbk1());
        requestJSON.put("base", (Object)bascis);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-v3-org-admins"));
        Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
        if (!response.isSuccess()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u83b7\u53d6\u4f01\u4e1a\u7ba1\u7406\u5458\u5931\u8d25:") + response.getMessage());
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        EsignOrgAdminResponseVO esignOrgAdminResponseVO = (EsignOrgAdminResponseVO)JSON.parseObject((String)jsonObject.toJSONString(), EsignOrgAdminResponseVO.class);
        return esignOrgAdminResponseVO;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void setAppProvider(ElsEnterpriseCertificationInfo certificationInfo) {
        ElsEnterpriseCertificationInfo byId = (ElsEnterpriseCertificationInfo)((Object)this.getById((Serializable)((Object)certificationInfo.getId())));
        Assert.isNotNull((Object)((Object)byId), (String)I18nUtil.translate((String)"", (String)"\u4f01\u4e1a\u8ba4\u8bc1\u4e0d\u5b58\u5728\uff01"));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsEnterpriseCertificationInfo::getFbk6, (Object)"1")).eq(BaseEntity::getId, (Object)byId.getId())).update();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsEnterpriseCertificationInfo::getFbk6, (Object)"0")).ne(BaseEntity::getId, (Object)byId.getId())).update();
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void getAuthorization(ElsEnterpriseCertificationInfo certificationInfo1) {
        ElsEnterpriseCertificationInfo dbCertificationInfo = (ElsEnterpriseCertificationInfo)((Object)this.getById((Serializable)((Object)certificationInfo1.getId())));
        ElsSubaccountCertificationInfo psnCertification = (ElsSubaccountCertificationInfo)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.elsSubaccountCertificationInfoService.lambdaQuery().eq(ElsSubaccountCertificationInfo::getAccountId, (Object)dbCertificationInfo.getAccountId())).eq(BaseEntity::getElsAccount, (Object)dbCertificationInfo.getElsAccount())).one());
        String notifyUrl = this.address.endsWith("/") ? this.address + "/els/esign/elsEnterpriseCertificationInfo/v3/callback/orgAuth" : this.address + "//els/esign/elsEnterpriseCertificationInfo/v3/callback/orgAuth";
        EsignOrgAuthEO authenticationEO = new EsignOrgAuthEO(dbCertificationInfo, psnCertification, notifyUrl);
        JSONObject requestJSON = new JSONObject();
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)authenticationEO)));
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-v3-org-auth-address"));
        Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
        if (!response.isSuccess()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6388\u6743\u63d0\u4ea4\u5931\u8d25:") + response.getMessage());
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        EsignAuthResponseVO esignAuthResponseVO = (EsignAuthResponseVO)JSON.parseObject((String)jsonObject.toJSONString(), EsignAuthResponseVO.class);
        dbCertificationInfo.setFbk7(esignAuthResponseVO.getAuthUrl());
        dbCertificationInfo.setFbk8(esignAuthResponseVO.getAuthShortUrl());
        dbCertificationInfo.setCertificationFlowId(esignAuthResponseVO.getAuthFlowId());
        this.updateById((Object)dbCertificationInfo);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void changeCertification(ElsEnterpriseCertificationInfo certificationInfo) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsEnterpriseCertificationInfo::getCertificationStatus, (Object)CertificationStatusEnum.CHANGING.getValue())).set(ElsEnterpriseCertificationInfo::getLongLink, (Object)"")).set(ElsEnterpriseCertificationInfo::getShortLink, (Object)"")).set(ElsEnterpriseCertificationInfo::getFbk7, (Object)"")).set(ElsEnterpriseCertificationInfo::getFbk8, (Object)"")).eq(BaseEntity::getId, (Object)certificationInfo.getId())).update((Object)new ElsEnterpriseCertificationInfo());
    }
}

