/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.esign.entity.ElsEnterpriseCertificationInfo;
import com.els.modules.esign.entity.ElsSeals;
import com.els.modules.esign.entity.PurchaseEsignSeals;
import com.els.modules.esign.enumerate.EsignSealCallbackActionEnum;
import com.els.modules.esign.mapper.ElsSealsMapper;
import com.els.modules.esign.service.ElsEnterpriseCertificationInfoService;
import com.els.modules.esign.service.ElsSealsService;
import com.els.modules.esign.service.PurchaseEsignSealsService;
import com.els.modules.esign.util.EsignFileEncryptUtil;
import com.els.modules.esign.util.EsignResultAnalysisUtil;
import com.els.modules.esign.vo.EsignOrgAdminResponseVO;
import com.els.modules.esign.vo.EsignOrgSealCreateEO;
import com.els.modules.esign.vo.EsignSealCallbackVO;
import com.els.modules.esign.vo.SealVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ElsSealsServiceImpl
extends BaseServiceImpl<ElsSealsMapper, ElsSeals>
implements ElsSealsService {
    private static final Logger log = LoggerFactory.getLogger(ElsSealsServiceImpl.class);
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    @Value(value="${els.path.upload}")
    private String uploadpath;
    @Autowired
    private PurchaseEsignSealsService purchaseEsignSealsService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsEnterpriseCertificationInfoService elsEnterpriseCertificationInfoService;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveElsSeals(ElsSeals elsSeals) {
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.elsEnterpriseCertificationInfoService.lambdaQuery().eq(ElsEnterpriseCertificationInfo::getOrgId, (Object)elsSeals.getOrgId())).eq(ElsEnterpriseCertificationInfo::getCertificationStatus, (Object)"1")).count();
        if (count == null || count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5173\u8054\u7684\u673a\u6784\u5c1a\u672a\u5b8c\u6210\u8ba4\u8bc1\uff01"));
        }
        elsSeals.setDeleted(CommonConstant.DEL_FLAG_0);
        ((ElsSealsMapper)this.baseMapper).insert((Object)elsSeals);
        if ("1".equals(elsSeals.getFbk11())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsSeals::getFbk11, (Object)"0")).ne(BaseEntity::getId, (Object)elsSeals.getId())).update();
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void updateElsSeals(ElsSeals elsSeals) {
        ((ElsSealsMapper)this.baseMapper).updateById((Object)elsSeals);
        if ("1".equals(elsSeals.getFbk11())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsSeals::getFbk11, (Object)"0")).ne(BaseEntity::getId, (Object)elsSeals.getId())).update();
        }
    }

    @Override
    public void delElsSeals(String id) {
        ((ElsSealsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsSeals(List<String> idList) {
        ((ElsSealsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Result<?> uploadToEsign(ElsSeals seals) {
        if (StringUtils.isNotBlank((CharSequence)seals.getId())) {
            this.updateElsSeals(seals);
        } else {
            this.saveElsSeals(seals);
        }
        Result<?> response = null;
        if (StringUtils.isBlank((CharSequence)seals.getSealId())) {
            String data = EsignFileEncryptUtil.fileToBase64(this.uploadpath + seals.getFilePath());
            if (data == null) {
                try {
                    data = EsignFileEncryptUtil.GetUrlImageToBase64(seals.getFilePath().toString());
                }
                catch (Exception e) {
                    return Result.error((String)I18nUtil.translate((String)"i18n_alert_XVKmWWePOIH_31bf6c3f", (String)"\u4e0a\u4f20\u5931\u8d25:\u5370\u7ae0\u56fe\u7247\u5f02\u5e38"));
                }
            }
            SealVO sealVO = new SealVO(seals, data);
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("accountId", (Object)seals.getOrgId());
            requestJSON.put("base", (Object)bascis);
            requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)sealVO)));
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("create-person-or-org-seal-image"));
            response = EsignResultAnalysisUtil.analysisResult(object);
            if (response.isSuccess()) {
                JSONObject jsonObject = (JSONObject)response.getResult();
                seals.setSealId(jsonObject.getString("sealId"));
                this.updateElsSeals(seals);
                return Result.ok((String)I18nUtil.translate((String)"i18n_alert_XVLR_24aeb765", (String)"\u4e0a\u4f20\u6210\u529f\uff01"));
            }
            return Result.error((String)(I18nUtil.translate((String)"i18n_alert_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25:") + response.getMessage()));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_WeIXV_d10ea058", (String)"\u5370\u7ae0\u5df2\u4e0a\u4f20"));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public JSONObject sealCallBack4V3(JSONObject object) {
        log.info("e\u7b7e\u5b9d-V3\u5370\u7ae0\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)object);
        EsignSealCallbackVO callbackVO = (EsignSealCallbackVO)JSON.parseObject((String)object.toJSONString(), EsignSealCallbackVO.class);
        String action = callbackVO.getAction();
        if (EsignSealCallbackActionEnum.SEAL_CREATE.getType().equals(action)) {
            this.sealCreateProccessor(callbackVO);
        } else if (!EsignSealCallbackActionEnum.SEAL_DELETE.getType().equals(action)) {
            if (EsignSealCallbackActionEnum.SEAL_AUTH_EFFICTIVE.getType().equals(action)) {
                this.sealAuthProccessor(callbackVO);
            } else if (EsignSealCallbackActionEnum.SEAL_AUTH_INEFFICTIVE.getType().equals(action)) {
                this.sealAuthProccessor(callbackVO);
            }
        }
        JSONObject resp = new JSONObject();
        resp.put("code", (Object)"200");
        resp.put("msg", (Object)"success");
        return resp;
    }

    private void sealAuthProccessor(EsignSealCallbackVO callbackVO) {
        boolean update;
        if (!StringUtils.isNotBlank((CharSequence)callbackVO.getAuthorizedPsnId()) && StringUtils.isNotBlank((CharSequence)callbackVO.getAuthorizedOrgId()) && !(update = ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseEsignSealsService.lambdaUpdate().set(PurchaseEsignSeals::getFbk4, (Object)callbackVO.getAuthStatus())).set(PurchaseEsignSeals::getFbk6, (Object)String.valueOf(callbackVO.getEffectiveTime()))).set(PurchaseEsignSeals::getFbk7, (Object)String.valueOf(callbackVO.getExpireTime()))).eq(PurchaseEsignSeals::getSealId, (Object)callbackVO.getSealId())).eq(PurchaseEsignSeals::getFbk1, (Object)callbackVO.getSealAuthBizId())).eq(PurchaseEsignSeals::getFbk5, (Object)callbackVO.getAuthorizedOrgId())).update((Object)new PurchaseEsignSeals()))) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsSeals::getFbk4, (Object)callbackVO.getAuthStatus())).set(ElsSeals::getFbk6, (Object)String.valueOf(callbackVO.getEffectiveTime()))).set(ElsSeals::getFbk7, (Object)String.valueOf(callbackVO.getExpireTime()))).eq(ElsSeals::getSealId, (Object)callbackVO.getSealId())).eq(ElsSeals::getFbk1, (Object)callbackVO.getSealAuthBizId())).eq(ElsSeals::getFbk5, (Object)callbackVO.getAuthorizedOrgId())).update((Object)new ElsSeals());
        }
    }

    private void sealCreateProccessor(EsignSealCallbackVO callbackVO) {
        if (callbackVO.getCustomBizNum().startsWith("PU_")) {
            PurchaseEsignSeals purchaseEsignSeals = new PurchaseEsignSeals();
            purchaseEsignSeals.setId(callbackVO.getCustomBizNum().split("_")[1]);
            purchaseEsignSeals.setSealId(callbackVO.getSealId());
            purchaseEsignSeals.setAlias(callbackVO.getSealName());
            purchaseEsignSeals.setFbk8("1");
            this.purchaseEsignSealsService.updateById((Object)purchaseEsignSeals);
        } else if (callbackVO.getCustomBizNum().startsWith("SU_")) {
            ElsSeals elsSeals = new ElsSeals();
            elsSeals.setId(callbackVO.getCustomBizNum().split("_")[1]);
            elsSeals.setSealId(callbackVO.getSealId());
            elsSeals.setAlias(callbackVO.getSealName());
            elsSeals.setFbk8("1");
            this.updateById((Object)elsSeals);
        }
    }

    @Override
    public String getCreateUrl(ElsSeals seals) {
        String sealCreateUrl = "";
        ElsEnterpriseCertificationInfo certificationInfo = (ElsEnterpriseCertificationInfo)((Object)((LambdaQueryChainWrapper)this.elsEnterpriseCertificationInfoService.lambdaQuery().eq(ElsEnterpriseCertificationInfo::getOrgId, (Object)seals.getOrgId())).one());
        long now = Instant.now().toEpochMilli();
        if (!("1".equals(certificationInfo.getCertificationStatus()) || now >= Long.valueOf(certificationInfo.getFbk4()) && now <= Long.valueOf(certificationInfo.getFbk5()))) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u83b7\u53d6\u94fe\u63a5\u5931\u8d25\uff0c\u673a\u6784\u5c1a\u672a\u8ba4\u8bc1\u6216\u6388\u6743\u5df2\u5931\u6548\uff0c\u8bf7\u5148\u63d0\u4ea4\u8ba4\u8bc1\u6216\u6388\u6743\uff01"));
        }
        String tenant = TenantContext.getTenant();
        TenantContext.setTenant((String)seals.getBusAccount());
        EsignOrgAdminResponseVO esignOrgAdminResponseVO = this.elsEnterpriseCertificationInfoService.listOrgAdministrators(certificationInfo);
        TenantContext.setTenant((String)tenant);
        List<EsignOrgAdminResponseVO.Administrator> administrators = esignOrgAdminResponseVO.getAdministrators();
        Assert.isNotEmpty(administrators, (String)I18nUtil.translate((String)"", (String)"\u67e5\u8be2\u7ba1\u7406\u5458\u5931\u8d25\uff01"));
        String adminPsnId = administrators.get(0).getPsnId();
        String redirectUrl = this.address.endsWith("/") ? this.address + "esignResult?id=SU_" + seals.getId() : this.address + "/esignResult?id=SU_" + seals.getId();
        EsignOrgSealCreateEO esignOrgSealCreateEO = new EsignOrgSealCreateEO(certificationInfo.getFbk1(), adminPsnId, "SU_" + seals.getId(), redirectUrl, seals);
        JSONObject requestJSON = new JSONObject();
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)esignOrgSealCreateEO)));
        TenantContext.setTenant((String)seals.getBusAccount());
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-v3-org-create-seal-address"));
        TenantContext.setTenant((String)tenant);
        Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
        if (!response.isSuccess()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u83b7\u53d6\u5370\u7ae0\u521b\u5efa\u94fe\u63a5\u5931\u8d25:") + response.getMessage());
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        sealCreateUrl = jsonObject.getString("orgSealCreateUrl");
        return sealCreateUrl;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void setDefaultSeal(ElsSeals seals) {
        ElsSeals byId = (ElsSeals)((Object)this.getById((Serializable)((Object)seals.getId())));
        Assert.isNotNull((Object)((Object)byId), (String)I18nUtil.translate((String)"", (String)"\u5370\u7ae0\u4fe1\u606f\u4e0d\u5b58\u5728\uff01"));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsSeals::getFbk11, (Object)"1")).eq(BaseEntity::getId, (Object)seals.getId())).update();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsSeals::getFbk11, (Object)"0")).ne(BaseEntity::getId, (Object)seals.getId())).update();
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void setSealAudit(ElsSeals seals) {
        String id = seals.getId();
        if (StringUtils.isBlank((CharSequence)id)) {
            log.error("\u5370\u7ae0\u521b\u5efa\u5b8c\u6210\u56de\u8c03\u8bbe\u7f6e\u5ba1\u6279\u72b6\u6001\u5931\u8d25\uff0c\u5370\u7ae0");
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u56de\u5199\u5931\u8d25\uff01"));
        }
        if (id.startsWith("PU_")) {
            id = id.split("_")[1];
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseEsignSealsService.lambdaUpdate().set(PurchaseEsignSeals::getFbk8, (Object)"0")).eq(BaseEntity::getId, (Object)id)).isNull(PurchaseEsignSeals::getSealId)).update();
        } else if (id.startsWith("SU_")) {
            id = id.split("_")[1];
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsSeals::getFbk8, (Object)"0")).eq(BaseEntity::getId, (Object)id)).isNull(ElsSeals::getSealId)).update();
        }
    }
}

