/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.esign.entity.ElsSubaccountCertificationInfo;
import com.els.modules.esign.enums.CertificationStatusEnum;
import com.els.modules.esign.mapper.ElsSubaccountCertificationInfoMapper;
import com.els.modules.esign.service.ElsSubaccountCertificationInfoService;
import com.els.modules.esign.util.EsignResultAnalysisUtil;
import com.els.modules.esign.vo.EsignAuthCallbackVO;
import com.els.modules.esign.vo.EsignAuthResponseVO;
import com.els.modules.esign.vo.EsignCreatePersonAccountVO;
import com.els.modules.esign.vo.EsignPsnAuthEO;
import com.els.modules.esign.vo.PersonAuthCallBakVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsSubaccountCertificationInfoServiceImpl
extends BaseServiceImpl<ElsSubaccountCertificationInfoMapper, ElsSubaccountCertificationInfo>
implements ElsSubaccountCertificationInfoService {
    private static final Logger log = LoggerFactory.getLogger(ElsSubaccountCertificationInfoServiceImpl.class);
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void saveElsSubaccountCertificationInfo(ElsSubaccountCertificationInfo elsSubaccountCertificationInfo) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.and(w -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)w.eq((Object)"sub_account_id", (Object)elsSubaccountCertificationInfo.getSubAccountId());
        });
        wrapper.ne((Object)"certification_status", (Object)"2");
        if (!this.list((Wrapper)wrapper).isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u5b50\u8d26\u53f7\u5df2\u521b\u5efa\u4e2a\u4eba\u8ba4\u8bc1\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        }
        elsSubaccountCertificationInfo.setBusAccount(TenantContext.getTenant());
        elsSubaccountCertificationInfo.setCertificationStatus("0");
        ElsEnterpriseInfo enterpriseInfo = this.elsEnterpriseInfoMapper.getByElsAccount(elsSubaccountCertificationInfo.getElsAccount());
        if (enterpriseInfo != null) {
            elsSubaccountCertificationInfo.setCompanyName(enterpriseInfo.getName());
        }
        ((ElsSubaccountCertificationInfoMapper)this.baseMapper).insert((Object)elsSubaccountCertificationInfo);
    }

    @Override
    public void updateElsSubaccountCertificationInfo(ElsSubaccountCertificationInfo elsSubaccountCertificationInfo) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.ne((Object)"id", (Object)elsSubaccountCertificationInfo.getId());
        wrapper.and(w -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)w.eq((Object)"sub_account_id", (Object)elsSubaccountCertificationInfo.getSubAccountId());
        });
        wrapper.ne((Object)"certification_status", (Object)"2");
        if (!this.list((Wrapper)wrapper).isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u5b50\u8d26\u53f7\u5df2\u521b\u5efa\u4e2a\u4eba\u8ba4\u8bc1\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        }
        ((ElsSubaccountCertificationInfoMapper)this.baseMapper).updateById((Object)elsSubaccountCertificationInfo);
    }

    @Override
    public void delElsSubaccountCertificationInfo(String id) {
        ((ElsSubaccountCertificationInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsSubaccountCertificationInfo(List<String> idList) {
        ((ElsSubaccountCertificationInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Result<?> submintCertification(ElsSubaccountCertificationInfo elsSubaccountCertificationInfo) {
        if (StringUtils.isBlank((CharSequence)elsSubaccountCertificationInfo.getId())) {
            this.saveElsSubaccountCertificationInfo(elsSubaccountCertificationInfo);
        } else {
            ElsSubaccountCertificationInfo dbCertification = (ElsSubaccountCertificationInfo)((Object)this.getById((Serializable)((Object)elsSubaccountCertificationInfo.getId())));
            if (!dbCertification.getIdNumber().equals(elsSubaccountCertificationInfo.getIdNumber()) && CertificationStatusEnum.CHANGING.getValue().equals(dbCertification.getCertificationStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u53d8\u66f4\u4e2d\u7684\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u5141\u8bb8\u4fee\u6539\u8bc1\u4ef6\u53f7\uff01"));
            }
            this.updateElsSubaccountCertificationInfo(elsSubaccountCertificationInfo);
        }
        Result<?> response = null;
        if (StringUtils.isBlank((CharSequence)elsSubaccountCertificationInfo.getAccountId())) {
            EsignCreatePersonAccountVO accountVO = (EsignCreatePersonAccountVO)SysUtil.copyProperties((Object)((Object)elsSubaccountCertificationInfo), EsignCreatePersonAccountVO.class);
            accountVO.setThirdPartyUserId(elsSubaccountCertificationInfo.getThirdPartyUserId());
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)accountVO)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("create-person-account"));
            response = EsignResultAnalysisUtil.analysisResult(jsonObject);
            if (response.isSuccess()) {
                ElsSubaccountCertificationInfo certificationInfo = (ElsSubaccountCertificationInfo)((Object)JSON.parseObject((String)response.getResult().toString(), ElsSubaccountCertificationInfo.class));
                elsSubaccountCertificationInfo.setAccountId(certificationInfo.getAccountId());
                elsSubaccountCertificationInfo.setFbk7("1");
                this.updateById((Object)elsSubaccountCertificationInfo);
            } else {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_LiDJKmW_44a47b5", (String)"\u8ba4\u8bc1\u63d0\u4ea4\u5931\u8d25:") + response.getMessage()));
            }
        }
        this.esignPsnAuth(elsSubaccountCertificationInfo);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_LiDJLR_296e9080", (String)"\u8ba4\u8bc1\u63d0\u4ea4\u6210\u529f"));
    }

    private void esignPsnAuth(ElsSubaccountCertificationInfo elsSubaccountCertificationInfo) {
        String notifyUrl = this.address.endsWith("/") ? this.address + "els/esign/elsSubaccountCertificationInfo/v3/callback/psnAuth" : this.address + "/els/esign/elsSubaccountCertificationInfo/v3/callback/psnAuth";
        EsignPsnAuthEO esignPsnAuthEO = new EsignPsnAuthEO(elsSubaccountCertificationInfo, notifyUrl);
        JSONObject requestJSON = new JSONObject();
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)esignPsnAuthEO)));
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-v3-psn-auth-address"));
        Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
        if (!response.isSuccess()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LiDJKmW_44a47b5", (String)"\u8ba4\u8bc1\u63d0\u4ea4\u5931\u8d25:") + response.getMessage());
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        EsignAuthResponseVO esignAuthResponseVO = (EsignAuthResponseVO)JSON.parseObject((String)jsonObject.toJSONString(), EsignAuthResponseVO.class);
        elsSubaccountCertificationInfo.setLongLink(esignAuthResponseVO.getAuthUrl());
        elsSubaccountCertificationInfo.setShortLink(esignAuthResponseVO.getAuthShortUrl());
        elsSubaccountCertificationInfo.setEsignFlowId(esignAuthResponseVO.getAuthFlowId());
        elsSubaccountCertificationInfo.setCertificationStartTime(new Date());
        this.updateById((Object)elsSubaccountCertificationInfo);
    }

    @Override
    public Result<?> getCertificationInfo(String id) {
        ElsSubaccountCertificationInfo certificationInfo = (ElsSubaccountCertificationInfo)((Object)this.getById((Serializable)((Object)id)));
        if (certificationInfo != null) {
            JSONObject param = new JSONObject();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("flowId", certificationInfo.getEsignFlowId());
            param.put("base", map);
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(param, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-auth-info"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_tkKm_2f078e83", (String)"\u64cd\u4f5c\u5931\u8d25") + "\uff1a" + response.getMessage()));
            }
            JSONObject data = (JSONObject)response.getResult();
            String status = data.getString("status");
            if (!"SUCCESS".equals(status)) {
                if ("INIT".equals(status)) {
                    return Result.error((String)I18nUtil.translate((String)"i18n_alert_rVHWIhAWLiWtsLLiMWVKdVELCtLiKyHcLiW_763da9fc", (String)"\u8be5\u4fe1\u606f\u201c\u5df2\u53d1\u8d77\u201d\u8ba4\u8bc1\uff0c\u4f46\u8fd8\u672a\u8ba4\u8bc1\u5b8c\uff0c\u8bf7\u5728\u8be6\u60c5\u9875\u9762\u70b9\u51fb\u8ba4\u8bc1\u94fe\u63a5\u8fdb\u884c\u8ba4\u8bc1\uff01"));
                }
                if ("ING".equals(status)) {
                    return Result.error((String)I18nUtil.translate((String)"i18n_alert_rVHjLizELWHcsWWVLyVEoLiMLW_b5d7fad0", (String)"\u8be5\u4fe1\u606f\u7684\u8ba4\u8bc1\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u8bf7\u60a8\u8010\u5fc3\u7b49\u5f85\u8ba4\u8bc1\u5b8c\u6210\uff01"));
                }
                return Result.error((String)I18nUtil.translate((String)"i18n__rVHLizELWIKmWWVLVVLiW_8dcfc898", (String)"\u8be5\u4fe1\u606f\u8ba4\u8bc1\u72b6\u6001\u4e3a\u201c\u5df2\u5931\u8d25\u201d\uff0c\u8bf7\u60a8\u91cd\u65b0\u8ba4\u8bc1\uff01"));
            }
            certificationInfo.setCertificationStatus("1");
            ((ElsSubaccountCertificationInfoMapper)this.baseMapper).updateById((Object)certificationInfo);
            return Result.ok((String)I18nUtil.translate((String)"i18n_title_operationSuccess", (String)"\u64cd\u4f5c\u6210\u529f\uff01"));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_VNjWWjSWmhxuIdjWFW_5a452366", (String)"\u4f20\u5165\u7684id\u6709\u8bef\uff0c\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff01"));
    }

    @Override
    public void personCallBack(JSONObject object) {
        PersonAuthCallBakVO authCallBakVO = (PersonAuthCallBakVO)JSON.parseObject((String)object.toJSONString(), PersonAuthCallBakVO.class);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"esign_flow_id", (Object)authCallBakVO.getFlowId());
        List certificationInfos = this.list((Wrapper)wrapper);
        if (!certificationInfos.isEmpty()) {
            ElsSubaccountCertificationInfo certificationInfo = (ElsSubaccountCertificationInfo)((Object)certificationInfos.get(0));
            JSONObject obj = new JSONObject();
            if (authCallBakVO.isSuccess()) {
                certificationInfo.setCertificationStatus("1");
                certificationInfo.setVerifyCode(authCallBakVO.getVerifycode());
                this.updateById((Object)certificationInfo);
                obj.put("authResult", (Object)"\u6210\u529f");
            } else {
                obj.put("authResult", (Object)"\u5931\u8d25");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public Result<?> modifyAuthInfo(ElsSubaccountCertificationInfo elsSubaccountCertificationInfo) {
        ElsSubaccountCertificationInfo dbCertification = (ElsSubaccountCertificationInfo)((Object)this.getById((Serializable)((Object)elsSubaccountCertificationInfo.getId())));
        String optType = "modify";
        if (!dbCertification.getIdNumber().equals(elsSubaccountCertificationInfo.getIdNumber())) {
            if (CertificationStatusEnum.CHANGING.getValue().equals(dbCertification.getCertificationStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u53d8\u66f4\u4e2d\u7684\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u5141\u8bb8\u4fee\u6539\u8bc1\u4ef6\u53f7\uff01"));
            }
            optType = "new";
        }
        this.updateElsSubaccountCertificationInfo(elsSubaccountCertificationInfo);
        if ("new".equals(optType)) {
            EsignCreatePersonAccountVO accountVO = (EsignCreatePersonAccountVO)SysUtil.copyProperties((Object)((Object)elsSubaccountCertificationInfo), EsignCreatePersonAccountVO.class);
            accountVO.setThirdPartyUserId(dbCertification.getThirdPartyUserId());
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)accountVO)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("create-person-account"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
            if (!response.isSuccess()) throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LiDJKmW_44a47b5", (String)"\u8ba4\u8bc1\u63d0\u4ea4\u5931\u8d25:") + response.getMessage());
            ElsSubaccountCertificationInfo certificationInfo = (ElsSubaccountCertificationInfo)((Object)JSON.parseObject((String)response.getResult().toString(), ElsSubaccountCertificationInfo.class));
            elsSubaccountCertificationInfo.setAccountId(certificationInfo.getAccountId());
            int createTimes = Integer.valueOf((String)ObjectUtil.defaultIfBlank((CharSequence)dbCertification.getFbk7(), (CharSequence)"0")) + 1;
            elsSubaccountCertificationInfo.setFbk7(String.valueOf(createTimes));
            this.updateById((Object)elsSubaccountCertificationInfo);
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_crLR_25ddaeda", (String)"\u4fee\u6539\u6210\u529f"));
        } else {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("accountId", (Object)elsSubaccountCertificationInfo.getAccountId());
            requestJSON.put("base", (Object)bascis);
            EsignCreatePersonAccountVO accountVO = (EsignCreatePersonAccountVO)SysUtil.copyProperties((Object)((Object)elsSubaccountCertificationInfo), EsignCreatePersonAccountVO.class);
            accountVO.setThirdPartyUserId(elsSubaccountCertificationInfo.getId());
            requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)accountVO)));
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("modify-person-account"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
            if (!response.isSuccess()) throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_crKmW_95bef49b", (String)"\u4fee\u6539\u5931\u8d25:") + response.getMessage());
            this.updateById((Object)elsSubaccountCertificationInfo);
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_crLR_25ddaeda", (String)"\u4fee\u6539\u6210\u529f"));
    }

    @Override
    public Result<?> silentAuth(ElsSubaccountCertificationInfo elsSubaccountCertificationInfo) {
        JSONObject requestJSON = new JSONObject();
        JSONObject bascis = new JSONObject();
        bascis.put("accountId", (Object)elsSubaccountCertificationInfo.getAccountId());
        requestJSON.put("base", (Object)bascis);
        JSONObject body = new JSONObject();
        body.put("deadline", (Object)"2099-01-01 00:00:00");
        requestJSON.put("body", (Object)body);
        JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("silent-auth-account"));
        Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
        if (!response.isSuccess()) {
            return Result.error((String)(I18nUtil.translate((String)"i18n_alert_crKmW_95bef49b", (String)"\u4fee\u6539\u5931\u8d25:") + response.getMessage()));
        }
        elsSubaccountCertificationInfo.setSilentAuthStatus("1");
        this.updateById((Object)elsSubaccountCertificationInfo);
        return Result.ok((String)I18nUtil.translate((String)"i18n_title_successfulAuthorizationThanksSupport", (String)"\u6388\u6743\u6210\u529f"));
    }

    @Override
    public JSONObject psnAuthCallBack4V3(JSONObject object) {
        log.info("e\u7b7e\u5b9d-V3\u4e2a\u4eba\u8ba4\u8bc1&\u6388\u6743\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)object);
        EsignAuthCallbackVO authCallBakVO = (EsignAuthCallbackVO)JSON.parseObject((String)object.toJSONString(), EsignAuthCallbackVO.class);
        if ("AUTH_PASS".equals(authCallBakVO.getAction())) {
            this.authCallbackProccessor(authCallBakVO);
        } else if ("AUTHORIZE_FINISH".equals(authCallBakVO.getAction())) {
            this.authorizedCallbackProccessor(authCallBakVO);
        } else {
            log.error("e\u7b7e\u5b9d-V3\u4e2a\u4eba\u8ba4\u8bc1&\u6388\u6743\u56de\u8c03\uff0c\u6d41\u7a0b[{}]-\u8ba4\u8bc1\u4e3b\u4f53[{}]-\u901a\u77e5\u7c7b\u578b[{}]\u6ca1\u6709\u76f8\u5e94\u7684\u901a\u77e5\u7c7b\u578b\u5904\u7406\uff01", new Object[]{authCallBakVO.getAuthFlowId(), authCallBakVO.getAuthType(), authCallBakVO.getAction()});
        }
        JSONObject resp = new JSONObject();
        resp.put("code", (Object)"200");
        resp.put("msg", (Object)"success");
        return resp;
    }

    private void authorizedCallbackProccessor(EsignAuthCallbackVO authCallBakVO) {
        List certificationInfos = ((LambdaQueryChainWrapper)this.lambdaQuery().select(new SFunction[]{BaseEntity::getId}).eq(ElsSubaccountCertificationInfo::getEsignFlowId, (Object)authCallBakVO.getAuthFlowId())).list();
        if (CollectionUtil.isNotEmpty((Collection)certificationInfos)) {
            ElsSubaccountCertificationInfo certificationInfo = new ElsSubaccountCertificationInfo();
            certificationInfo.setId(((ElsSubaccountCertificationInfo)((Object)certificationInfos.get(0))).getId());
            certificationInfo.setFbk2("1");
            List<EsignAuthCallbackVO.AuthorizedInfo> authorizedInfos = authCallBakVO.getAuthorizedInfo();
            if (CollectionUtil.isNotEmpty(authorizedInfos)) {
                certificationInfo.setFbk3(String.valueOf(authorizedInfos.get(0).getEffectiveTime()));
                certificationInfo.setFbk4(String.valueOf(authorizedInfos.get(0).getExpireTime()));
            }
            certificationInfo.setCertificationStatus("1");
            certificationInfo.setFbk1(authCallBakVO.getPsnId());
            this.updateById((Object)certificationInfo);
        }
    }

    private void authCallbackProccessor(EsignAuthCallbackVO authCallBakVO) {
        List certificationInfos = ((LambdaQueryChainWrapper)this.lambdaQuery().select(new SFunction[]{BaseEntity::getId}).eq(ElsSubaccountCertificationInfo::getEsignFlowId, (Object)authCallBakVO.getAuthFlowId())).list();
        if (CollectionUtil.isNotEmpty((Collection)certificationInfos)) {
            ElsSubaccountCertificationInfo certificationInfo = new ElsSubaccountCertificationInfo();
            certificationInfo.setId(((ElsSubaccountCertificationInfo)((Object)certificationInfos.get(0))).getId());
            certificationInfo.setCertificationStatus("1");
            EsignAuthCallbackVO.PsnInfo psnInfo = authCallBakVO.getPsnInfo();
            if (psnInfo != null) {
                certificationInfo.setFbk1(psnInfo.getPsnId());
            }
            this.updateById((Object)certificationInfo);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void getAuthorization(ElsSubaccountCertificationInfo certificationInfo) {
        ElsSubaccountCertificationInfo dbCertificationInfo = (ElsSubaccountCertificationInfo)((Object)this.getById((Serializable)((Object)certificationInfo.getId())));
        String notifyUrl = this.address.endsWith("/") ? this.address + "els/esign/elsSubaccountCertificationInfo/v3/callback/psnAuth" : this.address + "/els/esign/elsSubaccountCertificationInfo/v3/callback/psnAuth";
        EsignPsnAuthEO esignPsnAuthEO = new EsignPsnAuthEO(dbCertificationInfo, notifyUrl);
        JSONObject requestJSON = new JSONObject();
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)esignPsnAuthEO)));
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-v3-psn-auth-address"));
        Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
        if (!response.isSuccess()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6388\u6743\u63d0\u4ea4\u5931\u8d25:") + response.getMessage());
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        EsignAuthResponseVO esignAuthResponseVO = (EsignAuthResponseVO)JSON.parseObject((String)jsonObject.toJSONString(), EsignAuthResponseVO.class);
        dbCertificationInfo.setFbk2("0");
        dbCertificationInfo.setFbk5(esignAuthResponseVO.getAuthUrl());
        dbCertificationInfo.setFbk6(esignAuthResponseVO.getAuthShortUrl());
        dbCertificationInfo.setEsignFlowId(esignAuthResponseVO.getAuthFlowId());
        this.updateById((Object)dbCertificationInfo);
    }

    @Override
    public void cancel4Supplier(String id) {
        ElsSubaccountCertificationInfo certification = (ElsSubaccountCertificationInfo)((Object)this.getById((Serializable)((Object)id)));
        Assert.isNotNull((Object)((Object)certification), (String)I18nUtil.translate((String)"", (String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01"));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsSubaccountCertificationInfo::getCertificationStatus, (Object)"2")).eq(BaseEntity::getId, (Object)id)).update((Object)new ElsSubaccountCertificationInfo());
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void changeCertification(ElsSubaccountCertificationInfo certificationInfo) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsSubaccountCertificationInfo::getCertificationStatus, (Object)CertificationStatusEnum.CHANGING.getValue())).set(ElsSubaccountCertificationInfo::getLongLink, (Object)"")).set(ElsSubaccountCertificationInfo::getShortLink, (Object)"")).set(ElsSubaccountCertificationInfo::getFbk5, (Object)"")).set(ElsSubaccountCertificationInfo::getFbk6, (Object)"")).eq(BaseEntity::getId, (Object)certificationInfo.getId())).update((Object)new ElsSubaccountCertificationInfo());
    }
}

