/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.TemplateParseUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.contract.dto.PurchaseContractContentItemDTO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.contract.dto.PurchaseContractItemDTO;
import com.els.modules.contract.dto.SaleContractHeadDTO;
import com.els.modules.contract.enumerate.ContractItemSourceTypeEnum;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.enquiry.api.dto.PurchaseEnquiryItemDTO;
import com.els.modules.enquiry.api.service.PurchaseEnquiryItemRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.esign.entity.ElsEsign;
import com.els.modules.esign.entity.ElsSigners;
import com.els.modules.esign.enumerate.EsignBusTypeEnum;
import com.els.modules.esign.enumerate.EsignRoleTypeEnum;
import com.els.modules.esign.enumerate.EsignSignerStatusEmun;
import com.els.modules.esign.enumerate.EsignStatusEmun;
import com.els.modules.esign.rpc.service.EsignInvokeBaseRpcService;
import com.els.modules.esign.rpc.service.EsignInvokeContractRpcService;
import com.els.modules.esign.rpc.service.EsignInvokeOrderRpcService;
import com.els.modules.esign.rpc.service.EsignInvokeSupplierRpcService;
import com.els.modules.esign.service.ElsEsignService;
import com.els.modules.esign.service.ElsSignersService;
import com.els.modules.esign.service.EsignOperationService;
import com.els.modules.esign.util.EsignFileEncryptUtil;
import com.els.modules.esign.util.EsignResultAnalysisUtil;
import com.els.modules.esign.util.FileHelper;
import com.els.modules.esign.util.NumberUtil;
import com.els.modules.esign.util.PdfUtil;
import com.els.modules.esign.vo.CreateFlowOneStep;
import com.els.modules.esign.vo.ElsEsignVO;
import com.els.modules.esign.vo.EsignAttachmentVO;
import com.els.modules.esign.vo.EsignCopiersVO;
import com.els.modules.esign.vo.EsignDocsVO;
import com.els.modules.esign.vo.EsignFlowInfoVO;
import com.els.modules.esign.vo.EsignPurchaseContractItemVO;
import com.els.modules.esign.vo.EsignSignerVO;
import com.els.modules.extend.api.dto.EsignExtendDTO;
import com.els.modules.extend.api.service.EsignExtendService;
import com.els.modules.extend.api.util.DateFormatValueFilter;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.enumerate.EsignFinalStatusEnum;
import com.els.modules.supplier.api.dto.SupplierBankInfoDTO;
import com.els.modules.supplier.api.dto.SupplierContactsInfoDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EsignOperationServiceImpl
implements EsignOperationService {
    private static final Logger log = LoggerFactory.getLogger(EsignOperationServiceImpl.class);
    private static final Integer A_SIGNED = 2;
    private static final Integer LOSE = 3;
    private static final Integer REFUSAL = 4;
    private static final String SIGN_FLOW_UPDATE = "SIGN_FLOW_UPDATE";
    private static final String SIGN_FLOW_FINISH = "SIGN_FLOW_FINISH";
    @Value(value="${els.path.upload}")
    private String uploadpath;
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private EsignInvokeContractRpcService esignInvokeContractRpcService;
    @Autowired
    private EsignInvokeOrderRpcService esignInvokeOrderRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsEsignService elsEsignService;
    @Autowired
    private ElsSignersService elsSignersService;
    @Autowired
    private EsignInvokeBaseRpcService esignInvokeBaseRpcService;
    @Resource(name="srmPoolExecutor")
    private ThreadPoolExecutor srmPoolExecutor;
    @Lazy
    @Autowired
    private PurchaseEnquiryItemRpcService purchaseEnquiryItemRpcService;
    @Autowired
    private EsignInvokeSupplierRpcService esignInvokeSupplierRpcService;

    @Override
    public Result<?> uploadFile(ElsEsignVO esign, HttpServletRequest request, HttpServletResponse response) {
        block23: {
            String cookie = request.getHeader("cookie");
            if (StringUtils.isNotBlank((CharSequence)esign.getId())) {
                this.elsEsignService.updateById((Object)esign);
            } else {
                this.elsEsignService.save((Object)esign);
            }
            String busName = null;
            String busVersion = null;
            String busNumber = null;
            if (EsignBusTypeEnum.CONTRACT.getValue().equals(esign.getBusType())) {
                PurchaseContractHeadDTO contractBuyHead = this.esignInvokeContractRpcService.getPurchaseContractById(esign.getRelationId());
                busName = contractBuyHead.getContractName();
                busVersion = contractBuyHead.getContractVersion();
                busNumber = contractBuyHead.getContractNumber();
            } else if (EsignBusTypeEnum.ORDER.getValue().equals(esign.getBusType())) {
                PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.esignInvokeOrderRpcService.getPurchaseOrderById(esign.getRelationId());
                busName = purchaseOrderHeadDTO.getOrderNumber();
                busVersion = purchaseOrderHeadDTO.getOrderVersion();
                busNumber = purchaseOrderHeadDTO.getOrderNumber();
            }
            InputStream inputStream = null;
            File file = null;
            try {
                if ("sale".equals(esign.getFirstSeal()) && !"1".equals(esign.getOnlineSealed())) {
                    List attachment = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(esign.getId());
                    if (attachment.isEmpty()) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RCLXVPWQI_dbdd64c5", (String)"\u4f9b\u65b9\u672a\u4e0a\u4f20\u7b7e\u7f72\u6587\u4ef6"));
                    }
                    String tempPath = this.uploadpath + ((PurchaseAttachmentDTO)attachment.get(0)).getFilePath();
                    file = new File(tempPath);
                } else {
                    file = this.getFileById(esign.getRelationId(), esign.getBusType(), busNumber, busVersion, esign.getReportUrl(), esign.getToken(), cookie);
                }
                if (file != null && file.exists()) {
                    String path = file.getPath();
                    log.info("path=" + path);
                    response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
                    inputStream = new BufferedInputStream(new FileInputStream(file));
                    byte[] bytes = EsignFileEncryptUtil.getFileMD5Bytes1282(inputStream);
                    String contentMD5 = EsignFileEncryptUtil.getStringContentMD5(bytes);
                    int fileSize = bytes.length;
                    EsignAttachmentVO attachmentVO = null;
                    int lastIndexOf = path.lastIndexOf("/");
                    attachmentVO = path.endsWith(".pdf") ? new EsignAttachmentVO(contentMD5, path.substring(lastIndexOf + 1), fileSize, null) : new EsignAttachmentVO(contentMD5, path.substring(lastIndexOf + 1), fileSize, "application/octet-stream");
                    JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSONObject.parseObject((String)JSONObject.toJSONString((Object)attachmentVO)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("upload-file"));
                    Result<?> responseResult = EsignResultAnalysisUtil.analysisResult(object);
                    if (responseResult.isSuccess()) {
                        JSONObject jsonObject = (JSONObject)responseResult.getResult();
                        String uploadUrl = jsonObject.getString("uploadUrl");
                        String fileId = jsonObject.getString("fileId");
                        esign.setFilesId(fileId);
                        esign.setDeleted(CommonConstant.DEL_FLAG_0);
                        esign.setFilesName(busName + ".pdf");
                        try {
                            FileHelper.streamUpload(path, uploadUrl, attachmentVO.getContentMd5());
                            esign.setUploaded("1");
                            this.elsEsignService.updateById((Object)esign);
                            break block23;
                        }
                        catch (Exception e) {
                            throw new ELSBootException(I18nUtil.translate((String)"i18n_title_uploadError", (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a") + e.getMessage());
                        }
                    }
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_title_uploadError", (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a") + responseResult.getMessage());
                }
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SMxuXVQI_34a31727", (String)"\u83b7\u53d6\u4e0d\u5230\u4e0a\u4f20\u6587\u4ef6"));
            }
            catch (Exception e) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a") + e.getMessage());
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                        if (EsignBusTypeEnum.ORDER.getValue().equals(esign.getBusType()) && file != null && file.exists() && "1".equals(esign.getOnlineSealed())) {
                            file.delete();
                        }
                    }
                    catch (IOException e) {
                        log.error("printStackTrace:", (Throwable)e);
                    }
                }
            }
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_PWQIXVLR_d4866ee8", (String)"\u7b7e\u7f72\u6587\u4ef6\u4e0a\u4f20\u6210\u529f"));
    }

    private List<EsignPurchaseContractItemVO> mergeItem(List<PurchaseContractItemDTO> purchaseContractItemList) {
        ArrayList<EsignPurchaseContractItemVO> purchaseContractItemVOList = new ArrayList<EsignPurchaseContractItemVO>();
        for (PurchaseContractItemDTO contractItemDTO : purchaseContractItemList) {
            EsignPurchaseContractItemVO itemVO = new EsignPurchaseContractItemVO();
            if (contractItemDTO.getSourceType().equals(ContractItemSourceTypeEnum.ENQUIRY.getValue())) {
                PurchaseEnquiryItemDTO enquiryItem = this.purchaseEnquiryItemRpcService.getEnquiryItemById(contractItemDTO.getSourceItemId());
                BeanUtils.copyProperties((Object)enquiryItem, (Object)((Object)itemVO));
                itemVO.setE_itemNumber(enquiryItem.getItemNumber());
                itemVO.setE_fbk1(enquiryItem.getFbk1());
                itemVO.setE_fbk2(enquiryItem.getFbk2());
                itemVO.setE_fbk3(enquiryItem.getFbk3());
                itemVO.setE_fbk4(enquiryItem.getFbk4());
                itemVO.setE_fbk5(enquiryItem.getFbk5());
            } else if (contractItemDTO.getSourceType().equals(ContractItemSourceTypeEnum.ORDER.getValue()) || contractItemDTO.getSourceType().equals(ContractItemSourceTypeEnum.PURCHAS_REQUEST.getValue())) {
                // empty if block
            }
            BeanUtils.copyProperties((Object)contractItemDTO, (Object)((Object)itemVO));
            purchaseContractItemVOList.add(itemVO);
        }
        return purchaseContractItemVOList;
    }

    @Override
    public File getFileById(String id, String busType, String busNumber, String busVersion, String reportUrl, String token, String cookie) {
        String path = null;
        if (EsignBusTypeEnum.CONTRACT.getValue().equals(busType)) {
            String html = this.getContractHtml(id);
            if (StringUtils.isBlank((CharSequence)html)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VmQIxOXV_825e3ab8", (String)"\u7a7a\u767d\u6587\u4ef6\u4e0d\u80fd\u4e0a\u4f20"));
            }
            try {
                path = PdfUtil.htmlToPdf(this.uploadpath, html, busNumber + "_" + busVersion, null);
            }
            catch (Exception e1) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QISMKmW_e0294b38", (String)"\u6587\u4ef6\u83b7\u53d6\u5931\u8d25\uff1a") + e1.getMessage());
            }
            log.info("path=" + path);
            File file = new File(path);
            return file;
        }
        if (EsignBusTypeEnum.ORDER.getValue().equals(busType)) {
            EsignExtendDTO esignExtendDTO = new EsignExtendDTO();
            esignExtendDTO.setBusType(busType);
            esignExtendDTO.setPrintBusinessType("order");
            esignExtendDTO.setRelationId(id);
            esignExtendDTO.setToken(token);
            esignExtendDTO.setCookie(cookie);
            return ((EsignExtendService)SpringContextUtils.getBean(EsignExtendService.class)).getPrintFile(esignExtendDTO);
        }
        return null;
    }

    @Override
    public String getContractHtml(String id) {
        List supplierAdminS;
        PurchaseContractHeadDTO purchaseContractHead = this.esignInvokeContractRpcService.getPurchaseContractById(id);
        List<PurchaseContractItemDTO> purchaseContractItemList = this.esignInvokeContractRpcService.getItemListByMainId(id);
        List<PurchaseContractContentItemDTO> purchaseContractContentItemList = this.esignInvokeContractRpcService.getContentItemListByMainId(id);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        List<EsignPurchaseContractItemVO> purchaseContractItemVOList = this.mergeItem(purchaseContractItemList);
        JSONObject jsonObject = (JSONObject)JSONObject.parse((String)JSONObject.toJSONString((Object)purchaseContractHead, (SerializeFilter)new DateFormatValueFilter(), (SerializerFeature[])new SerializerFeature[0]));
        jsonObject.put("purchaseContractItemList", purchaseContractItemList);
        jsonObject.put("purchaseContractItemVOList", purchaseContractItemVOList);
        jsonObject.put("purchaseContractContentItemList", purchaseContractContentItemList);
        jsonObject.put("purchaseAttachmentList", (Object)purchaseAttachmentList);
        ElsEnterpriseInfoDTO supplierEnterprise = this.esignInvokeSupplierRpcService.getSupplierEnterpriseInfo(purchaseContractHead.getToElsAccount());
        List<SupplierContactsInfoDTO> supplierContractList = this.esignInvokeSupplierRpcService.listSupplierContractInfo(purchaseContractHead.getToElsAccount());
        List<SupplierBankInfoDTO> supplierBankList = this.esignInvokeSupplierRpcService.listSupplierBankInfo(purchaseContractHead.getToElsAccount());
        jsonObject.put("msupplierTaxNumber", (Object)supplierEnterprise.getTaxNumber());
        jsonObject.put("msupplierLegalPerson", (Object)supplierEnterprise.getLegalPersonName());
        jsonObject.put("msupplierAddress", (Object)supplierEnterprise.getRegLocation());
        if (CollectionUtil.isNotEmpty(supplierContractList) && CollectionUtil.isNotEmpty(supplierAdminS = supplierContractList.stream().filter(o -> "1001".equals(o.getSubAccount())).collect(Collectors.toList()))) {
            jsonObject.put("msupplierPhone", (Object)((SupplierContactsInfoDTO)supplierAdminS.get(0)).getTelphone());
            jsonObject.put("msupplierMail", (Object)((SupplierContactsInfoDTO)supplierAdminS.get(0)).getEmail());
            jsonObject.put("msalePrincipal", (Object)((SupplierContactsInfoDTO)supplierAdminS.get(0)).getName());
        }
        if (CollectionUtil.isNotEmpty(supplierBankList)) {
            jsonObject.put("msupplierBankAccount", (Object)supplierBankList.get(0).getBankAccount());
            jsonObject.put("msupplierBankName", (Object)supplierBankList.get(0).getBankBranchName());
        }
        for (Map.Entry next : jsonObject.entrySet()) {
            if (!((String)next.getKey()).contains("_dictText") || next.getValue() == null || String.valueOf(next.getValue()).split("_").length <= 1) continue;
            next.setValue(next.getValue().toString().split("_")[1]);
        }
        Map param = (Map)JSON.parse((String)jsonObject.toString());
        param.put("itemList", param.get("purchaseContractItemVOList"));
        List<PurchaseContractContentItemDTO> contractBuyContentItemList = this.esignInvokeContractRpcService.getContentItemListByMainId(id);
        if (CollectionUtils.isEmpty(contractBuyContentItemList)) {
            // empty if block
        }
        int index = 0;
        StringBuilder html = new StringBuilder();
        for (PurchaseContractContentItemDTO item : contractBuyContentItemList) {
            if ("3".equals(item.getItemType()) || "4".equals(item.getItemType())) {
                param.put("index", ++index);
                param.put("zh_index", NumberUtil.number2Chinese(index));
            }
            String itemContent = item.getItemContent();
            if ("4".equals(item.getItemType())) {
                itemContent = PdfUtil.changeTemplate(itemContent);
            }
            String content = "";
            if (StringUtils.isNotBlank((CharSequence)itemContent)) {
                content = TemplateParseUtil.getTemplateText((String)"", (String)itemContent, (Map)param);
            }
            html.append(content);
        }
        return html.toString();
    }

    @Override
    public Result<?> createFlowOneStep(ElsEsign esign) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"head_id", (Object)esign.getId());
        wrapper.eq((Object)"role_type", (Object)"0");
        List purhcaseSigners = this.elsSignersService.list((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)purhcaseSigners)) {
            purhcaseSigners.stream().forEach(signer -> {
                if ("1".equals(signer.getAutoArchive())) {
                    // empty if block
                }
            });
        }
        wrapper.clear();
        wrapper.eq((Object)"head_id", (Object)esign.getId());
        wrapper.eq((Object)"role_type", (Object)"1");
        List saleSigners = this.elsSignersService.list((Wrapper)wrapper);
        ArrayList<EsignSignerVO> signerVOs = new ArrayList<EsignSignerVO>();
        if ("sale".equals(esign.getFirstSeal())) {
            if (!saleSigners.isEmpty()) {
                signerVOs.add(new EsignSignerVO((ElsSigners)((Object)saleSigners.get(0)), 1L, "sale"));
                signerVOs.add(new EsignSignerVO((ElsSigners)((Object)purhcaseSigners.get(0)), 2L, "purchase"));
            } else {
                signerVOs.add(new EsignSignerVO((ElsSigners)((Object)purhcaseSigners.get(0)), 1L, "purchase"));
            }
        } else {
            if (!saleSigners.isEmpty()) {
                signerVOs.add(new EsignSignerVO((ElsSigners)((Object)saleSigners.get(0)), 2L, "sale"));
            }
            signerVOs.add(new EsignSignerVO((ElsSigners)((Object)purhcaseSigners.get(0)), 1L, "purchase"));
        }
        String notifyUrl = "";
        notifyUrl = this.address.endsWith("/") ? this.address + "els/esign/esignOperation/callback/esign" : this.address + "/els/esign/esignOperation/callback/esign";
        CreateFlowOneStep flowOneStep = new CreateFlowOneStep();
        flowOneStep.setSigners(signerVOs);
        ArrayList<EsignCopiersVO> copiersVOs = new ArrayList<EsignCopiersVO>();
        EsignCopiersVO copiersVO = new EsignCopiersVO();
        copiersVO.setCopierAccountId(((ElsSigners)((Object)purhcaseSigners.get(0))).getAccountId());
        copiersVO.setCopierIdentityAccountId(((ElsSigners)((Object)purhcaseSigners.get(0))).getOrgId());
        copiersVO.setCopierIdentityAccountType("1");
        copiersVOs.add(copiersVO);
        flowOneStep.setCopiers(copiersVOs);
        ArrayList<EsignDocsVO> docsVOs = new ArrayList<EsignDocsVO>();
        EsignDocsVO docsVO = new EsignDocsVO();
        docsVO.setFileId(esign.getFilesId());
        docsVO.setFileName(esign.getFilesName());
        docsVOs.add(docsVO);
        flowOneStep.setDocs(docsVOs);
        EsignFlowInfoVO flowInfoVO = new EsignFlowInfoVO(esign, (ElsSigners)((Object)purhcaseSigners.get(0)), notifyUrl);
        flowOneStep.setFlowInfo(flowInfoVO);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSONObject.parseObject((String)JSONObject.toJSONString((Object)flowOneStep)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("one-step-flow-start"));
        Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
        if (!response.isSuccess()) {
            return Result.error((String)(I18nUtil.translate((String)"i18n_alert_IxPWhAKmW_f40249c7", (String)"\u4e00\u6b65\u7b7e\u7f72\u53d1\u8d77\u5931\u8d25:") + response.getMessage()));
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        esign.setFlowId(jsonObject.getString("flowId"));
        esign.setLaunch("1");
        esign.setEsignStatus(EsignStatusEmun.UNFINISHED.getValue());
        if ("1".equals(esign.getAutoInitiate())) {
            esign.setInitiate("1");
        }
        esign.setReason("");
        this.elsEsignService.updateById((Object)esign);
        ((ElsSigners)((Object)purhcaseSigners.get(0))).setFlowId(esign.getFlowId());
        this.elsSignersService.updateById(purhcaseSigners.get(0));
        if (!saleSigners.isEmpty()) {
            ((ElsSigners)((Object)saleSigners.get(0))).setFlowId(esign.getFlowId());
            this.elsSignersService.updateById(saleSigners.get(0));
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_hALR_28390cd5", (String)"\u53d1\u8d77\u6210\u529f"));
    }

    @Override
    public void esignSigner(JSONObject object) {
        log.info("e\u7b7e\u5b9d\u7b7e\u7f72\u6d41\u7a0b\u56de\u8c03[{}]", (Object)object.toJSONString());
        if (SIGN_FLOW_UPDATE.equals(object.getString("action"))) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"flow_id", (Object)object.getString("flowId"));
            wrapper.eq((Object)"account_id", (Object)object.getString("accountId"));
            List signers = this.elsSignersService.list((Wrapper)wrapper);
            if (!signers.isEmpty()) {
                ElsSigners elsSigners = (ElsSigners)((Object)signers.get(0));
                if (A_SIGNED.equals(object.getInteger("signResult"))) {
                    elsSigners.setEsignStatus(EsignSignerStatusEmun.A_SIGNED.getValue());
                } else if (LOSE.equals(object.getInteger("signResult"))) {
                    elsSigners.setEsignStatus(EsignSignerStatusEmun.LOSE.getValue());
                    elsSigners.setReason(object.getString("resultDescription"));
                } else if (REFUSAL.equals(object.getInteger("signResult"))) {
                    elsSigners.setEsignStatus(EsignSignerStatusEmun.REFUSAL.getValue());
                    elsSigners.setReason(object.getString("resultDescription"));
                }
                this.elsSignersService.updateById((Object)elsSigners);
                ElsEsign esign = (ElsEsign)((Object)this.elsEsignService.getById((Serializable)((Object)elsSigners.getHeadId())));
                if (EsignRoleTypeEnum.PURCHASE.getValue().equals(elsSigners.getRoleType())) {
                    esign.setPurchaseEsignStatus(elsSigners.getEsignStatus());
                } else {
                    esign.setSaleEsignStatus(elsSigners.getEsignStatus());
                }
                this.elsEsignService.updateById((Object)esign);
            }
        } else if (SIGN_FLOW_FINISH.equals(object.getString("action"))) {
            String flowStatus = object.getString("flowStatus");
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"flow_id", (Object)object.getString("flowId"));
            List esigns = this.elsEsignService.list((Wrapper)wrapper);
            if (!esigns.isEmpty()) {
                PurchaseOrderHeadDTO purchaseOrderHeadDTO;
                ElsEsign esign = (ElsEsign)((Object)esigns.get(0));
                esign.setEsignStatus(flowStatus);
                if (EsignStatusEmun.UNDONE.getValue().equals(flowStatus)) {
                    esign.setLaunch("0");
                    if (!"1".equals(esign.getAutoInitiate())) {
                        esign.setInitiate("0");
                    }
                }
                if (EsignStatusEmun.FINISHED.getValue().equals(flowStatus) && "1".equals(esign.getAutoArchiving())) {
                    esign.setArchiving("1");
                }
                esign.setReason(object.getString("statusDescription"));
                if (EsignStatusEmun.FINISHED.getValue().equals(flowStatus)) {
                    esign.setPurchaseEsignStatus(EsignSignerStatusEmun.A_SIGNED.getValue());
                    esign.setSaleEsignStatus(EsignSignerStatusEmun.A_SIGNED.getValue());
                }
                this.elsEsignService.updateById((Object)esign);
                if (EsignBusTypeEnum.CONTRACT.getValue().equals(esign.getBusType())) {
                    PurchaseContractHeadDTO contractHead = this.esignInvokeContractRpcService.getPurchaseContractById(esign.getRelationId());
                    if (contractHead != null) {
                        if (EsignStatusEmun.FINISHED.getValue().equals(flowStatus) && "1".equals(esign.getAutoArchiving())) {
                            contractHead.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
                        }
                        contractHead.setEndSign(esign.getEsignStatus());
                        this.esignInvokeContractRpcService.updatePurchaseEntityById(contractHead);
                        SaleContractHeadDTO saleContractHead = this.esignInvokeContractRpcService.getSaleContractById(contractHead.getRelationId());
                        if (saleContractHead != null) {
                            saleContractHead.setContractStatus(contractHead.getContractStatus());
                            saleContractHead.setEndSign(contractHead.getEndSign());
                            this.esignInvokeContractRpcService.updateSaleEntityById(saleContractHead);
                        }
                    }
                } else if (EsignBusTypeEnum.ORDER.getValue().equals(esign.getBusType()) && (purchaseOrderHeadDTO = this.esignInvokeOrderRpcService.getPurchaseOrderById(esign.getRelationId())) != null && EsignStatusEmun.FINISHED.getValue().equals(flowStatus) && "1".equals(esign.getAutoArchiving())) {
                    purchaseOrderHeadDTO.setEsignFinalStatus(EsignFinalStatusEnum.FINAL.getValue());
                    this.esignInvokeOrderRpcService.updatePurchaseOrderById(purchaseOrderHeadDTO);
                    this.esignInvokeOrderRpcService.updateSaleOrderByRelationId(purchaseOrderHeadDTO);
                }
            }
        }
    }

    @Override
    public Result<?> startFlow(String id) {
        ElsEsign esign = (ElsEsign)((Object)this.elsEsignService.getById((Serializable)((Object)id)));
        if ("1".equals(esign.getAutoInitiate())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFQLLJOvA_ca4b831f", (String)"\u8be5\u5355\u636e\u6d41\u7a0b\u4e3a\u81ea\u52a8\u5f00\u542f"));
        }
        if (esign != null && StringUtils.isNotBlank((CharSequence)esign.getFlowId())) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("flow-start"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_QLvAKmW_3418ff05", (String)"\u6d41\u7a0b\u5f00\u8d77\u5931\u8d25:") + response.getMessage()));
            }
            esign.setInitiate("1");
            this.elsEsignService.updateById((Object)esign);
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_QLvALR_536ca7e8", (String)"\u6d41\u7a0b\u5f00\u542f\u6210\u529f"));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFsLhAIxPWQLWShvA_ed94197", (String)"\u8be5\u5355\u636e\u8fd8\u672a\u53d1\u8d77\u4e00\u6b65\u7b7e\u7f72\u6d41\u7a0b\uff0c\u65e0\u6cd5\u5f00\u542f"));
    }

    @Override
    public Result<?> archiveFlow(String id) {
        ElsEsign esign = (ElsEsign)((Object)this.elsEsignService.getById((Serializable)((Object)id)));
        if ("1".equals(esign.getAutoArchiving())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFQLLJOLA_ca4ba141", (String)"\u8be5\u5355\u636e\u6d41\u7a0b\u4e3a\u81ea\u52a8\u5f52\u6863"));
        }
        if (esign != null && EsignSignerStatusEmun.A_SIGNED.getValue().equals(esign.getPurchaseEsignStatus()) && EsignSignerStatusEmun.A_SIGNED.getValue().equals(esign.getSaleEsignStatus())) {
            PurchaseOrderHeadDTO purchaseOrderHeadDTO;
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("flow-archive"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_QLLAKmW_27c1b3eb", (String)"\u6d41\u7a0b\u5f52\u6863\u5931\u8d25:") + response.getMessage()));
            }
            esign.setArchiving("1");
            esign.setEsignStatus(EsignStatusEmun.FINISHED.getValue());
            this.elsEsignService.updateById((Object)esign);
            if (EsignBusTypeEnum.CONTRACT.getValue().equals(esign.getBusType())) {
                PurchaseContractHeadDTO contractHead = this.esignInvokeContractRpcService.getPurchaseContractById(esign.getRelationId());
                if (contractHead != null) {
                    contractHead.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
                    this.esignInvokeContractRpcService.updatePurchaseEntityById(contractHead);
                    SaleContractHeadDTO saleContractHead = this.esignInvokeContractRpcService.getSaleContractById(contractHead.getRelationId());
                    if (saleContractHead != null) {
                        saleContractHead.setContractStatus(contractHead.getContractStatus());
                        this.esignInvokeContractRpcService.updateSaleEntityById(saleContractHead);
                    }
                }
            } else if (EsignBusTypeEnum.ORDER.getValue().equals(esign.getBusType()) && (purchaseOrderHeadDTO = this.esignInvokeOrderRpcService.getPurchaseOrderById(esign.getRelationId())) != null) {
                purchaseOrderHeadDTO.setEsignFinalStatus(EsignFinalStatusEnum.FINAL.getValue());
                this.esignInvokeOrderRpcService.updatePurchaseOrderById(purchaseOrderHeadDTO);
                this.esignInvokeOrderRpcService.updateSaleOrderByRelationId(purchaseOrderHeadDTO);
            }
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_QLLALR_53ddc58a", (String)"\u6d41\u7a0b\u5f52\u6863\u6210\u529f"));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_LPWMLjQLShHcLA_a16b54a3", (String)"\u672a\u7b7e\u7f72\u5b8c\u6210\u7684\u6d41\u7a0b\u65e0\u6cd5\u8fdb\u884c\u5f52\u6863"));
    }
}

