/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.esign.entity.ElsEnterpriseCertificationInfo;
import com.els.modules.esign.entity.ElsSubaccountCertificationInfo;
import com.els.modules.esign.entity.PurchaseEsignSeals;
import com.els.modules.esign.entity.SaleEsignSeals;
import com.els.modules.esign.mapper.PurchaseEsignSealsMapper;
import com.els.modules.esign.mapper.SaleEsignSealsMapper;
import com.els.modules.esign.service.ElsEnterpriseCertificationInfoService;
import com.els.modules.esign.service.ElsSubaccountCertificationInfoService;
import com.els.modules.esign.service.PurchaseEsignSealsService;
import com.els.modules.esign.util.EsignFileEncryptUtil;
import com.els.modules.esign.util.EsignResultAnalysisUtil;
import com.els.modules.esign.vo.EsignAuthorizationResponseVO;
import com.els.modules.esign.vo.EsignOrgAdminResponseVO;
import com.els.modules.esign.vo.EsignOrgSealCreateEO;
import com.els.modules.esign.vo.EsignOrgSealExternalAuthEO;
import com.els.modules.esign.vo.EsignPsnSealCreateEO;
import com.els.modules.esign.vo.SealVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEsignSealsServiceImpl
extends BaseServiceImpl<PurchaseEsignSealsMapper, PurchaseEsignSeals>
implements PurchaseEsignSealsService {
    @Value(value="${els.path.upload}")
    private String uploadpath;
    @Autowired
    private SaleEsignSealsMapper saleEsignSealsMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsEnterpriseCertificationInfoService elsEnterpriseCertificationInfoService;
    @Autowired
    private ElsSubaccountCertificationInfoService elsSubaccountCertificationInfoService;
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void savePurchaseEsignSeals(PurchaseEsignSeals purchaseEsignSeals) {
        purchaseEsignSeals.setBusAccount(TenantContext.getTenant());
        ElsEnterpriseCertificationInfo certificationInfo = (ElsEnterpriseCertificationInfo)((Object)((LambdaQueryChainWrapper)this.elsEnterpriseCertificationInfoService.lambdaQuery().eq(ElsEnterpriseCertificationInfo::getOrgId, (Object)purchaseEsignSeals.getOrgId())).one());
        if ("1".equals(purchaseEsignSeals.getSealType()) && !"1".equals(certificationInfo.getFbk6())) {
            purchaseEsignSeals.setFbk10("1");
        } else {
            purchaseEsignSeals.setFbk10("0");
        }
        ((PurchaseEsignSealsMapper)this.baseMapper).insert((Object)purchaseEsignSeals);
        if ("1".equals(purchaseEsignSeals.getFbk11())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseEsignSeals::getFbk11, (Object)"0")).ne(BaseEntity::getId, (Object)purchaseEsignSeals.getId())).eq(PurchaseEsignSeals::getSealType, (Object)purchaseEsignSeals.getSealType())).update();
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void updatePurchaseEsignSeals(PurchaseEsignSeals purchaseEsignSeals) {
        ElsEnterpriseCertificationInfo certificationInfo = (ElsEnterpriseCertificationInfo)((Object)((LambdaQueryChainWrapper)this.elsEnterpriseCertificationInfoService.lambdaQuery().eq(ElsEnterpriseCertificationInfo::getOrgId, (Object)purchaseEsignSeals.getOrgId())).one());
        if ("1".equals(purchaseEsignSeals.getSealType()) && !"1".equals(certificationInfo.getFbk6())) {
            purchaseEsignSeals.setFbk10("1");
        }
        ((PurchaseEsignSealsMapper)this.baseMapper).updateById((Object)purchaseEsignSeals);
        if ("1".equals(purchaseEsignSeals.getFbk11())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseEsignSeals::getFbk11, (Object)"0")).ne(BaseEntity::getId, (Object)purchaseEsignSeals.getId())).eq(PurchaseEsignSeals::getSealType, (Object)purchaseEsignSeals.getSealType())).update();
        }
    }

    @Override
    public void delPurchaseEsignSeals(String id) {
        ((PurchaseEsignSealsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseEsignSeals(List<String> idList) {
        ((PurchaseEsignSealsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void send(PurchaseEsignSeals seals) {
        seals.setSendStatus("1");
        SaleEsignSeals saleEsignSeals = (SaleEsignSeals)((Object)SysUtil.copyProperties((Object)((Object)seals), SaleEsignSeals.class));
        saleEsignSeals.setElsAccount(saleEsignSeals.getToElsAccount());
        saleEsignSeals.setToElsAccount(seals.getElsAccount());
        saleEsignSeals.setRelationId(seals.getId());
        saleEsignSeals.setId(null);
        this.saleEsignSealsMapper.insert((Object)saleEsignSeals);
        seals.setRelationId(saleEsignSeals.getId());
        this.updateById((Object)seals);
    }

    @Override
    public Result<?> uploadToEsign(PurchaseEsignSeals seals) {
        if (StringUtils.isNotBlank((CharSequence)seals.getId())) {
            this.updatePurchaseEsignSeals(seals);
        } else {
            this.savePurchaseEsignSeals(seals);
        }
        Result<?> response = null;
        if (StringUtils.isBlank((CharSequence)seals.getSealId())) {
            File file = new File(this.uploadpath + seals.getFilePath());
            if (file.exists() && file.isFile() && file.length() > 0x100000L) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25\uff1a") + I18nUtil.translate((String)"i18n_field_QIfXxOBR_f2502a49", (String)"\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7") + " 1M"));
            }
            String data = null;
            if (file.exists()) {
                data = EsignFileEncryptUtil.fileToBase64(this.uploadpath + seals.getFilePath());
            } else {
                try {
                    data = EsignFileEncryptUtil.GetUrlImageToBase64(seals.getFilePath().toString());
                }
                catch (Exception e) {
                    return Result.error((String)I18nUtil.translate((String)"i18n_alert_XVKmWWePOIH_31bf6c3f", (String)"\u4e0a\u4f20\u5931\u8d25:\u5370\u7ae0\u56fe\u7247\u5f02\u5e38"));
                }
            }
            SealVO sealVO = new SealVO(seals, data);
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            if ("1".equals(seals.getSealType())) {
                bascis.put("accountId", (Object)seals.getOrgId());
            } else {
                bascis.put("accountId", (Object)seals.getAccountId());
            }
            requestJSON.put("base", (Object)bascis);
            requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)sealVO)));
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("create-person-or-org-seal-image"));
            response = EsignResultAnalysisUtil.analysisResult(object);
            if (response.isSuccess()) {
                JSONObject jsonObject = (JSONObject)response.getResult();
                seals.setSealId(jsonObject.getString("sealId"));
                seals.setUploaded("1");
                this.updatePurchaseEsignSeals(seals);
                return Result.ok((String)I18nUtil.translate((String)"i18n_alert_XVLR_24aeb765", (String)"\u4e0a\u4f20\u6210\u529f\uff01"));
            }
            return Result.error((String)(I18nUtil.translate((String)"i18n_alert_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25:") + response.getMessage()));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_WeIXV_d10ea058", (String)"\u5370\u7ae0\u5df2\u4e0a\u4f20"));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public String getCreateUrl(PurchaseEsignSeals seals) {
        String sealCreateUrl = "";
        if (StringUtils.isBlank((CharSequence)seals.getId())) {
            this.savePurchaseEsignSeals(seals);
        } else {
            this.updatePurchaseEsignSeals(seals);
        }
        String redirectUrl = this.address.endsWith("/") ? this.address + "esignResult?id=PU_" + seals.getId() : this.address + "/esignResult?id=PU_" + seals.getId();
        if ("0".equals(seals.getSealType())) {
            ElsSubaccountCertificationInfo certificationInfo = (ElsSubaccountCertificationInfo)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.elsSubaccountCertificationInfoService.lambdaQuery().select(new SFunction[]{ElsSubaccountCertificationInfo::getFbk1}).eq(ElsSubaccountCertificationInfo::getAccountId, (Object)seals.getAccountId())).eq(BaseEntity::getElsAccount, (Object)seals.getElsAccount())).eq(ElsSubaccountCertificationInfo::getCertificationStatus, (Object)"1")).one());
            EsignPsnSealCreateEO esignPsnSealCreateEO = new EsignPsnSealCreateEO(certificationInfo.getFbk1(), "PU_" + seals.getId(), redirectUrl, seals.getAlias());
            JSONObject requestJSON = new JSONObject();
            requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)esignPsnSealCreateEO)));
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-v3-psn-create-seal-address"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
            if (!response.isSuccess()) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u83b7\u53d6\u5370\u7ae0\u521b\u5efa\u94fe\u63a5\u5931\u8d25:") + response.getMessage());
            }
            JSONObject jsonObject = (JSONObject)response.getResult();
            sealCreateUrl = jsonObject.getString("psnSealCreateUrl");
        } else if ("1".equals(seals.getSealType())) {
            ElsEnterpriseCertificationInfo certificationInfo = (ElsEnterpriseCertificationInfo)((Object)((LambdaQueryChainWrapper)this.elsEnterpriseCertificationInfoService.lambdaQuery().eq(ElsEnterpriseCertificationInfo::getOrgId, (Object)seals.getOrgId())).one());
            long now = Instant.now().toEpochMilli();
            if (!("1".equals(certificationInfo.getCertificationStatus()) || now >= Long.valueOf(certificationInfo.getFbk4()) && now <= Long.valueOf(certificationInfo.getFbk5()))) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u83b7\u53d6\u94fe\u63a5\u5931\u8d25\uff0c\u673a\u6784\u5c1a\u672a\u8ba4\u8bc1\u6216\u6388\u6743\u5df2\u5931\u6548\uff0c\u8bf7\u5148\u63d0\u4ea4\u8ba4\u8bc1\u6216\u6388\u6743\uff01"));
            }
            EsignOrgAdminResponseVO esignOrgAdminResponseVO = this.elsEnterpriseCertificationInfoService.listOrgAdministrators(certificationInfo);
            List<EsignOrgAdminResponseVO.Administrator> administrators = esignOrgAdminResponseVO.getAdministrators();
            Assert.isNotEmpty(administrators, (String)I18nUtil.translate((String)"", (String)"\u67e5\u8be2\u7ba1\u7406\u5458\u5931\u8d25\uff01"));
            String adminPsnId = administrators.get(0).getPsnId();
            EsignOrgSealCreateEO esignPsnSealCreateEO = new EsignOrgSealCreateEO(certificationInfo.getFbk1(), adminPsnId, "PU_" + seals.getId(), redirectUrl, seals.getAlias());
            JSONObject requestJSON = new JSONObject();
            requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)esignPsnSealCreateEO)));
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-v3-org-create-seal-address"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
            if (!response.isSuccess()) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u83b7\u53d6\u5370\u7ae0\u521b\u5efa\u94fe\u63a5\u5931\u8d25:") + response.getMessage());
            }
            JSONObject jsonObject = (JSONObject)response.getResult();
            sealCreateUrl = jsonObject.getString("orgSealCreateUrl");
        }
        return sealCreateUrl;
    }

    @Override
    public void getExternalAuthUrl(PurchaseEsignSeals seals) {
        ElsEnterpriseCertificationInfo certificationInfo = (ElsEnterpriseCertificationInfo)((Object)((LambdaQueryChainWrapper)this.elsEnterpriseCertificationInfoService.lambdaQuery().eq(ElsEnterpriseCertificationInfo::getOrgId, (Object)seals.getOrgId())).one());
        ElsEnterpriseCertificationInfo authorizedOrgInfo = (ElsEnterpriseCertificationInfo)((Object)((LambdaQueryChainWrapper)this.elsEnterpriseCertificationInfoService.lambdaQuery().eq(ElsEnterpriseCertificationInfo::getFbk6, (Object)"1")).one());
        EsignOrgAdminResponseVO esignOrgAdminResponseVO = this.elsEnterpriseCertificationInfoService.listOrgAdministrators(certificationInfo);
        List<EsignOrgAdminResponseVO.Administrator> administrators = esignOrgAdminResponseVO.getAdministrators();
        Assert.isNotEmpty(administrators, (String)I18nUtil.translate((String)"", (String)"\u67e5\u8be2\u7ba1\u7406\u5458\u5931\u8d25\uff01"));
        String adminPsnId = administrators.get(0).getPsnId();
        EsignOrgSealExternalAuthEO esignOrgSealExternalAuthEO = new EsignOrgSealExternalAuthEO(certificationInfo, authorizedOrgInfo, seals, adminPsnId);
        JSONObject requestJSON = new JSONObject();
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)esignOrgSealExternalAuthEO)));
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-v3-org-seal-external-auth-address"));
        Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
        if (!response.isSuccess()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u83b7\u53d6\u5370\u7ae0\u8de8\u4f01\u4e1a\u6388\u6743\u94fe\u63a5\u5931\u8d25:") + response.getMessage());
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        EsignAuthorizationResponseVO responseVO = (EsignAuthorizationResponseVO)JSON.parseObject((String)jsonObject.toJSONString(), EsignAuthorizationResponseVO.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseEsignSeals::getFbk1, (Object)responseVO.getSealAuthBizId())).set(PurchaseEsignSeals::getFbk2, (Object)responseVO.getAuthorizationSignUrl())).set(PurchaseEsignSeals::getFbk3, (Object)responseVO.getAuthorizationSignShortUrl())).set(PurchaseEsignSeals::getFbk4, (Object)"3")).set(PurchaseEsignSeals::getFbk5, (Object)authorizedOrgInfo.getFbk1())).eq(BaseEntity::getId, (Object)seals.getId())).update();
        seals.setFbk1(responseVO.getSealAuthBizId());
        seals.setFbk2(responseVO.getAuthorizationSignUrl());
        seals.setFbk3(responseVO.getAuthorizationSignShortUrl());
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void setDefaultSeal(PurchaseEsignSeals seals) {
        PurchaseEsignSeals byId = (PurchaseEsignSeals)((Object)this.getById((Serializable)((Object)seals.getId())));
        Assert.isNotNull((Object)((Object)byId), (String)I18nUtil.translate((String)"", (String)"\u5370\u7ae0\u4fe1\u606f\u4e0d\u5b58\u5728\uff01"));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseEsignSeals::getFbk11, (Object)"1")).eq(BaseEntity::getId, (Object)seals.getId())).eq(PurchaseEsignSeals::getSealType, (Object)byId.getSealType())).update();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseEsignSeals::getFbk11, (Object)"0")).eq(PurchaseEsignSeals::getOrgId, (Object)seals.getOrgId())).eq(PurchaseEsignSeals::getSealType, (Object)seals.getSealType())).ne(BaseEntity::getId, (Object)seals.getId())).update();
    }
}

