/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.vo;

import com.els.modules.esign.entity.ElsEnterpriseCertificationInfo;
import com.els.modules.esign.entity.PurchaseEsignSeals;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class EsignOrgSealExternalAuthEO {
    private String orgId;
    private String sealId;
    private String transactorPsnId;
    private AuthorizedOrgInfo authorizedOrgInfo;
    private long effectiveTime;
    private long expireTime;
    private String redirectUrl;
    private String appScheme;

    public EsignOrgSealExternalAuthEO(ElsEnterpriseCertificationInfo certificationInfo, ElsEnterpriseCertificationInfo elsAuthorizedOrgInfo, PurchaseEsignSeals seals, String psnId) {
        long expireTime;
        long effectiveTime;
        this.orgId = certificationInfo.getFbk1();
        this.sealId = seals.getSealId();
        this.transactorPsnId = psnId;
        AuthorizedOrgInfo authorizedOrgInfo = new AuthorizedOrgInfo();
        authorizedOrgInfo.setOrgName(elsAuthorizedOrgInfo.getCompanyName());
        authorizedOrgInfo.setOrgIDCardNum(elsAuthorizedOrgInfo.getIdNumber());
        this.authorizedOrgInfo = authorizedOrgInfo;
        ZoneOffset defaultOffset = OffsetDateTime.now().getOffset();
        LocalDateTime now = LocalDateTime.now();
        this.effectiveTime = effectiveTime = now.toEpochSecond(defaultOffset) * 1000L;
        this.expireTime = expireTime = now.plusYears(3L).toEpochSecond(defaultOffset) * 1000L;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public String getSealId() {
        return this.sealId;
    }

    public String getTransactorPsnId() {
        return this.transactorPsnId;
    }

    public AuthorizedOrgInfo getAuthorizedOrgInfo() {
        return this.authorizedOrgInfo;
    }

    public long getEffectiveTime() {
        return this.effectiveTime;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getAppScheme() {
        return this.appScheme;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public void setSealId(String sealId) {
        this.sealId = sealId;
    }

    public void setTransactorPsnId(String transactorPsnId) {
        this.transactorPsnId = transactorPsnId;
    }

    public void setAuthorizedOrgInfo(AuthorizedOrgInfo authorizedOrgInfo) {
        this.authorizedOrgInfo = authorizedOrgInfo;
    }

    public void setEffectiveTime(long effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setAppScheme(String appScheme) {
        this.appScheme = appScheme;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EsignOrgSealExternalAuthEO)) {
            return false;
        }
        EsignOrgSealExternalAuthEO other = (EsignOrgSealExternalAuthEO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEffectiveTime() != other.getEffectiveTime()) {
            return false;
        }
        if (this.getExpireTime() != other.getExpireTime()) {
            return false;
        }
        String this$orgId = this.getOrgId();
        String other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !this$orgId.equals(other$orgId)) {
            return false;
        }
        String this$sealId = this.getSealId();
        String other$sealId = other.getSealId();
        if (this$sealId == null ? other$sealId != null : !this$sealId.equals(other$sealId)) {
            return false;
        }
        String this$transactorPsnId = this.getTransactorPsnId();
        String other$transactorPsnId = other.getTransactorPsnId();
        if (this$transactorPsnId == null ? other$transactorPsnId != null : !this$transactorPsnId.equals(other$transactorPsnId)) {
            return false;
        }
        AuthorizedOrgInfo this$authorizedOrgInfo = this.getAuthorizedOrgInfo();
        AuthorizedOrgInfo other$authorizedOrgInfo = other.getAuthorizedOrgInfo();
        if (this$authorizedOrgInfo == null ? other$authorizedOrgInfo != null : !((Object)this$authorizedOrgInfo).equals(other$authorizedOrgInfo)) {
            return false;
        }
        String this$redirectUrl = this.getRedirectUrl();
        String other$redirectUrl = other.getRedirectUrl();
        if (this$redirectUrl == null ? other$redirectUrl != null : !this$redirectUrl.equals(other$redirectUrl)) {
            return false;
        }
        String this$appScheme = this.getAppScheme();
        String other$appScheme = other.getAppScheme();
        return !(this$appScheme == null ? other$appScheme != null : !this$appScheme.equals(other$appScheme));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EsignOrgSealExternalAuthEO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $effectiveTime = this.getEffectiveTime();
        result = result * 59 + (int)($effectiveTime >>> 32 ^ $effectiveTime);
        long $expireTime = this.getExpireTime();
        result = result * 59 + (int)($expireTime >>> 32 ^ $expireTime);
        String $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : $orgId.hashCode());
        String $sealId = this.getSealId();
        result = result * 59 + ($sealId == null ? 43 : $sealId.hashCode());
        String $transactorPsnId = this.getTransactorPsnId();
        result = result * 59 + ($transactorPsnId == null ? 43 : $transactorPsnId.hashCode());
        AuthorizedOrgInfo $authorizedOrgInfo = this.getAuthorizedOrgInfo();
        result = result * 59 + ($authorizedOrgInfo == null ? 43 : ((Object)$authorizedOrgInfo).hashCode());
        String $redirectUrl = this.getRedirectUrl();
        result = result * 59 + ($redirectUrl == null ? 43 : $redirectUrl.hashCode());
        String $appScheme = this.getAppScheme();
        result = result * 59 + ($appScheme == null ? 43 : $appScheme.hashCode());
        return result;
    }

    public String toString() {
        return "EsignOrgSealExternalAuthEO(orgId=" + this.getOrgId() + ", sealId=" + this.getSealId() + ", transactorPsnId=" + this.getTransactorPsnId() + ", authorizedOrgInfo=" + this.getAuthorizedOrgInfo() + ", effectiveTime=" + this.getEffectiveTime() + ", expireTime=" + this.getExpireTime() + ", redirectUrl=" + this.getRedirectUrl() + ", appScheme=" + this.getAppScheme() + ")";
    }

    class AuthorizedOrgInfo {
        private String orgName;
        private String orgIDCardNum;

        public String getOrgName() {
            return this.orgName;
        }

        public String getOrgIDCardNum() {
            return this.orgIDCardNum;
        }

        public void setOrgName(String orgName) {
            this.orgName = orgName;
        }

        public void setOrgIDCardNum(String orgIDCardNum) {
            this.orgIDCardNum = orgIDCardNum;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthorizedOrgInfo)) {
                return false;
            }
            AuthorizedOrgInfo other = (AuthorizedOrgInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$orgName = this.getOrgName();
            String other$orgName = other.getOrgName();
            if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
                return false;
            }
            String this$orgIDCardNum = this.getOrgIDCardNum();
            String other$orgIDCardNum = other.getOrgIDCardNum();
            return !(this$orgIDCardNum == null ? other$orgIDCardNum != null : !this$orgIDCardNum.equals(other$orgIDCardNum));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AuthorizedOrgInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $orgName = this.getOrgName();
            result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
            String $orgIDCardNum = this.getOrgIDCardNum();
            result = result * 59 + ($orgIDCardNum == null ? 43 : $orgIDCardNum.hashCode());
            return result;
        }

        public String toString() {
            return "EsignOrgSealExternalAuthEO.AuthorizedOrgInfo(orgName=" + this.getOrgName() + ", orgIDCardNum=" + this.getOrgIDCardNum() + ")";
        }
    }
}

