/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.vo;

import cn.hutool.core.util.StrUtil;
import com.els.modules.esign.entity.ElsContractAcceptanceSigners;
import com.els.modules.esign.entity.ElsSigners;
import com.els.modules.esign.entity.PurchaseEsignSigners;
import com.els.modules.esign.vo.EsignDocsVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class EsignSignerVO {
    public static final String BELONG_PURCHASE = "purchase";
    public static final String BELONG_SALE = "sale";
    private boolean platformSign = false;
    private long signOrder;
    private SignerAccount signerAccount;
    private List<Signfields> signfields;

    public EsignSignerVO() {
    }

    public EsignSignerVO(ElsContractAcceptanceSigners signers, long signOrder, String belong) {
        if ("1".equals(signers.getAutoSign())) {
            this.platformSign = true;
        }
        this.signOrder = signOrder;
        this.signerAccount = new SignerAccount();
        this.signerAccount.signerAccountId = signers.getAccountId();
        this.signfields = new ArrayList<Signfields>();
        Signfields field = new Signfields(signers.getActorIndentityType());
        if (!"0".equals(signers.getSignType())) {
            field = new Signfields(signers.getSignArea().split("_")[0], Float.parseFloat(signers.getSignArea().split("_")[1]), Float.parseFloat(signers.getSignArea().split("_")[2]), signers.getActorIndentityType());
            field.signType = 1;
        } else {
            field.signType = 0;
        }
        this.fillContractSignFieldsInfo(signers, field);
        this.signfields.add(field);
        if ("2".equals(signers.getSignType())) {
            float x = 0.0f;
            float y = BELONG_PURCHASE.equals(belong) ? 600.0f : 200.0f;
            Signfields junctionField = new Signfields("all", x, y, signers.getActorIndentityType());
            junctionField.signType = 2;
            this.fillContractSignFieldsInfo(signers, junctionField);
            this.signfields.add(junctionField);
        }
    }

    private void fillContractSignFieldsInfo(ElsContractAcceptanceSigners signers, Signfields fields) {
        fields.autoExecute = this.platformSign || StrUtil.equals((CharSequence)"1", (CharSequence)signers.getAutoArchive());
        fields.fileId = signers.getFilesId();
        if ("2".equals(fields.actorIndentityType)) {
            if (!fields.autoExecute) {
                fields.sealId = null;
                fields.sealIds = Arrays.asList(signers.getSealIds());
            } else {
                fields.sealId = signers.getSealIds();
            }
            this.signerAccount.authorizedAccountId = signers.getOrgId();
        }
        if ("0".equals(signers.getRoleType()) && "1".equals(signers.getAutoArchive())) {
            this.platformSign = true;
            this.signerAccount.signerAccountId = "";
            this.signerAccount.authorizedAccountId = "";
            this.signfields.stream().forEach(o -> {
                o.setAutoExecute(true);
                o.setActorIndentityType("2");
            });
        }
    }

    public EsignSignerVO(ElsSigners signers, long signOrder, String belong) {
        if ("1".equals(signers.getAutoSign())) {
            this.platformSign = true;
        }
        this.signOrder = signOrder;
        this.signerAccount = new SignerAccount();
        this.signerAccount.signerAccountId = signers.getAccountId();
        this.signfields = new ArrayList<Signfields>();
        Signfields field = new Signfields(signers.getActorIndentityType());
        if (!"0".equals(signers.getSignType())) {
            field = new Signfields(signers.getSignArea().split("_")[0], Float.parseFloat(signers.getSignArea().split("_")[1]), Float.parseFloat(signers.getSignArea().split("_")[2]), signers.getActorIndentityType());
            field.signType = 1;
        } else {
            field.signType = 0;
        }
        this.fillSignFieldsInfo(signers, field);
        this.signfields.add(field);
        if ("2".equals(signers.getSignType())) {
            float x = 0.0f;
            float y = BELONG_PURCHASE.equals(belong) ? 600.0f : 200.0f;
            Signfields junctionField = new Signfields("all", x, y, signers.getActorIndentityType());
            junctionField.signType = 2;
            this.fillSignFieldsInfo(signers, junctionField);
            this.signfields.add(junctionField);
        }
        if ("0".equals(signers.getRoleType()) && "1".equals(signers.getAutoArchive())) {
            this.platformSign = true;
            this.signerAccount.signerAccountId = "";
            this.signerAccount.authorizedAccountId = "";
            this.signfields.stream().forEach(o -> {
                o.setAutoExecute(true);
                o.setActorIndentityType("2");
            });
        }
    }

    private void fillSignFieldsInfo(ElsSigners signers, Signfields field) {
        field.autoExecute = this.platformSign || StrUtil.equals((CharSequence)"1", (CharSequence)signers.getAutoArchive());
        field.fileId = signers.getFilesId();
        if ("2".equals(field.actorIndentityType)) {
            if (!field.autoExecute) {
                field.sealId = null;
                field.sealIds = Arrays.asList(signers.getSealIds());
            } else {
                field.sealId = signers.getSealIds();
            }
            this.signerAccount.authorizedAccountId = signers.getOrgId();
        }
    }

    public EsignSignerVO(PurchaseEsignSigners signers, long signOrder) {
        if ("1".equals(signers.getAutoSign())) {
            this.platformSign = true;
        }
        this.signOrder = signOrder;
        this.signerAccount = new SignerAccount();
        this.signerAccount.signerAccountId = signers.getAccountId();
        this.signfields = new ArrayList<Signfields>();
        Signfields e = new Signfields(signers.getActorIndentityType());
        if (!"0".equals(signers.getSignType())) {
            e = new Signfields(signers.getSignArea().split("_")[0], Float.parseFloat(signers.getSignArea().split("_")[1]), Float.parseFloat(signers.getSignArea().split("_")[2]), signers.getActorIndentityType());
        }
        e.autoExecute = this.platformSign;
        e.signType = Integer.parseInt(signers.getSignType());
        e.fileId = signers.getFilesId();
        if ("2".equals(e.actorIndentityType)) {
            if (e.autoExecute) {
                e.sealId = null;
                e.sealIds = Arrays.asList(signers.getSealIds());
            } else {
                e.sealId = signers.getSealIds();
            }
            this.signerAccount.authorizedAccountId = signers.getOrgId();
        }
        this.signfields.add(e);
    }

    public EsignSignerVO(PurchaseEsignSigners signers, List<EsignDocsVO> docs, long signOrder) {
        if ("1".equals(signers.getAutoSign())) {
            this.platformSign = true;
        }
        this.signOrder = signOrder;
        this.signerAccount = new SignerAccount();
        this.signerAccount.signerAccountId = signers.getAccountId();
        this.signfields = new ArrayList<Signfields>();
        for (EsignDocsVO esignDocsVO : docs) {
            Signfields e = new Signfields(signers.getActorIndentityType());
            if (!"0".equals(signers.getSignType())) {
                e = new Signfields(signers.getSignArea().split("_")[0], Float.parseFloat(signers.getSignArea().split("_")[1]), Float.parseFloat(signers.getSignArea().split("_")[2]), signers.getActorIndentityType());
            }
            e.autoExecute = this.platformSign;
            e.signType = Integer.parseInt(signers.getSignType());
            e.fileId = esignDocsVO.getFileId();
            if (!e.autoExecute) {
                e.sealId = null;
                e.sealIds = Arrays.asList(signers.getSealIds());
            } else {
                e.sealId = signers.getSealIds();
            }
            if ("2".equals(e.actorIndentityType)) {
                this.signerAccount.authorizedAccountId = signers.getOrgId();
            } else {
                e.actorIndentityType = null;
            }
            this.signfields.add(e);
        }
    }

    public boolean isPlatformSign() {
        return this.platformSign;
    }

    public long getSignOrder() {
        return this.signOrder;
    }

    public SignerAccount getSignerAccount() {
        return this.signerAccount;
    }

    public List<Signfields> getSignfields() {
        return this.signfields;
    }

    public void setPlatformSign(boolean platformSign) {
        this.platformSign = platformSign;
    }

    public void setSignOrder(long signOrder) {
        this.signOrder = signOrder;
    }

    public void setSignerAccount(SignerAccount signerAccount) {
        this.signerAccount = signerAccount;
    }

    public void setSignfields(List<Signfields> signfields) {
        this.signfields = signfields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EsignSignerVO)) {
            return false;
        }
        EsignSignerVO other = (EsignSignerVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPlatformSign() != other.isPlatformSign()) {
            return false;
        }
        if (this.getSignOrder() != other.getSignOrder()) {
            return false;
        }
        SignerAccount this$signerAccount = this.getSignerAccount();
        SignerAccount other$signerAccount = other.getSignerAccount();
        if (this$signerAccount == null ? other$signerAccount != null : !((Object)this$signerAccount).equals(other$signerAccount)) {
            return false;
        }
        List<Signfields> this$signfields = this.getSignfields();
        List<Signfields> other$signfields = other.getSignfields();
        return !(this$signfields == null ? other$signfields != null : !((Object)this$signfields).equals(other$signfields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EsignSignerVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPlatformSign() ? 79 : 97);
        long $signOrder = this.getSignOrder();
        result = result * 59 + (int)($signOrder >>> 32 ^ $signOrder);
        SignerAccount $signerAccount = this.getSignerAccount();
        result = result * 59 + ($signerAccount == null ? 43 : ((Object)$signerAccount).hashCode());
        List<Signfields> $signfields = this.getSignfields();
        result = result * 59 + ($signfields == null ? 43 : ((Object)$signfields).hashCode());
        return result;
    }

    public String toString() {
        return "EsignSignerVO(platformSign=" + this.isPlatformSign() + ", signOrder=" + this.getSignOrder() + ", signerAccount=" + this.getSignerAccount() + ", signfields=" + this.getSignfields() + ")";
    }

    class Signfields {
        private boolean assignedPosbean = true;
        private boolean autoExecute = false;
        private String actorIndentityType = "2";
        private String fileId;
        private List<String> sealIds;
        private String sealId;
        private Integer signType = 1;
        private PosBean posBean;

        public Signfields() {
        }

        public Signfields(String posPage, float posX, float posY, String actorIndentityType) {
            this.posBean = new PosBean();
            this.posBean.posPage = posPage;
            this.posBean.posX = posX;
            this.posBean.posY = posY;
            if (StringUtils.isNotBlank((CharSequence)actorIndentityType) && !"2".equals(actorIndentityType)) {
                this.actorIndentityType = actorIndentityType;
            }
        }

        public Signfields(String actorIndentityType) {
            if (StringUtils.isNotBlank((CharSequence)actorIndentityType) && !"2".equals(actorIndentityType)) {
                this.actorIndentityType = actorIndentityType;
            }
        }

        public boolean isAssignedPosbean() {
            return this.assignedPosbean;
        }

        public boolean isAutoExecute() {
            return this.autoExecute;
        }

        public String getActorIndentityType() {
            return this.actorIndentityType;
        }

        public String getFileId() {
            return this.fileId;
        }

        public List<String> getSealIds() {
            return this.sealIds;
        }

        public String getSealId() {
            return this.sealId;
        }

        public Integer getSignType() {
            return this.signType;
        }

        public PosBean getPosBean() {
            return this.posBean;
        }

        public void setAssignedPosbean(boolean assignedPosbean) {
            this.assignedPosbean = assignedPosbean;
        }

        public void setAutoExecute(boolean autoExecute) {
            this.autoExecute = autoExecute;
        }

        public void setActorIndentityType(String actorIndentityType) {
            this.actorIndentityType = actorIndentityType;
        }

        public void setFileId(String fileId) {
            this.fileId = fileId;
        }

        public void setSealIds(List<String> sealIds) {
            this.sealIds = sealIds;
        }

        public void setSealId(String sealId) {
            this.sealId = sealId;
        }

        public void setSignType(Integer signType) {
            this.signType = signType;
        }

        public void setPosBean(PosBean posBean) {
            this.posBean = posBean;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Signfields)) {
                return false;
            }
            Signfields other = (Signfields)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAssignedPosbean() != other.isAssignedPosbean()) {
                return false;
            }
            if (this.isAutoExecute() != other.isAutoExecute()) {
                return false;
            }
            Integer this$signType = this.getSignType();
            Integer other$signType = other.getSignType();
            if (this$signType == null ? other$signType != null : !((Object)this$signType).equals(other$signType)) {
                return false;
            }
            String this$actorIndentityType = this.getActorIndentityType();
            String other$actorIndentityType = other.getActorIndentityType();
            if (this$actorIndentityType == null ? other$actorIndentityType != null : !this$actorIndentityType.equals(other$actorIndentityType)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
                return false;
            }
            List<String> this$sealIds = this.getSealIds();
            List<String> other$sealIds = other.getSealIds();
            if (this$sealIds == null ? other$sealIds != null : !((Object)this$sealIds).equals(other$sealIds)) {
                return false;
            }
            String this$sealId = this.getSealId();
            String other$sealId = other.getSealId();
            if (this$sealId == null ? other$sealId != null : !this$sealId.equals(other$sealId)) {
                return false;
            }
            PosBean this$posBean = this.getPosBean();
            PosBean other$posBean = other.getPosBean();
            return !(this$posBean == null ? other$posBean != null : !((Object)this$posBean).equals(other$posBean));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Signfields;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAssignedPosbean() ? 79 : 97);
            result = result * 59 + (this.isAutoExecute() ? 79 : 97);
            Integer $signType = this.getSignType();
            result = result * 59 + ($signType == null ? 43 : ((Object)$signType).hashCode());
            String $actorIndentityType = this.getActorIndentityType();
            result = result * 59 + ($actorIndentityType == null ? 43 : $actorIndentityType.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            List<String> $sealIds = this.getSealIds();
            result = result * 59 + ($sealIds == null ? 43 : ((Object)$sealIds).hashCode());
            String $sealId = this.getSealId();
            result = result * 59 + ($sealId == null ? 43 : $sealId.hashCode());
            PosBean $posBean = this.getPosBean();
            result = result * 59 + ($posBean == null ? 43 : ((Object)$posBean).hashCode());
            return result;
        }

        public String toString() {
            return "EsignSignerVO.Signfields(assignedPosbean=" + this.isAssignedPosbean() + ", autoExecute=" + this.isAutoExecute() + ", actorIndentityType=" + this.getActorIndentityType() + ", fileId=" + this.getFileId() + ", sealIds=" + this.getSealIds() + ", sealId=" + this.getSealId() + ", signType=" + this.getSignType() + ", posBean=" + this.getPosBean() + ")";
        }

        class PosBean {
            private String posPage;
            private float posX;
            private float posY;

            public String getPosPage() {
                return this.posPage;
            }

            public float getPosX() {
                return this.posX;
            }

            public float getPosY() {
                return this.posY;
            }

            public void setPosPage(String posPage) {
                this.posPage = posPage;
            }

            public void setPosX(float posX) {
                this.posX = posX;
            }

            public void setPosY(float posY) {
                this.posY = posY;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PosBean)) {
                    return false;
                }
                PosBean other = (PosBean)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (Float.compare(this.getPosX(), other.getPosX()) != 0) {
                    return false;
                }
                if (Float.compare(this.getPosY(), other.getPosY()) != 0) {
                    return false;
                }
                String this$posPage = this.getPosPage();
                String other$posPage = other.getPosPage();
                return !(this$posPage == null ? other$posPage != null : !this$posPage.equals(other$posPage));
            }

            protected boolean canEqual(Object other) {
                return other instanceof PosBean;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + Float.floatToIntBits(this.getPosX());
                result = result * 59 + Float.floatToIntBits(this.getPosY());
                String $posPage = this.getPosPage();
                result = result * 59 + ($posPage == null ? 43 : $posPage.hashCode());
                return result;
            }

            public String toString() {
                return "EsignSignerVO.Signfields.PosBean(posPage=" + this.getPosPage() + ", posX=" + this.getPosX() + ", posY=" + this.getPosY() + ")";
            }
        }
    }

    class SignerAccount {
        private String signerAccountId;
        private String authorizedAccountId;

        public String getSignerAccountId() {
            return this.signerAccountId;
        }

        public String getAuthorizedAccountId() {
            return this.authorizedAccountId;
        }

        public void setSignerAccountId(String signerAccountId) {
            this.signerAccountId = signerAccountId;
        }

        public void setAuthorizedAccountId(String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SignerAccount)) {
                return false;
            }
            SignerAccount other = (SignerAccount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$signerAccountId = this.getSignerAccountId();
            String other$signerAccountId = other.getSignerAccountId();
            if (this$signerAccountId == null ? other$signerAccountId != null : !this$signerAccountId.equals(other$signerAccountId)) {
                return false;
            }
            String this$authorizedAccountId = this.getAuthorizedAccountId();
            String other$authorizedAccountId = other.getAuthorizedAccountId();
            return !(this$authorizedAccountId == null ? other$authorizedAccountId != null : !this$authorizedAccountId.equals(other$authorizedAccountId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SignerAccount;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $signerAccountId = this.getSignerAccountId();
            result = result * 59 + ($signerAccountId == null ? 43 : $signerAccountId.hashCode());
            String $authorizedAccountId = this.getAuthorizedAccountId();
            result = result * 59 + ($authorizedAccountId == null ? 43 : $authorizedAccountId.hashCode());
            return result;
        }

        public String toString() {
            return "EsignSignerVO.SignerAccount(signerAccountId=" + this.getSignerAccountId() + ", authorizedAccountId=" + this.getAuthorizedAccountId() + ")";
        }
    }
}

