/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.Sign;
import cn.hutool.crypto.asymmetric.SignAlgorithm;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.encryption.AESUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.extend.api.dto.LicenseExtendDTO;
import com.els.modules.extend.api.service.AccountExtendRpcService;
import com.els.modules.system.rpc.service.InvokeBaseRpcService;
import com.els.modules.system.rpc.service.InvokeOtherRpcService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LicenseUtil {
    private static final Logger log = LoggerFactory.getLogger(LicenseUtil.class);
    private static final String REDIS_KEY = "sys:license:alert";
    private static final String CHECK_RESULT = "checkResult";
    private static final String CHECK_TIME = "checkTime";
    private static final Map<String, Object> localMap = new ConcurrentHashMap<String, Object>(8);
    private static final Map<String, Object> purchaseLocalMap = new ConcurrentHashMap<String, Object>(8);
    private static final long intervalTime = 86400000L;
    private static String purchaseElsAccount = (String)((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig().get("purchaseAccount");
    @Resource
    private RedisUtil redisUtil;

    public String check() {
        String result = "";
        if (LicenseUtil.containsLocalMapKey(CHECK_TIME) && DateUtil.isSameDay((Date)DateUtil.parse((CharSequence)((String)LicenseUtil.getLocalMapVal(CHECK_TIME))), (Date)new Date())) {
            String checkResult = (String)LicenseUtil.getLocalMapVal(CHECK_RESULT);
            if ("success".equals(checkResult)) {
                return (String)LicenseUtil.getLocalMapVal("checkMsg");
            }
            if ("expire".equals(checkResult)) {
                throw new ELSBootException("\u5f53\u524d License \u5df2\u5931\u6548\uff0c\u8bf7\u8054\u7cfb\u83b7\u53d6\u65b0\u7684 License\u3002");
            }
            if ("effective".equals(checkResult)) {
                throw new ELSBootException("\u5f53\u524d License \u6682\u672a\u751f\u6548 \u3002");
            }
        } else {
            try {
                LicenseExtendDTO licenseDTO = ((InvokeOtherRpcService)SpringUtil.getBean(InvokeOtherRpcService.class)).getLicenseInfo();
                String license = licenseDTO.getLicense();
                String[] licenseArry = license.split("\\.");
                String aesEncodeStr = licenseArry[0];
                String signStr = licenseArry[1];
                byte[] bData = aesEncodeStr.getBytes();
                byte[] signed = Base64.decode((CharSequence)signStr);
                Sign sign = SecureUtil.sign((SignAlgorithm)SignAlgorithm.MD5withRSA, (String)null, (String)licenseDTO.getPublicKey());
                boolean verify = sign.verify(bData, signed);
                if (!verify) {
                    throw new ELSBootException("\u5f53\u524d License \u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u6b63\u786e\u914d\u7f6e\u3002");
                }
                String aesDecodeStr = null;
                log.info("aesEncodeStr:" + aesEncodeStr);
                aesDecodeStr = AESUtil.decrypt((String)aesEncodeStr, (String)licenseDTO.getSecret());
                if (aesDecodeStr == null) {
                    aesDecodeStr = Base64.decodeStr((CharSequence)aesEncodeStr);
                }
                log.info("aesDecodeStr:" + aesDecodeStr);
                JSONObject infoObj = JSONObject.parseObject((String)aesDecodeStr);
                log.error("License\u9a8c\u8bc1\u8fd4\u56de\u4fe1\u606f" + infoObj.toJSONString());
                Date expireDate = infoObj.getDate("expireDate");
                if (expireDate.compareTo((Date)DateUtil.offsetDay((Date)new Date(), (int)-1)) < 0) {
                    LicenseUtil.setLocalMap("expire", null);
                    throw new ELSBootException("\u5f53\u524d License \u5df2\u5931\u6548\uff0c\u8bf7\u8054\u7cfb\u83b7\u53d6\u65b0\u7684 License\u3002");
                }
                Date effectiveDate = infoObj.getDate("effectiveDate");
                if (effectiveDate.compareTo((Date)DateUtil.offsetDay((Date)new Date(), (int)0)) > 0) {
                    LicenseUtil.setLocalMap("effective", null);
                    throw new ELSBootException("\u5f53\u524d License \u6682\u672a\u751f\u6548 \u3002");
                }
                int alertDays = 15;
                DateTime alertDate = DateUtil.offsetDay((Date)expireDate, (int)(-alertDays));
                String msg = "";
                if (alertDate.compareTo((Date)DateUtil.offsetDay((Date)new Date(), (int)0)) < 0) {
                    if (!this.redisUtil.hasKey(REDIS_KEY)) {
                        String alertEmail = ((AccountExtendRpcService)SpringContextUtils.getBean(AccountExtendRpcService.class)).getUserEmail(purchaseElsAccount, "1001");
                        ((InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class)).sendLicenseAlert(alertEmail, infoObj.getString("expireDate"));
                        this.redisUtil.set(REDIS_KEY, (Object)"alert", 604800L);
                    }
                    msg = "\u7cfb\u7edf\u5c06\u4e8e" + DateUtil.format((Date)expireDate, (String)"yyyy-MM-dd") + "\u5230\u671f\uff0c\u8bf7\u4e0e\u4f01\u4f01\u901a\u5546\u52a1\u4eba\u5458\u8054\u7cfb";
                    if (StringUtils.isNotBlank((CharSequence)TenantContext.getTenant()) && TenantContext.getTenant().equals(purchaseElsAccount)) {
                        result = msg;
                    }
                }
                LicenseUtil.setLocalMap("success", msg);
            }
            catch (Exception var17) {
                log.error("LicenseUtil_check_failed:", (Throwable)var17);
                throw new ELSBootException("\u5f53\u524d License \u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u6b63\u786e\u914d\u7f6e\u3002");
            }
        }
        return result;
    }

    private static void setLocalMap(String checkResult, String checkMsg) {
        String tenant = TenantContext.getTenant();
        if (StringUtils.isNotBlank((CharSequence)tenant) && tenant.equals(purchaseElsAccount)) {
            purchaseLocalMap.put(CHECK_RESULT, checkResult);
            purchaseLocalMap.put("checkMsg", checkMsg);
            purchaseLocalMap.put(CHECK_TIME, LocalDate.now().format(DateTimeFormatter.ISO_DATE));
        } else {
            localMap.put(CHECK_RESULT, checkResult);
            localMap.put("checkMsg", "");
            localMap.put(CHECK_TIME, LocalDate.now().format(DateTimeFormatter.ISO_DATE));
        }
    }

    private static Object getLocalMapVal(String key) {
        String tenant = TenantContext.getTenant();
        if (StringUtils.isNotBlank((CharSequence)tenant) && tenant.equals(purchaseElsAccount)) {
            return purchaseLocalMap.get(key);
        }
        return localMap.get(key);
    }

    private static boolean containsLocalMapKey(String key) {
        String tenant = TenantContext.getTenant();
        if (StringUtils.isNotBlank((CharSequence)tenant) && tenant.equals(purchaseElsAccount)) {
            return purchaseLocalMap.containsKey(key);
        }
        return localMap.containsKey(key);
    }
}

