/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.contract.dto.SaleContractAcceptanceDTO;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.esign.entity.ElsContractAcceptanceEsign;
import com.els.modules.esign.entity.ElsContractAcceptanceSigners;
import com.els.modules.esign.entity.ElsSubaccountCertificationInfo;
import com.els.modules.esign.enumerate.EsignBusTypeEnum;
import com.els.modules.esign.enumerate.EsignContractAcceptanceEleSignStatusEnum;
import com.els.modules.esign.enumerate.EsignContractAcceptanceSignStatusEnum;
import com.els.modules.esign.enumerate.EsignRoleTypeEnum;
import com.els.modules.esign.enumerate.EsignSignerStatusEmun;
import com.els.modules.esign.enumerate.EsignStatusEmun;
import com.els.modules.esign.enumerate.SignerVindicateStatusEnum;
import com.els.modules.esign.enums.ModifyPersonEnum;
import com.els.modules.esign.mapper.ElsContractAcceptanceEsignMapper;
import com.els.modules.esign.mapper.ElsContractAcceptanceSignersMapper;
import com.els.modules.esign.rpc.service.EsignInvokeContractRpcService;
import com.els.modules.esign.rpc.service.EsignInvokeFinanceRpcService;
import com.els.modules.esign.service.ElsContractAcceptanceEsignService;
import com.els.modules.esign.service.ElsSubaccountCertificationInfoService;
import com.els.modules.esign.util.EsignFileEncryptUtil;
import com.els.modules.esign.util.EsignResultAnalysisUtil;
import com.els.modules.esign.util.FileHelper;
import com.els.modules.esign.vo.CreateFlowOneStep;
import com.els.modules.esign.vo.ElsContractAcceptanceEsignVO;
import com.els.modules.esign.vo.EsignAttachmentVO;
import com.els.modules.esign.vo.EsignCopiersVO;
import com.els.modules.esign.vo.EsignDocsVO;
import com.els.modules.esign.vo.EsignFlowInfoVO;
import com.els.modules.esign.vo.EsignSignerVO;
import com.els.modules.finance.api.enumerate.ConfirmElectronicSignStatusEmun;
import com.els.modules.finance.api.enumerate.ConfirmEsignStatusEnum;
import com.els.modules.reconciliation.api.dto.ReconciliationConfirmationDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ElsContractAcceptanceEsignServiceImpl
extends BaseServiceImpl<ElsContractAcceptanceEsignMapper, ElsContractAcceptanceEsign>
implements ElsContractAcceptanceEsignService {
    private static final Logger log = LoggerFactory.getLogger(ElsContractAcceptanceEsignServiceImpl.class);
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private static final String SIGN_FLOW_UPDATE = "SIGN_FLOW_UPDATE";
    private static final String SIGN_FLOW_FINISH = "SIGN_FLOW_FINISH";
    @Autowired
    private ElsContractAcceptanceEsignMapper elsEsignMapper;
    @Autowired
    private ElsContractAcceptanceSignersMapper elsSignersMapper;
    @Autowired
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsSubaccountCertificationInfoService subaccountCertificationInfoService;
    @Resource
    private com.els.modules.system.rpc.service.InvokeBaseRpcService baseRpcService;
    @Autowired
    private EsignInvokeContractRpcService esignInvokeContractRpcService;
    @Autowired
    private EsignInvokeFinanceRpcService esignInvokeFinanceRpcService;
    @Value(value="${els.path.upload}")
    private String uploadpath;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(ElsContractAcceptanceEsign elsEsign, List<ElsContractAcceptanceSigners> purchaseSignersList, List<ElsContractAcceptanceSigners> saleSignersList) {
        ReconciliationConfirmationDTO confirmation;
        List<ElsCompanySetDTO> list;
        JSONObject object;
        ElsEnterpriseInfo enterpriseInfo;
        elsEsign.setBusAccount("100000");
        elsEsign.setDeleted(CommonConstant.DEL_FLAG_0);
        elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.NO_MAINTENANCE.getValue());
        elsEsign.setAutoArchiving("1");
        elsEsign.setAutoInitiate("1");
        if (StringUtils.isBlank((CharSequence)elsEsign.getPurchaseName()) && (enterpriseInfo = this.elsEnterpriseInfoMapper.getByElsAccount(TenantContext.getTenant())) != null) {
            elsEsign.setPurchaseName(enterpriseInfo.getName());
        }
        if (StringUtils.isBlank((CharSequence)elsEsign.getSupplierName()) && (enterpriseInfo = this.elsEnterpriseInfoMapper.getByElsAccount(elsEsign.getToElsAccount())) != null) {
            elsEsign.setSupplierName(enterpriseInfo.getName());
        }
        if ((object = this.getObjBySet(list = this.baseRpcService.getCompanySetList(elsEsign.getToElsAccount()))) != null && StringUtils.isNotBlank((CharSequence)object.getString("electronicSignature")) && object.getString("electronicSignature").contains(elsEsign.getBusType())) {
            elsEsign.setOnlineSealed("1");
        } else {
            elsEsign.setOnlineSealed("0");
        }
        this.elsEsignMapper.insert((Object)elsEsign);
        if (EsignBusTypeEnum.CONTRACT_ACCEPTANCE.getValue().equals(elsEsign.getBusType())) {
            SaleContractAcceptanceDTO dto = this.esignInvokeContractRpcService.getSaleContractAcceptanceById(elsEsign.getRelationId());
            if (dto != null) {
                if (!EsignContractAcceptanceSignStatusEnum.NOT_INITIATED.getValue().equals(dto.getSignStatus())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rtFIhARPWWqKCJPeWQLhARvsmA_dae99d52", (String)"\u8be5\u5355\u636e\u5df2\u53d1\u8d77\u8fc7\u7b7e\u7f72\uff0c\u53ef\u5728\u7535\u5b50\u7b7e\u7ae0-\u6d41\u7a0b\u53d1\u8d77\u7ba1\u7406\u4e2d\u67e5\u770b"));
                }
                dto.setSignStatus(EsignContractAcceptanceSignStatusEnum.INITIATED.getValue());
                dto.setSignInitiate("1");
                this.esignInvokeContractRpcService.updateContractAcceptanceEntityById(dto);
            }
            elsEsign.setBusNumber(dto.getAcceptanceNumbers());
        } else if (EsignBusTypeEnum.RECONCILIATION_CONFIRMATION.getValue().equals(elsEsign.getBusType()) && (confirmation = this.esignInvokeFinanceRpcService.getSaleReconciliationConfirmationById(elsEsign.getRelationId())) != null) {
            ReconciliationConfirmationDTO purchaseConfirmation;
            if (ConfirmEsignStatusEnum.START_END.getValue().equals(confirmation.getSignStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rtFIhARPWWqKCJPeWQLhARvsmA_dae99d52", (String)"\u8be5\u5355\u636e\u5df2\u53d1\u8d77\u8fc7\u7b7e\u7f72\uff0c\u53ef\u5728\u7535\u5b50\u7b7e\u7ae0-\u6d41\u7a0b\u53d1\u8d77\u7ba1\u7406\u4e2d\u67e5\u770b"));
            }
            confirmation.setSignStatus(ConfirmEsignStatusEnum.START_END.getValue());
            confirmation.setSignInitiate("1");
            this.esignInvokeFinanceRpcService.updateSaleConfirmationByRelationId(confirmation);
            if (!StringUtils.isEmpty((CharSequence)confirmation.getRelationId()) && (purchaseConfirmation = this.esignInvokeFinanceRpcService.getPurchaseReconciliationConfirmationById(confirmation.getRelationId())) != null) {
                purchaseConfirmation.setSignStatus(ConfirmEsignStatusEnum.START_END.getValue());
                purchaseConfirmation.setSignInitiate("1");
                this.esignInvokeFinanceRpcService.updateSaleConfirmationByRelationId(purchaseConfirmation);
            }
        }
        this.insertData(elsEsign, purchaseSignersList, saleSignersList, null);
    }

    private JSONObject getObjBySet(List<ElsCompanySetDTO> list) {
        JSONObject result = new JSONObject();
        if (list != null) {
            for (ElsCompanySetDTO set : list) {
                result.put(set.getItemCode(), (Object)set.getDefaultValue());
            }
        }
        return result;
    }

    private void check(List<ElsContractAcceptanceSigners> signers) {
        if (CollUtil.isNotEmpty(signers)) {
            signers.forEach(row -> {
                if (StringUtils.equals((CharSequence)"1", (CharSequence)row.getAutoArchive())) {
                    ElsSubaccountCertificationInfo info = (ElsSubaccountCertificationInfo)((Object)((Object)this.subaccountCertificationInfoService.getOne((Wrapper)Wrappers.lambdaQuery().eq(ElsSubaccountCertificationInfo::getAccountId, (Object)row.getAccountId()))));
                    Assert.notNull((Object)((Object)info), (String)"\u7b7e\u7f72\u4eba\u5f02\u5e38");
                    Assert.isTrue(("1".equals(info.getSilentAuthStatus()) && "1".equals(info.getCertificationStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_JOWePWLlTjILinIOClb_b4463c13", (String)"\u81ea\u52a8\u843d\u7ae0\u7b7e\u7f72\u4eba\u5fc5\u987b\u5f97\u5df2\u8ba4\u8bc1\u548c\u5df2\u9759\u9ed8\u6388\u6743"));
                    Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)row.getSignArea()), (String)"\u81ea\u52a8\u843d\u7ae0\u7b7e\u7f72\u4eba\u5fc5\u987b\u8bbe\u7f6e\u7b7e\u7f72\u533a\u57df");
                }
            });
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(ElsContractAcceptanceEsign elsEsign, List<ElsContractAcceptanceSigners> purchaseSignersList, List<ElsContractAcceptanceSigners> saleSignersList, List<PurchaseAttachmentDTO> attachments) {
        this.check(purchaseSignersList);
        this.check(saleSignersList);
        if (!"1".equals(elsEsign.getAutoInitiate())) {
            elsEsign.setInitiate("0");
        }
        if (!"1".equals(elsEsign.getAutoArchiving())) {
            elsEsign.setArchiving("0");
        }
        this.updateById((Object)elsEsign);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"head_id", (Object)elsEsign.getId());
        wrapper.eq((Object)"role_type", (Object)elsEsign.getModifyPerson());
        this.elsSignersMapper.delete((Wrapper)wrapper);
        this.insertData(elsEsign, purchaseSignersList, saleSignersList, attachments);
        if ("1".equals(elsEsign.getSendStatus())) {
            this.sendMsg(elsEsign);
        }
    }

    private void sendMsg(ElsContractAcceptanceEsign elsEsign) {
        if (StringUtils.isEmpty((CharSequence)elsEsign.getOperateType())) {
            return;
        }
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        toElsAccountList.add(elsEsign.getToElsAccount());
        String url = "id=" + elsEsign.getId();
        ModifyPersonEnum modifyPersonEnum = ModifyPersonEnum.get(elsEsign.getModifyPerson());
        if (modifyPersonEnum == null) {
            return;
        }
        String elsAccount = elsEsign.getElsAccount();
        String operateType = "publish";
        if (ModifyPersonEnum.SUPPLIER.equals((Object)modifyPersonEnum)) {
            toElsAccountList.clear();
            toElsAccountList.add(elsEsign.getElsAccount());
            elsAccount = elsEsign.getToElsAccount();
            operateType = "supplierEsignPublish";
        }
        super.sendMsg(elsAccount, toElsAccountList, (Object)elsEsign, url, "esign", operateType);
    }

    private void insertData(ElsContractAcceptanceEsign elsEsign, List<ElsContractAcceptanceSigners> purchaseSignersList, List<ElsContractAcceptanceSigners> saleSignersList, List<PurchaseAttachmentDTO> attachments) {
        boolean purchaseFlag = false;
        boolean saleFlag = false;
        if (EsignRoleTypeEnum.PURCHASE.getValue().equals(elsEsign.getModifyPerson())) {
            if (purchaseSignersList != null) {
                for (ElsContractAcceptanceSigners entity : purchaseSignersList) {
                    entity.setId(null);
                    entity.setHeadId(elsEsign.getId());
                    entity.setFilesId(elsEsign.getFilesId());
                    entity.setFilesName(elsEsign.getFilesName());
                    entity.setFlowId(elsEsign.getFlowId());
                    entity.setRoleType("0");
                    SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsEsign);
                }
                if (!purchaseSignersList.isEmpty()) {
                    this.elsSignersMapper.insertBatchSomeColumn(purchaseSignersList);
                    purchaseFlag = true;
                }
            }
            if (saleSignersList != null && saleSignersList.size() > 0) {
                saleFlag = true;
            }
        } else {
            if (saleSignersList != null) {
                for (ElsContractAcceptanceSigners entity : saleSignersList) {
                    entity.setId(null);
                    entity.setHeadId(elsEsign.getId());
                    entity.setFilesId(elsEsign.getFilesId());
                    entity.setFilesName(elsEsign.getFilesName());
                    entity.setRoleType("1");
                    entity.setFlowId(elsEsign.getFlowId());
                    String elsAccount = entity.getElsAccount();
                    SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsEsign);
                    entity.setElsAccount(elsAccount);
                }
                if (!saleSignersList.isEmpty()) {
                    this.elsSignersMapper.insertBatchSomeColumn(saleSignersList);
                    saleFlag = true;
                }
            }
            if (purchaseSignersList != null && purchaseSignersList.size() > 0) {
                purchaseFlag = true;
            }
        }
        if (attachments != null) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(elsEsign.getId());
            for (PurchaseAttachmentDTO saleAttachment : attachments) {
                saleAttachment.setElsAccount(elsEsign.getElsAccount());
                saleAttachment.setHeadId(elsEsign.getId());
                saleAttachment.setRelationId(saleAttachment.getId());
                saleAttachment.setSendStatus("1");
                this.invokeBaseRpcService.insertPurchaseAttachment(saleAttachment);
            }
        }
        if ("1".equals(elsEsign.getOnlineSealed())) {
            if (!purchaseFlag && !saleFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.NO_MAINTENANCE.getValue());
            } else if (purchaseFlag && saleFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
            } else if (!purchaseFlag && saleFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.PURCHASE_NO_MAINTENANCE.getValue());
            } else if (purchaseFlag && !saleFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.SALE_NO_MAINTENANCE.getValue());
            }
        } else {
            if (!purchaseFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.PURCHASE_NO_MAINTENANCE.getValue());
            } else if (purchaseFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
            }
            if (!EsignRoleTypeEnum.PURCHASE.getValue().equals(elsEsign.getModifyPerson())) {
                elsEsign.setSaleEsignStatus(EsignSignerStatusEmun.A_SIGNED.getValue());
            }
        }
        this.elsEsignMapper.updateById((Object)elsEsign);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.elsSignersMapper.deleteByMainId(id);
        this.elsEsignMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.elsSignersMapper.deleteByMainId(serializable.toString());
            this.elsEsignMapper.deleteById(serializable);
        }
    }

    @Override
    public Result<?> sendBack(String id) {
        ElsContractAcceptanceEsign esign = (ElsContractAcceptanceEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            ReconciliationConfirmationDTO confirmation;
            if ("1".equals(esign.getLaunch())) {
                return Result.ok((String)"\u7b7e\u7f72\u6d41\u7a0b\u5df2\u53d1\u8d77\uff0c\u65e0\u6cd5\u9000\u56de");
            }
            if (EsignBusTypeEnum.CONTRACT_ACCEPTANCE.getValue().equals(esign.getBusType())) {
                SaleContractAcceptanceDTO saleContractAcceptanceDTO = this.esignInvokeContractRpcService.getSaleContractAcceptanceById(esign.getRelationId());
                saleContractAcceptanceDTO.setSignStatus(EsignContractAcceptanceSignStatusEnum.NOT_INITIATED.getValue());
                saleContractAcceptanceDTO.setElectronicSignStatus(EsignContractAcceptanceEleSignStatusEnum.NOT_INITIATED.getValue());
                this.esignInvokeContractRpcService.updateContractAcceptanceEntityById(saleContractAcceptanceDTO);
            } else if (EsignBusTypeEnum.RECONCILIATION_CONFIRMATION.getValue().equals(esign.getBusType()) && (confirmation = this.esignInvokeFinanceRpcService.getSaleReconciliationConfirmationById(esign.getRelationId())) != null) {
                confirmation.setSignStatus(ConfirmEsignStatusEnum.BACK.getValue());
                confirmation.setSignInitiate("0");
                this.esignInvokeFinanceRpcService.updateSaleConfirmationByRelationId(confirmation);
                if (!StringUtils.isEmpty((CharSequence)confirmation.getRelationId())) {
                    ReconciliationConfirmationDTO purchaseConfirmation = this.esignInvokeFinanceRpcService.getPurchaseReconciliationConfirmationById(confirmation.getRelationId());
                    purchaseConfirmation.setSignStatus(ConfirmEsignStatusEnum.BACK.getValue());
                    purchaseConfirmation.setSignInitiate("0");
                    this.esignInvokeFinanceRpcService.updatePurchaseConfirmationById(purchaseConfirmation);
                }
            }
        } else {
            return Result.error((String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548");
        }
        esign.setSendBack("1");
        this.updateById((Object)esign);
        return Result.ok((String)"\u9000\u56de\u6210\u529f");
    }

    @Override
    public Result<?> backout(String id, String reason) {
        ElsContractAcceptanceEsign esign = (ElsContractAcceptanceEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            ReconciliationConfirmationDTO confirmation;
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject body = new JSONObject();
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)esign.getId());
            wrapper.eq((Object)"role_type", (Object)"0");
            List purhcaseSigners = this.elsSignersMapper.selectList((Wrapper)wrapper);
            if (purhcaseSigners != null) {
                body.put("operatorId", (Object)((ElsContractAcceptanceSigners)((Object)purhcaseSigners.get(0))).getAccountId());
            }
            body.put("revokeReason", (Object)reason);
            requestJSON.put("body", (Object)body);
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("flow-backout"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
            if (!response.isSuccess()) {
                return Result.error((String)("\u64a4\u9500\u5931\u8d25:" + response.getMessage()));
            }
            esign.setEsignStatus(EsignStatusEmun.UNDONE.getValue());
            if (!"1".equals(esign.getAutoInitiate())) {
                esign.setInitiate("0");
            }
            esign.setPurchaseEsignStatus(EsignSignerStatusEmun.UNDONE.getValue());
            esign.setReason(reason);
            this.updateById((Object)esign);
            if (EsignBusTypeEnum.CONTRACT_ACCEPTANCE.getValue().equals(esign.getBusType())) {
                SaleContractAcceptanceDTO saleContractAcceptanceDTO = this.esignInvokeContractRpcService.getSaleContractAcceptanceById(esign.getRelationId());
                saleContractAcceptanceDTO.setSignStatus(EsignContractAcceptanceSignStatusEnum.INITIATED.getValue());
                saleContractAcceptanceDTO.setElectronicSignStatus(EsignContractAcceptanceEleSignStatusEnum.REVOKED.getValue());
                this.esignInvokeContractRpcService.updateContractAcceptanceEntityById(saleContractAcceptanceDTO);
            } else if (EsignBusTypeEnum.RECONCILIATION_CONFIRMATION.getValue().equals(esign.getBusType()) && (confirmation = this.esignInvokeFinanceRpcService.getSaleReconciliationConfirmationById(esign.getRelationId())) != null) {
                confirmation.setSignStatus(ConfirmEsignStatusEnum.BACK.getValue());
                confirmation.setSignInitiate("0");
                this.esignInvokeFinanceRpcService.updateSaleConfirmationByRelationId(confirmation);
                if (!StringUtils.isEmpty((CharSequence)confirmation.getRelationId())) {
                    ReconciliationConfirmationDTO purchaseConfirmation = this.esignInvokeFinanceRpcService.getPurchaseReconciliationConfirmationById(confirmation.getRelationId());
                    purchaseConfirmation.setSignStatus(ConfirmEsignStatusEnum.BACK.getValue());
                    purchaseConfirmation.setSignInitiate("0");
                    this.esignInvokeFinanceRpcService.updatePurchaseConfirmationById(purchaseConfirmation);
                }
            }
        } else {
            return Result.error((String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548");
        }
        return Result.ok((String)"\u64a4\u9500\u6210\u529f");
    }

    @Override
    public Result<?> signFileDownload(String id) {
        ElsContractAcceptanceEsign esign = (ElsContractAcceptanceEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign == null) {
            esign = (ElsContractAcceptanceEsign)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ElsContractAcceptanceEsign::getRelationId, (Object)id)).eq(ElsContractAcceptanceEsign::getArchiving, (Object)"1")));
        }
        if (esign != null) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("flow-file-download"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
            if (!response.isSuccess()) {
                return Result.error((String)("\u6d41\u7a0b\u6587\u6863\u4e0b\u8f7d\u94fe\u63a5\u83b7\u53d6\u5931\u8d25:" + response.getMessage()));
            }
            JSONObject object = (JSONObject)response.getResult();
            return Result.ok((Object)object.getJSONArray("docs"));
        }
        return Result.error((String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548");
    }

    @Override
    public Result<?> viewEsignFile(String id) {
        ElsContractAcceptanceEsign esign = (ElsContractAcceptanceEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("fileId", (Object)esign.getFilesId());
            requestJSON.put("base", (Object)bascis);
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("view-pdf-file-detail"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
            if (!response.isSuccess()) {
                return Result.error((String)("\u5f85\u7b7e\u7f72\u6587\u4ef6\u94fe\u63a5\u83b7\u53d6\u5931\u8d25:" + response.getMessage()));
            }
            return Result.ok((Object)response.getResult());
        }
        return Result.error((String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548");
    }

    @Override
    public Result<?> busSignFileDownload(String id, String busType) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"relation_id", (Object)id);
        wrapper.eq((Object)"bus_type", (Object)busType);
        wrapper.eq((Object)"is_archiving", (Object)"1");
        wrapper.eq((Object)"is_send_back", (Object)"0");
        wrapper.eq((Object)"is_deleted", (Object)"0");
        List esigns = this.list((Wrapper)wrapper);
        if (!esigns.isEmpty()) {
            return this.signFileDownload(((ElsContractAcceptanceEsign)((Object)esigns.get(0))).getId());
        }
        return Result.error((String)"\u7b7e\u7ae0\u6d41\u7a0b\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
    }

    @Override
    public Result<?> flowQuery(String id) {
        ElsContractAcceptanceEsign esign = (ElsContractAcceptanceEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("query-esign-flow"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
            if (!response.isSuccess()) {
                return Result.error((String)("\u7b7e\u7f72\u6d41\u7a0b\u67e5\u8be2\u5931\u8d25:" + response.getMessage()));
            }
            JSONObject data = (JSONObject)response.getResult();
            String status = data.getString("flowStatus");
            if (EsignStatusEmun.FINISHED.getValue().equals(status)) {
                esign.setEsignStatus(EsignStatusEmun.FINISHED.getValue());
                ((ElsContractAcceptanceEsignMapper)this.baseMapper).updateById((Object)esign);
                this.handleContractAcceptanceStatus(esign, EsignContractAcceptanceSignStatusEnum.COMPLETED.getValue(), EsignContractAcceptanceEleSignStatusEnum.COMPLETED.getValue());
                this.handleConfirmStatus(esign, ConfirmEsignStatusEnum.FINISH.getValue(), ConfirmElectronicSignStatusEmun.FINISH.getValue());
            }
            if (EsignStatusEmun.EXPIRED.getValue().equals(status)) {
                esign.setEsignStatus(EsignStatusEmun.EXPIRED.getValue());
                ((ElsContractAcceptanceEsignMapper)this.baseMapper).updateById((Object)esign);
                this.handleContractAcceptanceStatus(esign, null, EsignContractAcceptanceEleSignStatusEnum.EXPIRED.getValue());
                this.handleConfirmStatus(esign, null, ConfirmElectronicSignStatusEmun.EXPIRED.getValue());
            }
            if (EsignStatusEmun.REFUSAL.getValue().equals(status)) {
                esign.setEsignStatus(EsignStatusEmun.REFUSAL.getValue());
                ((ElsContractAcceptanceEsignMapper)this.baseMapper).updateById((Object)esign);
                this.handleContractAcceptanceStatus(esign, null, EsignContractAcceptanceEleSignStatusEnum.REFUSED.getValue());
                this.handleConfirmStatus(esign, null, ConfirmElectronicSignStatusEmun.REFUSAL.getValue());
            }
            return Result.ok((Object)response.getResult());
        }
        return Result.error((String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548");
    }

    private void handleContractAcceptanceStatus(ElsContractAcceptanceEsign esign, String signStatus, String electronicSignStatus) {
        if (EsignBusTypeEnum.CONTRACT_ACCEPTANCE.getValue().equals(esign.getBusType())) {
            SaleContractAcceptanceDTO saleContractAcceptanceDTO = this.esignInvokeContractRpcService.getSaleContractAcceptanceById(esign.getRelationId());
            if (StrUtil.isNotBlank((CharSequence)signStatus)) {
                saleContractAcceptanceDTO.setSignStatus(signStatus);
            }
            if (StrUtil.isNotBlank((CharSequence)electronicSignStatus)) {
                saleContractAcceptanceDTO.setElectronicSignStatus(electronicSignStatus);
            }
            this.esignInvokeContractRpcService.updateContractAcceptanceEntityById(saleContractAcceptanceDTO);
        }
    }

    private void handleConfirmStatus(ElsContractAcceptanceEsign esign, String signStatus, String electronicSignStatus) {
        if (!EsignBusTypeEnum.RECONCILIATION_CONFIRMATION.getValue().equals(esign.getBusType())) {
            return;
        }
        ReconciliationConfirmationDTO confirmation = this.esignInvokeFinanceRpcService.getSaleReconciliationConfirmationById(esign.getRelationId());
        if (confirmation == null) {
            return;
        }
        if (StrUtil.isNotBlank((CharSequence)signStatus)) {
            confirmation.setSignStatus(signStatus);
        }
        if (StrUtil.isNotBlank((CharSequence)electronicSignStatus)) {
            confirmation.setElectronicSignStatus(electronicSignStatus);
        }
        this.esignInvokeFinanceRpcService.updateSaleConfirmationByRelationId(confirmation);
        if (StringUtils.isEmpty((CharSequence)confirmation.getRelationId())) {
            return;
        }
        ReconciliationConfirmationDTO purchaseConfirmation = this.esignInvokeFinanceRpcService.getPurchaseReconciliationConfirmationById(confirmation.getRelationId());
        if (purchaseConfirmation == null) {
            return;
        }
        if (StrUtil.isNotBlank((CharSequence)signStatus)) {
            purchaseConfirmation.setSignStatus(signStatus);
        }
        if (StrUtil.isNotBlank((CharSequence)electronicSignStatus)) {
            purchaseConfirmation.setElectronicSignStatus(electronicSignStatus);
        }
        this.esignInvokeFinanceRpcService.updatePurchaseConfirmationById(purchaseConfirmation);
    }

    @Override
    public Result<?> uploadFile(ElsContractAcceptanceEsignVO esign, HttpServletRequest request, HttpServletResponse response) {
        block23: {
            String cookie = request.getHeader("cookie");
            if (StringUtils.isNotBlank((CharSequence)esign.getId())) {
                this.updateById((Object)esign);
            } else {
                this.save((Object)esign);
            }
            String busName = null;
            if (EsignBusTypeEnum.CONTRACT_ACCEPTANCE.getValue().equals(esign.getBusType())) {
                SaleContractAcceptanceDTO saleContractAcceptanceDTO = this.esignInvokeContractRpcService.getSaleContractAcceptanceById(esign.getRelationId());
                String string = busName = StrUtil.isNotBlank((CharSequence)esign.getBusNumber()) ? esign.getBusNumber() : saleContractAcceptanceDTO.getAcceptanceNumbers();
            }
            if (EsignBusTypeEnum.RECONCILIATION_CONFIRMATION.getValue().equals(esign.getBusType())) {
                ReconciliationConfirmationDTO reconciliationConfirmation = this.esignInvokeFinanceRpcService.getSaleReconciliationConfirmationById(esign.getRelationId());
                busName = StrUtil.isNotBlank((CharSequence)esign.getBusNumber()) ? esign.getBusNumber() : reconciliationConfirmation.getPreparedByNumber();
            }
            InputStream inputStream = null;
            File file = null;
            try {
                if ("sale".equals(esign.getFirstSeal()) && !"1".equals(esign.getOnlineSealed())) {
                    List attachment = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(esign.getId());
                    if (attachment.isEmpty()) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RCLXVPWQI_dbdd64c5", (String)"\u4f9b\u65b9\u672a\u4e0a\u4f20\u7b7e\u7f72\u6587\u4ef6"));
                    }
                    String tempPath = this.uploadpath + ((PurchaseAttachmentDTO)attachment.get(0)).getFilePath();
                    file = new File(tempPath);
                } else {
                    file = this.getFileById(esign.getRelationId(), esign.getBusType(), esign.getReportUrl(), esign.getToken(), cookie);
                }
                if (file != null && file.exists()) {
                    JSONObject object;
                    Result<?> responseResult;
                    String path = file.getPath();
                    System.out.println("file.getname" + file.getName());
                    log.info("path=" + path);
                    response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
                    inputStream = new BufferedInputStream(new FileInputStream(file));
                    byte[] bytes = EsignFileEncryptUtil.getFileMD5Bytes1282(inputStream);
                    String contentMD5 = EsignFileEncryptUtil.getStringContentMD5(bytes);
                    int fileSize = bytes.length;
                    EsignAttachmentVO attachmentVO = null;
                    int lastIndexOf = path.lastIndexOf("/");
                    if (lastIndexOf == -1) {
                        lastIndexOf = path.lastIndexOf("\\");
                    }
                    if ((responseResult = EsignResultAnalysisUtil.analysisResult(object = this.invokeBaseRpcService.callIPaasInterface(JSONObject.parseObject((String)JSONObject.toJSONString((Object)(attachmentVO = path.endsWith(".pdf") ? new EsignAttachmentVO(contentMD5, path.substring(lastIndexOf + 1), fileSize, null) : new EsignAttachmentVO(contentMD5, path.substring(lastIndexOf + 1), fileSize, "application/octet-stream")))), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("upload-file")))).isSuccess()) {
                        JSONObject jsonObject = (JSONObject)responseResult.getResult();
                        String uploadUrl = jsonObject.getString("uploadUrl");
                        String fileId = jsonObject.getString("fileId");
                        esign.setFilesId(fileId);
                        esign.setDeleted(CommonConstant.DEL_FLAG_0);
                        esign.setFilesName(StrUtil.isNotBlank((CharSequence)busName) ? busName : esign.getBusinessScene() + ".pdf");
                        try {
                            FileHelper.streamUpload(path, uploadUrl, attachmentVO.getContentMd5());
                            esign.setUploaded("1");
                            this.updateById((Object)esign);
                            break block23;
                        }
                        catch (Exception e) {
                            throw new ELSBootException(I18nUtil.translate((String)"i18n_title_uploadError", (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a") + e.getMessage());
                        }
                    }
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_title_uploadError", (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a") + responseResult.getMessage());
                }
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SMxuXVQI_34a31727", (String)"\u83b7\u53d6\u4e0d\u5230\u4e0a\u4f20\u6587\u4ef6"));
            }
            catch (Exception e) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_title_uploadError", (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a") + e.getMessage());
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                        if (esign.getOnlineSealed().equals("1") && EsignBusTypeEnum.CONTRACT_ACCEPTANCE.getValue().equals(esign.getBusType()) && file != null && file.exists()) {
                            file.delete();
                        }
                    }
                    catch (IOException e) {
                        log.error("printStackTrace:", (Throwable)e);
                    }
                }
            }
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_PWQIXVLR_d4866ee8", (String)"\u7b7e\u7f72\u6587\u4ef6\u4e0a\u4f20\u6210\u529f"));
    }

    @Override
    public Result<?> createFlowOneStep(ElsContractAcceptanceEsignVO esign) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"head_id", (Object)esign.getId());
        wrapper.eq((Object)"role_type", (Object)"0");
        List purhcaseSigners = this.elsSignersMapper.selectList((Wrapper)wrapper);
        wrapper.clear();
        wrapper.eq((Object)"head_id", (Object)esign.getId());
        wrapper.eq((Object)"role_type", (Object)"1");
        List saleSigners = this.elsSignersMapper.selectList((Wrapper)wrapper);
        ArrayList<EsignSignerVO> signerVOs = new ArrayList<EsignSignerVO>();
        if ("sale".equals(esign.getFirstSeal())) {
            if (!saleSigners.isEmpty()) {
                signerVOs.add(new EsignSignerVO((ElsContractAcceptanceSigners)((Object)saleSigners.get(0)), 1L));
                signerVOs.add(new EsignSignerVO((ElsContractAcceptanceSigners)((Object)purhcaseSigners.get(0)), 2L));
            } else {
                signerVOs.add(new EsignSignerVO((ElsContractAcceptanceSigners)((Object)purhcaseSigners.get(0)), 1L));
            }
        } else {
            if (!saleSigners.isEmpty()) {
                signerVOs.add(new EsignSignerVO((ElsContractAcceptanceSigners)((Object)saleSigners.get(0)), 2L));
            }
            signerVOs.add(new EsignSignerVO((ElsContractAcceptanceSigners)((Object)purhcaseSigners.get(0)), 1L));
        }
        String notifyUrl = "";
        notifyUrl = this.address.endsWith("/") ? this.address + "els/esign/elsContractAcceptanceEsign/noToken/callback/esign" : this.address + "/els/esign/elsContractAcceptanceEsign/noToken/callback/esign";
        CreateFlowOneStep flowOneStep = new CreateFlowOneStep();
        flowOneStep.setSigners(signerVOs);
        ArrayList<EsignCopiersVO> copiersVOs = new ArrayList<EsignCopiersVO>();
        EsignCopiersVO copiersVO = new EsignCopiersVO();
        copiersVO.setCopierAccountId(((ElsContractAcceptanceSigners)((Object)purhcaseSigners.get(0))).getAccountId());
        copiersVO.setCopierIdentityAccountId(((ElsContractAcceptanceSigners)((Object)purhcaseSigners.get(0))).getOrgId());
        copiersVO.setCopierIdentityAccountType("1");
        copiersVOs.add(copiersVO);
        flowOneStep.setCopiers(copiersVOs);
        ArrayList<EsignDocsVO> docsVOs = new ArrayList<EsignDocsVO>();
        EsignDocsVO docsVO = new EsignDocsVO();
        docsVO.setFileId(esign.getFilesId());
        docsVO.setFileName(esign.getFilesName());
        docsVOs.add(docsVO);
        flowOneStep.setDocs(docsVOs);
        EsignFlowInfoVO flowInfoVO = new EsignFlowInfoVO(esign, (ElsContractAcceptanceSigners)((Object)purhcaseSigners.get(0)), notifyUrl);
        flowOneStep.setFlowInfo(flowInfoVO);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSONObject.parseObject((String)JSONObject.toJSONString((Object)flowOneStep)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("one-step-flow-start"));
        Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
        if (!response.isSuccess()) {
            return Result.error((String)(I18nUtil.translate((String)"i18n_alert_IxPWhAKmW_f40249c7", (String)"\u548c\u4e00\u6b65\u7b7e\u7f72\u53d1\u8d77\u5931\u8d25:") + response.getMessage()));
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        esign.setFlowId(jsonObject.getString("flowId"));
        esign.setLaunch("1");
        esign.setEsignStatus(EsignStatusEmun.UNFINISHED.getValue());
        if ("1".equals(esign.getAutoInitiate())) {
            esign.setInitiate("1");
        }
        this.updateById((Object)esign);
        ((ElsContractAcceptanceSigners)((Object)purhcaseSigners.get(0))).setFlowId(esign.getFlowId());
        this.elsSignersMapper.updateById(purhcaseSigners.get(0));
        if (!saleSigners.isEmpty()) {
            ((ElsContractAcceptanceSigners)((Object)saleSigners.get(0))).setFlowId(esign.getFlowId());
            this.elsSignersMapper.updateById(saleSigners.get(0));
        }
        if (EsignBusTypeEnum.CONTRACT_ACCEPTANCE.getValue().equals(esign.getBusType())) {
            SaleContractAcceptanceDTO saleContractAcceptanceDTO = this.esignInvokeContractRpcService.getSaleContractAcceptanceById(esign.getRelationId());
            saleContractAcceptanceDTO.setElectronicSignStatus(EsignContractAcceptanceEleSignStatusEnum.UNDER_SIGN.getValue());
            this.esignInvokeContractRpcService.updateContractAcceptanceEntityById(saleContractAcceptanceDTO);
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_hALR_28390cd5", (String)"\u53d1\u8d77\u6210\u529f"));
    }

    @Override
    public void esignSigner(JSONObject object) {
        if (SIGN_FLOW_UPDATE.equals(object.getString("action"))) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"flow_id", (Object)object.getString("flowId"));
            wrapper.eq((Object)"account_id", (Object)object.getString("accountId"));
            List signers = this.elsSignersMapper.selectList((Wrapper)wrapper);
            if (!signers.isEmpty()) {
                ElsContractAcceptanceSigners elsSigners = (ElsContractAcceptanceSigners)((Object)signers.get(0));
                if (EsignSignerStatusEmun.A_SIGNED.equals(object.getInteger("signResult"))) {
                    elsSigners.setEsignStatus(EsignSignerStatusEmun.A_SIGNED.getValue());
                } else if (EsignSignerStatusEmun.LOSE.equals(object.getInteger("signResult"))) {
                    elsSigners.setEsignStatus(EsignSignerStatusEmun.LOSE.getValue());
                    elsSigners.setReason(object.getString("resultDescription"));
                } else if (EsignSignerStatusEmun.REFUSAL.equals(object.getInteger("signResult"))) {
                    elsSigners.setEsignStatus(EsignSignerStatusEmun.REFUSAL.getValue());
                    elsSigners.setReason(object.getString("resultDescription"));
                }
                this.elsSignersMapper.updateById((Object)elsSigners);
                ElsContractAcceptanceEsign esign = (ElsContractAcceptanceEsign)((Object)this.getById((Serializable)((Object)elsSigners.getHeadId())));
                if (EsignRoleTypeEnum.PURCHASE.getValue().equals(elsSigners.getRoleType())) {
                    esign.setPurchaseEsignStatus(elsSigners.getEsignStatus());
                } else {
                    esign.setSaleEsignStatus(elsSigners.getEsignStatus());
                }
                this.updateById((Object)esign);
            }
        } else if (SIGN_FLOW_FINISH.equals(object.getString("action"))) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"flow_id", (Object)object.getString("flowId"));
            List esigns = this.list((Wrapper)wrapper);
            if (!esigns.isEmpty()) {
                ElsContractAcceptanceEsign esign = (ElsContractAcceptanceEsign)((Object)esigns.get(0));
                esign.setEsignStatus(object.getString("flowStatus"));
                if (EsignStatusEmun.UNDONE.getValue().equals(object.getString("flowStatus"))) {
                    esign.setLaunch("0");
                }
                if ("2".equals(object.getString("flowStatus")) && "1".equals(esign.getAutoArchiving())) {
                    esign.setArchiving("1");
                }
                esign.setPurchaseEsignStatus(EsignSignerStatusEmun.A_SIGNED.getValue());
                esign.setSaleEsignStatus(EsignSignerStatusEmun.A_SIGNED.getValue());
                esign.setReason(object.getString("statusDescription"));
                this.updateById((Object)esign);
                if (EsignBusTypeEnum.CONTRACT_ACCEPTANCE.getValue().equals(esign.getBusType())) {
                    SaleContractAcceptanceDTO saleContractAcceptanceDTO = this.esignInvokeContractRpcService.getSaleContractAcceptanceById(esign.getRelationId());
                    if ("1".equals(esign.getArchiving())) {
                        saleContractAcceptanceDTO.setSignStatus(EsignContractAcceptanceSignStatusEnum.ARCHIVED.getValue());
                        saleContractAcceptanceDTO.setElectronicSignStatus(EsignContractAcceptanceEleSignStatusEnum.COMPLETED.getValue());
                    } else {
                        saleContractAcceptanceDTO.setSignStatus(EsignContractAcceptanceSignStatusEnum.COMPLETED.getValue());
                        saleContractAcceptanceDTO.setElectronicSignStatus(EsignContractAcceptanceEleSignStatusEnum.COMPLETED.getValue());
                    }
                    this.esignInvokeContractRpcService.updateContractAcceptanceEntityById(saleContractAcceptanceDTO);
                }
            }
        }
    }

    @Override
    public Result<?> startFlow(String id) {
        ElsContractAcceptanceEsign esign = (ElsContractAcceptanceEsign)((Object)this.getById((Serializable)((Object)id)));
        if ("1".equals(esign.getAutoInitiate())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFQLLJOvA_ca4b831f", (String)"\u8be5\u5355\u636e\u6d41\u7a0b\u4e3a\u81ea\u52a8\u5f00\u542f"));
        }
        if (esign != null && StringUtils.isNotBlank((CharSequence)esign.getFlowId())) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("flow-start"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_QLvAKmW_3418ff05", (String)"\u6d41\u7a0b\u5f00\u8d77\u5931\u8d25:") + response.getMessage()));
            }
            esign.setInitiate("1");
            this.updateById((Object)esign);
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_QLvALR_536ca7e8", (String)"\u6d41\u7a0b\u5f00\u542f\u6210\u529f"));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFsLhAIxPWQLWShvA_ed94197", (String)"\u8be5\u5355\u636e\u8fd8\u672a\u53d1\u8d77\u4e00\u6b65\u7b7e\u7f72\u6d41\u7a0b\uff0c\u65e0\u6cd5\u5f00\u542f"));
    }

    @Override
    public Result<?> archiveFlow(String id) {
        ElsContractAcceptanceEsign esign = (ElsContractAcceptanceEsign)((Object)this.getById((Serializable)((Object)id)));
        if ("1".equals(esign.getAutoArchiving())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFQLLJOLA_ca4ba141", (String)"\u8be5\u5355\u636e\u6d41\u7a0b\u4e3a\u81ea\u52a8\u5f52\u6863"));
        }
        if (esign != null && EsignSignerStatusEmun.A_SIGNED.getValue().equals(esign.getPurchaseEsignStatus()) && EsignSignerStatusEmun.A_SIGNED.getValue().equals(esign.getSaleEsignStatus())) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("flow-archive"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
            if (!response.isSuccess()) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_QLLAKmW_27c1b3eb", (String)"\u6d41\u7a0b\u5f52\u6863\u5931\u8d25:") + response.getMessage()));
            }
            esign.setArchiving("1");
            esign.setEsignStatus(EsignStatusEmun.FINISHED.getValue());
            this.updateById((Object)esign);
            this.handleContractAcceptanceStatus(esign, EsignContractAcceptanceSignStatusEnum.ARCHIVED.getValue(), null);
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_QLLALR_53ddc58a", (String)"\u6d41\u7a0b\u5f52\u6863\u6210\u529f"));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_LPWMLjQLShHcLA_a16b54a3", (String)"\u672a\u7b7e\u7f72\u5b8c\u6210\u7684\u6d41\u7a0b\u65e0\u6cd5\u8fdb\u884c\u5f52\u6863"));
    }

    public File getFileById(String id, String busType, String reportUrl, String token, String cookie) {
        Object path = null;
        if (EsignBusTypeEnum.CONTRACT_ACCEPTANCE.getValue().equals(busType)) {
            try {
                File file = new File("tempOrder" + id + ".pdf");
                file.createNewFile();
                StringBuffer url = new StringBuffer();
                url.append(reportUrl).append("/els/report/ureport/pdf?_u=mysql:sale_contract_acceptance.ureport.xml").append("&token=").append(token).append("&id=").append(id);
                log.info("uReport\u63a5\u53e3\u5730\u5740:{}", (Object)url.toString());
                ((HttpRequest)((HttpRequest)HttpRequest.get((String)url.toString()).header("cookie", cookie)).header("Referer", reportUrl)).execute().writeBody(file);
                return file;
            }
            catch (Exception e) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QISMKmW_e0294b38", (String)"\u6587\u4ef6\u83b7\u53d6\u5931\u8d25\uff1a") + e.getMessage());
            }
        }
        if (EsignBusTypeEnum.RECONCILIATION_CONFIRMATION.getValue().equals(busType)) {
            try {
                File file = new File("tempOrder" + id + ".pdf");
                file.createNewFile();
                StringBuffer url = new StringBuffer();
                url.append(reportUrl).append("/els/report/ureport/pdf?_u=mysql:sale_reconciliation_confirmation.ureport.xml").append("&token=").append(token).append("&id=").append(id);
                log.info("uReport\u63a5\u53e3\u5730\u5740:{}", (Object)url.toString());
                ((HttpRequest)((HttpRequest)HttpRequest.get((String)url.toString()).header("cookie", cookie)).header("Referer", reportUrl)).execute().writeBody(file);
                return file;
            }
            catch (Exception e) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QISMKmW_e0294b38", (String)"\u6587\u4ef6\u83b7\u53d6\u5931\u8d25\uff1a") + e.getMessage());
            }
        }
        return null;
    }
}

