/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class LocalDateTimeUtil {
    private LocalDateTimeUtil() {
    }

    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date localDateTimeToDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static boolean compareMonthLater(Date date, int months) {
        LocalDateTime dt = LocalDateTimeUtil.dateToLocalDateTime(date);
        return LocalDateTimeUtil.compareMonthLater(LocalDateTimeUtil.now(), dt, months);
    }

    public static boolean compareDayLater(Date date, int days) {
        LocalDateTime dt = LocalDateTimeUtil.dateToLocalDateTime(date);
        return LocalDateTimeUtil.compareDayLater(LocalDateTimeUtil.now(), dt, days);
    }

    public static boolean compareMonthLater(LocalDateTime dt, int months) {
        return LocalDateTimeUtil.compareMonthLater(LocalDateTimeUtil.now(), dt, months);
    }

    public static boolean compareMonthLater(LocalDateTime dt1, LocalDateTime dt2, int months) {
        return dt1.isAfter(dt2.plusMonths(months));
    }

    public static boolean compareDayLater(LocalDateTime dt1, LocalDateTime dt2, int days) {
        return dt1.isAfter(dt2.plusDays(days));
    }
}

