/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.api.service.SubAccountOrgRpcService;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import io.swagger.annotations.Api;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/account/chatBi"})
public class ChatBiAccountHttpController
extends BaseController<ElsSubAccount, ElsSubAccountService> {
    private static final Logger log = LoggerFactory.getLogger(ChatBiAccountHttpController.class);
    @Autowired(required=false)
    private AccountRpcService accountBeanService;
    @Autowired(required=false)
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoRpcService;
    @Autowired(required=false)
    private SubAccountOrgRpcService subAccountOrgBeanService;

    @RequestMapping(value={"/invoke/{methodCode}"}, method={RequestMethod.POST})
    public Result<?> invoke(@RequestBody JSONObject object, @PathVariable(value="methodCode") String methodCode) {
        if ("chatBiListAccount".equals(methodCode)) {
            LoginUserDTO user = (LoginUserDTO)object.toJavaObject(LoginUserDTO.class);
            return Result.ok(((ElsSubAccountService)this.service).chatBiListAccount(user));
        }
        if ("getPermissionSensitiveFieldList".equals(methodCode)) {
            String userId = object.getString("userId");
            String businessType = object.getString("businessType");
            return Result.ok((Object)this.accountBeanService.getPermissionSensitiveFieldList(userId, businessType));
        }
        if ("getPermissionByAccount".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String subAccount = object.getString("subAccount");
            return Result.ok((Object)this.accountBeanService.getPermissionByAccount(elsAccount, subAccount));
        }
        if ("getUserOrg".equals(methodCode)) {
            String userId = object.getString("userId");
            return Result.ok((Object)this.subAccountOrgBeanService.getUserOrg(userId));
        }
        if ("getPermissionDataList".equals(methodCode)) {
            String userId = object.getString("userId");
            String businessType = object.getString("businessType");
            return Result.ok((Object)this.accountBeanService.getPermissionDataList(userId, businessType));
        }
        if ("getSubAccountOrgList".equals(methodCode)) {
            String userId = object.getString("userId");
            return Result.ok((Object)this.subAccountOrgBeanService.getSubAccountOrgList(userId));
        }
        if ("queryAllSubAccount".equals(methodCode)) {
            List elsAccountList = object.getJSONArray("elsAccount").toJavaList(String.class);
            return Result.ok((Object)this.accountBeanService.queryAllSubAccount(elsAccountList));
        }
        if ("getAccountListByLeader".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String subAccount = object.getString("subAccount");
            return Result.ok((Object)this.accountBeanService.getAccountListByLeader(elsAccount, subAccount));
        }
        if ("getMenuJsonArray".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String subAccount = object.getString("subAccount");
            Integer mobile = object.getInteger("mobile");
            return Result.ok((Object)this.accountBeanService.getMenuJsonArray(elsAccount, subAccount, mobile));
        }
        if ("getAccountList".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            List subAccount = object.getJSONArray("subAccounts").toJavaList(String.class);
            return Result.ok((Object)this.accountBeanService.getAccountList(elsAccount, subAccount));
        }
        if ("getAllOptPermission".equals(methodCode)) {
            return Result.ok((Object)this.accountBeanService.getAllOptPermission());
        }
        if ("getUserPermissionsSet".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String subAccount = object.getString("subAccount");
            return Result.ok((Object)this.accountBeanService.getUserPermissionsSet(elsAccount, subAccount));
        }
        if ("getUserRolesSet".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String subAccount = object.getString("subAccount");
            return Result.ok((Object)this.accountBeanService.getUserRolesSet(elsAccount, subAccount));
        }
        if ("getLoginUser".equals(methodCode)) {
            String account = object.getString("account");
            return Result.ok((Object)this.accountBeanService.getLoginUser(account));
        }
        if ("getAccount".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String subAccount = object.getString("subAccount");
            return Result.ok((Object)this.accountBeanService.getAccount(elsAccount, subAccount));
        }
        return Result.error((String)"\u4e0d\u5b58\u5728\u7684\u63a5\u53e3\u65b9\u6cd5");
    }
}

