/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.auth.controller;

import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.modules.auth.service.LoginService;
import com.els.modules.auth.vo.LoginByAccountVO;
import com.els.modules.auth.vo.LoginByPhoneVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.Resource;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u767b\u9646\u8ba4\u8bc1", description="\u767b\u9646\u8ba4\u8bc1")
@RestController
@RequestMapping(value={"/account"})
public class LoginController {
    @Resource
    private LoginService loginService;
    @Resource
    private ElsSubAccountService accountInfoService;

    @Operation(summary="\u83b7\u53d6\u5bc6\u7801\u52a0\u5bc6\u516c\u94a5", description="\u83b7\u53d6\u5bc6\u7801\u52a0\u5bc6\u516c\u94a5")
    @GetMapping(value={"/noToken/getEncryptedKey"})
    public Result<?> getEncryptedKey() throws Exception {
        return Result.ok((Object)this.loginService.getEncryptedKey());
    }

    @Operation(summary="\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801", description="\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/noToken/sendSmsAuthCode"})
    public Result<?> sendSmsAuthCode(@RequestParam(name="mobilePhone") String mobilePhone) {
        this.loginService.sendSmsAuthCode(mobilePhone);
        return Result.ok();
    }

    @Operation(summary="\u7528\u6237\u540d\u5bc6\u7801\u767b\u5f55", description="\u7528\u6237\u540d\u5bc6\u7801\u767b\u5f55")
    @PostMapping(value={"/login"})
    public Result<?> loginByAccount(@RequestBody LoginByAccountVO login) {
        return Result.ok((Object)this.loginService.loginByAccount(login));
    }

    @Operation(summary="\u624b\u673a\u53f7\u767b\u5f55", description="\u624b\u673a\u53f7\u767b\u5f55")
    @PostMapping(value={"/loginByPhone"})
    public Result<?> loginByPhone(@RequestBody LoginByPhoneVO login) {
        return Result.ok((Object)this.loginService.loginByPhone(login));
    }

    @Operation(summary="\u6839\u636etoken\u767b\u5f55", description="\u6839\u636etoken\u767b\u5f55")
    @GetMapping(value={"/loginByToken"})
    public Result<?> loginByToken(@RequestParam(name="token") String token) {
        return Result.ok((Object)this.loginService.loginByToken(token));
    }

    @Operation(summary="\u767b\u51fa", description="\u767b\u51fa")
    @GetMapping(value={"/logout"})
    public Result<?> logout() {
        this.loginService.logout();
        return Result.ok();
    }

    @Operation(summary="\u5f00\u53d1\u73af\u5883\u767b\u5165", description="\u5f00\u53d1\u73af\u5883\u767b\u5165")
    @GetMapping(value={"/noToken/devLogin"})
    public Result<?> devLogin(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="subAccount") String subAccount) throws Exception {
        long beginTime = System.currentTimeMillis();
        Environment env = (Environment)SpringContextUtils.getBean(Environment.class);
        String dev = env.getProperty("spring.profiles.active", "sit");
        if (!"dev".equals(dev)) {
            throw new ELSBootException("\u5f53\u524d\u73af\u5883\u4e0d\u53ef\u64cd\u4f5c\uff01");
        }
        ElsSubAccount accountInfo = this.accountInfoService.getByAccount(elsAccount, subAccount);
        if (accountInfo == null) {
            throw new ELSBootException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        JSONObject result = this.loginService.buildLoginResult(beginTime, accountInfo);
        return Result.ok((Object)result);
    }
}

