/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.enumerate.DeployWayEnum;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.ConfigUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.service.PermissionExtendService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class PermissionExtendServiceImpl
extends ServiceImpl<PermissionMapper, Permission>
implements PermissionExtendService {
    @Override
    public void createOrUpdate(String customId, List<PermissionDTO> permissionList) {
        ((PermissionMapper)this.baseMapper).deleteByCustomBusinessId(customId);
        if (permissionList != null && !permissionList.isEmpty()) {
            ArrayList insertList = SysUtil.copyProperties(permissionList, Permission.class);
            this.saveBatch(insertList);
            List idList = insertList.stream().filter(vo -> StrUtil.isNotBlank((CharSequence)vo.getParentId())).map(Permission::getParentId).distinct().collect(Collectors.toList());
            for (String id : idList) {
                ((PermissionMapper)this.baseMapper).setMenuLeaf(id, 0);
            }
        }
    }

    @Override
    public List<String> getPermissonCodeListByAccountId(String elsAccount, String accountId) {
        List<Permission> resourceList = this.getByAccountId(elsAccount, accountId);
        ArrayList<String> resultList = new ArrayList<String>();
        for (Permission vo : resourceList) {
            String permissonCode;
            if ("0".equals(vo.getStatus()) || !StrUtil.isNotBlank((CharSequence)(permissonCode = vo.getPerms()))) continue;
            if (permissonCode.contains(";")) {
                resultList.addAll(Arrays.asList(permissonCode.split(";")));
                continue;
            }
            resultList.add(permissonCode);
        }
        return resultList;
    }

    @Override
    public List<Permission> getByAccountId(String elsAccount, String accountId) {
        String adminFlag = AdminFlagUtil.getAdminFlag();
        if ("0".equals(adminFlag) && CharSequenceUtil.isNotEmpty((CharSequence)accountId)) {
            return ((PermissionMapper)this.baseMapper).getRoleResourceByAccountId(elsAccount, accountId);
        }
        String deployWay = ConfigUtil.getDeployWay();
        String purchaseAccount = ConfigUtil.getPurchaseAccount();
        if (DeployWayEnum.SAAS.getValue().equals(deployWay)) {
            if (purchaseAccount.equals(elsAccount) && "1".equals(adminFlag)) {
                return ((PermissionMapper)this.baseMapper).getAllResourceList();
            }
            String tenantAttribute = "";
            List<Permission> resourceList = ((PermissionMapper)this.baseMapper).getTenantResourceList(elsAccount);
            if (StrUtil.isNotBlank((CharSequence)tenantAttribute) && tenantAttribute.contains("supplier")) {
                List<Permission> allList = ((PermissionMapper)this.baseMapper).getAllResourceList();
                List waitAddList = allList.stream().filter(o -> "2".equals(o.getMenuAttribute()) || "3".equals(o.getMenuAttribute())).collect(Collectors.toList());
                List<String> existIdList = resourceList.stream().map(Permission::getId).toList();
                for (Permission resource : waitAddList) {
                    if (existIdList.contains(resource.getId())) continue;
                    resourceList.add(resource);
                }
            }
            return resourceList;
        }
        List<Permission> list = ((PermissionMapper)this.baseMapper).getAllResourceList();
        if (elsAccount.equals(purchaseAccount)) {
            return list.stream().filter(o -> !"2".equals(o.getMenuAttribute())).collect(Collectors.toList());
        }
        List<Permission> authList = ((PermissionMapper)this.baseMapper).getLocalTenantResourceListBySupplierGroup(purchaseAccount, elsAccount);
        if (!authList.isEmpty()) {
            return authList;
        }
        return list.stream().filter(o -> "2".equals(o.getMenuAttribute()) || "3".equals(o.getMenuAttribute())).collect(Collectors.toList());
    }
}

