/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.excel;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.excel.service.BaseExportService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.vo.ElsSubAccountVO;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="accountOtherListExportServiceImpl")
public class AccountOtherListExportServiceImpl
extends BaseExportService<ElsSubAccountVO, ElsSubAccountVO, ElsSubAccountVO>
implements ExportDataLoaderService {
    @Autowired
    private ElsSubAccountService elsSubAccountService;

    public List<ElsSubAccountVO> queryExportData(QueryWrapper<ElsSubAccountVO> queryWrapper, ElsSubAccountVO param, Map<String, String[]> paramMap) {
        if (!TenantContext.getTenant().equals(SysUtil.getPurchaseAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APeyBjbWCQryV_d23d634", (String)"\u5f53\u524d\u8d26\u53f7\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u63a5\u53e3"));
        }
        queryWrapper.notIn((Object)"els_account", new Object[]{TenantContext.getTenant(), "100000"});
        List<ElsSubAccountVO> list = this.elsSubAccountService.selectSubAccountAndEnterpriseList(queryWrapper);
        return list;
    }

    public long queryExportDataCount(QueryWrapper<ElsSubAccountVO> queryWrapper, ElsSubAccountVO map, Map<String, String[]> paramMap) {
        queryWrapper.notIn((Object)"els_account", new Object[]{TenantContext.getTenant(), "100000"});
        return this.elsSubAccountService.selectSubAccountAndEnterpriseCount(queryWrapper);
    }

    public String getBusinessType() {
        return "ElsSubaccountInfoList";
    }

    public String getBeanName() {
        return "elsSubAccountOtherListExcelDataBatchQueryLoader";
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> entityMap, Map<String, String[]> requestParamMap) {
        if (!TenantContext.getTenant().equals(SysUtil.getPurchaseAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APeyBjbWCQryV_d23d634", (String)"\u5f53\u524d\u8d26\u53f7\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u63a5\u53e3"));
        }
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = this.builderWrapper(entityMap, requestParamMap);
        queryWrapper.notIn((Object)"els_account", new Object[]{TenantContext.getTenant(), "100000"});
        IPage<ElsSubAccountVO> pageList = this.elsSubAccountService.selectSubAccountAndEnterprisePage((Page<ElsSubAccountVO>)page, (QueryWrapper<ElsSubAccountVO>)queryWrapper);
        List result = Convert.toList(ElsSubAccountVO.class, (Object)pageList.getRecords());
        return JSON.toJSONString((Object)result);
    }
}

