/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.entity.SaleAttachment;
import com.els.modules.attachment.mapper.PurchaseAttachmentMapper;
import com.els.modules.attachment.mapper.SaleAttachmentMapper;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.attachment.service.SaleAttachmentService;
import com.els.modules.attachment.vo.AttachmentSendVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseAttachmentServiceImpl
extends ServiceImpl<PurchaseAttachmentMapper, PurchaseAttachment>
implements PurchaseAttachmentService {
    @Autowired
    private SaleAttachmentMapper saleAttachmentMapper;

    @Override
    public void delPurchaseAttachment(String id) {
        ((PurchaseAttachmentMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseAttachment(List<String> idList) {
        ((PurchaseAttachmentMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void sendFile(AttachmentSendVO sendVO) {
        this.sendFile(sendVO, false);
    }

    @Override
    public void sendFile(AttachmentSendVO sendVO, boolean sendAllFlag) {
        String elsAccount = sendVO.getElsAccount();
        List<PurchaseAttachment> attachmentList = ((PurchaseAttachmentMapper)this.baseMapper).selectByMainId(sendVO.getHeadId());
        List<PurchaseAttachment> needSendList = attachmentList.parallelStream().filter(attachment -> sendAllFlag || !"1".equals(attachment.getSendStatus())).filter(attachment -> elsAccount.equals(attachment.getUploadElsAccount())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(needSendList)) {
            needSendList.forEach(attachment -> attachment.setSendStatus("1"));
            this.updateBatchById(needSendList);
            ArrayList<SaleAttachment> insertSaleList = new ArrayList<SaleAttachment>();
            Map<Object, Object> toSend = sendVO.getToSend() == null ? new ConcurrentHashMap() : sendVO.getToSend();
            for (String string : toSend.keySet()) {
                String saleElsAccount = (String)toSend.get(string);
                for (PurchaseAttachment purchaseAttachment : needSendList) {
                    SaleAttachment saleAttachment = new SaleAttachment();
                    BeanUtils.copyProperties((Object)((Object)purchaseAttachment), (Object)((Object)saleAttachment));
                    saleAttachment.setId(IdWorker.getIdStr());
                    saleAttachment.setElsAccount(saleElsAccount);
                    saleAttachment.setRelationId(purchaseAttachment.getId());
                    saleAttachment.setHeadId(string);
                    insertSaleList.add(saleAttachment);
                }
            }
            if (!insertSaleList.isEmpty()) {
                SaleAttachmentService saleAttachmentService = (SaleAttachmentService)SpringContextUtils.getBean(SaleAttachmentService.class);
                saleAttachmentService.saveBatch(insertSaleList);
            }
        }
    }

    @Override
    public List<PurchaseAttachment> selectByMainId(String mainId) {
        return ((PurchaseAttachmentMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseAttachmentMapper)this.baseMapper).delete((Wrapper)new LambdaQueryWrapper().eq(PurchaseAttachment::getHeadId, (Object)mainId));
    }

    @Override
    public void updateSaleFile(AttachmentSendVO sendVO) {
        List<SaleAttachment> attachmentList = this.saleAttachmentMapper.selectByMainId(sendVO.getHeadId());
        if (!attachmentList.isEmpty()) {
            Map<String, String> sendMap = sendVO.getToSend();
            for (String id : sendMap.keySet()) {
                String elsAccount = sendMap.get(id);
                List list = attachmentList.stream().filter(o -> o.getUploadElsAccount().equals(elsAccount)).collect(Collectors.toList());
                for (SaleAttachment attachment : list) {
                    attachment.setHeadId(id);
                    this.saleAttachmentMapper.updateById((Object)attachment);
                }
            }
        }
    }
}

