/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.els.common.system.vo.DictModel;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.impl.DictServiceImpl;
import java.util.List;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddressList;

public class ExcelDictWriteHandler
implements SheetWriteHandler {
    private List<ExcelDetail> detailList;
    private DictService sysDictService;

    public ExcelDictWriteHandler(List<ExcelDetail> detailList) {
        this.detailList = detailList;
        this.sysDictService = (DictService)SpringContextUtils.getBean(DictServiceImpl.class);
    }

    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        Sheet sheet = writeSheetHolder.getSheet();
        DataValidationHelper helper = sheet.getDataValidationHelper();
        for (ExcelDetail detail : this.detailList) {
            List<DictModel> dictList;
            int index = detail.getColumnIndex() - 1;
            if (!ExcelDataTypeEnum.DICT.getCode().equals(detail.getDataType()) || (dictList = this.sysDictService.queryDictItemsByCode(detail.getDataFormat(), TenantContext.getTenant())).size() <= 0) continue;
            String[] values = new String[dictList.size()];
            for (int i = 0; i < dictList.size(); ++i) {
                values[i] = dictList.get(i).getText();
            }
            CellRangeAddressList addressList = new CellRangeAddressList(2, 1000, index, index);
            DataValidationConstraint constraint = helper.createExplicitListConstraint(values);
            DataValidation dataValidation = helper.createValidation(constraint, addressList);
            sheet.addValidationData(dataValidation);
        }
    }
}

