/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.template.util;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;

public class ListColumnQueryBuilder {
    private static final int DB_LIST_IN_MAX_SIZE = 998;

    public static <T, U> List<List<U>> partitionList(List<T> list, Function<T, U> apply) {
        List fields = list.stream().map(apply).collect(Collectors.toList());
        return ListUtils.partition(fields, (int)998);
    }

    public static <O, T, C, E, F> List<T> batchQueryByColumnList(List<O> originList, Function<O, C> listColumnApply, SFunction<T, C> inField, Function<QueryWrapper<T>, List<T>> serviceApply, List<OtherEqColumnQuery<T, E>> otherEqColumnQueries, List<SortColumn<T, F>> sortColumns) {
        List fields = originList.stream().map(listColumnApply).collect(Collectors.toList());
        List ids = ListUtils.partition(fields, (int)998);
        QueryWrapper queryWrapper = Wrappers.query();
        if (ids.isEmpty()) {
            queryWrapper.lambda().inSql(inField, null);
            return serviceApply.apply((QueryWrapper<QueryWrapper>)queryWrapper);
        }
        if (null != otherEqColumnQueries) {
            for (OtherEqColumnQuery<T, E> otherEqColumnQuery : otherEqColumnQueries) {
                if (otherEqColumnQuery.isLam) {
                    queryWrapper.lambda().eq(ObjectUtil.isNull(otherEqColumnQuery.getOtherEqColumnValue()), otherEqColumnQuery.getOtherEqColumn(), otherEqColumnQuery.getOtherEqColumnValue());
                    continue;
                }
                queryWrapper.eq((Object)otherEqColumnQuery.getColumn(), otherEqColumnQuery.getOtherEqColumnValue());
            }
        }
        if (null != sortColumns) {
            sortColumns.sort(Comparator.comparingInt(SortColumn::getOrder));
            for (SortColumn sortColumn : sortColumns) {
                if (sortColumn.desc) {
                    if (sortColumn.isLam) {
                        queryWrapper.lambda().orderByDesc(sortColumn.lamSortColumn);
                        continue;
                    }
                    queryWrapper.orderByDesc((Object)sortColumn.sortColumn);
                    continue;
                }
                if (sortColumn.isLam) {
                    queryWrapper.lambda().orderByAsc(sortColumn.lamSortColumn);
                    continue;
                }
                queryWrapper.orderByAsc((Object)sortColumn.sortColumn);
            }
        }
        queryWrapper.and(q -> {
            for (int i = 0; i < ids.size(); ++i) {
                if (i < ids.size() - 1) {
                    ((LambdaQueryWrapper)q.lambda().in((Object)inField, (Collection)ids.get(i))).or();
                    continue;
                }
                q.lambda().in((Object)inField, (Collection)ids.get(i));
            }
        });
        return serviceApply.apply((QueryWrapper<QueryWrapper>)queryWrapper);
    }

    public static <T, V> void lambdaWrapperEqOrNullBuilder(LambdaQueryWrapper<T> wrapper, SFunction<T, V> function, V value) {
        if (null == value) {
            wrapper.isNull(function);
        } else {
            wrapper.eq(function, value);
        }
    }

    public static <O, T, C, E, F> Map<C, List<T>> batchQueryByColumnListToMap(List<O> originList, Function<O, C> listColumnApply, SFunction<T, C> inField, Function<QueryWrapper<T>, List<T>> serviceApply, List<OtherEqColumnQuery<T, E>> otherEqColumnQueries, List<SortColumn<T, F>> sortColumns) {
        List<T> result = ListColumnQueryBuilder.batchQueryByColumnList(originList, listColumnApply, inField, serviceApply, otherEqColumnQueries, sortColumns);
        return result.stream().collect(Collectors.groupingBy(inField));
    }

    public static class SortColumn<T, C> {
        boolean isLam = true;
        String sortColumn;
        SFunction<T, C> lamSortColumn;
        int order;
        boolean desc;

        public static <T, C> SortColumn<T, C> builder(SFunction<T, C> otherSortColumn, boolean desc) {
            SortColumn<T, C> o = new SortColumn<T, C>();
            o.setLamSortColumn(otherSortColumn);
            o.setDesc(desc);
            o.setOrder(0);
            return o;
        }

        public static <T, C> SortColumn<T, C> builder(SFunction<T, C> otherSortColumn, boolean desc, Integer order) {
            SortColumn<T, C> o = new SortColumn<T, C>();
            o.setLamSortColumn(otherSortColumn);
            o.setOrder(null == order ? 0 : order);
            o.setDesc(desc);
            return o;
        }

        public static <T, C> SortColumn<T, C> builder(String sortColumn, boolean desc) {
            SortColumn<T, C> o = new SortColumn<T, C>();
            o.setSortColumn(sortColumn);
            o.setLam(false);
            o.setDesc(desc);
            return o;
        }

        private SortColumn() {
        }

        public boolean isLam() {
            return this.isLam;
        }

        public String getSortColumn() {
            return this.sortColumn;
        }

        public SFunction<T, C> getLamSortColumn() {
            return this.lamSortColumn;
        }

        public int getOrder() {
            return this.order;
        }

        public boolean isDesc() {
            return this.desc;
        }

        public void setLam(boolean isLam) {
            this.isLam = isLam;
        }

        public void setSortColumn(String sortColumn) {
            this.sortColumn = sortColumn;
        }

        public void setLamSortColumn(SFunction<T, C> lamSortColumn) {
            this.lamSortColumn = lamSortColumn;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public void setDesc(boolean desc) {
            this.desc = desc;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SortColumn)) {
                return false;
            }
            SortColumn other = (SortColumn)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isLam() != other.isLam()) {
                return false;
            }
            if (this.getOrder() != other.getOrder()) {
                return false;
            }
            if (this.isDesc() != other.isDesc()) {
                return false;
            }
            String this$sortColumn = this.getSortColumn();
            String other$sortColumn = other.getSortColumn();
            if (this$sortColumn == null ? other$sortColumn != null : !this$sortColumn.equals(other$sortColumn)) {
                return false;
            }
            SFunction<T, C> this$lamSortColumn = this.getLamSortColumn();
            SFunction<T, C> other$lamSortColumn = other.getLamSortColumn();
            return !(this$lamSortColumn == null ? other$lamSortColumn != null : !this$lamSortColumn.equals(other$lamSortColumn));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SortColumn;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isLam() ? 79 : 97);
            result = result * 59 + this.getOrder();
            result = result * 59 + (this.isDesc() ? 79 : 97);
            String $sortColumn = this.getSortColumn();
            result = result * 59 + ($sortColumn == null ? 43 : $sortColumn.hashCode());
            SFunction<T, C> $lamSortColumn = this.getLamSortColumn();
            result = result * 59 + ($lamSortColumn == null ? 43 : $lamSortColumn.hashCode());
            return result;
        }

        public String toString() {
            return "ListColumnQueryBuilder.SortColumn(isLam=" + this.isLam() + ", sortColumn=" + this.getSortColumn() + ", lamSortColumn=" + this.getLamSortColumn() + ", order=" + this.getOrder() + ", desc=" + this.isDesc() + ")";
        }
    }

    public static class OtherEqColumnQuery<T, C> {
        boolean isLam = true;
        String column;
        SFunction<T, C> otherEqColumn;
        C otherEqColumnValue;

        public static <T, C> OtherEqColumnQuery<T, C> builder(SFunction<T, C> otherColumn, C otherColumnValue) {
            OtherEqColumnQuery<T, C> o = new OtherEqColumnQuery<T, C>();
            o.setOtherEqColumn(otherColumn);
            o.setOtherEqColumnValue(otherColumnValue);
            return o;
        }

        public static <T, C> OtherEqColumnQuery<T, C> builder(String column, C otherColumnValue) {
            OtherEqColumnQuery<T, C> o = new OtherEqColumnQuery<T, C>();
            o.setColumn(column);
            o.setLam(false);
            o.setOtherEqColumnValue(otherColumnValue);
            return o;
        }

        private OtherEqColumnQuery() {
        }

        public boolean isLam() {
            return this.isLam;
        }

        public String getColumn() {
            return this.column;
        }

        public SFunction<T, C> getOtherEqColumn() {
            return this.otherEqColumn;
        }

        public C getOtherEqColumnValue() {
            return this.otherEqColumnValue;
        }

        public void setLam(boolean isLam) {
            this.isLam = isLam;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public void setOtherEqColumn(SFunction<T, C> otherEqColumn) {
            this.otherEqColumn = otherEqColumn;
        }

        public void setOtherEqColumnValue(C otherEqColumnValue) {
            this.otherEqColumnValue = otherEqColumnValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OtherEqColumnQuery)) {
                return false;
            }
            OtherEqColumnQuery other = (OtherEqColumnQuery)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isLam() != other.isLam()) {
                return false;
            }
            String this$column = this.getColumn();
            String other$column = other.getColumn();
            if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
                return false;
            }
            SFunction<T, C> this$otherEqColumn = this.getOtherEqColumn();
            SFunction<T, C> other$otherEqColumn = other.getOtherEqColumn();
            if (this$otherEqColumn == null ? other$otherEqColumn != null : !this$otherEqColumn.equals(other$otherEqColumn)) {
                return false;
            }
            C this$otherEqColumnValue = this.getOtherEqColumnValue();
            C other$otherEqColumnValue = other.getOtherEqColumnValue();
            return !(this$otherEqColumnValue == null ? other$otherEqColumnValue != null : !this$otherEqColumnValue.equals(other$otherEqColumnValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OtherEqColumnQuery;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isLam() ? 79 : 97);
            String $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : $column.hashCode());
            SFunction<T, C> $otherEqColumn = this.getOtherEqColumn();
            result = result * 59 + ($otherEqColumn == null ? 43 : $otherEqColumn.hashCode());
            C $otherEqColumnValue = this.getOtherEqColumnValue();
            result = result * 59 + ($otherEqColumnValue == null ? 43 : $otherEqColumnValue.hashCode());
            return result;
        }

        public String toString() {
            return "ListColumnQueryBuilder.OtherEqColumnQuery(isLam=" + this.isLam() + ", column=" + this.getColumn() + ", otherEqColumn=" + this.getOtherEqColumn() + ", otherEqColumnValue=" + this.getOtherEqColumnValue() + ")";
        }
    }
}

