/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.oss.service;

import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.oss.service.IAttachmnetService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

@Component
public class LocalFileServiceImpl
implements IAttachmnetService {
    @Value(value="${els.path.upload}")
    private String uploadpath;
    private static final String STR_SPLIT = "_";
    private static final String STR_DOT = ".";
    private static final String STR_FORMAT = "yyyyMMdd";

    @Override
    public String uploadFile(MultipartFile uploadFile) throws IOException {
        String documentName = uploadFile.getOriginalFilename();
        String documentType = "";
        String bizPath = "files";
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowDay = dtf.format(time);
        String elsAccount = TenantContext.getTenant();
        File file = new File(this.uploadpath + File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay);
        if (!file.exists()) {
            file.mkdirs();
        }
        String fileName = "";
        int suffixLocation = documentName.lastIndexOf(STR_DOT);
        if (suffixLocation > 0) {
            documentType = documentName.substring(suffixLocation + 1);
            fileName = documentName.substring(0, documentName.lastIndexOf(STR_DOT)) + STR_SPLIT + System.currentTimeMillis() + STR_DOT + documentType;
        } else {
            fileName = documentName + STR_SPLIT + System.currentTimeMillis();
        }
        String documentLocation = File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay + File.separator + fileName;
        if (documentLocation.contains("\\")) {
            documentLocation = documentLocation.replace("\\", "/");
        }
        String savePath = file.getPath() + File.separator + fileName;
        File savefile = new File(savePath);
        FileCopyUtils.copy((byte[])uploadFile.getBytes(), (File)savefile);
        return savePath;
    }

    @Override
    public void downloadFile(OutputStream outputStream, String filePath) throws Exception {
        int len;
        String downloadFilePath = this.uploadpath + File.separator + filePath;
        File file = new File(downloadFilePath);
        Assert.isTrue((boolean)file.exists(), (String)I18nUtil.translate((String)"", (String)"\u9644\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"));
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)inputStream).read(buf)) > 0) {
            outputStream.write(buf, 0, len);
        }
        outputStream.flush();
    }
}

