/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.barcode.entity.SaleBarcodeInfoDetail;
import com.els.modules.barcode.entity.SaleBarcodeInfoHead;
import com.els.modules.barcode.entity.SaleBarcodeInfoItem;
import com.els.modules.barcode.entity.SaleBarcodePoolHead;
import com.els.modules.barcode.entity.SaleBarcodePoolItem;
import com.els.modules.barcode.entity.SaleBarcodePoolRecord;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.mapper.SaleBarcodePoolHeadMapper;
import com.els.modules.barcode.mapper.SaleBarcodePoolItemMapper;
import com.els.modules.barcode.mapper.SaleBarcodePoolRecordMapper;
import com.els.modules.barcode.service.SaleBarcodePoolHeadService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleBarcodePoolHeadServiceImpl
extends BaseServiceImpl<SaleBarcodePoolHeadMapper, SaleBarcodePoolHead>
implements SaleBarcodePoolHeadService {
    @Autowired
    private SaleBarcodePoolHeadMapper saleBarcodePoolHeadMapper;
    @Autowired
    private SaleBarcodePoolItemMapper saleBarcodePoolItemMapper;
    @Autowired
    private SaleBarcodePoolRecordMapper saleBarcodePoolRecordMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleBarcodePoolHead saleBarcodePoolHead, List<SaleBarcodePoolItem> saleBarcodePoolItemList, List<SaleBarcodePoolRecord> saleBarcodePoolRecordList) {
        this.saleBarcodePoolHeadMapper.insert((Object)saleBarcodePoolHead);
        this.insertData(saleBarcodePoolHead, saleBarcodePoolItemList, saleBarcodePoolRecordList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleBarcodePoolHead saleBarcodePoolHead, List<SaleBarcodePoolItem> saleBarcodePoolItemList, List<SaleBarcodePoolRecord> saleBarcodePoolRecordList) {
        this.saleBarcodePoolHeadMapper.updateById((Object)saleBarcodePoolHead);
        this.saleBarcodePoolItemMapper.deleteByMainId(saleBarcodePoolHead.getId());
        this.saleBarcodePoolRecordMapper.deleteByMainId(saleBarcodePoolHead.getId());
        this.insertData(saleBarcodePoolHead, saleBarcodePoolItemList, saleBarcodePoolRecordList);
    }

    private void insertData(SaleBarcodePoolHead saleBarcodePoolHead, List<SaleBarcodePoolItem> saleBarcodePoolItemList, List<SaleBarcodePoolRecord> saleBarcodePoolRecordList) {
        for (SaleBarcodePoolItem saleBarcodePoolItem : saleBarcodePoolItemList) {
            saleBarcodePoolItem.setHeadId(saleBarcodePoolHead.getId());
            SysUtil.setSysParam((BaseEntity)saleBarcodePoolItem, (BaseEntity)saleBarcodePoolHead);
        }
        if (!saleBarcodePoolItemList.isEmpty()) {
            this.saleBarcodePoolItemMapper.insertBatchSomeColumn(saleBarcodePoolItemList);
        }
        for (SaleBarcodePoolRecord saleBarcodePoolRecord : saleBarcodePoolRecordList) {
            saleBarcodePoolRecord.setHeadId(saleBarcodePoolHead.getId());
            SysUtil.setSysParam((BaseEntity)saleBarcodePoolRecord, (BaseEntity)saleBarcodePoolHead);
        }
        if (!saleBarcodePoolRecordList.isEmpty()) {
            this.saleBarcodePoolRecordMapper.insertBatchSomeColumn(saleBarcodePoolRecordList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleBarcodePoolItemMapper.deleteByMainId(id);
        this.saleBarcodePoolRecordMapper.deleteByMainId(id);
        this.saleBarcodePoolHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleBarcodePoolItemMapper.deleteByMainId(serializable.toString());
            this.saleBarcodePoolRecordMapper.deleteByMainId(serializable.toString());
            this.saleBarcodePoolHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @Transactional
    public void addByBarcodeInfo(SaleBarcodeInfoHead saleBarcodeInfoHead, List<SaleBarcodeInfoItem> saleBarcodeInfoItemList, List<SaleBarcodeInfoDetail> sysBarcodeList) {
        if (sysBarcodeList != null && sysBarcodeList.size() > 0) {
            for (SaleBarcodeInfoDetail detail : sysBarcodeList) {
                SaleBarcodePoolHead poolHead = new SaleBarcodePoolHead();
                poolHead.setOriginalBarcode(detail.getOriginalBarcode());
                poolHead.setBarcode(detail.getBarcode());
                poolHead.setInfoNumber(saleBarcodeInfoHead.getInfoNumber());
                poolHead.setRuleCode(saleBarcodeInfoHead.getRuleCode());
                poolHead.setRuleId(saleBarcodeInfoHead.getRuleId());
                poolHead.setStatus(SrmEnabledStatusEnum.ENABLED.getValue());
                poolHead.setPrintNumber(detail.getPrintNumber());
                poolHead.setPrintedNumber(0);
                poolHead.setUsed("1");
                poolHead.setElsAccount(detail.getElsAccount());
                poolHead.setToElsAccount(detail.getToElsAccount());
                poolHead.setSupplierName(detail.getSupplierName());
                poolHead.setSupplierCode(detail.getSupplierCode());
                this.save((Object)poolHead);
                ArrayList<SaleBarcodePoolItem> saleBarcodePoolItemList = new ArrayList<SaleBarcodePoolItem>();
                for (SaleBarcodeInfoItem entity : saleBarcodeInfoItemList) {
                    SaleBarcodePoolItem saleBarcodePoolItem = new SaleBarcodePoolItem();
                    BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)saleBarcodePoolItem));
                    saleBarcodePoolItem.setHeadId(poolHead.getId());
                    saleBarcodePoolItem.setRelationId(null);
                    saleBarcodePoolItem.setId(null);
                    for (String attr : entity.getAttribute().split(",")) {
                        if (!poolHead.getOriginalBarcode().contains(attr)) continue;
                        saleBarcodePoolItem.setAttribute(attr);
                    }
                    saleBarcodePoolItemList.add(saleBarcodePoolItem);
                }
                this.saleBarcodePoolItemMapper.insertBatchSomeColumn(saleBarcodePoolItemList);
            }
        }
    }
}

