/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl.base;

import com.els.common.util.AssertI18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.encryption.base.IEncryption;
import com.els.modules.barcode.enumerate.EncryptionEnum;
import com.els.modules.barcode.enumerate.I18nBarCodeEnum;
import com.els.modules.barcode.mapper.ElsBarCodeShortCodeMapper;
import com.els.modules.barcode.mapper.ElsBarcodeRuleHeadMapper;
import com.els.modules.barcode.utils.BarCodeSubUtil;
import com.els.modules.barcode.vo.BarCodeExplainItemVO;
import com.els.modules.barcode.vo.BarCodeExplainRespVO;
import com.els.modules.barcode.vo.BarCodeRuleItemVO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;

public abstract class BaseExplainService {
    protected ElsBarcodeRuleHeadMapper ruleHeadMapper;
    protected ElsBarCodeShortCodeMapper shortCodeMapper;

    public void setRuleHeadMapper(ElsBarcodeRuleHeadMapper ruleHeadMapper) {
        this.ruleHeadMapper = ruleHeadMapper;
    }

    public void setShortCodeMapper(ElsBarCodeShortCodeMapper shortCodeMapper) {
        this.shortCodeMapper = shortCodeMapper;
    }

    protected abstract List<BarCodeExplainItemVO> barCodeLibrary(String var1);

    protected abstract BarCodeExplainRespVO explainByLibrary(String var1, int var2);

    protected String getOriginalValue(String shortCode, String codeType) {
        return this.shortCodeMapper.getOriginalValue(shortCode, codeType, TenantContext.getTenant());
    }

    protected String getShortCodeValue(String originalValue, String codeType) {
        return this.shortCodeMapper.getShortCodeValue(originalValue, codeType, TenantContext.getTenant());
    }

    protected String originalBarcode(String barcodeContent) {
        String encryptionType = BarCodeSubUtil.subLastChar(barcodeContent);
        IEncryption iEncryption = EncryptionEnum.of(encryptionType);
        return iEncryption.cipherTextDecrypt(BarCodeSubUtil.removeLastChar(barcodeContent)) + encryptionType;
    }

    protected List<BarCodeExplainItemVO> explainBarCode(String cipherBarcode) {
        AssertI18nUtil.isTrue((cipherBarcode.length() < 4 ? 1 : 0) != 0, (Enum)I18nBarCodeEnum.BAR_CODE_IS_ILLEGAL);
        String ruleNum = BarCodeSubUtil.subRuleNum(cipherBarcode);
        List<BarCodeRuleItemVO> ruleItems = this.ruleHeadMapper.getRuleItemByRodeCode(ruleNum, TenantContext.getTenant());
        AssertI18nUtil.isTrue((boolean)CollectionUtils.isEmpty(ruleItems), (Enum)I18nBarCodeEnum.RULE_CODE_NOT_FOUND);
        int sumLen = ruleItems.stream().mapToInt(BarCodeRuleItemVO::getLength).sum();
        AssertI18nUtil.isTrue((sumLen != cipherBarcode.length() - 4 ? 1 : 0) != 0, (Enum)I18nBarCodeEnum.BAR_CODE_IS_ILLEGAL);
        ArrayList<BarCodeExplainItemVO> explainItemVOS = new ArrayList<BarCodeExplainItemVO>();
        for (BarCodeRuleItemVO ruleItemVO : ruleItems) {
            String subValue = BarCodeSubUtil.subBarCode(cipherBarcode, ruleItemVO.getLength());
            BarCodeExplainItemVO explainItemVO = new BarCodeExplainItemVO();
            explainItemVO.setAttrType(ruleItemVO.getBusinessType()).setAttrName(ruleItemVO.getBusinessFieldName()).setOriginalValue(subValue);
            if ("1".equals(ruleItemVO.getUsedCode())) {
                String originalValue = this.getOriginalValue(subValue, ruleItemVO.getCodeType());
                explainItemVO.setOriginalValue(originalValue).setShortCode(subValue);
            }
            explainItemVOS.add(explainItemVO);
            cipherBarcode = BarCodeSubUtil.removebarCode(cipherBarcode, ruleItemVO.getLength());
        }
        return explainItemVOS;
    }

    protected BarCodeExplainRespVO explainByRule(String barCodeCotent) {
        String cipherBarcode = this.originalBarcode(barCodeCotent);
        List<BarCodeExplainItemVO> itemVOS = this.explainBarCode(cipherBarcode);
        return new BarCodeExplainRespVO(cipherBarcode, itemVOS);
    }
}

