/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dashboard.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.config.mybatis.TenantContext;
import com.els.modules.dashboard.entity.ChartUserConfig;
import com.els.modules.dashboard.mapper.ChartUserConfigMapper;
import com.els.modules.dashboard.service.ChartUserConfigService;
import com.els.modules.dashboard.vo.ChartConfigVO;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ChartUserConfigServiceImpl
extends ServiceImpl<ChartUserConfigMapper, ChartUserConfig>
implements ChartUserConfigService {
    private final Integer DISPLAY = 1;

    @Override
    public void saveChartUserConfig(ChartUserConfig chartUserConfig) {
        ((ChartUserConfigMapper)this.baseMapper).insert((Object)chartUserConfig);
    }

    @Override
    public void updateChartUserConfig(ChartUserConfig chartUserConfig) {
        ((ChartUserConfigMapper)this.baseMapper).updateById((Object)chartUserConfig);
    }

    @Override
    public void delChartUserConfig(String id) {
        ((ChartUserConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchChartUserConfig(List<String> idList) {
        ((ChartUserConfigMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<ChartConfigVO> getDashboardByUserId(String dashboardCode, String id) {
        return ((ChartUserConfigMapper)this.baseMapper).getDashboardByUserId(dashboardCode, id, TenantContext.getTenant());
    }

    @Override
    public List<ChartConfigVO> getDashboardConfigByUserId(String dashboardCode, String id) {
        return ((ChartUserConfigMapper)this.baseMapper).getDashboardConfigByUserId(dashboardCode, id, TenantContext.getTenant());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveUserConfig(String userId, List<ChartUserConfig> chartUserConfigList) {
        for (ChartUserConfig chartUserConfig : chartUserConfigList) {
            chartUserConfig.setDisplay(this.DISPLAY);
            chartUserConfig.setUserId(userId);
            if (StrUtil.isNotBlank((CharSequence)chartUserConfig.getId())) {
                ((ChartUserConfigMapper)this.baseMapper).updateById((Object)chartUserConfig);
                continue;
            }
            ((ChartUserConfigMapper)this.baseMapper).insert((Object)chartUserConfig);
        }
    }
}

