/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.service.DictItemService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/dictItem"})
public class DictItemController {
    private static final Logger log = LoggerFactory.getLogger(DictItemController.class);
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String CATALOGUE = "sys:cache:dict";

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<DictItem>> queryPageList(DictItem sysDictItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysDictItem, (Map)req.getParameterMap());
        queryWrapper.orderByAsc((Object)"sort_order");
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.dictItemService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @RequestMapping(value={"/sysList"}, method={RequestMethod.GET})
    public Result<IPage<DictItem>> querySysPageList(DictItem sysDictItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysDictItem, (Map)req.getParameterMap());
        queryWrapper.orderByAsc((Object)"sort_order");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.dictItemService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<DictItem> add(@RequestBody DictItem sysDictItem) {
        Result result = new Result();
        try {
            sysDictItem.setCreateTime(new Date());
            this.dictItemService.save(sysDictItem);
            this.cleanRedis(sysDictItem.getDictId(), TenantContext.getTenant());
            result.success("\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<DictItem> edit(@RequestBody DictItem sysDictItem) {
        Result result = new Result();
        DictItem sysdict = (DictItem)this.dictItemService.getById((Serializable)((Object)sysDictItem.getId()));
        if (sysdict == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            sysDictItem.setUpdateTime(new Date());
            boolean ok = this.dictItemService.updateById(sysDictItem);
            if (ok) {
                result.success("\u7f16\u8f91\u6210\u529f!");
            }
            this.cleanRedis(sysDictItem.getDictId(), TenantContext.getTenant());
        }
        return result;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<DictItem> delete(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        DictItem joinSystem = (DictItem)this.dictItemService.getById((Serializable)((Object)id));
        String dict_id = null;
        if (joinSystem == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            dict_id = joinSystem.getDictId();
            boolean ok = this.dictItemService.removeById((Serializable)((Object)id));
            if (ok) {
                result.success("\u5220\u9664\u6210\u529f!");
            }
            this.cleanRedis(dict_id, TenantContext.getTenant());
        }
        return result;
    }

    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.GET})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<DictItem> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        if (ids == null || "".equals(ids.trim())) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            DictItem joinSystem = (DictItem)this.dictItemService.getById((Serializable)((Object)ids.split(",")[0]));
            this.dictItemService.removeByIds(Arrays.asList(ids.split(",")));
            if (joinSystem != null) {
                this.cleanRedis(joinSystem.getDictId(), TenantContext.getTenant());
            }
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    public void cleanRedis(String dict_id, String elsAccount) {
        Dict dict = this.dictItemService.selectByDictId(dict_id, elsAccount);
        this.redisUtil.set(CATALOGUE + elsAccount + ":" + dict.getDictCode(), null);
    }
}

