/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.template.service.impl;

import cn.hutool.core.convert.Convert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.language.entity.I18n;
import com.els.modules.language.service.I18nService;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigHeadHis;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.entity.TemplateConfigItemHis;
import com.els.modules.template.entity.TemplateGroup;
import com.els.modules.template.entity.TemplateGroupHis;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.entity.TemplateHeadHis;
import com.els.modules.template.enumerate.TemplateStatusEnum;
import com.els.modules.template.mapper.TemplateConfigHeadMapper;
import com.els.modules.template.mapper.TemplateConfigItemMapper;
import com.els.modules.template.mapper.TemplateGroupMapper;
import com.els.modules.template.mapper.TemplateHeadMapper;
import com.els.modules.template.service.TemplateConfigHeadService;
import com.els.modules.template.service.TemplateConfigItemService;
import com.els.modules.template.service.TemplateGroupService;
import com.els.modules.template.service.TemplateHeadHisService;
import com.els.modules.template.service.TemplateHeadService;
import com.els.modules.template.vo.TemplateHeadHisVO;
import com.els.modules.template.vo.TemplateHeadVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class TemplateHeadServiceImpl
extends ServiceImpl<TemplateHeadMapper, TemplateHead>
implements TemplateHeadService {
    @Resource
    private TemplateHeadMapper templateHeadMapper;
    @Resource
    private TemplateGroupMapper templateGroupMapper;
    @Resource
    private TemplateConfigHeadMapper templateConfigHeadMapper;
    @Resource
    private TemplateConfigItemMapper templateConfigItemMapper;
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    private TemplateHeadHisService templateHeadHisService;
    @Autowired
    private TemplateConfigItemService templateConfigItemService;
    @Autowired
    private I18nService i18nService;
    @Autowired
    private TemplateConfigHeadService templateConfigHeadService;
    @Autowired
    private TemplateGroupService templateGroupService;
    @Autowired
    private RedisUtil redisUtil;
    public static final String ADDRESS = "srm:template:";

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(TemplateHead templateHead, List<TemplateGroup> templateGroupList, List<TemplateConfigHead> templateConfigHeadList, List<TemplateConfigItem> templateConfigItemList) {
        String templateNumber = this.codeGeneratorService.getNextCode("srmTemplateNumber", (Object)templateHead);
        templateHead.setTemplateNumber(templateNumber);
        templateHead.setTemplateVersion(1);
        this.templateHeadMapper.insert((Object)templateHead);
        this.insertData(templateHead, templateGroupList, templateConfigHeadList, templateConfigItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(TemplateHead templateHead, List<TemplateGroup> templateGroupList, List<TemplateConfigHead> templateConfigHeadList, List<TemplateConfigItem> templateConfigItemList) {
        this.templateHeadMapper.updateById((Object)templateHead);
        this.templateGroupMapper.deleteByMainId(templateHead.getId());
        this.templateConfigHeadMapper.deleteByMainId(templateHead.getId());
        this.templateConfigItemMapper.deleteByMainId(templateHead.getId());
        this.insertData(templateHead, templateGroupList, templateConfigHeadList, templateConfigItemList);
    }

    private void insertData(TemplateHead templateHead, List<TemplateGroup> templateGroupList, List<TemplateConfigHead> templateConfigHeadList, List<TemplateConfigItem> templateConfigItemList) {
        String field;
        List collect = templateGroupList.parallelStream().filter(item -> StringUtils.isBlank((CharSequence)item.getGroupNameI18nKey())).map(item -> item.getGroupName()).collect(Collectors.toList());
        List collect1 = templateConfigHeadList.parallelStream().filter(item -> StringUtils.isBlank((CharSequence)item.getFieldLabelI18nKey())).distinct().map(item -> item.getFieldName()).collect(Collectors.toList());
        List collect2 = templateConfigItemList.parallelStream().filter(item -> StringUtils.isBlank((CharSequence)item.getFieldLabelI18nKey())).distinct().map(item -> item.getFieldName()).collect(Collectors.toList());
        List alertheadlist = templateConfigHeadList.parallelStream().filter(item -> StringUtils.isBlank((CharSequence)item.getAlertMsgI18nKey())).distinct().map(item -> item.getAlertMsg()).collect(Collectors.toList());
        List alertitemlist = templateConfigItemList.parallelStream().filter(item -> StringUtils.isBlank((CharSequence)item.getAlertMsgI18nKey())).distinct().map(item -> item.getAlertMsg()).collect(Collectors.toList());
        collect.addAll(collect1);
        collect.addAll(collect2);
        collect.addAll(alertitemlist);
        collect.addAll(alertheadlist);
        Map<Object, Object> stringMap = new HashMap();
        if (!CollectionUtils.isEmpty(collect)) {
            List zh = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.i18nService.lambdaQuery().eq(I18n::getLanguage, (Object)"zh")).in(I18n::getI18nValue, collect)).list();
            stringMap = zh.stream().collect(Collectors.toMap(I18n::getI18nValue, I18n::getI18nKey, (key1, key2) -> key2));
        }
        HashMap<String, String> noKeyHashMap = new HashMap<String, String>();
        for (TemplateGroup templateGroup : templateGroupList) {
            templateGroup.setId(null);
            templateGroup.setHeadId(templateHead.getId());
            SysUtil.setSysParam((BaseEntity)templateGroup, (BaseEntity)templateHead);
            if (!StringUtils.isBlank((CharSequence)templateGroup.getGroupNameI18nKey())) continue;
            if (stringMap.containsKey(templateGroup.getGroupName())) {
                templateGroup.setGroupNameI18nKey((String)stringMap.get(templateGroup.getGroupName()));
                continue;
            }
            field = this.i18nService.createI18nKey(templateGroup.getGroupName(), "field");
            noKeyHashMap.put(templateGroup.getGroupName(), field);
            templateGroup.setGroupNameI18nKey(field);
        }
        if (!templateGroupList.isEmpty()) {
            this.templateGroupMapper.insertBatchSomeColumn(templateGroupList);
        }
        for (TemplateConfigHead templateConfigHead : templateConfigHeadList) {
            templateConfigHead.setId(null);
            templateConfigHead.setHeadId(templateHead.getId());
            templateConfigHead.setPurchaseEdit(templateConfigHead.getPurchaseEdit() == null ? "0" : templateConfigHead.getPurchaseEdit());
            templateConfigHead.setPurchaseShow(templateConfigHead.getPurchaseShow() == null ? "0" : templateConfigHead.getPurchaseShow());
            templateConfigHead.setSaleEdit(templateConfigHead.getSaleEdit() == null ? "0" : templateConfigHead.getSaleEdit());
            templateConfigHead.setSaleShow(templateConfigHead.getSaleShow() == null ? "0" : templateConfigHead.getSaleShow());
            templateConfigHead.setRequired(templateConfigHead.getRequired() == null ? "0" : templateConfigHead.getRequired());
            templateConfigHead.setSys(templateConfigHead.getSys() == null ? "0" : templateConfigHead.getSys());
            SysUtil.setSysParam((BaseEntity)templateConfigHead, (BaseEntity)templateHead);
            if (StringUtils.isBlank((CharSequence)templateConfigHead.getFieldLabelI18nKey())) {
                if (stringMap.containsKey(templateConfigHead.getFieldLabel())) {
                    templateConfigHead.setFieldLabelI18nKey((String)stringMap.get(templateConfigHead.getFieldLabel()));
                } else {
                    field = this.i18nService.createI18nKey(templateConfigHead.getFieldLabel(), "field");
                    noKeyHashMap.put(templateConfigHead.getFieldLabel(), field);
                    templateConfigHead.setFieldLabelI18nKey(field);
                }
            }
            if (!StringUtils.isBlank((CharSequence)templateConfigHead.getAlertMsgI18nKey()) || StringUtils.isBlank((CharSequence)templateConfigHead.getAlertMsg())) continue;
            if (stringMap.containsKey(templateConfigHead.getAlertMsg())) {
                templateConfigHead.setAlertMsgI18nKey((String)stringMap.get(templateConfigHead.getAlertMsg()));
                continue;
            }
            field = this.i18nService.createI18nKey(templateConfigHead.getAlertMsg(), "field");
            noKeyHashMap.put(templateConfigHead.getAlertMsg(), field);
            templateConfigHead.setAlertMsgI18nKey(field);
        }
        if (!templateConfigHeadList.isEmpty()) {
            this.templateConfigHeadMapper.insertBatchSomeColumn(templateConfigHeadList);
        }
        for (TemplateConfigItem templateConfigItem : templateConfigItemList) {
            templateConfigItem.setId(null);
            templateConfigItem.setHeadId(templateHead.getId());
            templateConfigItem.setPurchaseEdit(templateConfigItem.getPurchaseEdit() == null ? "0" : templateConfigItem.getPurchaseEdit());
            templateConfigItem.setPurchaseShow(templateConfigItem.getPurchaseShow() == null ? "0" : templateConfigItem.getPurchaseShow());
            templateConfigItem.setSaleEdit(templateConfigItem.getSaleEdit() == null ? "0" : templateConfigItem.getSaleEdit());
            templateConfigItem.setSaleShow(templateConfigItem.getSaleShow() == null ? "0" : templateConfigItem.getSaleShow());
            templateConfigItem.setRequired(templateConfigItem.getRequired() == null ? "0" : templateConfigItem.getRequired());
            templateConfigItem.setSys(templateConfigItem.getSys() == null ? "0" : templateConfigItem.getSys());
            SysUtil.setSysParam((BaseEntity)templateConfigItem, (BaseEntity)templateHead);
            if (StringUtils.isBlank((CharSequence)templateConfigItem.getFieldLabelI18nKey())) {
                if (stringMap.containsKey(templateConfigItem.getFieldLabel())) {
                    templateConfigItem.setFieldLabelI18nKey((String)stringMap.get(templateConfigItem.getFieldLabel()));
                } else {
                    field = this.i18nService.createI18nKey(templateConfigItem.getFieldLabel(), "field");
                    noKeyHashMap.put(templateConfigItem.getFieldLabel(), field);
                    templateConfigItem.setFieldLabelI18nKey(field);
                }
            }
            if (!StringUtils.isBlank((CharSequence)templateConfigItem.getAlertMsgI18nKey()) || StringUtils.isBlank((CharSequence)templateConfigItem.getAlertMsg())) continue;
            if (stringMap.containsKey(templateConfigItem.getAlertMsg())) {
                templateConfigItem.setAlertMsgI18nKey((String)stringMap.get(templateConfigItem.getAlertMsg()));
                continue;
            }
            field = this.i18nService.createI18nKey(templateConfigItem.getAlertMsg(), "field");
            noKeyHashMap.put(templateConfigItem.getAlertMsg(), field);
            templateConfigItem.setAlertMsgI18nKey(field);
        }
        if (!templateConfigItemList.isEmpty()) {
            this.templateConfigItemMapper.insertBatchSomeColumn(templateConfigItemList);
        }
        this.i18nService.addOtherKey(noKeyHashMap);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.templateGroupMapper.deleteByMainId(id);
        this.templateConfigHeadMapper.deleteByMainId(id);
        this.templateConfigItemMapper.deleteByMainId(id);
        this.templateHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.templateGroupMapper.deleteByMainId(serializable.toString());
            this.templateConfigHeadMapper.deleteByMainId(serializable.toString());
            this.templateConfigItemMapper.deleteByMainId(serializable.toString());
            this.templateHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void copyById(String id) {
        TemplateHead templateHead = (TemplateHead)((Object)this.templateHeadMapper.selectById((Serializable)((Object)id)));
        String templateNumber = this.codeGeneratorService.getNextCode("srmTemplateNumber", (Object)templateHead);
        templateHead.setId(null);
        templateHead.setElsAccount(TenantContext.getTenant());
        templateHead.setTemplateNumber(templateNumber);
        templateHead.setTemplateVersion(1);
        templateHead.setTemplateStatus("0");
        templateHead.setDefaultType("0");
        templateHead.setCreateBy(null);
        templateHead.setCreateTime(null);
        templateHead.setUpdateBy(null);
        templateHead.setUpdateTime(null);
        this.templateHeadMapper.insert((Object)templateHead);
        List<TemplateGroup> templateGroupList = this.templateGroupMapper.selectByMainId(id);
        for (TemplateGroup templateGroup : templateGroupList) {
            templateGroup.setId(null);
            templateGroup.setElsAccount(TenantContext.getTenant());
            templateGroup.setHeadId(templateHead.getId());
        }
        if (!templateGroupList.isEmpty()) {
            this.templateGroupMapper.insertBatchSomeColumn(templateGroupList);
        }
        List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadMapper.selectByMainId(id);
        for (TemplateConfigHead configHead : templateConfigHeadList) {
            configHead.setId(null);
            configHead.setElsAccount(TenantContext.getTenant());
            configHead.setHeadId(templateHead.getId());
        }
        if (!templateConfigHeadList.isEmpty()) {
            this.templateConfigHeadMapper.insertBatchSomeColumn(templateConfigHeadList);
        }
        List<TemplateConfigItem> list = this.templateConfigItemMapper.selectByMainId(id);
        for (TemplateConfigItem configItem : list) {
            configItem.setId(null);
            configItem.setElsAccount(TenantContext.getTenant());
            configItem.setHeadId(templateHead.getId());
        }
        if (!list.isEmpty()) {
            this.templateConfigItemMapper.insertBatchSomeColumn(list);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void upgradeVersion(String id) {
        TemplateHead templateHead = (TemplateHead)((Object)this.templateHeadMapper.selectById((Serializable)((Object)id)));
        TemplateHeadHis headHis = new TemplateHeadHis();
        BeanUtils.copyProperties((Object)((Object)templateHead), (Object)((Object)headHis));
        headHis.setId(null);
        TemplateHead updateHead = new TemplateHead();
        updateHead.setId(templateHead.getId());
        updateHead.setTemplateVersion(templateHead.getTemplateVersion() + 1);
        updateHead.setTemplateStatus(TemplateStatusEnum.NEW.getValue());
        this.templateHeadMapper.updateById((Object)updateHead);
        ArrayList<TemplateGroupHis> templateGroupHisList = new ArrayList<TemplateGroupHis>();
        ArrayList<TemplateConfigHeadHis> templateConfigHeadHisList = new ArrayList<TemplateConfigHeadHis>();
        ArrayList<TemplateConfigItemHis> templateConfigItemHisList = new ArrayList<TemplateConfigItemHis>();
        List<TemplateGroup> templateGroupList = this.templateGroupMapper.selectByMainId(id);
        for (TemplateGroup templateGroup : templateGroupList) {
            TemplateGroupHis groupHis = new TemplateGroupHis();
            BeanUtils.copyProperties((Object)((Object)templateGroup), (Object)((Object)groupHis));
            groupHis.setId(null);
            templateGroupHisList.add(groupHis);
        }
        List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadMapper.selectByMainId(id);
        for (TemplateConfigHead configHead : templateConfigHeadList) {
            TemplateConfigHeadHis configHeadHis = new TemplateConfigHeadHis();
            BeanUtils.copyProperties((Object)((Object)configHead), (Object)((Object)configHeadHis));
            configHeadHis.setId(null);
            templateConfigHeadHisList.add(configHeadHis);
        }
        List<TemplateConfigItem> list = this.templateConfigItemMapper.selectByMainId(id);
        for (TemplateConfigItem configItem : list) {
            TemplateConfigItemHis configItemHis = new TemplateConfigItemHis();
            BeanUtils.copyProperties((Object)((Object)configItem), (Object)((Object)configItemHis));
            configItemHis.setId(null);
            templateConfigItemHisList.add(configItemHis);
        }
        this.templateHeadHisService.saveMain(headHis, templateGroupHisList, templateConfigHeadHisList, templateConfigItemHisList);
    }

    @Override
    public TemplateHeadVO getAllConfig(String busAccount, String templateNumber, String templateVersion) {
        StringBuilder redisKey = new StringBuilder(ADDRESS).append(busAccount).append(":").append(templateNumber).append(":").append(templateVersion);
        TemplateHeadVO headVO = (TemplateHeadVO)((Object)this.redisUtil.get(redisKey.toString()));
        if (headVO == null) {
            headVO = new TemplateHeadVO();
            TemplateHead head = (TemplateHead)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)busAccount)).eq(TemplateHead::getTemplateNumber, (Object)templateNumber)).eq(TemplateHead::getTemplateVersion, (Object)templateVersion)));
            if (head == null) {
                TemplateHeadHisVO headHisVO = this.templateHeadHisService.getAllConfig(busAccount, templateNumber, templateVersion);
                BeanUtils.copyProperties((Object)((Object)headHisVO), (Object)((Object)headVO));
                ArrayList<TemplateConfigHead> templateConfigHeadList = new ArrayList<TemplateConfigHead>();
                for (TemplateConfigHeadHis headHis : headHisVO.getTemplateConfigHeadHisList()) {
                    TemplateConfigHead configHead = new TemplateConfigHead();
                    BeanUtils.copyProperties((Object)((Object)headHis), (Object)((Object)configHead));
                    templateConfigHeadList.add(configHead);
                }
                headVO.setTemplateConfigHeadList(templateConfigHeadList);
                ArrayList<TemplateConfigItem> templateConfigItemList = new ArrayList<TemplateConfigItem>();
                for (TemplateConfigItemHis itemHis : headHisVO.getTemplateConfigItemHisList()) {
                    TemplateConfigItem configItem = new TemplateConfigItem();
                    BeanUtils.copyProperties((Object)((Object)itemHis), (Object)((Object)configItem));
                    templateConfigItemList.add(configItem);
                }
                headVO.setTemplateConfigItemList(templateConfigItemList);
            } else {
                BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
                List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadMapper.selectByMainId(head.getId());
                headVO.setTemplateConfigHeadList(templateConfigHeadList);
                List<TemplateConfigItem> templateConfigItemList = this.templateConfigItemMapper.selectByMainId(head.getId());
                headVO.setTemplateConfigItemList(templateConfigItemList);
            }
            this.redisUtil.set(redisKey.toString(), (Object)headVO);
        }
        return headVO;
    }

    @Override
    public List<TemplateHead> getAllByAccountAndType(String elsAccount, String businessType) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        wrapper.eq((Object)"business_type", (Object)businessType);
        wrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        wrapper.eq((Object)"is_default_type", (Object)1);
        wrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        List list = this.templateHeadMapper.selectList((Wrapper)wrapper);
        List<TemplateHead> result = list.stream().filter(o -> "1".equals(o.getDefaultType())).collect(Collectors.toList());
        if (result.isEmpty()) {
            return list;
        }
        return result;
    }

    @Override
    public List<TemplateHead> getDefaultTemplateByType(String businessType) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TemplateHead::getBusinessType, (Object)businessType)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(TemplateHead::getTemplateStatus, (Object)TemplateStatusEnum.GENERATED.getValue())).eq(TemplateHead::getDefaultType, (Object)"1")).list();
        if (list.isEmpty()) {
            list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TemplateHead::getBusinessType, (Object)businessType)).eq(BaseEntity::getElsAccount, (Object)"100000")).eq(TemplateHead::getDefaultType, (Object)"1")).eq(TemplateHead::getTemplateStatus, (Object)TemplateStatusEnum.GENERATED.getValue())).list();
        }
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u8bf7\u914d\u7f6e" + businessType + "\u5e73\u53f0\u7ea7\u9ed8\u8ba4\u6a21\u677f")));
        }
        return list;
    }

    @Override
    public TemplateHead getDefaultOneTemplateByType(String businessType) {
        return this.getDefaultTemplateByType(businessType).get(0);
    }

    @Override
    public TemplateHeadVO selectVoById(String templateId) {
        TemplateHead templateHead = (TemplateHead)((Object)((TemplateHeadMapper)this.baseMapper).selectById((Serializable)((Object)templateId)));
        TemplateHeadVO vo = (TemplateHeadVO)((Object)Convert.convert(TemplateHeadVO.class, (Object)((Object)templateHead)));
        List<TemplateGroup> templateGroups = this.templateGroupMapper.selectByMainId(templateId);
        List<TemplateConfigHead> templateConfigHeads = this.templateConfigHeadMapper.selectByMainId(templateId);
        List<TemplateConfigItem> templateConfigItems = this.templateConfigItemMapper.selectByMainId(templateId);
        vo.setTemplateGroupList(templateGroups);
        vo.setTemplateConfigHeadList(templateConfigHeads);
        vo.setTemplateConfigItemList(templateConfigItems);
        return vo;
    }

    @Override
    public void addTempleI18nKey() {
        List collect1;
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.templateGroupService.lambdaQuery().isNull(TemplateGroup::getGroupName)).eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        List listHead = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.templateConfigHeadService.lambdaQuery().isNull(TemplateConfigHead::getFieldLabelI18nKey)).eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        List listItem = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.templateConfigItemService.lambdaQuery().isNull(TemplateConfigItem::getFieldLabelI18nKey)).eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        ArrayList<String> collect = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            collect = list.parallelStream().map(o -> o.getGroupName()).distinct().collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)listHead)) {
            collect1 = listHead.parallelStream().map(o -> o.getFieldName()).distinct().collect(Collectors.toList());
            collect.addAll(collect1);
        }
        if (!CollectionUtils.isEmpty((Collection)listItem)) {
            collect1 = listItem.parallelStream().map(o -> o.getFieldName()).distinct().collect(Collectors.toList());
            collect.addAll(collect1);
        }
        if (!CollectionUtils.isEmpty(collect)) {
            Map<String, String> stringStringMap = this.i18nService.checkAndAdd(collect);
            list.forEach(item -> item.setGroupNameI18nKey((String)stringStringMap.get(item.getGroupName())));
            listHead.forEach(item -> item.setFieldLabelI18nKey((String)stringStringMap.get(item.getFieldLabel())));
            listItem.forEach(item -> item.setFieldLabelI18nKey((String)stringStringMap.get(item.getFieldLabel())));
            this.templateGroupService.updateBatchById(list);
            this.templateConfigHeadService.updateBatchById(listHead);
            this.templateConfigItemService.updateBatchById(listItem);
        }
    }
}

