/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.execl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.PurchaseBarcodePoolHead;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.service.PurchaseBarcodePoolHeadService;
import com.els.modules.base.api.service.ExcelImportRpcService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="barcodePoolHeadExcelHandle")
public class BarcodePoolHeadExcelHandle
implements ExcelImportRpcService {
    @Autowired
    private PurchaseBarcodePoolHeadService purchaseBarcodePoolHeadService;

    public List<Map<String, Object>> importExcel(List<Map<String, Object>> dataList) {
        Assert.notEmpty(dataList, (String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        ArrayList<PurchaseBarcodePoolHead> entityList = new ArrayList<PurchaseBarcodePoolHead>();
        for (Map<String, Object> data : dataList) {
            PurchaseBarcodePoolHead entity = (PurchaseBarcodePoolHead)((Object)JSON.parseObject((String)JSON.toJSONString(data), PurchaseBarcodePoolHead.class));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(PurchaseBarcodePoolHead::getBarcode, (Object)entity.getBarcode());
            queryWrapper.lambda().eq(PurchaseBarcodePoolHead::getRuleCode, (Object)entity.getRuleCode());
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
            PurchaseBarcodePoolHead head = (PurchaseBarcodePoolHead)((Object)this.purchaseBarcodePoolHeadService.getOne((Wrapper)queryWrapper));
            Assert.isTrue((head == null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5bfc\u5165\u6570\u636e\u4e2d\u6709\u5df2\u7ecf\u5b58\u5728\u7684\u6761\u7801"));
            entity.setElsAccount(TenantContext.getTenant());
            entity.setStatus(SrmEnabledStatusEnum.ENABLED.getValue());
            entity.setPrintedNumber(0);
            entityList.add(entity);
        }
        List stringList = entityList.stream().map(PurchaseBarcodePoolHead::getBarcode).collect(Collectors.toList());
        long count = stringList.stream().distinct().count();
        Assert.isTrue((count == (long)stringList.size() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5bfc\u5165\u6570\u636e\u4e2d\u6709\u91cd\u590d\u7684\u6761\u7801"));
        this.purchaseBarcodePoolHeadService.saveBatch(entityList);
        return dataList;
    }
}

