/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.barcode.entity.SaleBarcodeInfoDetail;
import com.els.modules.barcode.entity.SaleBarcodeInfoHead;
import com.els.modules.barcode.entity.SaleBarcodeInfoItem;
import com.els.modules.barcode.entity.SaleBarcodePoolHead;
import com.els.modules.barcode.entity.SaleBarcodePoolItem;
import com.els.modules.barcode.entity.SaleBarcodePoolRecord;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.mapper.SaleBarcodePoolHeadMapper;
import com.els.modules.barcode.mapper.SaleBarcodePoolItemMapper;
import com.els.modules.barcode.mapper.SaleBarcodePoolRecordMapper;
import com.els.modules.barcode.service.SaleBarcodePoolHeadService;
import com.els.modules.barcode.service.SaleBarcodePoolItemService;
import com.els.modules.barcode.service.SaleBarcodePoolRecordService;
import com.els.modules.barcode.vo.BarcodeInfoVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleBarcodePoolHeadServiceImpl
extends BaseServiceImpl<SaleBarcodePoolHeadMapper, SaleBarcodePoolHead>
implements SaleBarcodePoolHeadService {
    @Autowired
    private SaleBarcodePoolHeadMapper saleBarcodePoolHeadMapper;
    @Autowired
    private SaleBarcodePoolItemMapper saleBarcodePoolItemMapper;
    @Autowired
    private SaleBarcodePoolItemService saleBarcodePoolItemService;
    @Autowired
    private SaleBarcodePoolRecordMapper saleBarcodePoolRecordMapper;
    @Autowired
    private SaleBarcodePoolRecordService saleBarcodePoolRecordService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleBarcodePoolHead saleBarcodePoolHead, List<SaleBarcodePoolItem> saleBarcodePoolItemList, List<SaleBarcodePoolRecord> saleBarcodePoolRecordList) {
        this.saleBarcodePoolHeadMapper.insert((Object)saleBarcodePoolHead);
        this.insertData(saleBarcodePoolHead, saleBarcodePoolItemList, saleBarcodePoolRecordList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleBarcodePoolHead saleBarcodePoolHead, List<SaleBarcodePoolItem> saleBarcodePoolItemList, List<SaleBarcodePoolRecord> saleBarcodePoolRecordList) {
        int count = this.saleBarcodePoolHeadMapper.updateById((Object)saleBarcodePoolHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.saleBarcodePoolItemMapper.deleteByMainId(saleBarcodePoolHead.getId());
        this.saleBarcodePoolRecordMapper.deleteByMainId(saleBarcodePoolHead.getId());
        this.insertData(saleBarcodePoolHead, saleBarcodePoolItemList, saleBarcodePoolRecordList);
    }

    private void insertData(SaleBarcodePoolHead saleBarcodePoolHead, List<SaleBarcodePoolItem> saleBarcodePoolItemList, List<SaleBarcodePoolRecord> saleBarcodePoolRecordList) {
        if (saleBarcodePoolItemList != null && !saleBarcodePoolItemList.isEmpty()) {
            for (SaleBarcodePoolItem saleBarcodePoolItem : saleBarcodePoolItemList) {
                saleBarcodePoolItem.setHeadId(saleBarcodePoolHead.getId());
                SysUtil.setSysParam((BaseEntity)saleBarcodePoolItem, (BaseEntity)saleBarcodePoolHead);
            }
            this.saleBarcodePoolItemService.saveBatch(saleBarcodePoolItemList);
        }
        if (saleBarcodePoolRecordList != null && !saleBarcodePoolRecordList.isEmpty()) {
            for (SaleBarcodePoolRecord saleBarcodePoolRecord : saleBarcodePoolRecordList) {
                saleBarcodePoolRecord.setHeadId(saleBarcodePoolHead.getId());
                SysUtil.setSysParam((BaseEntity)saleBarcodePoolRecord, (BaseEntity)saleBarcodePoolHead);
            }
            this.saleBarcodePoolRecordService.saveBatch(saleBarcodePoolRecordList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleBarcodePoolItemMapper.deleteByMainId(id);
        this.saleBarcodePoolRecordMapper.deleteByMainId(id);
        this.saleBarcodePoolHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleBarcodePoolItemMapper.deleteByMainId(serializable.toString());
            this.saleBarcodePoolRecordMapper.deleteByMainId(serializable.toString());
            this.saleBarcodePoolHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @Transactional
    public void addByBarcodeInfo(Map<String, SaleBarcodeInfoHead> supplierBarcodeHeadMap, Map<String, List<SaleBarcodeInfoItem>> itemMap, Map<String, List<SaleBarcodeInfoDetail>> detailMap) {
        for (String elsAccount : supplierBarcodeHeadMap.keySet()) {
            if (detailMap.get(elsAccount) == null || detailMap.get(elsAccount).size() <= 0) continue;
            ArrayList<SaleBarcodePoolHead> poolHeadList = new ArrayList<SaleBarcodePoolHead>();
            for (SaleBarcodeInfoDetail detail : detailMap.get(elsAccount)) {
                SaleBarcodePoolHead poolHead = new SaleBarcodePoolHead();
                poolHead.setOriginalBarcode(detail.getOriginalBarcode());
                poolHead.setBarcode(detail.getBarcode());
                poolHead.setInfoNumber(supplierBarcodeHeadMap.get(elsAccount).getInfoNumber());
                poolHead.setRuleCode(supplierBarcodeHeadMap.get(elsAccount).getRuleCode());
                poolHead.setRuleId(supplierBarcodeHeadMap.get(elsAccount).getRuleId());
                poolHead.setStatus(SrmEnabledStatusEnum.ENABLED.getValue());
                poolHead.setPrintNumber(detail.getPrintNumber());
                poolHead.setPrintedNumber(0);
                poolHead.setUsed("1");
                poolHead.setElsAccount(detail.getElsAccount());
                poolHead.setToElsAccount(detail.getToElsAccount());
                poolHead.setSupplierName(detail.getSupplierName());
                poolHead.setSupplierCode(detail.getSupplierCode());
                poolHeadList.add(poolHead);
            }
            this.saveBatch(poolHeadList);
            ArrayList<SaleBarcodePoolItem> saleBarcodePoolItemList = new ArrayList<SaleBarcodePoolItem>();
            for (SaleBarcodePoolHead poolHead : poolHeadList) {
                for (SaleBarcodeInfoItem entity : itemMap.get(elsAccount)) {
                    SaleBarcodePoolItem saleBarcodePoolItem = new SaleBarcodePoolItem();
                    BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)saleBarcodePoolItem));
                    saleBarcodePoolItem.setHeadId(poolHead.getId());
                    saleBarcodePoolItem.setRelationId(null);
                    saleBarcodePoolItem.setId(null);
                    for (String attr : entity.getAttribute().split(",")) {
                        if (!poolHead.getOriginalBarcode().contains(attr)) continue;
                        saleBarcodePoolItem.setAttribute(attr);
                    }
                    saleBarcodePoolItemList.add(saleBarcodePoolItem);
                }
            }
            this.saleBarcodePoolItemService.saveBatch(saleBarcodePoolItemList);
        }
    }

    @Override
    public BarcodeInfoVO getBarcodeInfo(String barcode) {
        return this.saleBarcodePoolHeadMapper.getBarcodeInfo(barcode, SrmEnabledStatusEnum.ENABLED.getValue());
    }
}

